﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentYellowCardButton = function(name)
{
	this.componentButton = componentButton;
	this.componentButton(name);
};

componentYellowCardButton.prototype = new componentButton();
componentYellowCardButton.prototype.type = "componentYellowCardButton";

componentYellowCardButton.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.standardSrc, this.mouseOverSrc, this.clickSrc, this.bckgSrc, this.buttonTrashOver, this.buttonMiniOver, this.buttonHideOver, this.buttonTrashOut, this.buttonMiniOut, this.buttonHideOut, this.minimalizedMyCard, this.minimalizedAuthorCard, this.minimalizedAllCard, this.minimalizedTutorCard, this.myDot, this.authorDot, this.allDot, this.tutorDot, this.personGraphic, this.personGraphic ];
	this.getPreloadImagesArr();
	this.captureMouseEvents();
};

componentYellowCardButton.prototype.componentYellowCardButtonBaseEventMouseDown = componentYellowCardButton.prototype.eventMouseDown;
componentYellowCardButton.prototype.eventMouseDown = function(e)
{
	if (this.parent && this.parent.eventClick) this.parent.eventClick(e);

	var ID = this.findNotUsedID();
	var type = this.buttonAddsCardsType;

	var dateObj = new Date();
	var date = (dateObj.getMonth() + 1) + "-";
	date += dateObj.getDate() + "-";
	if (is.moz) {
		var arrData = dateObj.toString().split(' ');
		date += arrData[3] + this.hourLang+' ';
	} else {
		date += dateObj.getYear() + this.hourLang+' ';
	};
	date += dateObj.getHours() + ":";
	date += (dateObj.getMinutes() < 10) ? "0"+dateObj.getMinutes() : dateObj.getMinutes();

	var xMiddle = this.getXScreenMiddle();
	var yMiddle = this.getYScreenMiddle();
	if (PlayerInterface.connectedUELO){
		user = PlayerInterface.connectedUELO.username;

		if (this.restoreMouseOver) {
			var showMouseOver = true;
		} else {
			var showMouseOver = false;
		};

		switch (type){
			case "author" :
				var myDot = this.authorDot;
				var minimalizedMyCard = this.minimalizedAuthorCard;
				break;
			case "public" :
				var myDot = this.allDot;
				var minimalizedMyCard = this.minimalizedAllCard;
				break;
			case "private":
				var myDot = this.myDot;
				var minimalizedMyCard = this.minimalizedMyCard;
				break;
			case "tutor"  :
				var myDot = this.tutorDot;
				var minimalizedMyCard = this.minimalizedTutorCard;
				break;
		};
		var pageName = PageInterface.GetValue('pageName');
		var pageGI = PageInterface.GetValue('pageGix');

		var newObj = PageInterface.Execute("createChild", "componentImage", "__yc__"+ID+"_mini");
		var miniCard = PageInterface.Execute("addChild", newObj);
		miniCard.src = minimalizedMyCard;
		miniCard.x = xMiddle;
		miniCard.y = yMiddle;
		miniCard.w = this.minimalizedCardW;
		miniCard.h = this.minimalizedCardH;
		miniCard.canDragging = true;
		miniCard.onDblClick = this.onDblClickMiniCard;
		miniCard.endDrag = this.endDragMiniCard;
		miniCard.beginDrag = this.beginDragMiniCard;
		miniCard.hide();

		var card = PlayerInterface.Execute("addYellowCard", "__yc__" + ID, date, type, xMiddle, yMiddle, user, this.titleText, this.noteText, this.bckgSrc, this.buttonTrashOver, this.buttonTrashOut, this.buttonMiniOver, this.buttonMiniOut, this.buttonHideOver, this.buttonHideOut, minimalizedMyCard, myDot, this.personGraphic, this.clockGraphic, this.defaultMinimalize, showMouseOver, true, this.hourLang, this.id, this.spaceBetweenButtons, this.offsetTop, this.offsetLeft, this.bckgW, this.bckgH, this.showUserName, pageName, pageGI);
	};
	this.componentYellowCardButtonBaseEventMouseDown(e);
};

componentYellowCardButton.prototype.beginDragMiniCard = function(e)
{
	PageInterface.Execute("setOnTop", this);
};

componentYellowCardButton.prototype.endDragMiniCard = function(e)
{
	var bigCardName = this.id.replace('_mini', '');
	var cardName = page.all[bigCardName];
	if (cardName) {
		cardName.x = this.x;
		cardName.y = this.y;
		cardName.saveCard();
	};
};

componentYellowCardButton.prototype.onDblClickMiniCard = function(e)
{
	var bigCardName = this.id.replace('_mini', '');
	var cardName = PageInterface.GetValue("getChild", bigCardName);
	if (cardName) {
		cardName.x = this.x;
		cardName.y = this.y;
		cardName.maximalizeCard();
	};
	this.hide();
};

componentYellowCardButton.prototype.findNotUsedID = function(e)
{
	var i = -1;
	do {
		i++;
	} while (document.getElementById("__yc__" + i) || PlayerInterface.GetValue('findYellowCard', "__yc__" + i))
	return i;
}

componentYellowCardButton.prototype.getDate = function()
{
	var dateObj = new Date();
	var date = (dateObj.getMonth() + 1) + "-";
	date += dateObj.getDate() + "-";
	date += dateObj.getYear() + " ";
	date += dateObj.getHours() + ":";
	date += dateObj.getMinutes();
	return date;
};

componentYellowCardButton.prototype.getXScreenMiddle = function()
{
	return (PageInterface.GetValue("pageWidth")/2 - this.bckgW/2);
};

componentYellowCardButton.prototype.getYScreenMiddle = function()
{
	return (PageInterface.GetValue("pageHeight")/2 - this.bckgH/2);
};
