﻿/*
 * Copyright (c) 1995-2015 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentAudio = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	this.nextStepWaitToEnd = true;
	this.showPlayer = false;
	this.allowNextStep = true;
	this.preloaded = false;

	this.wmp64 = "{22D6F312-B0F6-11D0-94AB-0080C74C7E95}";
	this.wmp64Str = "MediaPlayer.MediaPlayer.1";
	this.wmp7up = "{6BF52A52-394A-11d3-B153-00C04F79FAA6}";
	this.wmp7upStr = "WMPlayer.OCX.7";
	this.wmpPluginStr = "Windows Media Player";

	this.pvWMPnone = true;
//	this.pvWMPembed = false;
	this.pvWMP64 = false;
	this.pvWMP7up = false;
	
	this.isSafariMobileVideo = (is.safari && is.mobile && this.type == "componentVideo"); //pg2-iPad
	this.isSafariMobileAudio = (is.safari && is.mobile && this.type == "componentAudio");

	this.hasActiveX = false;
	this.hasGeckoActiveXObject = false;

	//this.player = null;
	this.timer = null;
	this.preloadTimer = null;
	this.playTimer = null;
	this.timer = null; //pg2
	this.waitingTryCount = 0;

	this.orgX = 0;
	this.orgY = 0;

	this.mediaStatus = "online";
	this.mediaURL = "";

	this.waitForPlayerTimer = null;

	this.showControls = false;
	this.mediaDownload = 'Media download progress:';
	
	this.allowMediaStopEvent = false; //pg2-audio_onStop -event was invoked on element's create, on the end, on page's unload, but if audio.step==0 it didn't work as expected
	this.iPadControlFound = false; //pg2-bi_audioUPFrame -completion, tree
};

componentAudio.prototype = new componentElement;
componentAudio.prototype.type = "componentAudio";

componentAudio.prototype.componentAudioBaseFindContentObj = componentAudio.prototype.findContentObj;
componentAudio.prototype.findContentObj = function() //pg2-bi_audioUPFrame -too many audio on one page, navi to next one- objects aren't destroyed and finally it ends up with iPad browser crush down
{
	var thisObj;
	if (this.isSafariMobileAudio) {
		var wp = window.parent;
		thisObj = wp.document.getElementById(this.type);
		if (thisObj) this.iPadControlFound = true; else {
			this.iPadControlFound = false; //pg2-bi_audioUPFrame -completion, tree
			thisObj = this.componentAudioBaseFindContentObj();
		};
	} else {
		thisObj = this.componentAudioBaseFindContentObj(); //pg2-default one, for PC and - for now (todo, check it out)
	};
	return thisObj;
};

componentAudio.prototype.getPlayerObj = function() //pg2-bi_audioUPFrame
{
	var playerObj;
	if (this.isSafariMobileAudio && this.iPadControlFound) {
		var wp = window.parent;
		playerObj = wp.document.getElementById(this.type + 'MediaPlayer');
	} else {
		playerObj = document.getElementById(this.id + 'MediaPlayer'); //pg2-default one for PC (and iPad video)
	};
	return playerObj;
};

componentAudio.prototype.onCreate = function()
{
	this.orgX = this.x;
	this.orgY = this.y;
	
	if (this.isSafariMobileAudio && this.iPadControlFound) { //pg2-bi_audioUPFrame -test 'online' only
		this.mediaStatus = 'online';
	} else {
		this.mediaStatus = (lms) ? lms.mediaStatus() : 'online'; //pg2-default one
	};
	
	this.mediaURL = unescape(lms.mediaURL());
	if (this.src.indexOf('http://') == 0 || this.src.indexOf('https://') == 0) { //pg2-audio-video from another online location
		this.mediaURL = this.src;
	} else this.mediaURL += this.src;

	if (config.withoutMultimedia) this.mediaStatus = "textOnly";
	var t = "";

	var inner = this.findContentObj();
	if (inner) {
		if (!(this.isSafariMobileAudio && this.iPadControlFound)) { //pg2-bi_audioUPFrame -test 'online' only
			inner.innerHTML = this.initPlayer(); //pg2-default one //TODO -check if necessary to reset code for html5 control
		};
	};

	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly" || //pg2-if textOnly too
			PageInterface.GetValue("state") == psDesigning ||
			PageInterface.GetValue("state") == psPreview)
	{
		if (this.mediaStatus == "off" && !this.showIconWhenMediaOff) {
			t += "";
		} else {
			t += this.editorPaint();
		};
		this.setHTML(t);
		this.allowNextStep = true;
		//this.showPlayer = true;
		this.setUrl(this.mediaURL);
		this.doMute(true);
		this.preloaded = true;
	} else
	if (this.mediaStatus != "off") {
		var inner = this.findContentObj();
		if (inner) {
//			inner.innerHTML = this.initPlayer();
		} else {
			return;
		};

		//this.setHTML(this.initPlayer());

		//if (!this.showPlayer) this.x = -1000;
		//this.player = document.getElementById(this.id + "MediaPlayer");
		if (!this.isSafariMobileVideo && !this.isSafariMobileAudio) { //pg2-iPad
			this.setUrl(this.mediaURL);
			this.doMute(true);
			this.preload();
			this.noDisplay();
		};
	};
};

componentAudio.prototype.repaint = function()
{
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") return;

	if (is.moz) {
		var width = 0;
		var height = 0;
		if (this.showPlayer) {
			width = this.w;
			height = this.h;
		};
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
		
		} else {
			var s = "";
			s += '<OBJECT id="' + this.id + 'MediaPlayer" type="application/x-ms-wmp" width="' + width + '" height="' + height + '" data="' + this.mediaURL + '">';
			s += '<PARAM name="autostart" value="false" />';
			if (this.showControls == 1) {
				s += '<param name="uiMode" value="full" />';
			} else {
				s += '<param name="uiMode" value="none" />';
			};
			//s += '<PARAM name="enableContextMenu" value="false" />'; //pg2-replaced with code below
			s += '<PARAM name="enableContextMenu" value="true" />';
			//s += '<PARAM name="enabled" value="false" />'; //pg2-replaced with code below
			s += '<PARAM name="enabled" value="true" />';
			s += ' </OBJECT>';
			var inner = this.findContentObj();
			if (inner) {
				inner.innerHTML = s;
			};
		};
	};
};

componentAudio.prototype.editorPaint = function()
{
	return '<img src="' + resourcesURL + this.iconSrc + '" />';
};

componentAudio.prototype.onBeforeRemove = function()
{
	this.doStop();
	//var player = document.getElementById(this.id + "MediaPlayer");
	/*if (player) {
		delete this.player;
		this.player = null;
	}*/
	this.setVisible(false);
};

componentAudio.prototype.initPlayer = function()
{
	var player = null;
	try {
		if (window.ActiveXObject || is.ie11up) { //pg2-ie11 and up
			player = new ActiveXObject(this.wmp64Str);
		};
	} catch(e) {};
	if (!player) {
		try {
			player = navigator.mimeTypes["application/x-mplayer2"].enabledPlugin;
		} catch(e) {};
	};
	if (player) {
		player = null;
		this.pvWMPnone = false;
		try {
			if (window.ActiveXObject || is.ie11up) { //pg2-ie11 and up
				player = new ActiveXObject(this.wmp7upStr);
			};
			if (player) {
				var ver = player.versionInfo.split(".");
				if (Math.floor(ver[0]) >= 9) {
					this.pvWMP7up = true;
				} else {
					this.pvWMPnone = true;
				};
			};
		} catch(e) {
			this.pvWMPnone = true;
		};

		if (this.pvWMPnone) {
			this.pvWMPnone = false;
			try {
				if (window.ActiveXObject || is.ie11up) { //pg2-ie11 and up
					player = new ActiveXObject(this.wmp64Str);
				};
				if (player) {
					this.pvWMP64 = true;
					this.pvWMP7up = false;
				};
			} catch(e) {
				this.pvWMPnone = true;
			};
		};
	} else
	if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
		this.pvWMPnone = false;
	};

	player = null;

	// ten kod trzeba przeniesc do koponentu detekcja
	// komunikat jest uperdliwy (pokazuje sie na kazdej stronie)
	// a sa przypadki ze w przegladarkach specjalnie wylaczony jest dzwiek (np. Windows Server)
	// lub ktos na FF nie chce instalowac tego dadatku.
	if (this.pvWMPnone == false) return this.getInnerHTML(); //usun ta linie jezeli odblokujesz stary kod
	//if (this.pvWMPnone && !PageInterface.GetValue("noActiveXErrorShowed") && !is.moz) {
	//	PageInterface.SetValue("noActiveXErrorShowed", true);
	//	showMessage("Twoja przeglądarka nie wspiera ActiveX lub GeckoActiveX dla poprawnego odtwarzania plików multimedialnych.\nJeżeli używasz przeglądarki Mozilla lub FireFox zainstaluj odpowiednią wtyczkę ze strony: http://port25.technet.com/pages/windows-media-player-firefox-plugin-download.aspx");
	//}else{
	//return this.getInnerHTML();
	//}
};

componentAudio.prototype.parseSrc4iPad = function(isVideo, src) //pg2-in case of audio/video on iPad, replace files extensions
{
	if (!this.isSafariMobileVideo && !this.isSafariMobileAudio) return;
	if (typeof(src) == 'undefined' || src == '') return;
	
	var src2 = '';
	var lastPos = src.lastIndexOf('.');
	if (lastPos > -1) {
		src2 = src.substring(0, lastPos);
		if (isVideo) src2 += '.mp4'; else src2 += '.mp3';
	};
	return src2;
};

componentAudio.prototype.getInnerHTML = function(url)
{
	var width = 0;
	var height = 0;
	if (this.showPlayer) {
		width = this.w;
		height = this.h;
	};
	
	var s = "";
	
	if (this.pvWMP7up) {
		// WMP 7up code
		s += '	<OBJECT id="' + this.id + 'MediaPlayer" ';
		s += '		width="' + width + '" height="' + height + '" ';
		s += '		CLASSID=CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6 ';
		s += '		standby="Loading Microsoft Windows Media Player components..."';
		s += '		TYPE="application/x-oleobject">';
		s += '		<param name="url" VALUE="' + this.mediaURL + '" />';
		//s += '		<param name="uiMode" value="none" />';
		if (this.showControls == 1) {
			s += '		<param name="uiMode" value="full" />';
		} else {
			s += '		<param name="uiMode" value="none" />';
		};
		s += '		<param name="Volume" value="100" />';
		s += '		<param name="ShowControls" VALUE="false" />';
		s += '		<param name="ShowTracker" VALUE="false" />';
		s += '		<param name="ShowStatusBar" VALUE="false" />';
		s += '		<param name="VideoBorder3D" VALUE="false" />';
		s += '		<param name="VideoBorderWidth" VALUE="false" />';
		s += '		<param name="AutoStart" value="false" />';
		s += '		<param name="AnimationAtStart" value="false" />';
		s += '		<param name="TransparentAtStart" value="false" />';
		s += '	</OBJECT>';
	} else
	if (this.pvWMP64) {
		// WMP 6.4 code
		// IE code
		s += '	<OBJECT id="' + this.id + 'MediaPlayer" ';
		s += '		width="' + width + '" height="' + height + '" ';
		s += '		CLASSID=CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95 ';
		s += '		CODEBASE=http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,5,715 ';
		s += '		standby="Loading Microsoft Windows Media Player components..." ';
		s += '		TYPE="application/x-oleobject">';
		s += '		<param name="Volume" value="100" />';
		s += '		<param name="FileName" VALUE="" />';
		if (this.showControls == 1) {
			s += '		<param name="ShowControls" VALUE="true" />';
		} else {
			s += '		<param name="ShowControls" VALUE="false" />';
		};
		s += '		<param name="ShowTracker" VALUE="false" />';
		s += '		<param name="ShowStatusBar" VALUE="false" />';
		s += '		<param name="AutoStart" value="false" />';
		s += '	</OBJECT>';
	} else
	if (is.moz) {
		if (this.isSafariMobileAudio) { //pg2-iPad
			this.parseSrc4iPad(true, this.mediaURL);
			s += '<audio id="' + this.id + 'MediaPlayer" width="' + width + '" height="' + height + '" preload="none" controls>';// autoplay="autoplay" controls="controls" >'; //pg2-bi_af -preload- none instead of metadata
			s += '  <source src="' + this.parseSrc4iPad(false, this.mediaURL) + '" type="audio/mp3">';
			s += '</audio>';
			this.showPlayer = true;
		} else
		if (this.isSafariMobileVideo) { //pg2-iPad
			this.parseSrc4iPad(true, this.mediaURL);
			s += '<video id="' + this.id + 'MediaPlayer" width="' + width + '" height="' + height + '" preload="none"'; //pg2-bi_af -preload- none instead of metadata
			if (this.showControls == 1) {
				s += ' controls="controls"';
			};
			s += '>';// autoplay="autoplay" controls="controls" >';
			s += '  <source src="' + this.parseSrc4iPad(true, this.mediaURL) + '" type="video/mp4">';
			s += '</video>';
			this.showPlayer = true;
		} else {
			s += '<OBJECT id="' + this.id + 'MediaPlayer" type="application/x-ms-wmp" width="' + width + '" height="' + height + '" data="' + this.mediaURL + '">';
			s += '<PARAM name="autostart" value="false" />';
			if (this.showControls == 1) {
				s += '<param name="uiMode" value="full" />';
			} else {
				s += '<param name="uiMode" value="none" />';
			};
			//s += '<PARAM name="enableContextMenu" value="false" />'; //pg2-replaced with code below
			s += '<PARAM name="enableContextMenu" value="true" />';
			//s += '<PARAM name="enabled" value="false" />'; //pg2-replaced with code below
			s += '<PARAM name="enabled" value="true" />';
			s += ' </OBJECT>';
		};
	} else {
		s = this.editorPaint();
		this.allowNextStep = true;
		this.showPlayer = true;
	};
	if (!this.showPlayer) { //pg2-to prevent displaying a dot of WMP control
		s = '<div style="visibility: hidden;">' + s + '</div>';
	};
	return s;
};

componentAudio.prototype.setUrl = function(url)
{
	if (lms) this.mediaStatus = lms.mediaStatus(); //pg2
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") return; //pg2
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up) {
			player.URL = url;
		} else
		if (this.pvWMP64) {
			player.FileName = url;
		} else
		if (this.isSafariMobileVideo && !this.isSafariMobileAudio) { //pg2-iPad
			return;
//r			//alert('currentSRC=' + player.src);
//r			player.src = this.parseSrc4iPad(this.isSafariMobileVideo, url);
//r			player.load();
		} else
		if (is.moz && player.controls) {
			player.URL = url;
			player.controls.stop();
		};
	};
};

componentAudio.prototype.stopPreload = function()
{
	this.killPreloadTimer();
	this.waitingTryCount = 0;
	this.preloaded = true;
};

componentAudio.prototype.preload = function()
{
	if (typeof(this.src) == 'undefined' || is.moz || this.src == "") {
		this.stopPreload();
		return true;
	};
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.mediaStatus == "off") {
			this.stopPreload();
			return true;
		}
		this.checkDownloadProgress();
	} else {
		this.stopPreload();
		return true;
	};
};

componentAudio.prototype.checkDownloadProgress = function()
{
	if (!is.ie) {
		this.killPreloadTimer();
		this.preloaded = true;
		return;
	};

	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (!player.network) { //pg2-iPad
		this.preloaded = true;
		return;
	};

	this.play();
	this.doMute(true);
	this.setVisible(false);
	var obj = null

	if (this.showMediaDowlnoadProgress) {
		obj = document.getElementById("mediawaitlayer" + this.id);
		if (!obj) {
			var waitlayer = document.getElementById('waitlayer');
			var newdiv = document.createElement('div');
			newdiv.setAttribute("id", "mediawaitlayer" + this.id);
			waitlayer.appendChild(newdiv);
			var obj = document.getElementById("mediawaitlayer" + this.id);
		};
	};

	//if (this.isPlaying() && player.network.downloadProgress == 100) {
	if (player.network.downloadProgress == 100) {
		this.killPreloadTimer();
		this.preloaded = true;
		this.doStop();
		if (obj) obj.innerHTML = this.mediaDownload + ' 100%';
	} else {
		if (obj && player.network.downloadProgress != 0 && player.network.downloadProgress != 100) {
			obj.innerHTML = this.mediaDownload + ' ' + player.network.downloadProgress + '%';
		}
		this.preloaded = false;
		this.preloadTimer = window.setTimeout('var o=page.findChildByName("' + this.id + '"); if (o) { o.checkDownloadProgress(); }', 1000);
	};
};

componentAudio.prototype.isReady = function()
{
	if (this.src == "" || typeof(this.src) == 'undefined') return true;

	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	var pageState = PageInterface.GetValue("state");
	if (!player || pageState == psDesigning || pageState == psPreview || pageState == psView) { 
		return true;
	};
	if (is.ie10) return true; else return this.preloaded; //pg2-IE10_test
	//return this.preloaded; //pg2-removed
};

componentAudio.prototype.isActive = function()
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (!player ||PageInterface.GetValue("state") == psDesigning ||
		PageInterface.GetValue("state") == psPreview)
	{
		return true;
	};

	var res = false;

	if (player) {
		if (this.pvWMP7up || is.moz) { //pg2- is firefox
			res = (player.playState != 0 && player.playState != 1);
		} else
		if (this.pvWMP64) {
			res = ((player) ? player.ReadyState >= 4 : true);
		};
	};
	return res;
};

componentAudio.prototype.isPlaying = function()
{
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		try {
			if (this.pvWMP7up || is.moz) { //pg2-test
				res = (player.playState == 3);
			} else
			if (this.pvWMP64) {
				res = (player.PlayState == 2);
			} else
			if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
				res = (!player.paused && !player.ended);
			};
		} catch(e) {
			res = false;
		};
	};
	return res;
};

componentAudio.prototype.isPaused = function() //pg2-required to resume playing
{
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up) {
			res = (player.playState == 2);
			return res;
		} else
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
			res = (player.paused && !player.ended && player.currentTime > 0);
		} else
		if (is.moz) {
			res = (player.playState == 2);
		};
		//pg2-todo -other versions of WMP
	};
	return res;
};

componentAudio.prototype.isStopped = function()
{
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up) {
			res = (player.playState == 1);// || player.playState == 10);
			if (player.playState == 7) this.waitingTryCount++;
			if (this.waitingTryCount > 50) {
				this.preloaded = true;
				this.waitingTryCount = 0;
				return this.preloaded;
			};
		} else
		if (this.pvWMP64) {
			res = (player.playState == 0);
		} else
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
			res = player.ended;
		} else
		if (is.moz) {
			res = (player.playState == 1);
		};
	} else {
		res = true;
	};
	return res;
};

componentAudio.prototype.show = function()
{
	//pg2-BI_iPad_test
	if (is.safari && is.mobile && this.step == 0 && page.stepIndex == 0) {
		return;
	};
	var result = true;
	if (typeof(this.visibleIf) != "undefined" && this.visibleIf != "") 
	{
		try { //pg2-show error message in page preview only
			result = result && (eval(unescape(this.visibleIf)) == true);
		} catch(e) {
			result = true;
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.visibleIf eval execution error\nMessage:\n' + e.message); //pg2
		};
	};
	if (result) {
		this.firstMediaPlay();
	};
	//this.play();
};

componentAudio.prototype.hide = function()
{
	this.actionMediaStop(); 

	this.allowNextStep = true;

	if (this.preloadTimer != null) window.clearTimeout(this.preloadTimer); //pg2- on hide, clear all timers (it could be plain hide, or- hiding components while page unload)
	if (this.timer != null) window.clearTimeout(this.timer);
	if (this.playTimer != null) window.clearTimeout(this.playTimer);
	this.preloadTimer = null;
	this.timer = null;
	this.playTimer = null; 
};

componentAudio.prototype.play = function()
{
	this.doPlay();
	this.invokeEvent("MediaPlay");
	try { //pg2-ie
		this.focus(); //pg2- otherwise in MF context menu and fullscreen (if video) doesn't work at startup
	} catch(e) {};
};

componentAudio.prototype.pause = function()
{
	this.doPause();
	if (this.allowMediaStopEvent) this.invokeEvent("MediaPause");  //pg2-audio_onStop -allow only if audio is allowed to be stopped
};

componentAudio.prototype.stop = function()
{
	this.doStop();
};

componentAudio.prototype.killTimer = function()
{
	if (this.timer) {
		window.clearTimeout(this.timer);
		this.timer = null;
		this.invokeEvent("MediaPlay");
	};
	if (this.playTimer) {
		window.clearTimeout(this.playTimer);
		this.playTimer = null;
	};
};

componentAudio.prototype.killPreloadTimer = function()
{
	if (this.preloadTimer) {
		window.clearTimeout(this.preloadTimer);
		this.preloadTimer = null;
	};
};

componentAudio.prototype.prepareNextStep = function()
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	
	window.clearTimeout(this.timer);
	this.timer = null;

	var timeout = 500;
	if (!this.allowNextStep) {
		if (!this.nextStepWaitToEnd || !player) {
			this.allowNextStep = true;
			this.timer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.prepareNextStep();}', timeout);
		} else
		if (this.isPlaying() || this.isReady()) {
			if (player.playState == 7) this.waitingTryCount++;
			if (this.waitingTryCount > 50 || this.isStopped()) {
				this.allowNextStep = true;
				this.killTimer();
				this.waitingTryCount = 0;
				this.actionMediaStop();
				return;
			};
			this.timer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.prepareNextStep();}', timeout);
		};
	} else {
		if (this.isStopped()) {
			this.killTimer();
			this.actionMediaStop();
			return;
		};
		this.timer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.prepareNextStep();}', timeout);
	};
};

componentAudio.prototype.doPlay = function()
{	
	if (lms) this.mediaStatus = lms.mediaStatus(); //pg2
	
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") { //pg2-bi_test_iPad -if media are off, do not block step- allow next, or- invoke actions attached to event 'OnMediaStop'
		if (this.nextStepWaitToEnd) this.allowNextStep = true;
		this.invokeEvent("MediaStop");
		this.allowMediaStopEvent = false;
	};
	
	if (this.mediaStatus == "off") {
		return false;
	};
	if (this.mediaStatus == "textOnly") {
		var popup = PageInterface.GetValue("getChild", "audioTextPopup");
		if (popup && this.showTextWhenMediaOff == "1") { //pg2-condition if the text should be visible
			var p = popup.findContentObj();
			p.innerHTML = this.text;
			popup.initText = function () { return this.findContentObj().innerHTML; };
			//if (!popup.visible) //pg2-removed, now is unconditional - to recalculate text's size
			popup.show();
		};
		return false;
	};

	this.x = this.orgX;
	this.setVisible(this.showPlayer);
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame

	if (!player && is.moz) { //pg2- in case of Firefox, during video unloading innerHTML property is set to ''. If preloader is enabled, next try to play video will fail- there is no MediaPlayer object created. In this case, recreate it
		var inner = this.findContentObj();
		if (inner) {
			if (!(this.isSafariMobileAudio && this.iPadControlFound)) { //pg2-bi_audioUPFrame (it wasn't neccessary for iPad audio)
				inner.innerHTML = this.initPlayer(); //pg2-default one
			};
			player = this.getPlayerObj(); //player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
		};
	};

	if (player) {
		if (PageInterface.GetValue("preloadState") != 1 && this.textVisible) {
			var popup = PageInterface.GetValue("getChild", "audioTextPopup");
			if (popup) {
				var p = popup.findContentObj();
				p.innerHTML = this.text;
				popup.initText = function () { return this.findContentObj().innerHTML; };
				//if (!popup.visible) //pg2-removed, to recalculate text's size
				popup.show();
			} else {
				this.showText();
			};
		};

		//if (!this.invokeEvent("MediaPlay")) { //pg2-iPad & Firefox - removed
			this.invokeEvent("MediaPlay"); //pg2-iPad & Firefox
			if (!PageInterface.GetValue("pageIsShow")) return;
			
			if (!(this.type == 'componentVideo' && this.isSafariMobileVideo)) { //pg2-avOnStopPopup -iPad
				this.allowMediaStopEvent = true;
			};
			
			if (!(this.isSafariMobileVideo || this.isSafariMobileAudio)) {
				if (!this.isPaused()) { //pg2-otherwise, resume doesn't work
					this.setUrl(this.mediaURL);
					this.doMute(false);
				};
			};
			
			//alert(player.controls);
			if (this.pvWMP7up) {
				if (player.controls) res = player.controls.play();
				
				if (this.nextStepWaitToEnd) this.allowNextStep = false;
			} else
			if (this.pvWMP64) {
				res = player.Play();
				if (this.nextStepWaitToEnd) this.allowNextStep = false;
			} else
			if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad			
				if (this.isSafariMobileAudio && this.iPadControlFound) { //pg2-bi_audioUPFrame
					player.innerHTML = '<source src="' + resourcesURL + this.src + '" type="audio/mp3">';
					player.load();
				};
				
				this.allowMediaStopEvent = true; //pg2-bi_completion
				player.play();
			} else
			if (is.moz && player.controls) {
				player.controls.play();
				if (this.nextStepWaitToEnd) this.allowNextStep = false;
			};
			this.prepareNextStep();
		//} else return true; //pg2-iPad & Firefox - removed
	} else {
		this.allowNextStep = true;
		return false;
	};
	if (typeof(res) == "undefined") res = false;
	return res;
};

componentAudio.prototype.doPause = function()
{
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		//if (!this.invokeEvent("MediaPause")) { //pg2-iPad & Firefox - removed
			this.invokeEvent("MediaPause"); //pg2-iPad & Firefox
			if (this.pvWMP7up) {
				if (player.controls) res = player.controls.pause();
				this.waitingTryCount = 0;
			} else
			if (this.pvWMP64) {
				try {
					res = player.Pause();
				} catch(e) {}
			} else
			if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
				player.pause();
			} else
			if (is.moz && player.controls) {
				player.controls.pause();
			};
		//} else return true; //pg2-iPad & Firefox - removed
	};
	return res;
};

/*componentAudio.prototype.hardUnload = function() //pg2-bi_completion //pg2-bi_audioUPFrame
{
	return; //pg2-bi_audioUPFrame- removed, it ain't gonna work- iPad's Safari doesn't actually delete object even though their container has been cleaned
	var inner = this.findContentObj();
	if (inner) {
		inner.innerHTML = '';
	};
	var selfDiv = document.getElementById(this.id);
	if (selfDiv) {
		selfDiv = '';
	};
};*/

componentAudio.prototype.doStop = function()
{
	var res = false;
	this.killTimer();
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up) {
			if (player.controls) {
				res = player.controls.stop();
			};
			//this.allowNextStep = true; //pg2-moved below
			this.waitingTryCount = 0;
		} else
		if (this.pvWMP64) {
			res = player.Stop();
			this.setCurPos(0);
		} else 
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
//r			/*var inner = this.findContentObj();
//r			if (inner) {
//r				inner.innerHTML = ''; //this.initPlayer();
//r			};*/
//r			/*var selfDiv = document.getElementById(this.id);
//r			if (selfDiv) selfDiv.innerHTML = '';*/

			player.pause();
			try {
				player.currentTime = 0;
			} catch(e) {};
		} else
		if (is.moz && player.controls) {
			player.controls.stop();
		};
		this.allowNextStep = true; //pg2-allow next step no mattr what browser it was launched in
		this.doMute(true);

		try {
			if (typeof(this.onMediaStop) != 'undefined') { //pg2-try to avoid exception...
				var s = this.onMediaStop.toString(); //pg2-remove action 'onMediaStop -> audio -> mediaStop'
				s = s.replace(new RegExp('this.actionMediaStop', "g"), 'this.isPlaying');
				var f;
				eval("f=" + s);
				this.onMediaStop = f;
			};
		} catch(e) {};

		//if (this.step != 0) { // this.step > 0 && this.isPlaying()) {
		//if (this.step != 0 && page.stepIndex != 0) { //pg2-audio_onStop -it ain't working for audio in step 1, or stopped at page's startup and played by a component's action (example: onclick for some image /text)
			//alert('invoked');
			if (this.allowMediaStopEvent) { //pg2-audio_onStop
				//alert('MEDIA_STOP');
				this.invokeEvent("MediaStop"); //pg2-otherwise in step 0/-1 always is invoked actions onMediaStop, for example onMediaStop->image1->show will be invoked at page startup. Now it's fixed
				this.allowMediaStopEvent = false;

				//pg2-avOnStopPopup -find it and show if not visible
				if (this.avOnStopPopup) {
					var avOnStopPopup = getComponentByPartialId('avOnStopPopup');
					if (avOnStopPopup && !avOnStopPopup.visible) avOnStopPopup.show();
				};
			};
		//};
	};
	return res;
};

componentAudio.prototype.doRewind = function()
{
	var res = false;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up || is.moz) { //pg2- is firefox
			if (player.controls) res = player.controls.fastReverse();
		} else
		if (this.pvWMP64) {
			res = player.FastReverse();
		};
	};
	return res;
};

componentAudio.prototype.doFastForward = function()
{
	var res = false;
	var player = this.getPlayerObj(); //pg2-bi_audioUPFrame //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up || is.moz) { //pg2- is firefox
			if (player.controls) res = player.controls.fastForward();
		} else
		if (this.pvWMP64) {
			res = player.FastForward();
		};
	};
	return res;
};

componentAudio.prototype.doMute = function(b)
{
	b = b == true;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.pvWMP7up) {
			if (player.settings) player.settings.mute = b;
		} else
		if (this.pvWMP64) {
			player.Mute = b;
		} else
		if (is.moz && player.settings) {
			player.settings.volume = (b)?0:100;
		} else
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
			player.muted = b;
		};
	};
};

componentAudio.prototype.actionVolumeUp = function(value)
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
			var newValue = player.volume + value;
			if (newValue <= 100) player.volume = newValue; else player.volume = 100;
		} else {
			var oldValue = player.settings.volume; 
			if (oldValue + value <= 100) player.settings.volume = oldValue + value; else  player.settings.volume = 100; //pg2
		};
	};
};

componentAudio.prototype.actionVolumeDown = function(value)
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		if (this.isSafariMobileAudio || this.isSafariMobileVideo) { //pg2-iPad
			var newValue = player.volume - value;
			if (newValue >= 0) player.volume = newValue; else player.volume = 0;
		} else {
			var oldValue = player.settings.volume; 
			if (oldValue-value >= 0) player.settings.volume = oldValue - value; else player.settings.volume = 0; //pg2
		};
	};
};

componentAudio.prototype.setCurPos = function(strTime)
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) { //pg2-iPad -todo
		player.currentPosition = strTime;
	};
};

componentAudio.prototype.mediaLength = function()
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) { //pg2-iPad -todo
		return(parseInt(parseFloat(player.Duration) * 1000));
	} else {
		return 0;
	};
};

componentAudio.prototype.getClipLength = function()
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) { //pg2-iPad -todo
		return player.SelectionEnd;
	} else {
		return 0;
	};
};

componentAudio.prototype.getCurPos = function(getString)
{
	var curPos = 0;
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) { //pg2-iPad -todo
		curPos = player.currentPosition;
		if (getString) curPos = convertTimeToString(curPos);
	};
	return curPos;
};

componentAudio.prototype.convertTimeToString = function(dTime)
{
	var player = this.getPlayerObj(); //var player = document.getElementById(this.id + "MediaPlayer"); //pg2-bi_audioUPFrame
	if (player) {
		dTime = new Date(1, 1, 1, 0, 0, dTime);
		hh = dTime.getHours();
		mm = dTime.getMinutes();
		ss = dTime.getSeconds();
		if (hh < 10) hh = "0" + hh;
		if (mm < 10) mm = "0" + mm;
		if (ss < 10) ss = "0" + ss;
		dTime = hh + ":" + mm + ":" + ss;
	};
	return dTime;
};

componentAudio.prototype.showText = function()
{
	if (this.text != null && this.text != "" && this.textVisible &&
		PageInterface.GetValue("state") != psDesigning && PageInterface.GetValue("state") != psPreview)
	{
		if (this.allowGF) {
			text = '<font size="' + this.fontSize + '" face="' + this.fontFamily + '" color="' + this.fontColor + '">' + this.text + '</font>';
		} else {
			text = this.text;
		};
		PageInterface.Execute("addScrollText", text);
	};
};

componentAudio.prototype.firstMediaPlay = function()
{
	this.doStop();
	this.playTimer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.doPlay();}', 500);
};

componentAudio.prototype.actionMediaPlay = function()
{
	this.doPlay();
};

componentAudio.prototype.actionMediaStop = function()
{
	//this.setVisible(this.showPlayer); //pg2-bi_completion -video eventually ain't hidden (hidden, then- shown; action child.mediaStop invoked from page)
	this.doStop();
};

componentAudio.prototype.actionMediaPause = function()
{
	this.doPause();
};

componentAudio.prototype.onFree = function()
{
	this.stop();
	this.killTimer();
	this.killPreloadTimer();
};

componentAudio.prototype.changeplayState = function()
{
};

componentAudio.prototype.stepStop = function()
{
	this.hide();
	this.stop();
};
