var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var TFQuiz;
var zad_zaliczone = 0;
(function (_TFQuiz) {
    var TFQuiz = (function (_super) {
        __extends(TFQuiz, _super);
        function TFQuiz(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        TFQuiz.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        TFQuiz.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        TFQuiz.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.Elements.Color) {
                this.Color = this.Elements.Color;
            }
            else
                this.Color = "green";
            this.numberOfChecked = 0;
            this.createStaticElements();
            this.createQuestions();
            this.createInfo();
            EU.createSelectableElements(this);
        };
        TFQuiz.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        TFQuiz.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        TFQuiz.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        TFQuiz.prototype.createQuestions = function () {
            this.Questions = [];
            var positions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {
                positions.push(this.Elements.Questions[i].Position);
            }
            positions = EU.shuffleArray(positions);
            for (var i = 0; i < this.Elements.Questions.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = positions[i].x;
                var posY = positions[i].y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = (this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.type = i;
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans) + el.width / 2 + 40 + j * 40, posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans));
                    ans.inputEnabled = true;
                    ans.align = (this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue
                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        };
        TFQuiz.prototype.createInfo = function () {
            this.infoPremia = this.game.add.text(1300, 760, "Premia: 0 zł", this.Elements.Style);
            this.addChild(this.infoPremia);
            this.infoScore = this.game.add.text(100, 760, "X stwierdzeń zostało oznaczonych błędnie.", this.Elements.Style);
            this.infoScore.visible = false;
            this.addChild(this.infoScore);
        };
        TFQuiz.prototype.getJustedPositionX = function (just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        };
        TFQuiz.prototype.getJustedPositionY = function (just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        };
        TFQuiz.prototype.clearOfType = function (k) {
            EU.Log(k);
            for (var i = 0; i < this.Questions[k].Answers.length; i++) {
                EU.Log(this.Questions[k].Answers[i]);
                if (this.Questions[k].Answers[i].Element.name == "checked") {
                    EU.Log(k);
                    this.Questions[k].Answers[i].Element.setShadow(0, 0, "black");
                    this.numberOfChecked--;
                    this.Questions[k].Answers[i].Element.scale.set(1, 1);
                    this.Questions[k].Answers[i].Element.name = "unchecked";
                }
            }
        };
        TFQuiz.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        TFQuiz.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        TFQuiz.prototype.onInputDown = function (el, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.scale.set(1, 1);
                el.name = "unchecked";
            }
            else {
                this.clearOfType(el.type);
                el.setShadow(el.height / 15, el.height / 15, this.Color);
                this.numberOfChecked++;
                el.name = "checked";
                el.scale.set(1.3, 1.3);
            }
            this.checkIfEverythingIsCorrect();
        };
		TFQuiz.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
        TFQuiz.prototype.checkIfEverythingIsCorrect = function () {
            var srt = "Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked);
            this.infoPremia.text = "Premia: " + this.calculatePlayerPoints() + " zł";
            this.infoScore.text = "Oznaczono błędnie: " + (this.calculateMaxPoints() - this.calculatePlayerPoints());
            if (this.calculateMaxPoints() == this.numberOfChecked)
                this.infoScore.visible = true;
            if (this.calculatePlayerPoints() == this.calculateMaxPoints() && this.numberOfChecked == this.calculateMaxPoints() && EU.checkIfSelectablesAreCorrect(this)) {
                zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, -125, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
                    _super.prototype.nextTask.call(this);
                }
                return true;
            }
            zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        TFQuiz.prototype.calculateMaxPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue)
                        points++;
                }
            }
            return points;
        };
        TFQuiz.prototype.calculatePlayerPoints = function () {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked")
                        points++;
                }
            }
            return points;
        };
        return TFQuiz;
    })(Base.BasicGroup);
    _TFQuiz.TFQuiz = TFQuiz;
})(TFQuiz || (TFQuiz = {}));
//# sourceMappingURL=TFQuiz.js.map