var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ImageMath;
(function (_ImageMath) {
    var ImageMath = (function (_super) {
        __extends(ImageMath, _super);
        function ImageMath(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        ImageMath.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        ImageMath.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ImageMath.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            this.createSelectableElements();
            if (this.Elements.Options.Color)
                this.Color = this.Elements.Options.Color;
            if (this.Elements.Options.ColorText)
                this.ColorText = this.Elements.Options.ColorText;
        };
        ImageMath.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ImageMath.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        ImageMath.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        ImageMath.prototype.createSelectableElements = function () {
            this.Selectables = [];
            for (var i = 0; i < this.Elements.SelectableElements.length; i++) {
                var Element = [];
                var tmpline = 0;
                for (var j = 0; j < this.Elements.SelectableElements[i].NumberOfElements; j++) {
                    var el;
                    switch (this.Elements.SelectableElements[i].el.type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.SelectableElements[i].el.key);
                            el.events.onInputDown.add(this.onInputDown, this);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.SelectableElements[i].el.text, this.Elements.Options.Style);
                            el.events.onInputDown.add(this.onInputText, this);
                            break;
                    }
                    var posX = this.Elements.SelectableElements[i].Position.x;
                    var posY = this.Elements.SelectableElements[i].Position.y;
                    if (this.Elements.Options.Just) {
                        switch (this.Elements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2 - ((this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements) / 2;
                                el.anchor.x = 0;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120 - (this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements;
                                el.anchor.x = 0;
                                break;
                        }
                        switch (this.Elements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    if (this.Elements.SelectableElements[i].NumberOfElementsPeerLine) {
                        if (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine == 0) {
                            tmpline = tmpline + 1;
                        }
                        posX = posX + (el.width) * (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine);
                        posY = posY + (el.height) * (tmpline);
                        el.position.set(posX, posY);
                    }
                    else {
                        el.position.set(posX + (this.Elements.Options.Spacing + el.width) * j, posY);
                    }
                    el.inputEnabled = true;
                    el.name = "unchecked";
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    this.addChild(el);
                    Element.push(el);
                }
                this.Selectables.push(Element);
            }
        };
        ImageMath.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        ImageMath.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        ImageMath.prototype.onInputDown = function (el, pointer) {
            if (el.name == "unchecked") {
                el.tint = this.Color;
                el.name = "checked";
            }
            else {
                el.name = "unchecked";
                el.tint = 0xFFFFFF;
            }
            this.checkIfEverythingIsCorrect();
        };
        ImageMath.prototype.onInputText = function (el, pointer) {
            if (el.name == "unchecked") {
                el.setShadow(el.height / 25, el.height / 25, this.ColorText);
                el.name = "checked";
            }
            else {
                el.setShadow(0, 0, "black");
                el.name = "unchecked";
            }
            this.checkIfEverythingIsCorrect();
        };
        ImageMath.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log(this.calculatePlayerPoints() + "/" + this.calculateMaxPoints());
            if (this.calculateMaxPoints() == this.calculatePlayerPoints()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Everyting Correct!!!");
                if (TYPE === "gm")
                    _super.prototype.nextTask.call(this);
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        ImageMath.prototype.calculatePlayerPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Selectables.length; i++) {
                var checked = 0;
                for (var j = 0; j < this.Selectables[i].length; j++) {
                    if (this.Selectables[i][j].name == "checked") {
                        checked++;
                    }
                }
                if (checked == this.Elements.SelectableElements[i].CorrectNumOfElements) {
                    points++;
                }
            }
            return points;
        };
        ImageMath.prototype.calculateMaxPoints = function () {
            return this.Elements.SelectableElements.length;
        };
        return ImageMath;
    })(Base.BasicGroup);
    _ImageMath.ImageMath = ImageMath;
})(ImageMath || (ImageMath = {}));
//# sourceMappingURL=ImageMath.js.map