/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("object.js");

function destroy(obj) {
	delete obj;
};

var wbteObjectsCount = 0;
var wbteZIndex = 0;
var pc = new Object();

function WBTObject()
{
	this.setID("WBTObject" + wbteObjectsCount++);
	this.index = wbteObjectsCount;
	this.isChild = false;
	this.isCore = false;
	this.invokeEvt = true;
	this.created = false;
	this.obj = null;
	this.parent = null;
	this.execution = null;
	this.z = 0;
	this.children = [];
};

WBTObject.prototype.setID = function(id)
{
	if (pc[this.id]) delete pc[this.id];
	this.id = id;
	pc[this.id] = this;
}; 

WBTObject.prototype.addChild = function(o, id, core)
{
	if (o.isChild) o.parent.removeChild(o);
	o.isChild = true;
	o.parent = this;

	if (id) {
		o.obj = document.getElementById(id);
		o.execution = "wbte";
	};

	if (core) {
		o.isCore = true;
	};

	if (this.created) o.create();
	this.children[this.children.length] = o;

	return o;
}; 

WBTObject.prototype.removeChild = function(o)
{
	var l = this.children.length;
	for (var i=0;i<l && this.children[i]!=o;i++);
	if (i!=l) {
		o.invokeEvent("BeforeRemove");
		o.created=false;
		o.invokeEvent("Remove");
		o.isChild = false;
		o.parent = null;
		this.children[i] = this.children[l-1];
		this.children[l-1] = null;
		this.children.length--;
	};
};

WBTObject.prototype.create = function()
{
	this.z = ++wbteZIndex;

	this.specificCreate();
	this.created = true;
	var l = this.children.length;

	for (var i = 0; i < l; i++) {
		this.children[i].create();
	};

	if (this.invokeEvt) {
		this.invokeEvent("BaseCreate");
		this.invokeEvent("Create");
		this.invokeEvent("PreloadImages");
	};
}; 

WBTObject.prototype.free = function()
{
	this.invokeEvent("BeforeRemove");
	this.deleteAllChildren();
	this.specificRemove();
	this.created = false;
	this.invokeEvent("Remove");
	this.invokeEvent("Free");
	__of[__of.length] = this;
};

WBTObject.prototype.deleteChild = function(o) {
	var l = this.children.length;
	for (var i=0;i<l && this.children[i]!=o;i++);
	if (i!=l) {
		this.children[i] = this.children[l-1];
		this.children[l-1] = null;
		this.children.length--;
		o.free();
		o = null;
	};
};

WBTObject.prototype.deleteAllChildren = function()
{
	while (this.children.length > 0) {
		this.children[this.children.length - 1].free();
		this.children[this.children.length - 1] = null;
		delete this.children[this.children.length - 1];
		this.children.pop();
	};
}; 

WBTObject.prototype.findChildByName = function(name)
{
	for (var i=0; i<this.children.length; i++) {
		if (this.children[i].id == name) return this.children[i];
		if (this.children[i].children) {
			var result = this.children[i].findChildByName(name);
			if (result) return result;
		};
	};
	return null;    
};

WBTObject.prototype.invokeEventForAllObj = function(objArray, type, args)
{
	var res = false;
	for (var i = 0; i < objArray.length; i++) {
		res = (res || objArray[i].invokeEvent(type, args));
	};
	return res;
};

WBTObject.prototype.invokeEvent = function(type, args)
{
	try {
		var ev = (window.event) ? event : ((args)?args:e);
		if (this["on" + type]) return this["on" + type](ev, args);
	} catch (e) {};
	return false;
}; 

WBTObject.prototype.actionRunScript = function(s) 
{
	if (runScriptOnError) {
		runScriptSrc = unescape(s);
		window.onerror = runScriptOnError;
	};
	var vars = "var event=window.event;";
	try { //pg2- if error, show info, but in page preview only
		eval(vars + unescape(s));
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert('action RunScript(...) execution error\nMessage:\n' + e.message);
	};
	if (runScriptOnError) {
		runScriptSrc = "";
		window.onerror = null;
	};
};

WBTObject.prototype.actionRunFileScript = function(s) 
{
	if (runScriptOnError) {
		runScriptSrc = unescape(s);
		window.onerror = runScriptOnError;
	};
	var vars = "var event=window.event;";
	try { //pg2- if error, show info, but in page preview only
		eval(vars + unescape(s));
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert('action RunFileScript(...) execution error\nMessage:\n' + e.message);
	};
	if (runScriptOnError) {
		runScriptSrc = "";
		window.onerror = null;
	};
};

WBTObject.prototype.initZIndex = function(index)
{
	this.z = index || 0;
	for (var i=0; i<this.children.length; i++) {
		var z = this.z + i + 1;
		this.children[i].z = z;
		this.children[i].obj.style.zIndex = z;
	};
	return this.z + this.children.length;
};

var runScriptSrc = "";

function runScriptOnError(msg, url, lnum) {
	if (log) log.error(msg, 'Blad wykonania skryptu: ' + runScriptSrc + '\n');
	return true;
};

WBTObject.prototype.specificRemove = function() {};
WBTObject.prototype.specificCreate = function() {};

//deprecated
WBTObject.all = pc;
/********************************************************************/
