/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentSLWHint = function(name)
{
	this.componentHotspot = componentHotspot;
	this.componentHotspot(name);
	
	this.iTimerID = null;
	this.imagesNameArr = new Array();
};

componentSLWHint.prototype = new componentHotspot();
componentSLWHint.prototype.type = "componentSLWHint";

componentSLWHint.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(lms.resourcesURL());
};

componentSLWHint.prototype.onPaint = function(obj)
{
	//override
}

componentSLWHint.prototype.onCreate = function(obj)
{
	this.imagesNameArr = [	this.hintImageSrcUpRight, this.hintImageSrcUpLeft, this.hintImageSrcDownLeft, this.hintImageSrcDownRight ];	
	this.getPreloadImagesArr();
	this.setHTMLObiects();
	this.placeHTMLObiects(this.position);
};

componentSLWHint.prototype.setHTMLObiects = function(obj)
{
	document.getElementById(this.id + "_arrowContentObj").src = this.getSrc(this.position);
};

componentSLWHint.prototype.placeHTMLObiects = function(value)
{
	var hintDIV = document.getElementById(this.id + "_hintDIV");
	var arrowDIV = document.getElementById(this.id + "_arrowDIV");
	
	hintDIV.style.borderStyle = "solid";
	hintDIV.style.borderColor = this.popupBorderColor;
	hintDIV.style.borderWidth = this.popupBorderWidth;								
	
	var arrowOffsetW = (value == 'none') ? 12:this.hintImageWidth;
	var arrowOffsetH = (value == 'none') ? 12:this.hintImageHeight;
	
	var divWidth = this.w-arrowOffsetW+this.slipText;
	var divHeight = this.h-arrowOffsetH+this.slipText;
	hintDIV.style.width = divWidth;
	hintDIV.style.height = divHeight;		
	hintDIV.style.clip = 'rect(0px '+divWidth+'px '+divHeight+'px 0px)';
		
	switch (value){
		case "topleft":
				arrowDIV.style.left = 0;
				arrowDIV.style.top = 0;			
				hintDIV.style.top = this.hintImageHeight-this.slipText;
				hintDIV.style.left = this.hintImageWidth-this.slipText;				
			break;
		case "topright":
				arrowDIV.style.left = this.w-this.hintImageWidth;
				arrowDIV.style.top = 0;				
				hintDIV.style.top = this.hintImageHeight-this.slipText;
				hintDIV.style.left = 0;
			break;
		case "bottomleft":
				arrowDIV.style.left = 0;
				arrowDIV.style.top = this.h-this.hintImageHeight;				
				hintDIV.style.top = 0;
				hintDIV.style.left = this.hintImageWidth-this.slipText;
			break;
		case "bottomright":
				arrowDIV.style.left = this.w-this.hintImageWidth;
				arrowDIV.style.top = this.h-this.hintImageHeight;				
				hintDIV.style.top = 0;
				hintDIV.style.left = 0;
			break;
		default:
				arrowDIV.style.display = 'none';
				hintDIV.style.top = 0;
				hintDIV.style.left = 0;
			break;
	};
};

componentSLWHint.prototype.getSrc = function(value)
{
	var result = '';
	switch (value) {
		case "topright":
			result = this.resourcesURL + this.hintImageSrcUpLeft;
			break;
		case "bottomleft":
			result = this.resourcesURL + this.hintImageSrcDownLeft;
			break;
		case "bottomright":
			result = this.resourcesURL + this.hintImageSrcDownRight;
			break;
		default:
			result = this.resourcesURL + this.hintImageSrcUpRight;
			break;
	}
	return result;
};

componentSLWHint.prototype.componentSLWHintBaseShow = componentSLWHint.prototype.show;
componentSLWHint.prototype.show = function()
{
	if (PageInterface.GetValue("state") == psDesigning || this.visible == true) {
		this.componentSLWHintBaseShow();
		this.setOnTop();
	} else {
		this.tickOpac(0, this.id)
		this.componentSLWHintBaseShow();
		this.setOnTop();
		this.opacity(this.id, 0, 100, this.waneSpeed);
	}
}

componentSLWHint.prototype.componentSLWHintBaseHide = componentSLWHint.prototype.hide;
componentSLWHint.prototype.hide = function()
{
	if (this.step != 0)
	{
		if (PageInterface.GetValue("state") == psDesigning || this.visible == false) {
			this.componentSLWHintBaseHide();
		} else {
			this.opacity(this.id, 100, 0, this.waneSpeed);
			window.setTimeout('pc.'+this.id+'.componentSLWHintBaseHide()', 500);
		}
	}
}

componentSLWHint.prototype.opacity = function(id, opacStart, opacEnd, millisec)
{
    var speed = Math.round(millisec / 100);
    var timer = 0;

    if(opacStart > opacEnd) {
        for(i = opacStart; i >= opacEnd; i--) {
            setTimeout("pc."+this.id+".tickOpac(" + i + ",'" + id + "')",(timer * speed));
            timer++;
        }
    } else if(opacStart < opacEnd) {
        for(i = opacStart; i <= opacEnd; i++)
            {
            setTimeout("pc."+this.id+".tickOpac(" + i + ",'" + id + "')",(timer * speed));
            timer++;
        }
    }
};

componentSLWHint.prototype.tickOpac = function(opacity, id)
{
	this.changeOpac(opacity, id+"_hintDIV");
	this.changeOpac(opacity, id+"_arrowDIV");
};

componentSLWHint.prototype.changeOpac = function(opacity, id)
{
    var object = document.getElementById(id).style;
    object.opacity = (opacity / 100);
    object.MozOpacity = (opacity / 100);
    object.KhtmlOpacity = (opacity / 100);
    object.filter = "alpha(opacity=" + opacity + ")";
}
