/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
componentSLWToolBar = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.panelWidth = 0;
	
	this.imagesCompleteInfo = new Array();
	this.coloursInfo = new Array();
};

componentSLWToolBar.prototype = new componentElement();
componentSLWToolBar.prototype.type = "componentSLWToolBar";

componentSLWToolBar.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		}
	};
	this.captureMouseEvents();
	this.setCompleteArrayInfo( this.completeImagesInfo );
	this.setColoursInfo( this.buttonsColours );
};


componentSLWToolBar.prototype.onCreate = function(obj)
{
	var buttonsArr = unescape(this.content).split('||');
	var toolbar = "<p style='white-space: nowrap;'>";

	if (this.dir == "rtl") {
		this.panelWidth = this.w;
	} else {
		this.panelWidth = 0;
	}
	for (var i=0; i < buttonsArr.length; i++){
		toolbar += this.getButtonHTML(buttonsArr[i], i);
	};
	toolbar += "</p>"
	
	this.setHTML(toolbar);
}

componentSLWToolBar.prototype.getButtonHTML = function(button, i)
{
	var t = "";
	var infoArr = button.split('#!#');
	
	if (infoArr[2] == "") infoArr[2] = infoArr[1];
	if (infoArr[3] == "") infoArr[3] = infoArr[1];
	
	var font = getProjectFont(this.globalFormating, this.fontFamily, this.fontSize, this.fontColor);
	
	if (infoArr[0] != 'icon'){
		var captWidth = this.getImageWidth(infoArr[1]);
	}else if (this.isVerctical){
		var captWidth = this.getCaptionWidth(infoArr[4], font.family, getFontSize(font.size, 'px')) + 14;
	}else{
		var captWidth = this.getCaptionWidth(infoArr[4], font.family, getFontSize(font.size, 'px')) + 14 + this.getImageWidth(infoArr[1]);
	}

	if (this.dir == "rtl") {
		this.panelWidth -= captWidth;
	}
	
	t += '<div id="'+this.id+'div'+i+'" style="background:'+this.coloursInfo['outBckgColor']+'; border: 1px solid '+this.coloursInfo['outBorder']+'; top:0px; left:'+this.panelWidth+'px; width: '+captWidth+'px; height: '+this.h+'px; clip: rect(0px '+captWidth+'px '+this.h+'px 0px); position: absolute;"';
	if (infoArr[0] == 'icon'){
		t += ' onMouseover="pc.'+this.id+'.doOver('+i+', \''+infoArr[2]+'\');"';
		t += ' onMouseout="pc.'+this.id+'.doOut('+i+', \''+infoArr[1]+'\');"';
		t += ' onMousedown="pc.'+this.id+'.doClick('+i+', \''+infoArr[3]+'\', \''+infoArr[5]+'\', \''+infoArr[6]+'\');"';
		t += ' onMouseup="pc.'+this.id+'.doOver('+i+', \''+infoArr[2]+'\');"';
	}
	t += ' >';
	t += '<table cellSpacing="0" cellPadding="0" width="100%" height="100%"><tr><td align="center" valign="middle">';
	t += '<img id="'+this.id+'icon_'+i+'" src="'+this.resourcesURL + infoArr[1]+'" ></td>';
	t += (this.isVerctical) ? '</tr><tr>' : '';
	t += '<td align="center" valign="middle">';
	t += '<font style="font-family:'+font.family+'; font-size:'+getFontSize(font.size, 'px')+'px; color:'+font.color+'; white-space: nowrap;';
	t += ' ">';
	t += (this.fontBold) ? '<b>'+infoArr[4]+'</b>' : infoArr[4];
	t += '</td></tr>';
	t += '</table>';
	t += '</div>';
	
	if (this.dir == "rtl") {
//		this.panelWidth -= captWidth;
	} else {
		this.panelWidth += captWidth;
	}
	
	return t;
}

componentSLWToolBar.prototype.doOver = function(ID, imgOver)
{
	var obj = document.getElementById(this.id+'icon_'+ID);
	var div = document.getElementById(this.id+'div'+ID);
	
	if (obj) obj.src = this.resourcesURL + imgOver;
	if (div) {
		div.style.border = '1px solid '+this.coloursInfo['overBorder'];
		div.style.backgroundColor = this.coloursInfo['overBckgColor'];
	}
}

componentSLWToolBar.prototype.doOut = function(ID, imgOut)
{
	var obj = document.getElementById(this.id+'icon_'+ID);
	var div = document.getElementById(this.id+'div'+ID);
	
	if (obj) obj.src = this.resourcesURL + imgOut;
	if (div) {	
		div.style.border = '1px solid '+this.coloursInfo['outBorder'];
		div.style.backgroundColor = this.coloursInfo['outBckgColor'];
	}
}

componentSLWToolBar.prototype.doClick = function(ID, imgOut, action, aaaa)
{
	var obj = document.getElementById(this.id+'icon_'+ID);
	var div = document.getElementById(this.id+'div'+ID);
	
	if (obj) obj.src = this.resourcesURL + imgOut;
	if (div) {
		div.style.border = '1px solid '+this.coloursInfo['clickBorder'];
		div.style.backgroundColor = this.coloursInfo['clickBckgColor'];
	}
	try{
		eval('pc.'+action+';');	
	}catch(e){}
}

componentSLWToolBar.prototype.setCompleteArrayInfo = function( buttons )
{
	var imagesStr = buttons;
	
	var imgArr = imagesStr.split('||');
	for (var i = 0; i < imgArr.length; i++){
		var oneImg = imgArr[i].split(';');
		if (!this.imagesCompleteInfo[oneImg[0]]){
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];		
		};
	};
};

componentSLWToolBar.prototype.setColoursInfo = function( colours )
{
	var coloursArr = colours.split('||');
	for (var i = 0; i < coloursArr.length; i++){
		var color = coloursArr[i].split(';');
		if (!this.coloursInfo[color[0]]){
			this.coloursInfo[color[0]] = (color[1] == '')?'transparent':color[1];
		};
	};
};

componentSLWToolBar.prototype.getCaptionWidth = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		obj.style.whiteSpace = 'nowrap';
		return obj.offsetWidth;
	};
	return 0;
}

componentSLWToolBar.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentSLWToolBar.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};








