/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentCourseTree = function(name) {
	this.componentPagesList = componentPagesList;
	this.componentPagesList(name);

	this.src = '';
	this.menu = '';

	this.treeCreated = false;
	this.pagesArr = new Array();

	this.imagesArr = new Array();

	this.giubModeMainBranchOriented = true; //pg2-giub
};

componentCourseTree.prototype = new componentPagesList();
componentCourseTree.prototype.type = "componentCourseTree";

componentCourseTree.prototype.onBaseCreate = function(obj) {
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;	else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [this.bckgTop, this.bckgMiddle, this.bckgBottom, this.bckgSeparator, this.buttonCloseOut, this.buttonCloseOver];
	this.getPreloadImagesArr();
	if (this.expand == 'currentBranchOnly') this.focusColorStretch = true; //pg2-giub

	//this.treeFontBold = true; //test
	//this.treeFontItalic = true; //false;
	//this.treeFontUnderline = true;
	//this.treeFontSize = 3;
	//this.traceMouse = true;
};

componentCourseTree.prototype.getStruct = function() {
	var struct = getStruct();
	if (!struct) {
		var page1 = {
			"gix": 1,
			"index": 1,
			"title": this.exampleTitle + " 1",
			"realParent": 0,
			"status": "N",
			"visible": 1,
			"haveParent": false
		};
		var page2 = {
			"gix": 2,
			"index": 2,
			"title": this.exampleTitle + " 2",
			"realParent": 0,
			"status": "N",
			"visible": 1,
			"haveParent": false
		};
		var page3 = {
			"gix": 3,
			"index": 3,
			"title": this.exampleTitle,
			"realParent": 2,
			"status": "N",
			"visible": 1,
			"haveParent": false
		};

		struct = new Object();

		struct.m_list = new Array();
		struct.m_list = [page1, page2, page3];

		struct.length = function() {return 3; };
		struct.rootItem = function() {return {"title":"rootTitle", "index":0, "parent":1}; };
		struct.item = function(index) {return this.m_list[index]; };
	};

	return struct;
};

componentCourseTree.prototype.onShow = function()
{
	if (typeof(this.bringToFront) != "undefined") this.bringToFront(); //pg2- in old wbte, it could be undefined and an exception will be invoked; result = no tree

	var struct = this.getStruct();
	var structLength = struct.length();

	var player = getPlayer(); //pg2-multiversions

	if (this.expand == 'currentBranchOnly' && this.treeCreated) { //pg2-GIUB_test
		this.treeCreated = false;
		//prevObj = document.getElementById('__bckg__bg00001_courseTree1-tree-item-2-anchor');
		treeDiv = document.getElementById(this.id + '_treeDIV');
		if (treeDiv) treeDiv.innerHTML = '';
		for (var i=this.pagesArr.length-1; i>=0; i--) {
			var item = this.pagesArr[i];
			if (item) delete item;
		};
		delete this.pagesArr;
		this.menu = '';
		this.pagesArr = new Array();
		this.setTree();
	};

	if (!this.treeCreated) {
		if (this.treeType == 0) {
			this.objComboMenu = new comboMenu(this.id, page.p_globalIndex);
			this.objComboMenu.insertTree(struct);
			this.menu = this.objComboMenu.tree;
		} else 
		if (this.treeType == 1) {
			if (this.useImagesBckg) {
				var bckgTopH = getImageHeight(this.bckgTop);
			} else {
				var bckgTopH = 0;
			};
			this.setNewTreeImages(this.treeImages);

			var chaptersColors = this.chaptersColors.split('||');

			var fontSize = getFontSize(this.treeFontSize, 'px');
			var ind = struct.m_list[0];
			var addIndexShift = 0;
			if (structPage && structPage.index == 0) 
			addIndexShift = 2;
			var multiSCOInd = 0;
			var chColorIndex = 0;
			var chapterColor = '';
			var ind = 0;

			for (var i = 0; i < structLength; i++) {
				var structPage = struct.m_list[i];
				if (structPage.visible == 1) {
					//pg2-multiversions
					var pageTitle = structPage.title;
					if (player) {
						try {
							var version = player.courseVersion;
								pageTitle = struct.item(i)["title" + version];
						} catch(e) {
							pageTitle = structPage.title;
						};
					};
					//
					var pageIndex = parseInt(structPage.index) + addIndexShift;
					if (structPage.realParent == '1') {
						ind = chColorIndex % chaptersColors.length;
						chapterColor = chaptersColors[ind];
						chColorIndex++;
					} else 
					if (this.colorOnlyChapterPage) {
						chapterColor = 'transparent';
					};
					if (page && page.pageType == 'Information' && config.setCompleteStatusAtPageStartup && structPage.gix == page.p_globalIndex) { //pg2-GIUB
						structPage.status = 'C';
					};

					var item = new courseTreePageItem(
									i, 
									this.id, 
									structPage.gix,
									pageIndex, 
									//structPage.title,  //pg2-removed, replaced with below one
									pageTitle, //pg2-multiversions 
									'pc.' + this.id + '.checkIsGoToAllowed(' + structPage.gix + ', ' + pageIndex + ', ' + multiSCOInd + ')', 
									structPage.realParent, 
									structPage.status, 
									this.addPrefix, 
									this.resourcesURL, 
									this.imagesArr['pageNotAtt'], 
									this.imagesArr['pageIncomplete'], 
									this.imagesArr['pageCompleted'],
									this.imagesArr['pagePass'], 
									this.imagesArr['pageFail'], 
									this.imagesArr['blankIcon'], 
									this.imagesArr['minusIcon'], 
									this.imagesArr['plusIcon'], 
									this.treeFontFamily, 
									fontSize, 
									this.treeFontColor,
									chapterColor, 
									(structPage.realParent == '1'),
									(this.focusColorStretch?this.width:''), //pg2-new
									this.replaceInChapters,
									this.borderColor,
									(this.borderRows?1:0),
									this.pageNameFocusColor, 
									this.pageNameTitleColor, 
									this.bgColor,
									this.traceMouse, //pg2-draw selection bar while mouse is over page, and delete it when mouse is out
									(this.expand == 'currentBranchOnly'), //pg2-GIUB
									structPage //pg2-GIUB -expand-collapse subchapter
						);
					multiSCOInd++;
					this.addChildToParent(structPage.realParent, item);
					this.pagesArr[pageIndex] = item;
				};
			};

			if (this.showTREEicons) {
				this.menu += '<p>';
				this.menu += '<img src="' + this.resourcesURL + this.TREE_maksymalize + '" border="0" style="cursor: pointer;" onClick="pc.' + this.id + '.expandAllTree();"/>';
				this.menu += '&nbsp;';
				this.menu += '<img src="' + this.resourcesURL + this.TREE_minimalize + '" border="0" style="cursor: pointer;" onClick="pc.' + this.id + '.collapseAllTree();"/>';
				this.menu += '</p>';
			};

			var rulerStr = //pg2-GIUB
				'<SPAN id="' + this.id + '_ruler" style="visibility: hidden; white-space: nowrap; width: auto;' + //pg2-test- 'visible' instead of 'hidden'
				'font-weight: ' + (this.treeFontBold?'bold; ':'normal; ') +
				'font-style: ' + (this.treeFontItalic?'italic; ':'normal; ') +
				'text-decoration: ' + (this.treeFontUnderline?'underline; ':'none; ') +
				'font-family: ' + this.treeFontFamily + '; ' +
				'font-size: ' + getFontSize(this.treeFontSize, 'px') + 'px; ' +
				//'color: red; ' + //pg2-test
				'"></SPAN>';

			var chaptersNamesArr = this.chaptersNames.split('||');
			for (var i in this.pagesArr) {
				if (this.pagesArr[i] && !this.pagesArr[i].haveParent) {
					if (!this.isInArray(chaptersNamesArr, this.pagesArr[i].title)) {
						this.menu += this.pagesArr[i].toString();
					};
				};
			};

			if (this.expand == 'currentBranchOnly') this.menu += rulerStr; //pg2-GIUB
		} else 
		if (this.treeType == 2) {
			this.objCascadeMenu = new cascadeMainMenu(this.id);
			this.objCascadeMenu.insertTree(struct);
			this.menu = this.objCascadeMenu.tree;
		};
		this.setTree();
		this.treeCreated = true;
	};

	if (this.treeType == 1) {
		var single = checkExportType(config.exportDetails, 'single');
		var singleMulti = checkExportType(config.exportDetails, 'singleMulti');

		if (single || singleMulti) {
			this.setTreeIconsStatus(struct);
		} else {
			if (PageInterface.GetValue('isExam')) {
				this.setTreeIconsStatus_mltpSCO(struct, true);
			} else {
				var viewMode = PageInterface.GetValue("state"); //pg2-GIUB -course preview
				if (viewMode == psDesigning || viewMode == psView) {
					this.setTreeIconsStatus(struct); //pg2-GIUB -course preview
				} else {
					this.setTreeIconsStatus_mltpSCO(struct, false);
				};
			};
		};
		if (PageInterface.GetValue("state") == psDesigning) {
			this.setFocus(1);
		};
	};
	this.expandTree();
};

componentCourseTree.prototype.expandTree = function() {	
	//pg2-GIUB
	var currentPageTreeItem = null;
	var openPageIndex = 1; //pg2-select current page
	if (opener) {
		openPageIndex = parseInt(opener.PageInterface.GetValue('pageIndex'));
	} else {
		openPageIndex = parseInt(PageInterface.GetValue('pageIndex'));
	};
	currentPageTreeItem = this.setFocus(openPageIndex);

	//this.setFocus(PageInterface.GetValue("pageIndex")); //pg2-GIUB -removed
	if (this.treeType == 1) {
		/* //pg2-GIUB -moved higher
		var openPageIndex = 1; //pg2-select current page
		if (opener) {
			openPageIndex = parseInt(opener.PageInterface.GetValue('pageIndex'));
		} else {
			openPageIndex = parseInt(PageInterface.GetValue('pageIndex'));
		};
		this.setFocus(openPageIndex); */

		switch (this.expand) {
			case 'openBranch':
				this.expandPageParents(openPageIndex); //this.expandPageParents(PageInterface.GetValue("pageIndex")); //pg2-GIUB -removed
				break;
			case 'openAll':
				this.expandAllTree();
				break;
			case 'currentBranchOnly': //pg2-GIUB_test
				if (currentPageTreeItem.parentObj == null) { //pg2-GIUB -expand-collapse subchapter; main chapters
					this.expandCurrentBranchCollapseTheRest(currentPageTreeItem);
				} else { //new one
					if (this.giubModeMainBranchOriented) { //pg2-GIUB -switch
						var topParent = this.findTopParent(currentPageTreeItem);
						if (topParent) this.expandAllBranch(topParent);
					} else {
						this.expandPageParents(openPageIndex);
						if (currentPageTreeItem.children.length > 0) {
							if (currentPageTreeItem.structPage != null) {
								if (typeof(currentPageTreeItem.structPage.expanded) != 'undefined' && currentPageTreeItem.structPage.expanded != null) {
									if (currentPageTreeItem.structPage.expanded == true) this.collapseAllBranch(currentPageTreeItem); else this.expandAllBranch(currentPageTreeItem);
								};
							};
						} else {
							//var topParent = this.findTopParent(currentPageTreeItem);
							//if (topParent != null) this.processItemsInTopChapter(topParent);
						};
					};
				};
				var viewMode = PageInterface.GetValue("state");
				if (viewMode != psDesigning) { //pg2-otherwise
					window.setTimeout('pc.' + this.id + '.processItemsStyles();', 30); //pg2-otherwise some values for icon won't be evaluated...yet //this.processItemsStyles(); //pg2-GIUB -line wrap
				};
				break;
		};
	};
};

componentCourseTree.prototype.processItemsStyles = function() //pg2-GIUB
{
	//var str = ''; //pg2-test
	//top.window.document.title = '';
	var rulerObj = document.getElementById(this.id + '_ruler');
	for (var i=0; i<this.pagesArr.length; i++) {
		var item = this.pagesArr[i];
		if (typeof(item) != 'undefined' && item != null) {
			var anchorName = item.id + '-anchor';
			var contentName = item.id + '-cont';
			var iconName = item.compName + '_' + item.posInStruct + '_icon';
			var anchorObj = document.getElementById(anchorName); //pg2-object for css processing
			var contObj = document.getElementById(contentName);
			var iconObj = document.getElementById(iconName);

			var focusObj = document.getElementById(item.id + '-focus');

			if (anchorObj && contObj && iconObj && focusObj) { //
				var imgLeft = iconObj.offsetLeft;
				var imgWidth = iconObj.offsetWidth;
				var anchorLeft = anchorObj.offsetLeft;
				var anchorWidth = anchorObj.offsetWidth;
				var anchorHeight = anchorObj.offsetHeight;
				var anchorHeightOrig = anchorHeight;				
				if (iconObj.offsetWidth == 0) continue; //skip collapsed/not visible items

				imgWidth = 1;
				anchorWidth = this.width-10; //this.width-10;
				var newWidth = anchorWidth - (imgLeft) - (imgWidth*2);// -10; //new -10

				anchorObj.style.display = 'inline-block'; focusObj.style.display = 'inline-block';
				if (!is.ie6 && !is.ie7 && !is.ie8) {
					anchorObj.style.whiteSpace = 'normal'; //'nowrap'; -NOWRAP didn't work in IE9//'nowrap'; //anchorObj.style.whiteSpace = 'pre'; //anchorObj.style.whiteSpace = 'normal';
				} else {
					anchorObj.style.whiteSpace = 'normal';
				};
				anchorObj.style.width = newWidth + 'px'; //anchorObj.style.width = newWidth + 'px';
				//anchorObj.style.height = 'auto'; //anchorObj.style.height = newHeight + 'px';
				focusObj.style.width = (this.width-20) + 'px';

				iconObj.style.top = iconObj.offsetTop;
				anchorObj.style.top = (focusObj.offsetTop + 3) + 'px'; //+3
				anchorObj.style.left = (imgLeft + imgWidth + 2 - 20) + 'px'; //-20
				//focusObj.style.height = 'auto'; //focusObj.style.height = (newHeight + 6) + 'px';

				var aWidth = anchorObj.offsetWidth;
				var aLeft = anchorObj.offsetLeft;
				var diff = this.width - aWidth - aLeft - 20;
				if (diff > 0) {
					//anchorObj.style.width = anchorObj.offsetWidth + diff + 'px';
				};

				if (rulerObj) {
					rulerObj.innerHTML = anchorObj.title;
					var rWidth = rulerObj.offsetWidth;
					var rHeight = rulerObj.offsetHeight;

					//alert(anchorObj.title + '\n\n' + rWidth + ', ' + aWidth + ' : ' + (rWidth > aWidth) + '\n\n' + anchorObj.clientWidth);
					//alert(rWidth + ', ' + aWidth);
					if ((rWidth > aWidth && !is.ie6 && !is.ie7 && !is.ie8) || is.ie9 || is.ie10) { //pg2-new -IE9/10 -do it always
							this.processItemsDimentions(rulerObj, anchorObj, focusObj);
					} else {
						anchorObj.style.height = (anchorObj.offsetHeight + 3) + 'px';
						focusObj.style.height = (anchorObj.offsetHeight + 6) + 'px';
					};
				} else {
					anchorObj.style.height = (anchorObj.offsetHeight + 3) + 'px';
					focusObj.style.height = (anchorObj.offsetHeight + 6) + 'px';
				};
			};
		};
	};
	var mainDiv = document.getElementById(this.id + '_treeDIV');
	if (mainDiv) {
		mainDiv.style.overflowX = 'hidden';
		mainDiv.style.overflowY = 'auto';// 'auto';
		if (is.ie && !is.ie6 && !is.ie7 && !is.ie8) {
			mainDiv.style.clip = 'auto';
			mainDiv.style.clipbottom = 'auto';
			mainDiv.style.cliptop = 'auto';
			mainDiv.style.clipright = 'auto';
			mainDiv.style.clipleft = 'auto';
		};
	};
	//alert(str);
};

componentCourseTree.prototype.processItemsDimentions = function(rulerObj, anchorObj, focusObj)
{
	if (typeof(rulerObj) == 'undefined' || typeof(anchorObj) == 'undefined' || typeof(focusObj) == 'undefined' ||
	    rulerObj == null || anchorObj == null || focusObj == null) return;

	//var imgStr2Add = "<img src=\"" + this.resourcesURL + this.blankIcon + "\">";
	var rulerTextOrig = anchorObj.title; //replace(/<[^>]*>/g, "");
	while (rulerTextOrig.lastIndexOf(' ') == rulerTextOrig.length-1) { //remove spaces from the end of the line
		rulerTextOrig = rulerTextOrig.slice(0, rulerTextOrig.length-1);
	};
	while (rulerTextOrig.lastIndexOf(' ') == 0) { //remove spaces from the beginning of the line
		rulerTextOrig = rulerTextOrig.slice(1);
	};

	var rulerWidth = rulerObj.offsetWidth;
	var rulerHeight = rulerObj.offsetHeight;
	var anchorWidth = anchorObj.offsetWidth;
	//var anchorHeight = anchorObj.offsetHeight;
	var str = '';
	var maxLineCharactersCount = 0;
	var c = '';
	for (var i=0; i<rulerTextOrig.length; i++) {
		c = rulerTextOrig.substring(i,i+1);
		str += c;
		rulerObj.innerHTML = str;
		if (rulerObj.offsetWidth > anchorWidth) {
			maxLineCharactersCount--;
			break;
		} else maxLineCharactersCount++;
	};
	if (maxLineCharactersCount > 0) {
		str = '';
		var j = 0;
		var linesCount = 1;
		for (var i=0; i<rulerTextOrig.length; i++) {
			c = rulerTextOrig.substring(i,i+1);
			if (c == ' ' && j == 0) c = '';
			str += c;
			j++;
			if (j == maxLineCharactersCount) {
				str += '<br/>';
				j = 0;
				linesCount++;
			};
		}; //alert(str + '\n\n' + linesCount);
		//str += imgStr2Add;
		anchorObj.innerHTML = str;
		anchorObj.style.height = (linesCount*(rulerHeight+1)) + 'px';
		focusObj.style.height = (linesCount*(rulerHeight+1)) + 3 + 'px';
		rulerObj.innerHTML = rulerTextOrig; //pg2-test
	};
};

componentCourseTree.prototype.processItemsInTopChapter = function(item) //pg2-GIUB -expand-collapse subchapter - if chosen page hasn't subpages, collapse/expand another chapters (prev.state) according to their state
{
	if (typeof(item) == 'undefined' || item == null) return;
	
	if (item.structPage != null && typeof(item.structPage.expanded) != 'undefined') {
		if (item.structPage.expanded) item.expand(); else item.collapse();
	};
	if (item.children.length > 0) {
		for (var i=0; i<item.children.length; i++) {
			var subItem = item.children[i];
			if (typeof(subItem) != 'undefined' && subItem != null) this.processItemsInTopChapter(subItem);
		};
	};
	//if (branchParent.structPage != null) branchParent.structPage.expanded = false; //pg2-GIUB -expand-collapse subchapter
};

componentCourseTree.prototype.findTopParent = function(item) //pg2-GIUB -expand-collapse subchapter; main chapters
{
	var result = null;
	if (typeof(item) == 'undefined' || item == null) return null;

	var topCurrentParent = null;
	var tmp = item;

	while (topCurrentParent == null) {
		if (tmp.parentObj == null) topCurrentParent = tmp; else tmp = tmp.parentObj;
	};
	result = topCurrentParent;
	return result;
};

componentCourseTree.prototype.expandCurrentBranchCollapseTheRest = function(currentPageItem) //pg2-GIUB -as it's stated in method's name
{
	if (typeof(currentPageItem) == 'undefined' || currentPageItem == null) return;

	/*var topCurrentParent = null;
	var tmp = currentPageItem;
	while (topCurrentParent == null) {
		if (tmp.parentObj == null) topCurrentParent = tmp; else tmp = tmp.parentObj;
	};*/
	var topCurrentParent = this.findTopParent(currentPageItem);
	var allTopParents = new Array();
	for (var i=0; i<this.pagesArr.length; i++) {
		var item = this.pagesArr[i];
		if (typeof(item) != 'undefined' && item.parentObj == null) {
			//if (typeof(item.structPage) != 'undefined' && currentPageItem.gix != topCurrentParent.gix) item.structPage.expanded = false;
			allTopParents[allTopParents.length] = item;
		};
	};

	for (var i=0; i<allTopParents.length; i++) {
		var item = allTopParents[i];
		if (typeof(item) != 'undefined') {
			//item.isShown = true;
			if (item.index == topCurrentParent.index) { // && !topCurrentParent.structPage.expanded) {
				if (topCurrentParent.gix == currentPageItem.gix && typeof(currentPageItem.structPage.expanded) != 'undefined' && this.giubModeMainBranchOriented) {
					if (currentPageItem.structPage.expanded) this.collapseAllBranch(item); else this.expandAllBranch(item);
				} else { //old one
					this.expandAllBranch(item);
				};
			} else {
				if (item.parentObj == null && item.children.length == 0) {
					//pg2-do nothing test
				} else {
					this.collapseAllBranch(item);
				};
			};
		};
	};
	delete allTopParents;
};

componentCourseTree.prototype.componentCourseTreeBaseSetDivElements = componentCourseTree.prototype.setDivElements;
componentCourseTree.prototype.setDivElements = function()
{
	this.componentCourseTreeBaseSetDivElements();
	var addPageDiv = document.getElementById(this.id + "_addPageDiv");
	if (addPageDiv) {
		addPageDiv.style.top = this.paddingTop;
	};
};

componentCourseTree.prototype.setImagesIntoHTMLObj = function()
{
	var bckgTopImg = document.getElementById(this.id + "_bckgTopImg");
	var bckgMiddleImg = document.getElementById(this.id + "_bckgMiddleImg");
	var bckgBottomImg = document.getElementById(this.id + "_bckgBottomImg");
	var addPageImg = document.getElementById(this.id + "_addPageImg");

	if (bckgTopImg) {
		bckgTopImg.src = this.resourcesURL + this.bckgTop;
		bckgTopImg.width = this.w;
		bckgTopImg.height = this.bckgTopH;
	};
	if (bckgMiddleImg) {
		bckgMiddleImg.src = this.resourcesURL + this.bckgMiddle;
		bckgMiddleImg.width = this.w;
		bckgMiddleImg.height = this.h - this.bckgTopH - this.bckgBottomH;
	};
	if (bckgBottomImg) {
		bckgBottomImg.src = this.resourcesURL + this.bckgBottom;
		bckgBottomImg.width = this.w;
		bckgBottomImg.height = this.bckgBottomH;
	};
	if (addPageImg) {
		addPageImg.src = this.resourcesURL + this.buttonCloseOut;
		addPageImg.width = this.buttonCloseW;
		addPageImg.height = this.buttonCloseH;

		var closeButtonDiv = document.getElementById(this.id + "_addPageDiv"); //pg2
		if (closeButtonDiv) {
			if (this.useImagesBckg && this.showCloseButton == false) {
				closeButtonDiv.style.visibility = 'hidden';
			};
		};
	};
};

componentCourseTree.prototype.setTreeIconsStatus = function(struct)
{
	var structLength = struct.length();

	for (var i = 0; i < structLength; i++) {
		var structPage = struct.m_list[i];
		var treeItemIcon = document.getElementById(this.id + "_" + i + "_icon");

		if (treeItemIcon) {
			switch (structPage.status) {
				case 'I':
					if (structPage.realParent == '1' && this.replaceInChapters) { //pg2-new-icon
						treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
					} else
					treeItemIcon.src = this.resourcesURL + this.imagesArr['pageIncomplete'];
					break;
				case 'C':
					if (structPage.realParent == '1' && this.replaceInChapters) { //pg2-new-icon
						treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
					} else
					treeItemIcon.src = this.resourcesURL + this.imagesArr['pageCompleted'];
					break;
				case 'P':
					if (structPage.realParent == '1' && this.replaceInChapters) { //pg2-new-icon
						treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
					} else
					treeItemIcon.src = this.resourcesURL + this.imagesArr['pagePass']
					break;
				case 'F':
					if (structPage.realParent == '1' && this.replaceInChapters) { //pg2-new-icon
						treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
					} else
					treeItemIcon.src = this.resourcesURL + this.imagesArr['pageFail'];
					break;
				default:
					if (structPage.realParent == '1' && this.replaceInChapters) { //pg2-new-icon
						treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
					} else
					treeItemIcon.src = this.resourcesURL + this.imagesArr['pageNotAtt'];
					break;
			};
		};
	};
};

componentCourseTree.prototype.setTreeIconsStatus_mltpSCO = function(struct, isExam)
{
	if (lms) {
		var structLength = struct.length();
		var SCOStatus = '';
		var pageServerIndex = 0;

		for (var i = 0; i < structLength; i++) {
			var structPage = struct.m_list[i];
			var treeItemIcon = document.getElementById(this.id + "_" + i + "_icon");
			if (structPage.visible == "0") continue;
			if (isExam) {
				SCOStatus = lms.getValueForSco(pageServerIndex);
			} else {
				SCOStatus = lms.getValueForSco('cmi.core.lesson_status', pageServerIndex);
			};
			if (SCOStatus == null || SCOStatus.toString() == "null") {
				SCOStatus = lms.getValueForSco('cmi.success_status', pageServerIndex);
				if (SCOStatus == 'unknown') {
					SCOStatus = lms.getValueForSco('cmi.completion_status', pageServerIndex);
				};
			};

			if (treeItemIcon) {
				switch (SCOStatus) {
					case 'incomplete':
						treeItemIcon.src = this.resourcesURL + this.imagesArr['pageIncomplete'];
						break;
					case 'completed':
						treeItemIcon.src = this.resourcesURL + this.imagesArr['pageCompleted'];
						break;
					case 'passed':
						treeItemIcon.src = this.resourcesURL + this.imagesArr['pagePass']
						break;
					case 'failed':
						treeItemIcon.src = this.resourcesURL + this.imagesArr['pageFail'];
						break;
					default:
						treeItemIcon.src = this.resourcesURL + this.imagesArr['pageNotAtt'];
						break;
				};
			};
			pageServerIndex++;
		};
	};
};

componentCourseTree.prototype.onRepaint = function()
{
	var pageType = PageInterface.GetValue("pageType");
	if (pageType == "Exercise" && this.treeType == 1) {
		var userScore = PageInterface.GetValue("userScore");
		var masteryScore = PageInterface.GetValue("masteryScore");
		var maxScore = PageInterface.GetValue("maxScore");
		var answerWeighting = PageInterface.GetValue("answerWeighting");
		var corAns = (answerWeighting) ? (userScore >= masteryScore) : (userScore == maxScore);
		var pageIndex = PageInterface.GetValue('pageIndex');// - 2;
		var pInStruct = 0;

		if (this.pagesArr) {
			var item = this.pagesArr[pageIndex];
			if (item) {
				pInStruct = item.posInStruct;
			};
		};

		var treeItemIcon = document.getElementById(this.id + "_" + pInStruct + "_icon");
		if (treeItemIcon) {
			if (corAns) {
				if (item.isChapter && this.replaceInChapters) { //pg2-new-icon
					treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
				} else
				treeItemIcon.src = this.resourcesURL + this.imagesArr['pagePass'];
				if (treeItemIcon.style.filter) {
					if (item.isChapter && this.replaceInChapters) { //pg2-new-icon
					treeItemIcon.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='../resources/" + this.imagesArr['plusIcon'] + "', sizingMethod='image');"
				} else
					treeItemIcon.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='../resources/" + this.imagesArr['pagePass'] + "', sizingMethod='image');"
				};
			} else {
				if (item.isChapter && this.replaceInChapters) { //pg2-new-icon
					treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
				} else
				treeItemIcon.src = this.resourcesURL + this.imagesArr['pageFail'];
				if (treeItemIcon.style.filter) {
					if (item.isChapter && this.replaceInChapters) { //pg2-new-icon
					treeItemIcon.src = this.resourcesURL + this.imagesArr['plusIcon'];
				} else
					treeItemIcon.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='../resources/" + this.imagesArr['plusIcon'] + "', sizingMethod='image');"
				};
			};
		};
	};
};

componentCourseTree.prototype.componentCourseTreeResetElement = componentCourseTree.prototype.resetElement;
componentCourseTree.prototype.resetElement = function()
{
	this.componentCourseTreeResetElement();
	var pageIndex = PageInterface.GetValue('pageIndex') - 2;
	var treeItemIcon = document.getElementById(this.id + "_" + pageIndex + "_icon");
	if (treeItemIcon) {
		treeItemIcon.src = this.resourcesURL + this.imagesArr['pageNotAtt'];
	};
};

componentCourseTree.prototype.isInArray = function(arr, value)
{
	for (var i = 0; i < arr.length; i++) {
		if (arr[i] == value) {
			return true;
		};
	};
	return false;
};

componentCourseTree.prototype.onPaint = function()
{
    return;
};

componentCourseTree.prototype.setTree = function()
{
	var treeDIV = document.getElementById(this.id + "_treeDIV");
	if (this.useImagesBckg) {
		this.setImagesIntoHTMLObj();
		this.setDivElements();

		var titleDiv = document.getElementById(this.id + "_titleDiv");
		if (titleDiv) {
			var bckgTopH = getImageHeight(this.bckgTop);
			var bckgTopW = getImageWidth(this.bckgTop);
			titleDiv.style.left = 10;
			titleDiv.style.top = 0;
			titleDiv.style.height = bckgTopH;
			titleDiv.style.width = this.w - 10 - 10;
			titleDiv.style.clip = 'rect(0px ' + eval(this.w - 10) + 'px ' + bckgTopH + 'px 0px)';
			titleDiv.dir = this.dir;
		};

		if (treeDIV) {
			var bckgTopH = getImageHeight(this.bckgTop);
			var bckgTopW = getImageWidth(this.bckgTop);
			treeDIV.style.left = this.paddingLeft;
			treeDIV.style.top = bckgTopH;
			treeDIV.style.height = this.h - bckgTopH;// - 20; //pg2-removed - APS for MGO, scrollbar was higher than tree's bottom image
			treeDIV.style.width = this.w - this.paddingLeft;
			treeDIV.style.clip = is.ie11up?'auto':'rect(0px ' + eval(this.w - this.paddingLeft) + 'px ' + eval(this.h - bckgTopH) + 'px 0px)'; //pg2-ie11
			treeDIV.dir = this.dir;

			if (this.expand == 'currentBranchOnly') { //pg2-GIUB
				treeDIV.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
			} else {
				treeDIV.style.cssText += '; overflow-x: auto; overflow-y: auto;';
			};
			if (is.ie) {
				treeDIV.style.scrollbarFaceColor = this.getColor('FaceColor');
				treeDIV.style.scrollbarTrackColor = this.getColor('TrackColor');
				treeDIV.style.scrollbar3dlightColor = this.getColor('3dlightColor');
				treeDIV.style.scrollbarDarkshadowColor = this.getColor('DarkshadowColor');
				treeDIV.style.scrollbarArrowColor = this.getColor('ArrowColor');
				treeDIV.style.scrollbarShadowColor = this.getColor('ShadowColor');
				treeDIV.style.scrollbarHighlightColor = this.getColor('HighlightColor');
			};
			treeDIV.innerHTML = this.menu;
		};
	} else {
		if (treeDIV) {
			treeDIV.style.left = 0;
			treeDIV.style.top = 0;
			treeDIV.style.height = this.h;
			treeDIV.style.width = this.w;
			treeDIV.style.clip = is.ie11up?'auto':'rect(0px ' + this.w + 'px ' + this.h + 'px 0px)'; //pg2-ie11
			treeDIV.dir = this.dir;

			if (this.treeType != 2) {
				if (this.expand == 'currentBranchOnly') { //pg2-GIUB
					treeDIV.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
				} else {
					if (this.treeType != 2) {
						treeDIV.style.cssText += '; overflow-x: auto; overflow-y: auto;';
						if (is.ie) treeDIV.style.cssText += ' position:relative; '; //pg2-IE9_scroll -otherwise in IE9 and up (without document quirks mode, plain IE9-IE9) there is no vertical scrollbar
					};
				};
			};
			if (is.ie) {
				treeDIV.style.scrollbarFaceColor = this.getColor('FaceColor');
				treeDIV.style.scrollbarTrackColor = this.getColor('TrackColor');
				treeDIV.style.scrollbar3dlightColor = this.getColor('3dlightColor');
				treeDIV.style.scrollbarDarkshadowColor = this.getColor('DarkshadowColor');
				treeDIV.style.scrollbarArrowColor = this.getColor('ArrowColor');
				treeDIV.style.scrollbarShadowColor = this.getColor('ShadowColor');
				treeDIV.style.scrollbarHighlightColor = this.getColor('HighlightColor');
			} else {
				treeDIV.style.cliptop = '';
				treeDIV.style.clipbottom = '';
				treeDIV.style.clipright = '';
				treeDIV.style.clipleft = '';
			};
			treeDIV.innerHTML = this.menu;
		};
	};
	if (PageInterface.GetValue("state") == psNormal && this.treeType == 2) {
		document.getElementById(this.id).style.clip = 'rect(-2000px 2000px 2000px -2000px)';
	};
};

componentCourseTree.prototype.detectBrokenConnection = function(pageGix, pageIndex, multiSCOInd) //pg2-BV
{
	var imgID = 'testConectionImage';
	var imageCheckConnectionName = 'check_connection_image.gif';
	var imgSrc = resourcesURL + imageCheckConnectionName + '?' + (+new Date);
	var imgObj = document.getElementById(imgID);
	if (imgObj) {
		var detectProgressName = 'detectConnectionProgressPopup';
		var progressComp = getComponentByPartialId(detectProgressName);
		if (progressComp) {
			progressComp.show();
			progressComp.bringToFront();
		};

		var f;
		var str = 'try { pc.' + this.id + '.gotoPage(' + pageGix + ',' + multiSCOInd + '); } catch(e) {};';
		eval('f = function() { ' + str + '};');
		imgObj.onload = f;
		imgObj.onerror = function() {
			try {
				var p = getPage();
				if (p) {
					p.brokenConnectionInfoShow();
				};
			} catch(e) {};
		};
		imgObj.src = imgSrc;
		return;
	};
};

componentCourseTree.prototype.checkIsGoToAllowed = function(pageGix, pageIndex, multiSCOInd)
{    
	//var obj = document.getElementById('courseTreeNEW1-tree-item-2-anchor');
	//alert(obj.style.cssText);
	if (this.blockGoToPages) {
		var gotoPage = {};
		gotoPage.gix = pageGix;
		gotoPage.index = pageIndex;

		var openPage = {};
		if (opener) {
			openPage.gix = parseInt(opener.PageInterface.GetValue('pageGix'));
			openPage.index = parseInt(opener.PageInterface.GetValue('pageIndex'));
		} else {
			openPage.gix = parseInt(PageInterface.GetValue('pageGix'));
			openPage.index = parseInt(PageInterface.GetValue('pageIndex'));
		};

		var opened = this.checkWasPageOpened(pageIndex);
		if (opened) {
			if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
			this.gotoPage(pageGix, multiSCOInd);
		} else {
			if (parseInt(openPage.index) + 1 == gotoPage.index) {
				if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
				this.gotoPage(pageGix, multiSCOInd);
			} else {
				var allOpened = this.checkAllPagesBeforeOpened(pageGix);
				if (allOpened) {
					if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
					this.gotoPage(pageGix, multiSCOInd);
				} else 
				if (this.showAlert) {
					showMessage(this.alertText);
				};
			};
		};
	} else {
		if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
		this.gotoPage(pageGix, multiSCOInd);
	};
};

componentCourseTree.prototype.gotoPage = function(pageGix, multiSCOInd)
{
	var topWin = null;
	if (typeof(getWBTServerTop) != 'undefined') {
		topWin = getWBTServerTop();
	};
	if (opener && opener.lms) {
		opener.lms.gotoPage(pageGix);
	} else 
	if (PageInterface.GetValue('isExam') || (topWin && topWin.oneSCOCourse && topWin.oneSCOCourse.toString() == 'false')) {
		window.parent.changePage(multiSCOInd);
	} else {
		PlayerInterface.Execute('gotoPage', pageGix);
	};

	try { //pg2-if it is in new window which isn't closed after "gotoPage", select proper item in the tree
		if (opener && !this.closeOpenerPage) {
			var struct = getStruct();
			for (var i=0; i<this.pagesArr.length; i++) {
				var item = this.pagesArr[i];
				if (item) {
					if (item.gix == pageGix) {
						item.focus(this.pageNameFocusColor, this.pageNameTitleColor);
					} else item.unselect();

					var imgObj = document.getElementById(item.compName + '_' + item.posInStruct + '_icon');
					if (struct && imgObj) {
						var p = struct.findItem(item.gix);
						if (p) {
							var pageStatus = p["status"];

							var iconSrc = "";
							if (pageStatus == "I") iconSrc = item.pageIncompleted; else
							if (pageStatus == "C") iconSrc = item.pageCompleted; else
							if (pageStatus == "P") iconSrc = item.pagePass; else
							if (pageStatus == "F") iconSrc = item.pageFail; else
							//if (pageStatus == "N") 
							iconSrc = item.pageNotAtt;
							imgObj.src = item.resourcesURL + iconSrc;
						};
					};
				};
			};
		};
	} catch (e) {
		//alert(e.message); //pg2-test
	};

	if (opener && this.closeOpenerPage) {
		window.close();
	} else 
	if (opener) window.focus(); //pg2
};

componentCourseTree.prototype.setNewTreeImages = function(str)
{
	var images = str.split(';');
	for (var i = 0; i < images.length; i++) {
		var oneImg = images[i].split(':');
		if (images[i] != '') {
			if (this.expand == 'currentBranchOnly' && i<5) { //pg2-GIUB -use 1x1 image
				this.imagesArr[oneImg[0]] = 'blank_mini.gif';
			} else this.imagesArr[oneImg[0]] = oneImg[1];
		};
	};
};

componentCourseTree.prototype.getColor = function(value)
{
	var colorArr = this.treeCSSStyle.split(';')
	for (var i = 0; i < colorArr.length; i++) {
		var oneColor = colorArr[i].split(':');
		if (oneColor[0].indexOf(value) > -1) return oneColor[1];
	};
	return 'transparent';
};

componentCourseTree.prototype.checkAllPagesBeforeOpened = function(pageGix)
{
	var SCOStatus = '';
	var topWin = null;
	if (typeof(getWBTServerTop) != 'undefined') {
		topWin = getWBTServerTop();
	};
	if (topWin && topWin.oneSCOCourse && topWin.oneSCOCourse.toString() == 'false') {
		for (var i in this.pagesArr) {
			var item = this.pagesArr[i];
			SCOStatus = lms.getValueForSco('cmi.core.lesson_status', (item.index - 2));
			if (item.gix == pageGix) {
				return true;
			} else 
			if (SCOStatus == "not attempted") {
				return false;
			};
		};
		return (SCOStatus != "not attempted");
	} else 
	if (PageInterface.GetValue('isExam')) {
		for (var i in this.pagesArr) {
			var item = this.pagesArr[i];
			SCOStatus = lms.getValueForSco(eval(item.index - 2));
			if (item.gix == pageGix) {
				return true;
			} else 
			if (SCOStatus == "not attempted") {
				return false;
			};
		};
		return (SCOStatus != "not attempted");
	} else {
		for (var i in this.pagesArr) {
			var item = this.pagesArr[i];
			if (item.gix == pageGix) {
				return true;
			} else 
			if (item.status == "N") {
				return false;
			};
		};
	};
};

componentCourseTree.prototype.checkWasPageOpened = function(pageIndex)
{
	var SCOStatus = '';
	var topWin = null;
	if (typeof(getWBTServerTop) != 'undefined') {
		topWin = getWBTServerTop();
	};
	if (topWin && topWin.oneSCOCourse && topWin.oneSCOCourse.toString() == 'false') {
		SCOStatus = lms.getValueForSco('cmi.core.lesson_status', (pageIndex - 2));
		return (SCOStatus != "not attempted");
	} else 
	if (PageInterface.GetValue('isExam')) {
		SCOStatus = lms.getValueForSco(eval(pageIndex - 2));
		return (SCOStatus != "not attempted");
	} else {
		var item = this.pagesArr[pageIndex];
		if (item) {
			return (item.status != 'N');
		};
		return false;
	};
};

componentCourseTree.prototype.addChildToParent = function(pageIndex, child)
{
	var chaptersNamesArr = this.chaptersNames.split('||');
	var item = this.pagesArr[pageIndex];
	if (item) {
		if (!this.isInArray(chaptersNamesArr, child.title)) {
			item.children.push(child);
			child.haveParent = true;
			child.parentObj = item;
		};
	} else {
		child.haveParent = false;
	};
};

componentCourseTree.prototype.expandAllTree = function()
{
	for (var i in this.pagesArr) {
		var item = this.pagesArr[i];
		if (item && item.children.length > 0) {
			item.expand();
		};
	};
};

componentCourseTree.prototype.collapseAllTree = function()
{
	for (var i in this.pagesArr) {
		var item = this.pagesArr[i];
		if (item && item.children.length > 0) {
			item.collapse();
		};
	};
};

componentCourseTree.prototype.expandPageParents = function(index)
{
	if (this.pagesArr) {
		var item = this.pagesArr[index];
		if (item) 
		var itemParent = this.pagesArr[item.parent];

		while (itemParent) {
			if (itemParent && itemParent.children.length > 0) itemParent.expand();
			//pg2-GIUB -expand-collapse subchapter
			//itemParent.expanded = true;
			//if (itemParent.structPage != null) itemParent.structPage.expanded = true;
			//...
			itemParent = this.pagesArr[itemParent.parent];
		};
	};
};

componentCourseTree.prototype.setFocus = function(index)
{
	var result = null; //pg2-GIUB
	if (this.treeType == 0) {
		this.objComboMenu.focus(index, this.pageNameFocusColor, this.pageNameTitleColor);
	} else
	if (this.treeType == 1) {
		if (this.pagesArr) {
			var item = this.pagesArr[index];
			if (item && item.visible == 1) {
				item.focus(this.pageNameFocusColor, this.pageNameTitleColor);
				result = item; //pg2-GIUB
			} else 
			if (this.markPageParent) {
				var parentItem = this.findVisibleParent(item);
				if (parentItem != null) {
					parentItem.focus(this.pageNameFocusColor, this.pageNameTitleColor); //pg2-if
					result = parentItem; //pg2-GIUB
				};
			};
		};
	} else 
	if (this.treeType == 2) {
		this.objCascadeMenu.focus(index, this.pageNameFocusColor, this.pageNameTitleColor);
	};
	return result; //pg2-GIUB
};

componentCourseTree.prototype.findVisibleParent = function(child)
{
	if (typeof(child) == "undefined") return null; //pg2
	var itemParent = this.pagesArr[child.parent];
	while (itemParent && itemParent.visible == 0) {
		itemParent = this.pagesArr[itemParent.parent];
	};
	return itemParent;
};

componentCourseTree.prototype.expandAllBranch = function(branchParent)
{
	//pg2-GIUB
	branchParent.expanded = true; //pg2-GIUB -expand-collapse subchapter
	if (branchParent.structPage != null) branchParent.structPage.expanded = true; //pg2-GIUB -expand-collapse subchapter
	if (branchParent.parentObj == null && branchParent.children.length == 0) return; //pg2-test
	//...
	branchParent.expand();
	for (var i = 0; i < branchParent.children.length; i++) {
		var item = branchParent.children[i];
		if (item && item.children.length > 0) {
			this.expandAllBranch(item);
		};
	};
};

componentCourseTree.prototype.collapseAllBranch = function(branchParent) //pg2-GIUB
{
	//pg2-GIUB
	branchParent.expanded = false; //pg2-GIUB -expand-collapse subchapter
	if (branchParent.structPage != null) branchParent.structPage.expanded = false; //pg2-GIUB -expand-collapse subchapter
	if (branchParent.parentObj == null && branchParent.children.length == 0) return; //pg2-test
	//...
	branchParent.collapse();
	for (var i = 0; i < branchParent.children.length; i++) {
		var item = branchParent.children[i];
		if (item && item.children.length > 0) {
			this.collapseAllBranch(item);
		};
	};
};

componentCourseTree.prototype.showChapter = function(chapterName)
{
	chapterName = unescape(chapterName);

	var chapterParent = -1;
	var pageVisible = null;
	var pageChapter = null;
	var hideOtherPages = false;
	var foundChapterPage = false;

	for (var i in this.pagesArr) {
		var item = this.pagesArr[i];
		if (item) {
			if (chapterName == item.title) {
				chapterParent = item.parent;
				pageChapter = item;
				document.getElementById(item.id + '-focus').style.display = 'block';
				foundChapterPage = true;
			} else {
				if (foundChapterPage && chapterParent >= item.parent) {
					hideOtherPages = true;
				};
				if (!foundChapterPage || hideOtherPages) {
					document.getElementById(item.id + '-focus').style.display = 'none';
				} else {
					pageVisible = item;
					document.getElementById(item.id + '-focus').style.display = 'block';
				};
			};
		};
	};
	//if (pageChapter) pageChapter.expand();
	if (pageChapter) this.expandAllBranch(pageChapter);
};

function courseTreePageItem(posInStruct, compName, gix, index, title, action, parent, status, addPrefix, resourcesURL, pageNotAtt, pageIncompleted, pageCompleted, pagePass, pageFail, 
							blankIcon, minusIcon, plusIcon, fontFamily, fontSize, fontColor, chapterColor, isChapter, width, replaceInChapters, borderColor, borderWidth, focusBckgColor,
							focusTitleColor, mainBgColor, traceMouse,
							dontUsePlusMinusWithChapters, structPage) //pg2-GIUB, structPage-expand-collapse subchapter
{
	this.posInStruct = posInStruct;
	this.compName = compName;
	this.id = compName + '-tree-item-' + index;
	this.gix = gix;
	this.index = index;
	this.title = title;
	this.action = action;
	this.parent = parent;
	this.status = status;
	this.haveParent = false;
	this.parentObj = null;
	this.open = false;
	this.addPrefix = addPrefix;

	this.resourcesURL = resourcesURL;
	this.pageNotAtt = pageNotAtt;
	this.pageIncompleted = pageIncompleted;
	this.pageCompleted = pageCompleted;
	this.pagePass = pagePass;
	this.pageFail = pageFail;
	this.blankIcon = blankIcon;
	this.minusIcon = minusIcon;
	this.plusIcon = plusIcon;
	this.visible = 0;

	this.fontFamily = fontFamily;
	this.fontSize = fontSize;
	this.fontColor = fontColor;
	this.chapterColor = chapterColor;
	this.isChapter = isChapter;

	this.width = width; //pg2-new
	if (this.width <= 10) this.width = '';
	this.replaceInChapters = replaceInChapters;
	this.borderColor = borderColor;
	this.borderWidth = borderWidth;
	this.focusBckgColor = focusBckgColor;
	this.focusTitleColor = focusTitleColor;
	this.mainBgColor = mainBgColor;
	this.focused = false;
	this.traceMouse = traceMouse;

	//pg2-GIUB
	this.dontUsePlusMinusWithChapters = dontUsePlusMinusWithChapters;
	//pg2-GIUB -expand-collapse subchapter
	this.expanded = false;
	if (typeof(structPage) == 'undefined') structPage = null;
	this.structPage = structPage;
	//pg2-GIUB -line wrap
	//this.isShown = false;
	//...

	this.children = new Array();
};

courseTreePageItem.prototype.expand = function()
{
	var obj = document.getElementById(this.id + '-cont');
	var objSrc = document.getElementById(this.id + '-indent');
	if (obj) {
		obj.style.display = "block";
		this.open = true;
	};
	if (objSrc) {
		if (!this.replaceInChapters) { //pg2-new-icon
			objSrc.src = this.resourcesURL + this.minusIcon;
		} else {
			objSrc.src = this.resourcesURL + this.blankIcon;
		};
	};
};

courseTreePageItem.prototype.collapse = function()
{
	var obj = document.getElementById(this.id + '-cont');
	var objSrc = document.getElementById(this.id + '-indent');
	if (obj) {
		obj.style.display = "none";
		this.open = false;
	};
	if (objSrc) {
		if (!this.replaceInChapters) { //pg2-new-icon
			objSrc.src = this.resourcesURL + this.plusIcon;
		} else {
			objSrc.src = this.resourcesURL + this.blankIcon;
		};
	};
};

courseTreePageItem.prototype.expandCollapse = function()
{
	if (this.open) {
		this.collapse();
	} else {
		this.expand();
	};
};

courseTreePageItem.prototype.focus = function(bckgColor, titleColor)
{
	var span = document.getElementById(this.id + '-anchor');
	var par = document.getElementById(this.id + '-focus');
	var icon = document.getElementById(this.compName + "_" + this.posInStruct + "_icon");
	if (span) {
		if (bckgColor != 'transparent') {
			span.style.background = bckgColor;
		};
		if (titleColor != 'transparent') {
			span.style.color = titleColor;
		};
	};
	if (par && bckgColor != 'transparent') {
		par.style.background = bckgColor;
	};
	if (this.replaceInChapters && icon) { //pg2-new-select
		icon.src = this.resourcesURL + this.minusIcon;
	};
	this.focused = true;
};

courseTreePageItem.prototype.mouseOver = function() //function(bckgColor, titleColor)
{
	if (!this.traceMouse) return;
	var obj = document.getElementById(this.id + '-focus');
	if (obj) {
		obj.style.background = this.focusBckgColor;
	};
	var obj2 = document.getElementById(this.id + '-anchor');
	if (obj) {
		obj2.style.background = 'transparent';
	};
};

courseTreePageItem.prototype.mouseOut = function()
{
	if (!this.traceMouse) return;
	if (this.focused) {
		this.mouseOver();
		return;
	};
	var obj = document.getElementById(this.id + '-focus');
	if (obj) {
		obj.style.background = this.mainBgColor;
	};
};

courseTreePageItem.prototype.unselect = function() //pg2
{
	var span = document.getElementById(this.id+'-anchor');
	var par = document.getElementById(this.id+'-focus');

	if (span) span.style.background = 'transparent';//'#FFFFFF';
	if (span) span.style.color = this.fontColor;
	if (par) par.style.background = 'transparent'; //'#FFFFFF';
	this.focused = false;
};

courseTreePageItem.prototype.isInArray = function()
{
	for (var i = 0; i < arr.length; i++) {
		if (arr[i] == value) {
			return true;
		};
	};
	return false;
};

courseTreePageItem.prototype.toString = function() {
	var str = '';
	var treeComp = page.all[this.compName];
	var chaptersNamesArr = treeComp.chaptersNames.split('||');
	var fontWeight = (treeComp.chaptersBold && this.isChapter) ? 'bold' : 'normal';
	var fontColor = (this.isChapter || !treeComp.colorOnlyChapterPage) ? this.chapterColor : this.fontColor;
	var showIco = treeComp.showTreeIcons2; //pg2-added '2', cause there was a conflict in 'definition.xml'

	if (treeComp.isInArray(chaptersNamesArr, this.title)) {
		return str;
	};

	var myParent = this.parentObj;
	var expandStr = '';
	var indent = '';
	var fixDisplay = '';
	var fixPaddingLeft = (typeof(this.paddingLeft) != "undefined" ? 'padding-left:' + this.paddingLeft + 'px; ' : '');
	if (!is.ie) fixDisplay = 'display: table;'; //pg2-in Firefox div wasn't resized to span's width

	if (this.width == '') fixDisplay = 'display: inline';

	str = '';
	if (this.borderWidth > 0 /*&& !is.ie*/) { //pg2-new-lines
		str += '<hr style="margin-top: 0px; margin-bottom: 0px; height: 1px; color: ' + this.borderColor + '; background-color: ' + this.borderColor + '; border-style: solid; " />'
	};
	if (this.borderWidth > 0) {
		if (is.ie) { //pg2-new
			str += '<p id="' + this.id + '-focus" ' + 
				'style="background-repeat: repeat; background-attachement: fixed; width: ' + 
				(this.width!=''?this.width-20:'') + ';' + //pg2-new
				' white-space: nowrap; ' + fixPaddingLeft + fixDisplay + '"' +
				" onclick=\"" + this.action + "\"" +
				" onMouseOver=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOver();\"" +
				" onMouseOut=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOut();\"" +
				'>';
		} else {
			str += '<p id="' + this.id + '-focus" ' + 
				'style="background-repeat: repeat; background-attachement: fixed; width: ' + 
				this.width + ';' + //pg2-new
				' white-space: nowrap; ' + fixPaddingLeft + fixDisplay + '"' +
				" onclick=\"" + this.action + "\"" +
				" onMouseOver=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOver();\"" +
				" onMouseOut=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOut();\"" +
				'>';
		};
	} else {
		str += '<p id="' + this.id + '-focus" ' +
		'style="background-repeat: repeat; background-attachement: fixed; width: ' +
		this.width + ';' + //pg2-new
		' white-space: normal; ' + fixPaddingLeft + fixDisplay + '"' +
		//" onclick=\"" + this.action + "\"" + //pg2-removed, conflict with 'expand branch'
		" onMouseOver=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOver();\"" +
		" onMouseOut=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOut();\"" +
		'>';
		//alert(str); //pg2-test
	};

	//alert(str); //pg2-test

	while (myParent) {
		myParent = myParent.parentObj;
		indent = "<img src=\"" + this.resourcesURL + this.blankIcon + "\">" + indent;
	};

	if (this.children.length > 0 && !this.dontUsePlusMinusWithChapters) { //pg2-GIUB
		expandStr += "<img id=\"" + this.id + "-indent\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
	} else {
		expandStr += "<img src=\"" + this.resourcesURL + this.blankIcon + "\">"
	};

	str += indent;
	str += expandStr;

	str += "<span>&nbsp;</span>"; //pg2- a little bit of space between expand icon and status icon
   
	if (showIco) {
		switch (this.status) {
			case 'I':
				if (this.isChapter && this.replaceInChapters) { //pg2-new-icon
					str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
				} else
				str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" src=\"" + this.resourcesURL + this.pageIncompleted + "\">";
				break;
			case 'C':
				if (this.isChapter && this.replaceInChapters) { //pg2-new-icon
					str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
				} else
				str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" src=\"" + this.resourcesURL + this.pageCompleted + "\">";
				break;
			case 'P':
				if (this.isChapter && this.replaceInChapters) { //pg2-new-icon
					str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
				} else
				str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" src=\"" + this.resourcesURL + this.pagePass + "\">";
				break;
			case 'F':
				if (this.isChapter && this.replaceInChapters) { //pg2-new-icon
					str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
				} else
				str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" src=\"" + this.resourcesURL + this.pageFail + "\">";
				break;
			default:
				if (this.isChapter && this.replaceInChapters) { //pg2-new-icon
					str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" onclick=\"pc." + this.compName + ".pagesArr[" + this.index + "].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
				} else
				str += "<img id=\"" + this.compName + "_" + this.posInStruct + "_icon\" src=\"" + this.resourcesURL + this.pageNotAtt + "\">";
				break;
		};
	};

	str += "<span>&nbsp;</span>"; //pg2- a little bit of space between icon and page name

	var prefix = '';
	if (this.addPrefix) {
		prefix = eval(this.posInStruct + 1) + '. ';
	};

	if (this.dontUsePlusMinusWithChapters) { //pg2-GIUB -line wrap
		//str += "<div id=\"" + this.id + "-anchor\" title=\"" + this.title + "\" style=\"";
		str += "<div id=\"" + this.id + "-anchor\" " + 
			" onMouseOver=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOver();\"" + //pg2-spam is 'transparent' for events for paragraph, div- isn't
			" onMouseOut=\"pc." + this.compName + ".pagesArr[" + this.index + "].mouseOut();\""
		    + " title=\"" + this.title + "\" style=\"";
	} else {
		str += "<span id=\"" + this.id + "-anchor\" title=\"" + this.title + "\" style=\""; //pg2-standard one
	};
	str += "font-weight: " + ((treeComp.treeFontBold) ? "bold":"normal") + ";";
	str += "font-style: " + ((treeComp.treeFontItalic) ? "italic":"normal") + ";";
	str += "text-decoration: " + ((treeComp.treeFontUnderline) ? "underline":"none") + ";";
	str += "font-family: " + this.fontFamily + ";";
	str += "font-size:" + this.fontSize + "px;";
	str += "color: " + fontColor + ";";

	if (this.dontUsePlusMinusWithChapters) { //pg2-GIUB -line wrap
		str += "white-space: normal;";
		str += "display: inline-block;";
		str += "position: absolute;"
	};

	str += "cursor:pointer;\" onclick=\"" + this.action + "\" >" + prefix + 
			//'<font>' +
			this.title +
			//'</font>' +
			"<img src=\"" + this.resourcesURL + this.blankIcon + "\">"; //pg2-to expand backlight
	if (this.dontUsePlusMinusWithChapters) { //pg2-GIUB -line wrap
		str += "</div>";
	} else {
		str += "</span>";
	};

	str += "<div id=\"" + this.id + "-cont\" style=\"position: relative; display: " + ((this.open) ? 'block' : 'none') + ";\">";
	this.visible = 1;

	for (var i = 0; i < this.children.length; i++) {
		str += this.children[i].toString();
	};

	str += "</div>";
	str += "</p>";
	return str;
};
