/*
 * Copyright (c) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentResolutionHideElements = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.isResolutionHideElements = true;
	this.componentsVisibilityArray = new Array();

	this.visibleElements = new Array();
	this.hiddenElements = new Array();

	this.counter = 0;

	this.isLeftFrame 	= true;
	this.isTopFrame 	= true;
	this.isBottomFrame 	= false;
	this.timerID 		= null;
	this.timerComID		= null;

	this.isFrames = false;
	this.type = -1;
	this.inProgress = false;

	this.rows = parent.document.getElementById('top_frameset');
	this.cols = parent.document.getElementById('tree_frameset');
	
	if (this.rows && this.cols) {
		this.isFrames = true;
		var colsArr = this.cols.cols.split(","); 
		this.col1 = colsArr[0];
		this.col2 = colsArr[1];

		switch (this.rows.name) {
			case "top_default": 
				{
					this.type = 0;
					var rowsArr = this.rows.rows.split(","); 
					this.row1 = rowsArr[0];
					this.row2 = rowsArr[1];
					this.row3 = rowsArr[2];
					this.isBottomFrame 	= true;
				};
				break;
			case "top_nonframeset":
				{
					this.type = 1;
					var rowsArr = this.rows.rows.split(","); 
					this.row1 = rowsArr[0];
					this.row2 = rowsArr[1];	
				};
				break;
		};
	};
};

componentResolutionHideElements.prototype = new componentElement();
componentResolutionHideElements.prototype.type = "componentResolutionHideElements";

componentResolutionHideElements.prototype.onBaseCreate = function(obj)
{
	this.resourcesURL = resourcesURL;
	this.resourcesStatus = "online";
	if (this.execution) {
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
};

componentResolutionHideElements.prototype.onResize = function(obj)
{
	
	if (this.resizeOnlyOnStartup) return true;
	if (this.inProgress) {
		return true;
	} else {
		this.inProgress = true;
		this.hideShowFrames();
		this.showHideComponents();		
	};
	this.inProgress = false;
};

componentResolutionHideElements.prototype.onCreate = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) {
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").src = this.resourcesURL + this.iconSrc;
		} else {
			this.setHTML('<img src="'+ resourcesURL + this.iconSrc +'" />');
		};
	} else
	if (page.state == psNormal) {
		var x = 0, y = 0;

		if (this.userResX == 0 || this.userResY == 0) {
			var array = this.resolution.split("x");
			x = array[0];
			y = array[1];
			x = x - 20;
			y = y - 148;
		} else {
			x = this.userResX;
			y = this.userResY;
		};
		if (this.screenWidth() < x || this.screenHeight() < y) {
			var vid = PlayerInterface.GetValue("getCourseVersion");
			if (this.changeCourseVersionIfToLowResolution == "1" && vid != this.changeCourseVersionToVersion) {
				page.changeCourseVersion(this.changeCourseVersionToVersion);
			};
		};
	};
};

componentResolutionHideElements.prototype.onAfterLoad = function(obj)
{
	var x = 0, y = 0;
	var isOnList = false;

	if (this.userResX == 0 || this.userResY == 0) {
		var array = this.resolution.split("x");
		x = array[0];
		y = array[1];

		x = x - 20;
		y = y - 148;
	} else {
		x = this.userResX;
		y = this.userResY;
	};

	if (this.counter == 0) {
		for (var i in page.children) {
			
			if(page.children[i].step == 0) this.componentsVisibilityArray[i] = "visible";
			else this.componentsVisibilityArray[i] = "hidden";
		};
		this.counter++;
	};

	if (this.screenWidth() < x || this.screenHeight() < y) {
		
		var componentsToHide = this.componentsToHide.split("|");
		var componentsToShow = this.componentsToShow.split("|");
		if (this.resizeContentFrame) {
			//parent.document.getElementById('tree_frameset').cols = '0,*';
		};
		for (var i in page.children) {
			isOnList = false;
			for (var j = 0; j < componentsToHide.length; j++) {
				if (
						(page.children[i].id == componentsToHide[j]
							||(
								(page.children[i].id.indexOf("__bckg_")==0)
								&&(page.children[i].id.indexOf(componentsToHide[j])>=0)
								)
						)
						&& (page.children[i].visible)
					)
				{
					page.children[i].hide();
					isOnList = true;
					break;
				};
			};
			
			for (var j = 0; j < componentsToShow.length; j++) {
				if (
						(page.children[i].id == componentsToShow[j]
							||(
								(page.children[i].id.indexOf("__bckg_")==0)
								&&(page.children[i].id.indexOf(componentsToShow[j])>=0)
								)
						)
						&& (!page.children[i].visible)
					)
				{
					page.children[i].show();
					break;
				};
			};

			if (!isOnList) {
				var left = page.children[i].x - this.resMoveX;
				if (left > 0) page.children[i].style.left = left;
				else page.children[i].style.left = 0;
	
				var top = page.children[i].y - this.resMoveY;
				if (top > 0) page.children[i].style.top = top;
				else page.children[i].style.top = 0;
			};
		};
	} else {
		var componentsToHide = this.componentsToHide.split("|");
		var componentsToShow = this.componentsToShow.split("|");
		for (var i in page.children){			
			for (var j = 0; j < componentsToHide.length; j++){
				if (
						(page.children[i].id == componentsToHide[j]
							||(
								(page.children[i].id.indexOf("__bckg_")==0)
								&&(page.children[i].id.indexOf(componentsToHide[j])>=0)
								)
						)
					)
				{				
					if(this.componentsVisibilityArray[i]=="visible") page.children[i].show();
					else page.children[i].hide();
					
					break;
				};
			};
			for (var j = 0; j < componentsToShow.length; j++){
				if (
						(page.children[i].id == componentsToShow[j]
							||(
								(page.children[i].id.indexOf("__bckg_")==0)
								&&(page.children[i].id.indexOf(componentsToShow[j])>=0)
								)
						)
					)
				{
					if(this.componentsVisibilityArray[i]=="visible") page.children[i].show();
					else page.children[i].hide();			
					break;
				};
			};
			page.children[i].style.left = page.children[i].x;
			page.children[i].style.top = page.children[i].y;
		};
	};
};

componentResolutionHideElements.prototype.hideShowFrames = function()
{
	if ( page.state == psNormal && this.isFrames) {
		var x = 0, y = 0, sWidth = 0, sHeight = 0;
		var isOnList = false;

		if (this.userResX == 0 || this.userResY == 0) {
			var array = this.resolution.split("x");
			x = array[0];
			y = array[1];
	
			x = x - 20;
			y = y - 148;
		} else {
			x = this.userResX;
			y = this.userResY;
		};

		sWidth = this.screenWidth();
		sHeight = this.screenHeight();

		/* * * WIDTH  & HEIGHT * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
		if (x > sWidth || y > sHeight) {
			if (this.bottomFrame && this.topFrame && this.isBottomFrame && this.isTopFrame) {
				if (this.type == 0) {
					parent.document.body.rows = '0,*,0';
					this.isBottomFrame = false;
					this.isTopFrame    = false;				
				} else
				if (this.type == 1) {
					parent.document.body.rows = '0,*';
					this.isTopFrame    = false;				
				}
			} else
			if (this.topFrame && this.isTopFrame) {
				if (this.type == 0) {
					parent.document.body.rows = '0,*,'+this.row3;
					this.isTopFrame = false;			
				} else
				if (this.type == 1) {
					parent.document.body.rows = '0,*';
					this.isTopFrame    = false;				
				}
			} else
			if (this.bottomFrame && this.isBottomFrame) {
				if (this.type == 0) {
					parent.document.body.rows = this.row1+',*,0';
					this.isBottomFrame = false;		
				};
			};

			if (this.treeFrame && this.isLeftFrame) {
				parent.document.getElementById('tree_frameset').cols = '0,*';
				this.isLeftFrame = false;
			};
		} else {
			if (this.bottomFrame && this.topFrame && !this.isBottomFrame && !this.isTopFrame) {
				if (this.type == 0) {
					parent.document.body.rows = this.row1+',*,'+this.row3;
					this.isBottomFrame = true;
					this.isTopFrame    = true;				
				} else
				if (this.type == 1) {
					parent.document.body.rows = this.row1+',*';
					this.isTopFrame    = true;				
				}
			} else
			if (this.topFrame && !this.isTopFrame) {
				if (this.type == 0) {
					parent.document.body.rows = this.row1+',*,'+this.row3;
					this.isTopFrame = true;			
				} else
				if (this.type == 1) {
					parent.document.body.rows = this.row1+',*';
					this.isTopFrame    = true;				
				};
			} else
			if (this.bottomFrame && !this.isBottomFrame) {
				if (this.type == 0) {
					parent.document.body.rows = this.row1+',*,'+this.row3;
					this.isBottomFrame = true;		
				};
			};

			if (this.treeFrame && !this.isLeftFrame) {
				parent.document.getElementById('tree_frameset').cols = this.col1+',*';
				this.isLeftFrame = true;
			};
		};
	};
};

componentResolutionHideElements.prototype.showHideComponents = function()
{
	this.onLoad();
};

componentResolutionHideElements.prototype.screenWidth = function()
{
	if (top.self.innerWidth) return top.self.innerWidth; else
	if (top.document.documentElement && top.document.documentElement.clientWidth) return top.document.documentElement.clientWidth; else
	if (top.document.body) return top.document.body.clientWidth; else return false;
};

componentResolutionHideElements.prototype.screenHeight = function()
{
	if (top.self.innerHeight) return top.self.innerHeight; else
	if (top.document.documentElement && top.document.documentElement.clientHeight) return top.document.documentElement.clientHeight; else
	if (top.document.body) return top.document.body.clientHeight; else return false;
};

componentResolutionHideElements.prototype.onFree = function()
{
	if (this.TimerID != null) window.clearTimeout(this.TimerID);
	if (this.TimerComID != null) window.clearTimeout(this.TimerComID);
};
