﻿module Clock {
    export class Clock extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        Clocks: any[];

        ClickedHand: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.createClocks();
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }


        createClocks() {
            this.Clocks = [];
            this.ClickedHand = null;
            for (var i = 0; i < this.Elements.Clocks.length; i++) {
                var face, hand1, hand2;
                face = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Face.key);
                hand1 = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Hand2.key);
                hand2 = this.game.add.sprite(0, 0, this.PREFIX + this.Elements.Clocks[i].Hand1.key);
                face.scale.set(0.6, 0.6);
                hand1.scale.set(0.6, 0.6);
                hand2.scale.set(0.6, 0.6);
                hand1.anchor.set(0.5, 0.95);
                hand2.anchor.set(0.5, 0.9);
                hand1.name = 2 * i;
                hand2.name = 2 * i + 1;
                hand2.inputEnabled = true;
                hand2.events.onInputOver.add(this.onInputOver, this);
                hand2.events.onInputOut.add(this.onInputOut, this);
                hand2.events.onInputDown.add(this.onInputDown, this);
                if (this.Elements.Snap == true) hand2.events.onInputUp.add(this.onInputUpSnap, this);
                else hand2.events.onInputUp.add(this.onInputUp, this)
                hand1.inputEnabled = true;
                hand1.events.onInputOver.add(this.onInputOver, this);
                hand1.events.onInputOut.add(this.onInputOut, this);
                hand1.events.onInputDown.add(this.onInputDown, this);
                if (this.Elements.Snap == true) hand1.events.onInputUp.add(this.onInputUpSnap, this);
                else hand1.events.onInputUp.add(this.onInputUp, this)
                var posX = this.Elements.Clocks[i].Position.x;
                var posY = this.Elements.Clocks[i].Position.y;
                if (this.Elements.Options.Just) {
                    switch (this.Elements.Options.Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            face.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            face.anchor.x = 1;
                            break;
                    }
                    switch (this.Elements.Options.Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            face.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            face.anchor.y = 1;
                            break;
                    }
                }
                face.position.set(posX-25, posY);
                this.addChild(face);
                hand1.position.set(posX, posY+face.height/2);
                this.addChild(hand1);
                hand2.position.set(posX, posY + face.height/2);
                this.addChild(hand2);
                this.Clocks.push({ "hand": hand1, "value": 12 });
                this.Clocks.push({ "hand": hand2, "value": 12 });
            }
        }

        update() {
            if (this.ClickedHand !=null) {
                EU.Log(this.Clocks[this.ClickedHand].hand.angle);
                this.Clocks[this.ClickedHand].hand.angle = Phaser.Math.radToDeg(
                    Phaser.Math.angleBetween(
                        -this.Clocks[this.ClickedHand].hand.position.x,
                        -this.Clocks[this.ClickedHand].hand.position.y,
                        -(this.game.input.x - 120),
                        -(this.game.input.y - 200))) - 90;
            }
        }

        onInputOver(el: Phaser.Image, pointer) {
            el.alpha = 0.5;
        }

        onInputOut(el: Phaser.Image, pointer) {
            el.alpha = 1.0;
        }

        onInputDown(el: Phaser.Image, pointer) {           
            this.ClickedHand = el.name;
        }

        onInputUpSnap(el: Phaser.Image, pointer) {
            this.ClickedHand = null;
            if (el.angle > 0) {
                if ((el.angle % 30 - 15) < 0) el.angle = 30 * Phaser.Math.floor(el.angle / 30);
                else el.angle = 30 * (Phaser.Math.floor(el.angle / 30) + 1);
            }
            else {
                if ((el.angle % 30) > -15) el.angle = -30 * Phaser.Math.floor(el.angle / -30);
                else el.angle = -30 * (Phaser.Math.floor(el.angle / -30) + 1);
            }
            this.setHandValue(el);
            this.checkIfEverythingIsCorrect()
        }

        onInputUp(el: Phaser.Image, pointer) {
            this.ClickedHand = null;
            this.setHandValue(el);
            this.checkIfEverythingIsCorrect()
        }

        setHandValue(el) {
            if (el.angle > 0) {
                if ((el.angle % 30 - 15) < 0) this.Clocks[el.name].value = Phaser.Math.floor(el.angle / 30);
                else this.Clocks[el.name].value = (Phaser.Math.floor(el.angle / 30) + 1);
            }
            else {
                if ((el.angle % 30) > -15) this.Clocks[el.name].value = 12 - Phaser.Math.floor(el.angle / -30);
                else this.Clocks[el.name].value = 12 - (Phaser.Math.floor(el.angle / -30) + 1);
            }
            EU.Log(this.Clocks[el.name].value);
        }

        checkIfHourCorrect() {
            for (var i = 0; i < this.Elements.Clocks.length; i++) {
                if (this.Elements.Clocks[i].CorrectHours%12 != this.Clocks[2 * i+1].value) return false;
                if (this.Elements.Clocks[i].CorrectMinutes/5 != this.Clocks[2 * i].value) return false;
            }
            return true;
        }
       
        checkIfEverythingIsCorrect() {
            if (this.checkIfHourCorrect() && EU.checkIfFillsAreCorrect(this) && EU.checkIfSelectablesAreCorrect(this)) {
                EU.setGameCompletion(this.parent, 1);
                if (TYPE === "gm") {
                    super.nextTask();
                }
                EU.Log("Correct!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }
    }
} 