/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentSimpleFlashMoviePlayer = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);
	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.rendered = false;
};

componentSimpleFlashMoviePlayer.prototype = new componentElement;
componentSimpleFlashMoviePlayer.prototype.type = "componentSimpleFlashMoviePlayer";

componentSimpleFlashMoviePlayer.prototype.onBaseCreate = function(obj)
{
	this.disableOnlineOfflineMix = true; //mk: flash CAN'T be load from other domain then course
	this.resourcesURL = resourcesURL;
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
};

componentSimpleFlashMoviePlayer.prototype.onCreate = function(obj)
{
};

componentSimpleFlashMoviePlayer.prototype.onPaint = function(obj)
{
	if (this.rendered) return;
	var t = "";
	var fv = "";
	/*  //pg2-test-flv removed
	if (PageInterface.GetValue("state") != psDesigning) {
		fv = "mediaStatus=" + lms.mediaStatus() + "&" + this.formatVar(this.flashVars);
	}
	while (fv.indexOf('+') > -1) { //pg2- '+' in .setHTML() is converted in several ways, and finally simple '+' is passed as parameter and is missing in output flash
		fv = fv.replace('+', '_2B_'); //it will be converted to proper value '%2B' in 'element.js'
	}*/

	var backgroundColor = (this.useDefinedBG?this.bgColor:""); //pg2

	//var tst = "flv=ppt.flv&title=Test title&width=320&height=240&showstop=1&showvolume=1&showtime=1&startimage=___.flash.img.gif&showfullscreen=1&bgcolor1=189ca8&bgcolor2=085c68&playercolor=085c68&autoplay=0";

	var autoplay = 0;
	if (PageInterface.GetValue("state") != psDesigning && this.showAndPLay) { //&& this.step == 0)
		autoplay = 1;
	};

	var title = this.movieTitle;
	var titleNew = "";
	for (var i=0; i<title.length; i++) {
		var letter = title.charAt(i);
		var letterUp = letter.toUpperCase();
		if ((letterUp <= 'Z' && letterUp >= 'A') || (letterUp >= '0' && letterUp <= '9') || (letterUp == ' ')) {
			titleNew += letter;
		};
	};

	var color1 = this.playerColor1.replace(new RegExp('#', "g"), '');
	var color2 = this.playerColor2.replace(new RegExp('#', "g"), '');

	var onlineSrc = ((this.src.indexOf('https://') == 0) || (this.src.indexOf('http://') == 0)); //pg2-if online resource, do not add resourcesURL prefix
	if (onlineSrc) {
		fv = 'flv=' + this.src + '&';
	} else {
		fv = 'flv=' + this.resourcesURL + this.src + '&';
	};

	fv += 'title=' + titleNew + '&';
	fv += 'width=' + this.w + '&height=' + this.h + '&';
	fv += 'showstop=1&showvolume=1&showtime=1&';
	fv += 'startimage=' + this.resourcesURL + this.playerBackground + '&';
	fv += 'showfullscreen=1&';

	//fv += 'bgcolor1=ff0000&bgcolor2=00ff00&';  // + this.backgroundColor + '&';
	fv += 'bgcolor1=' + color1 + '&bgcolor2=' + color2 + '&';
	fv += 'playercolor=707070&playeralpha=20&showplayer=autohide&playertimeout=500&'; //pg2-new -alpha, autohide, bar color
	fv += 'autoplay=' + autoplay;

	if (PageInterface.GetValue("state") == psDesigning) { //pg2-otherwise in case of new version of FlashPlayer (v11) there is a blank rect
		t = '<img src="' + this.resourcesURL + this.playerBackground + '" width="' + this.w + '" height="' + this.h + '"/>';
		this.setHTML(t);
		this.rendered = true;
		return;
	};

	/*if (is.ie) {
		//t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ this.w +'" height="'+ this.h +'" id="'+ this.id +'flashPlayer" align="middle" data="' + this.resourcesURL + this.playerSrc '">';
		t += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="https://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="'+ this.w +'" height="'+ this.h +'" id="'+ this.id +'flashPlayer" align="middle" data="' + this.resourcesURL + this.playerSrc + '" class="playerpreview">';
		t += '  <param name="movie" value="' + this.resourcesURL + this.playerSrc + '" />';
		t += '  <param name="allowScriptAccess" value="sameDomain" />';
		//t += '  <param name="BGColor" value="' + backgroundColor + '">';
		//t += '  <param name="quality" value="' + this.quality + '">';
		//t += '  <param name="loop" value="' + this.loop + '">';
		//t += '  <param name="WMode" value="' + this.wmode + '">';
		//t += '  <param name="scale" value="' + this.scale + '">';
		//t += '  <param name="salign" value="' + this.salign + '">'; 
		t += '  <param name="FlashVars" value="' + fv + '" />'; //&veriable_1=value_1&veriable_2=value_2

		t+= '   <param name="allowFullScreen" value="true" />';
		t += '</object>';
	} else { */
		/*t += '<embed';
		t += '  wmode="' + this.wmode + '" ';
		t += '  src="'+ this.resourcesURL + this.playerSrc +'" ';
		//t += '  quality="' + this.quality + '" ';
		//t += '  BGColor="' + backgroundColor + '" ';
		t += '  id="'+ this.id +'flashPlayer" ';
		t += '  type="application/x-shockwave-flash" ';
		t += '  pluginspage="https://www.macromedia.com/go/getflashplayer" ';
		t += '  width="'+ this.w +'" ';
		t += '  height="'+ this.h +'" ';
		t += '  FlashVars="' + fv + '" ';
		//t += 'scale="' + this.scale + '" '; //pg2- missing parameters
		//t += 'loop="' + this.loop + '" '; 
		//t += 'salign="' + this.salign + '" ';
		t += '  allowFullScreen="true" ';
		t += 'allowScriptAccess="sameDomain"> ';
		t += '</embed>';*/
	//}

	t += '<embed';
	t += '  wmode="' + this.wmode + '" ';
	t += '  src="'+ this.resourcesURL + this.playerSrc +'" ';
	t += '  id="'+ this.id +'flashPlayer" ';
	t += '  type="application/x-shockwave-flash" ';
	t += '  pluginspage="https://www.macromedia.com/go/getflashplayer" ';
	t += '  width="'+ this.w +'" ';
	t += '  height="'+ this.h +'" ';
	t += '  FlashVars="' + fv + '" ';
	t += '  allowFullScreen="true" ';
	t += 'allowScriptAccess="sameDomain"> ';
	t += '</embed>';

	this.setHTML(t);
	this.rendered = true;
};

componentSimpleFlashMoviePlayer.prototype.componentSimpleFlashMoviePlayerBaseSetSizeScaledElement = componentSimpleFlashMoviePlayer.prototype.setSizeScaledElement;
componentSimpleFlashMoviePlayer.prototype.setSizeScaledElement = function(x, y, w, h)
{
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	if (flashPlayer) {
		flashPlayer.width = w;
		flashPlayer.height = h;
	};
	this.componentSimpleFlashMoviePlayerBaseSetSizeScaledElement(x, y, w, h);
};

componentSimpleFlashMoviePlayer.prototype.onHide = function() 
{
	this.setHTML(" ");
	this.rendered = false;
};

componentSimpleFlashMoviePlayer.prototype.actionFlashStop = function(obj) //pg2-invoke media stop from page.js
{
	this.setHTML(" ");
	this.rendered = false;
};
