/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentImageAndText = function(name)
{
	this.componentElement  = componentElement;
	this.componentElement(name);
	
	this.preloadImg = null;
	this.waitingTryCount = 0;
	this.staticLibText = new __componentText(null);
	
	if (arguments[1]) {
	} else {
		this.image = this.addChild(new __componentImage(null));
		this.text = this.addChild(new __componentText(null));
	};
};

componentImageAndText.prototype = new componentElement();
componentImageAndText.prototype.type = "componentImageAndText";

componentImageAndText.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL);
	};
};

componentImageAndText.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();
	if (this.execution) {
		document.getElementById(this.id + "_imageDIV_contentObj").src = this.resourcesURL + this.imageSrc;
		var o = document.getElementById(this.id + "_textDIV_contentObj");
		if (o) {
			var t = o.innerHTML;
			t = this.staticLibText.initText(t);
			o.innerHTML = t;
		};
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;
		
		this.image.p_checkMarkers = this.p_checkMarkers;
		this.image.p_checkPNG = this.p_checkPNG;
		this.image.pngFix = this.pngFix;
	};
	if (this.execution) {
		this.reinit();
	};
};

componentImageAndText.prototype.isReady = function()
{
	if (this.execution) {
		return preloadImage(this, this.resourcesURL + this.imageSrc);
	} else {
		return((this.buttonVisible)?this.image.isReady():true);
	};
};

componentImageAndText.prototype.componentImageAndTextBaseSetSizeScaledElement = componentImageAndText.prototype.setSizeScaledElement;
componentImageAndText.prototype.setSizeScaledElement = function(x, y, w, h)
{
	this.componentImageAndTextBaseSetSizeScaledElement(x, y, w, h);
	if (this.execution) {
		document.getElementById(this.id + "_imageDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';	
		document.getElementById(this.id + "_imageDIV").style.width = w;
		document.getElementById(this.id + "_imageDIV").style.height = h;		
		document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';	
		document.getElementById(this.id + "_textDIV").style.width = w;	
		document.getElementById(this.id + "_textDIV").style.height = h;		
	} else {
		this.image.w = w;
		this.image.h = h;
		this.text.w = w;
		this.text.h = h;
	};
};
