/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentLexiconGroups = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);
	this.groups = "";
};

componentLexiconGroups.prototype = new __componentText;
componentLexiconGroups.prototype.type = "componentLexiconGroups";

componentLexiconGroups.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
};

componentLexiconGroups.prototype.componentLexiconGroupsBaseOnCreate = componentLexiconGroups.prototype.onCreate;
componentLexiconGroups.prototype.onCreate = function(obj)
{
	this.componentLexiconGroupsBaseOnCreate();
	if (this.scrollable) {
		this.scrollOffset = 14;
		this.stopPropagation = true;
	};
	this.groups = this.text;
};

componentLexiconGroups.prototype.onPaint = function(obj)
{
	this.groups = this.groups.replace(new RegExp('&nbsp;', "g"), ' '); //pg2
	this.groups = this.groups.replace(new RegExp('  ', "g"), ' '); //pg2
	var parsedGroups = this.groups.replace(/<[^>]*>/g, ""); //pg2-get text without html formatting
	//var f_list = this.groups.split(" ");
	var f_list = parsedGroups.split(" ");
	this.text = "";
	for (var i=0; i<f_list.length; i++) {
		var filter = f_list[i];
		if (filter.length > 1 && filter != "0-9") filter = "";
		if (filter != "" && !lexicon.existsKey(f_list[i], true)) {
			this.text += "<SPAN style='color: " + this.font.color + ";'>" + f_list[i] + " " + "</SPAN>";
		} else {
			//this.text += '<a href="javascript:void(0);" title="' + f_list[i] + '" onclick="pc.' + this.id + '.doClick(\'' + filter + '\');">' + /*f_list[i]*/ fList_i_formatted + '</a> ';
			this.text += '<a href="javascript:void(0);" title="' /*+ f_list[i]*/ + '" style="color: ' + this.font.activeColor + ';" onclick="pc.' + this.id + '.doClick(\'' + filter + '\');">' + f_list[i] + '</a> ';
		};
	};
	this.setValue(this.text);
};

componentLexiconGroups.prototype.doClick = function(value)
{
	lexicon.setFilter(value);
};
