/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentMenu = function(name)
{
	this.componentPagesList = componentPagesList;
	this.componentPagesList(name);

	this.subMenuComponentsList = '';
	this.imagesCompleteInfo = new Array();
};

componentMenu.prototype = new componentPagesList();
componentMenu.prototype.type = "componentMenu";

componentMenu.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
		};
	    this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = [this.bckgTop, this.bckgMiddle, this.bckgBottom, this.bckgSeparator];
		this.imagesNameArr = this.imagesNameArr.concat(this.getImagesFromString());
		this.getPreloadImagesArr();
	};
	this.captureMouseEvents();
   
	this.setCompleteArrayInfo(this.completeInfoStyleImages);
};

componentMenu.prototype.setCompleteArrayInfo = function(imagesStr)
{

	var imgArr = imagesStr.split('||');
	for (var i = 0; i < imgArr.length; i++) {
		var oneImg = imgArr[i].split('#');
		if (!this.imagesCompleteInfo[oneImg[0]]) {
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentMenu.prototype.getImagesFromString = function()
{
	var arr = new Array();
	var menuRowsArr = this.menuContent.split('||');

	for (var i = 0; i < menuRowsArr.length; i++) {
		var rowValues = menuRowsArr[i].split('#!#');
		if (rowValues[0] != '') arr.push(rowValues[0]);
		if (rowValues[2] != '') arr.push(rowValues[2]);
	};
	return arr;
};

componentMenu.prototype.onCreate = function(obj)
{
	this.setImagesIntoHTMLObj();
	this.setDivElements();
};

componentMenu.prototype.onPaint = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) {
		this.deleteAllRows();
		this.setMenuContenstRows();
	};
	return;
};

componentMenu.prototype.onAfterLoad = function(obj)
{
	this.deleteAllRows();
	this.setMenuContenstRows();
	return;
};

componentMenu.prototype.deleteAllRows = function(index)
{
	var table = document.getElementById(this.id+"_contentTable");
	if (table) {
		var length = table.rows.length;
		for (var i=0; i < length; i++) {
			table.deleteRow(0);
		};
	};
};

componentMenu.prototype.setMenuContenstRows = function(obj)
{
	var contentTable = document.getElementById(this.id + "_contentTable");
	var menuRowsArr = this.menuContent.split('||');
	for (var i = 0; i < menuRowsArr.length; i++){
		var rowValues = menuRowsArr[i].split('#!#');
		var row = contentTable.insertRow(contentTable.rows.length);
		row.id = 'row_'+contentTable.rows.length;
		row.style.cursor = 'pointer';
		var compName = this.getActionCompName(rowValues[4]);
		row.name = 'pc.'+compName+rowValues[4]+';';
		row.compObj = this;
		if (this.hideAfterClick == 'true') row.hideComponent = (rowValues[2] != '') ? '' : 'pc.'+this.id+'.hide();';
		row.rowColour = this.rowHighlight;
		row.onclick = this.callAction;
		row.onmouseover = this.callActiononmouseover;
		row.onmouseout = this.callActiononmouseout;
		var cell_1 = row.insertCell(0);
		cell_1.width = 5;
		var cell_1 = row.insertCell(1);
		cell_1.style.vAlign = 'middle';
		cell_1.align = 'center';
		cell_1.width = 1;
		if (rowValues[0] != '') {
			cell_1.innerHTML = this.getImageHTML(rowValues[0], this.getImageWidth(rowValues[0]), this.getImageHeight(rowValues[0]));
		};

		var font = this.getProjectFont(this.globalFormating == 1, this.fontFamily, this.fontSize, this.fontColor);
		var cell_1 = row.insertCell(2);
		cell_1.width = 5;
		var cell_1 = row.insertCell(3);
		cell_1.style.vAlign = 'middle';
		cell_1.style.fontFamily = font.family;
		cell_1.style.fontSize = getFontSize(font.size, 'px');
		cell_1.style.color = font.color;
		if (this.textsBold) {
			cell_1.innerHTML = '<b>'+rowValues[1]+'</b>';
		} else {
			cell_1.innerHTML = rowValues[1];
		};
		var cell_1 = row.insertCell(4);
		cell_1.style.vAlign = 'middle';
		cell_1.align = 'center';
		cell_1.width = 1;
		if (rowValues[2] != '') {
			var arr = rowValues[4].split('.');
			this.subMenuComponentsList += compName+arr[0]+'||';
			cell_1.innerHTML = this.getImageHTML(rowValues[2], this.getImageWidth(rowValues[2]), this.getImageHeight(rowValues[2]));
		};
	};
};

componentMenu.prototype.callActiononmouseover = function()
{
	this.style.background = this.rowColour;
	if (this.compObj.hideSubmenu) {
		var compArr = this.compObj.subMenuComponentsList.split('||');
		var arr = this.name.split('.');

		for (var i = 0; i < compArr.length; i++) {
			if (compArr[i] != '' && compArr[i] != arr[1] && page.all[compArr[i]]){
				try {
					eval('pc.'+compArr[i]+'.hide();');
				} catch(e) {};
			};
		};
	};
};

componentMenu.prototype.callActiononmouseout = function()
{
	this.style.background = 'transparent';
}

componentMenu.prototype.getActionCompName = function(compAction)
{
	if (this.id.indexOf('__bckg__') > -1 && compAction.indexOf('page01') == -1) {
		var compNameArr = this.id.split('_');
		var bckgName = '__'+compNameArr[2]+'__'+compNameArr[4];
		return bckgName+'_';//+'_'+compAction
	} else {
		return '';
	};
};

componentMenu.prototype.callAction = function()
{
	try {
		eval(this.hideComponent);
		eval(this.name);
	} catch(e){};
};

componentMenu.prototype.getImageHTML = function(imgName, width, height)
{
	var imgObj = new Image();
	imgObj.src = this.resourcesURL + imgName;
	var counter = 0;

	if (width == 0) {
		width = this.getImageWidth(imgName);
	};
	if (height == 0) {
		height = this.getImageHeight(imgName);
	};

	var s = '';
	var src = this.resourcesURL+imgName;
	var smallLettersName = imgName.toLowerCase();
	src = ".." + src.substr(src.lastIndexOf("/resources/"), src.length);

	if (smallLettersName.indexOf('.png') > -1 && is.ie55UP && !is.ie7UP) {
		s = '<span  src="' + this.resourcesURL+imgName + '"';
		s += ' style="width:' + width + '; height:' + height + '; display:inline-block;';
		s += 'filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
		s += '(src=\'' + src + '\', sizingMethod=\'image\');" ></span>';
	} else {
		s = '<img src="'+this.resourcesURL+imgName+'" height="'+height+'px" width="'+width+'px" >';
	};
	return s;
};

componentMenu.prototype.getProjectFont = function(fontGlobalFormating, family, size, color)
{
	var font = {};
	font.family = family;
	font.size = size;
	font.color = color;

	if (fontGlobalFormating && project.globalFormating) {
		font.family = project.font.family;
		font.size = project.font.size;
		font.color = project.font.color;
	};
	return font;
};

componentMenu.prototype.getImageHeight = function( imgName )
{
	if (this.imagesCompleteInfo[imgName]) {
		return parseInt(this.imagesCompleteInfo[imgName][1]);
	} else {
		return getImageHeight(imgName);
	};
};

componentMenu.prototype.getImageWidth = function( imgName )
{
	if (this.imagesCompleteInfo[imgName]) {
		return parseInt(this.imagesCompleteInfo[imgName][0]);
	} else {
		return getImageWidth(imgName);
	};
};
