/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
componentInstruction = function( name )
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.arrSteps 	= new Array();
	this.oldHeight 	= null;
	this.timerID 	= null;

	this.contentObj = null;
};

componentInstruction.prototype = new __componentText;
componentInstruction.prototype.type = "componentInstruction";

componentInstruction.prototype.onCreate = function( obj )
{
	this.captureMouseEvents();
	if ( PageInterface.GetValue("state") != psDesigning ) {
		this.fillArray(this.stepsTexts);
	} else {
		if (this.fontBold) {
			this.notify = "<B>" + this.notify + "</B>";
		};
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").innerHTML = this.notify; 
		} else {
			this.text = this.notify;
		};
	};
};

componentInstruction.prototype.isInArray = function( item, itemArray )
{
	for (var k = 0; k < itemArray.length; k++) {
		if (itemArray[k].toString() == item.toString()) return true;
	};
	return false;
};

componentInstruction.prototype.isInSteps = function( step )
{
	var toShow = new Array();

	for (var i=0; i<this.arrSteps.length; i++) {
		for (var j=0; j<this.arrSteps[i].steps.length; j++) {
			if (step == this.arrSteps[i].steps[j]) { 
				if (!this.isInArray(i,toShow)) toShow.push(i);
			};
		};
	};
	return toShow;
};

componentInstruction.prototype.fillArray = function( string )
{
	var arrElements		= string.split("||");
	var arrSubElements 	= null;
	var arrLocalSteps 	= null;
	for (var i=0; i < arrElements.length; i++ ) {
		arrSubElements 	= arrElements[i].split("::");
		arrLocalSteps 	= arrSubElements[0].split(",");

		var obj = 
		{ 
			steps : arrLocalSteps, 
			time  : arrSubElements[2], 
			text  : arrSubElements[1]
		};
		this.arrSteps.push(obj);
	};
};

componentInstruction.prototype.onPaint = function()
{
	return;
};

componentInstruction.prototype.onStep = function()
{
	if (this.timerID != null) {
		window.clearTimeout(this.timerID);
		this.timerID = null;
	};
	this.toShow = this.isInSteps(page.stepIndex);

	if (this.showTitle.toString() == "true") {
		this.contentObj.innerHTML = "<B>" + this.instructionTitle + "</B>";
		if (this.allowReSize) this.setComponentSize();
	} else {
		this.contentObj.innerHTML = "";
		this.hide();
	};

	if (this.toShow.length != 0) {
		if (this.arrSteps[this.toShow[0]].time == 0) {
			this.doIt();
		} else {
			if (this.showTitle.toString() == "false") this.hide();
			this.timerID = setTimeout('pc.' + this.id + '.doIt();', this.arrSteps[this.toShow[0]].time);
		};
	} else this.doIt();
};

componentInstruction.prototype.doIt = function()
{
	this.contentObj = this.findContentObj();
	var toShow = this.toShow;
	if (toShow.length != 0) {
		var temp = this.contentObj.innerHTML;
		//pg2
		var condition = true;
        try {
			condition = (eval(unescape(this.visibleIf)) || (this.visibleIf == ''));
		} catch(e) {
			condition = true;
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.doIt() eval visibleIf execution error\nMessage:\n' + e.message); //pg2
		};
		if (condition) this.show();
		//

		if (this.showTitle) temp += '<br>';
		for (var i=0; i < toShow.length; i++) {
			var hintBeginFont = '<font style="font-family:' + this.hintFontFamily + '; font-size:' + getFontSize(this.hintFontSize, 'px') + '; color:' + this.hintFontColor + '">';
			var hintEndFont = '</font>';
			var beginBold = '';
			var endBold = '';
			if (this.fontBold) {
				beginBold += '<b>';
				endBold = '</b>' + endBold;
			};

			if (this.instructionAbove) {
				this.contentObj.innerHTML = beginBold + temp + hintBeginFont + this.arrSteps[toShow[i]].text + hintEndFont + endBold;
			} else {
				this.contentObj.innerHTML = beginBold + hintBeginFont + this.arrSteps[toShow[i]].text + hintEndFont + "<br>" + temp + endBold;
			};
		};
	} else {
		if (this.showTitle.toString() == "true") {
			this.show();
			this.contentObj.innerHTML = "<B>" + this.instructionTitle + "</B>";
		} else {
			this.hide();
		};
	};
	if (this.allowReSize) this.setComponentSize();
};

componentInstruction.prototype.setComponentSize = function()
{
	this.contentObj = this.findContentObj();
	var height = this.contentObj.offsetHeight + 2*this.borderWidth + this.padding*2;

	if (this.sizeType.toString() == "1") {
		if (this.oldHeight) {
			var top = this.oldHeight-height;
			var actualTop = parseInt(document.getElementById(this.id).style.top.match(/[0-9]*/));

			var newTop = (top+actualTop > 0) ? top + actualTop : "0";
			document.getElementById(this.id).style.top = newTop;
		};
	} else
	if ( (height + parseInt(document.getElementById(this.id).style.top.match(/[0-9]*/))) > this.screenHeight()) {
		document.getElementById(this.id).style.top = this.screenHeight() - height;
	};

	if (is.ie) {
		document.getElementById(this.id).style.height = height;
		document.getElementById(this.id).style.clip	= "rect(0px " + this.w + "px " + height + "px 0px)";
		document.getElementById(this.id + "Table").height = this.contentObj.offsetHeight;
		this.oldHeight = document.getElementById(this.id).style.height.match(/[0-9]*/);
	} else {
		document.getElementById(this.id).style.height = height - 4;
		document.getElementById(this.id).style.clip	= "rect(0px " + this.w + "px " + eval(height) + "px 0px)";
		document.getElementById(this.id + "Table").height = this.contentObj.offsetHeight;
		this.oldHeight = document.getElementById(this.id).style.height.match(/[0-9]*/);
	};
};

componentInstruction.prototype.screenHeight = function()
{
	if (top.self.innerHeight) return top.self.innerHeight; else
	if (top.document.documentElement && top.document.documentElement.clientHeight) return top.document.documentElement.clientHeight; else
	if (top.document.body) return top.document.body.clientHeight; else return false;
};

componentInstruction.prototype.onFree = function()
{
	if (this.timerID != null) {
		window.clearTimeout(this.timerID);
	};
};
