/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
componentIFrame = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.timerLoader = null;
};

componentIFrame.prototype = new componentElement;
componentIFrame.prototype.type = "componentIFrame";

componentIFrame.prototype.onCreate = function()
{
	this.captureMouseEvents();
	if (PageInterface.GetValue("state") != psDesigning && lms) {
		this.resourcesStatus = lms.resourcesStatus();
		this.resourcesURL = lms.resourcesURL();
	};

	this.src = replaceWBTProtocol(this.src);
};

componentIFrame.prototype.onPaintDelayed = function() //pg2-new, look below
{
	try {
		window.clearTimeout(this.timerLoader);
		this.timerLoader = null;
		var obj = document.getElementById(this.id + "_contentobj");
		if (obj) {
			obj.src = this.src;
		};
	} catch(e) {
		//alert('error1: ' + e.message); //pg2-test
	};
};

componentIFrame.prototype.onPaint = function()
{
	if (page.state == psDesigning) { //pg2
		this.setDefaultContent(); //pg2-new -instead of listing it few times
	} else {
		//if (this.step != 0) { //pg2-first solution, but also unsufficient 'cause in IE if element is loaded in first step (or with action "After load->iframeX->show" ie tries to access some frames too quick
			//var obj = document.getElementById(this.id + "_contentobj");
			//if (obj) {
				//obj.src = this.src;
			//}
		//} else {
			this.timerLoader = window.setTimeout('pc.' + this.id + '.onPaintDelayed()', 500); //pg2-otherwise if iframe1.step == 0 and is shown at page's startup, exception "Access denied" (access to some frames) is invoked
		//}
	};
	
	/* //pg2-removed, replaced with the code above
	var t = '';
	if (page.state == psDesigning) {
		t += '<table style="border: '+ this.borderWidth +'px solid #DDDDDD;" width="100%" height="100%" bgcolor="#FFFFFF">';
		t += '<tr><td align="center" valign="middle">';
		t += '<img src="'+ resourcesURL + this.iconSrc +'" />';
		t += '</td></tr></table>';
	} else {
		t = '<iframe src="' + this.src + '" scrolling="' + this.scrolling + '"';
		t += ' align="' + this.align + '" border="0" frameborder="0" framespacing="0"';
		t += ' style="width: ' + (this.w-(this.borderWidth*2)) + '; height: ' + (this.h-(this.borderWidth*2)) + '; border: 0px; align: ' + this.align + ';">';
		t += '</iframe>';
	}
	
	this.setHTML(t);
	*/
};

componentIFrame.prototype.setDefaultContent = function() //pg2-new
{
	var t = '';
	t += '<table style="border: '+ this.borderWidth +'px solid #DDDDDD;" width="100%" height="100%" bgcolor="#FFFFFF">';
	t += '<tr><td align="center" valign="middle">';
	t += '<img src="'+ resourcesURL + this.iconSrc +'" />';
	t += '</td></tr></table>';
	this.setHTML(t);
};

componentIFrame.prototype.componentIFrameBasehide = componentIFrame.prototype.hide; //pg2-new
componentIFrame.prototype.hide = function() //pg2-new
{
	if (page && page.state != psDesigning) {
		try {
			if (this.timerLoader != null) window.clearTimeout(this.timerLoader); //pg2-in case of fast navigation between pages, onPaintDelayed() could be invoked from some other page, and its content could be loaded into other document
			this.timerLoader = null;
			var obj = document.getElementById(this.id + "_contentobj");
			if (obj && obj.src != "") {
				obj.src = "";
				//this.componentIFrameBasehide();
			} else {
				if (obj) obj.src = ""; //pg2-new
			};
		} catch(e) {
			//alert('error2: ' + e.message); //pg2-test
		};
	};
	this.componentIFrameBasehide();
};

componentIFrame.prototype.componentIFrameBaseSetSizeScaledElement = componentIFrame.prototype.setSizeScaledElement;
componentIFrame.prototype.setSizeScaledElement = function (x, y, w, h)
{
	if (this.execution) {
		if (document.getElementById(this.id + "_contentobj")) {				
			document.getElementById(this.id + "_contentobj").style.width = w;
			document.getElementById(this.id + "_contentobj").style.height = h;	
		};
	};
	this.componentIFrameBaseSetSizeScaledElement(x, y, w, h);
};
