/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
componentRadioButton = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.isChanged = false;
	
	if (arguments[1]) {
	} else {
		this.text = this.addChild(new __componentText(null));
		this.imgc = this.addChild(new __componentImage(null));
		this.imgn = this.addChild(new __componentImage(null));
		this.imgc.visible = false;
		this.imgn.visible = false;
	};
	
	this.imgChecked = "";
	this.imgNotChecked = "";
};

componentRadioButton.prototype = new componentElement();

componentRadioButton.prototype.type = "componentRadioButton";

componentRadioButton.prototype.onBaseCreate = function(obj)
{
	if (this.correctAnswer == 'true') this.correctAnswer = "1"; else //pg2-JGU, radiobutton in v.old course
	if (this.correctAnswer == 'false') this.correctAnswer = "0";
	
	this.captureMouseEvents();
	
	if (!this.imgCheckedCorrectSrc) this.imgCheckedCorrectSrc = this.imgChecked;
    if (!this.imgNotCheckedCorrectSrc) this.imgNotCheckedCorrectSrc = this.imgNotChecked;
    if (!this.imgCheckedIncorrectSrc) this.imgCheckedIncorrectSrc = this.imgChecked;
    if (!this.imgNotCheckedIncorrectSrc) this.imgNotCheckedIncorrectSrc = this.imgNotChecked;
	
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		
		this.resourcesURL = unescape(this.resourcesURL);
				
		this.captureMouseEvents();
		this.imagesNameArr = [	this.imgChecked, this.imgNotChecked, this.imgCheckedCorrectSrc, this.imgNotCheckedCorrectSrc, this.imgCheckedIncorrectSrc, 	this.imgNotCheckedIncorrectSrc ];
		this.getPreloadImagesArr();
	};
};

componentRadioButton.prototype.onCreate = function(obj)
{
	this.correctAnswer = parseInt(this.correctAnswer);
	if (this.execution) {
		this.setImageSrc(this.resourcesURL + this.imgNotChecked);
		if (this.imageClick == 1) document.getElementById(this.id + "_clickedTD").onclick = '';
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;
		
		this.imgc.p_checkMarkers = this.p_checkMarkers;
		this.imgc.p_checkPNG = this.p_checkPNG;
		this.imgc.pngFix = this.pngFix;
		
		this.imgn.p_checkMarkers = this.p_checkMarkers;
		this.imgn.p_checkPNG = this.p_checkPNG;
		this.imgn.pngFix = this.pngFix;
		
		this.captureMouseEvents();
		this.text.captureMouseEvents();
		this.imgc.captureMouseEvents();
		this.imgn.captureMouseEvents();
	};
	if (PageInterface.GetValue("state") == psDesigning) {
		this.checked = this.correctAnswer;
	};
	//kr - page 2 components check answer without mark anyone - division by zero
	//this.checkLock = !this.correctAnswer; 
	this.addToGroup();
};

componentRadioButton.prototype.componentRadioButtonResetElement = componentRadioButton.prototype.resetElement;
componentRadioButton.prototype.resetElement = function()
{
	this.componentRadioButtonResetElement();
	this.checked = false;
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		this.setImageSrc(this.resourcesURL + ((this.checked) ? this.imgCheckedCorrectSrc : this.imgNotCheckedCorrectSrc));
	};
	this.locked = false;
	this.isChanged = false;
};

componentRadioButton.prototype.onPaint = function(obj)
{
	if (this.execution) {
		this.contentObj = this.findContentObj();
		if (this.contentObj) {
			this.setImageSrc(this.resourcesURL + ((this.checked) ? this.imgChecked : this.imgNotChecked));
		};
	} else {
		this.imgc.visible = this.checked;
		this.imgn.visible = !this.checked;
		this.imgc.onClick = function (e) {
			this.parent.changeChecked();
			return true;
		};
		this.imgn.onClick = function (e) {
			this.parent.changeChecked();
			return true;
		};
		this.text.onClick = function (e) {
			if (this.parent.imageClick == 0) this.parent.changeChecked();
			return true;
		};
		
		this.style.cursor = this.cursor;
		this.text.cursor = this.cursor;
		this.imgc.cursor = this.cursor;
		this.imgn.cursor = this.cursor;
		
		this.text.x = parseInt(this.imgc.w) + parseInt(this.textOffset) + parseInt(this.padding);
		this.text.y = this.paddingTopText;
		this.text.w = parseInt(this.w) - parseInt(this.imgc.w) - parseInt(this.textOffset) - (parseInt(this.padding) * 2);
		this.text.h = parseInt(this.h) - (parseInt(this.padding) * 2) - this.paddingTopText;
		
		if (this.checkVAlign == "bottom") {
			var xp = this.padding;
			var yp = parseInt(this.h) - parseInt(this.imgc.h) - parseInt(this.padding) - 2 + this.paddingTopImage;
		} else
        if (this.checkVAlign == "middle") {
			var xp = this.padding;
			var yp = parseInt(this.h)/2 - parseInt(this.imgc.h)/2 + parseInt(this.padding) + this.paddingTopImage;
		} else {
			var xp = this.padding;
			var yp = this.padding + this.paddingTopImage + 2;
		};
		this.imgc.x = this.imgn.x = xp;
		this.imgc.y = this.imgn.y = yp;
	};
	this.onRepaint();
};

componentRadioButton.prototype.showCAI = function(obj)
{
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		if (this.checkAnswer()) {
			this.setImageSrc(this.resourcesURL + ((this.checked) ? this.imgCheckedCorrectSrc : this.imgNotCheckedCorrectSrc));
		} else {
			this.setImageSrc(this.resourcesURL + ((this.checked) ? this.imgCheckedIncorrectSrc : this.imgNotCheckedIncorrectSrc));
		}
	}
};
componentRadioButton.prototype.onRepaint = function(obj)
{
	if (this.execution) {
		if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
			this.showCAI();
		};
	} else {
		if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator){
			if (this.checkAnswer()) {
				this.imgc.src = this.imgCheckedCorrectSrc;
				this.imgn.src = this.imgNotCheckedCorrectSrc;
			} else {
				this.imgc.src = this.imgCheckedIncorrectSrc;
				this.imgn.src = this.imgNotCheckedIncorrectSrc;
			};
		} else {
			this.imgc.src = this.imgChecked;
			this.imgn.src = this.imgNotChecked;
		};
		this.imgc.paint();
		this.imgn.paint();
	};
};

//pg2-axa_bm -change cursor to defaul on element lock
componentRadioButton.prototype.setCursor = function(cursorStr)
{
	var obj = document.getElementById(this.id);
	if (obj) obj.style.cursor = cursorStr;
	obj = document.getElementById(this.id + '_textDIV');
	if (obj) obj.style.cursor = cursorStr;
	obj = document.getElementById(this.id + '_checkDIV');
	if (obj) obj.style.cursor = cursorStr;
};

componentRadioButton.prototype.onLock = function()
{
	if (this.changeCursorOnLock) this.setCursor('default');
};

componentRadioButton.prototype.onUnLock = function()
{
	if (this.changeCursorOnLock) this.setCursor(this.cursor);
};
//...

componentRadioButton.prototype.getValue = function()
{
	return (this.checked) ? 1 : 0;
};

componentRadioButton.prototype.setValue = function(value)
{
	//if (typeof(value) == 'undefined' || typeof(value) != 'number') return; //pg2-IE10 -removed again, the problem wasn't here
	this.checked = (value == 1) ? true : false;
	this.paint();
	return false;
};

// examine if answer is correct
componentRadioButton.prototype.checkAnswer = function()
{
	return(this.parseCheckAnswer(this));
};

componentRadioButton.prototype.checkIsAnswer = function()
{
	return this.checked;
};

componentRadioButton.prototype.getAnswer = function()
{
	return (!this.ignoreAnswer && this.checked) ? 1 : 0;
};

componentRadioButton.prototype.setAnswer = function(v)
{
	this.setValue(v);
};

componentRadioButton.prototype.isReady = function()
{
	if (this.execution) {
		var isLoaded = false
		for (var i=0; i < this.imagesNameArr.length; i++){
			isLoaded = preloadImage(this, "_"+i);
			if (!isLoaded) return false;
		};
		this.isLoaded = isLoaded;
		return this.isLoaded;
	} else {
		return(this.imgc.isReady() && this.imgn.isReady());
	};
};

componentRadioButton.prototype.checkIsChanged = function()
{
	return(this.isChanged);
};

componentRadioButton.prototype.setAllUnchecked = function()
{
	var children = PageInterface.GetValue("getChildren");
	
	for (var i=0; i<this.parent.children.length; i++) {
		var o = this.parent.children[i];
		if (o.id != this.id && o.type == this.type && o.group == this.group) {
			o.setAnswer(0);
		};
	};
};

componentRadioButton.prototype.changeChecked = function()
{
	this.invokeEvent("Click");
	if (this.locked) return; //if (this.locked || this.checked) return; //pg2-aps_test
	
	if (!this.locked) {
		this.setAllUnchecked();
		this.isChanged = true;
		this.checked = !this.checked;
		this.setValue((this.checked) ? 1 : 0);
		this.invokeEvent("Marked");
		
		if (this.checkAnswer()) {
			this.invokeEvent("ChangeCorrectAnswer");
		} else {
			this.invokeEvent("ChangeIncorrectAnswer");
		};
	};
	if (config.FocusManegementForSynthesizer && page) { //pg2-aps_test
		page.processRadiobuttons(true, this.checked);
	};
};

componentRadioButton.prototype.componentRadioButtonBaseSetSizeScaledElement = componentRadioButton.prototype.setSizeScaledElement;
componentRadioButton.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		document.getElementById(this.id + "_checkDIV_textTable").style.height = w;		
	};
	this.componentRadioButtonBaseSetSizeScaledElement(x, y, w, h);
};

componentRadioButton.prototype.addToGroup = function()
{
	var c = 1;
	for (var i = 0; i < page.children.length; i++) {
		if (page.children[i].type == "componentRadioButtonGroup") {
			c++;
			if (page.children[i].group == this.group) return;
		};
	};
	//var e = page.addChild(new componentRadioButtonGroup("radiobuttongroup" + c));
	var e = page.addChild(new componentRadioButtonGroup(this.type+"Group"+c));
	e.globalIndex = this.globalIndex;
	e.group = this.group;
};

//
// componentRadioButtonGroup
//
componentRadioButtonGroup = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	this.group = "";
	this.isGroup = true;
	
	this.interactions = true;
	this.interactionsType = "numeric";
};

componentRadioButtonGroup.prototype = new componentElement();

componentRadioButtonGroup.prototype.type = "componentRadioButtonGroup";

componentRadioButtonGroup.prototype.interactionsCorrectResponsesCount = function()
{
	return 1;
};

componentRadioButtonGroup.prototype.interactionsCorrectResponses = function(index)
{
	var res = "";
	for (var i = 0; i < page.children.length; i++) {
		var o = page.children[i];
		if (o.type == "componentRadioButton" && o.group == this.group) {
			if (res.length > 0) res += ':';
			res += (o.correctAnswer) ? "1":"0";
		};
	};
	return res;
};

componentRadioButtonGroup.prototype.interactionsStudentResponse = function()
{
	var res = "";
	for (var i = 0; i < page.children.length; i++) {
		var o = page.children[i];
		if (o.type == "componentRadioButton" && o.group == this.group) {
			if (res.length > 0) res += ':';
			res += (o.checked) ? "1":"0";
		};
	};
	return res;
};

componentRadioButtonGroup.prototype.interactionsCorrectResponsesAsText = function(index)
{
	var res = "";
	for (var i = 0; i < page.children.length; i++) {
		var o = page.children[i];
		if (o.type == "componentRadioButton" && o.group == this.group) {
			if (o.correctAnswer) {
				if (res.length > 0) res += ':';
				if (o.answerValuesString != "") {
					res += escape(o.answerValuesString);
				} else res += "1";
			};
		};
	};
	return res;
};

componentRadioButtonGroup.prototype.interactionsStudentResponseAsText = function()
{
	var res = "";
	for (var i = 0; i < page.children.length; i++) {
		var o = page.children[i];
		if (o.type == "componentRadioButton" && o.group == this.group) {
			if (o.checked) {
				if (res.length > 0) res += ':';
				if (o.answerValuesString != "") res += escape(o.answerValuesString); else res += "1";
			} else {
				if (o.answerValuesString != "") res += "";
                else {
					if (res.length > 0) res += ':';
					res += "0";
				};
			};
		};
	};
	return res;
};

componentRadioButtonGroup.prototype.getAnswer = function()
{
	var groupAnswer="";
	for (var i = 0; i < page.children.length; i++) {
		if (page.children[i].type == "componentRadioButton") {
			if (page.children[i].group == this.group) {
				if(groupAnswer.length>0) groupAnswer +=':';
				groupAnswer += page.children[i].getAnswer();
			};
		};
	};
	return groupAnswer;
};

componentRadioButtonGroup.prototype.setAnswer = function(valStr, showCorrect)
{
	var res = "";
	if(valStr==null || typeof(valStr)=="undefined") return;
	var elemAnswer = valStr.split(':');
	var cnt=0;
	for (var i = 0; i < page.children.length; i++) {
		var o = page.children[i];
		if (o.type == "componentRadioButton" && o.group == this.group) {			
			o.setAnswer(elemAnswer[cnt]);
			cnt++;
		};
	};
	return res;
};

componentRadioButtonGroup.prototype.parseCheckAnswer = function()
{
	var groupParseCheckAnswer=true;
	for (var i = 0; i < page.children.length; i++) {
		if (page.children[i].type == "componentRadioButton") {
			if (page.children[i].group == this.group) {								
				if(!page.children[i].parseCheckAnswer(page.children[i])){
					groupParseCheckAnswer=false;
					break;
				};
			};
		};
	};
	return groupParseCheckAnswer;
};
//
//
function radioButtonGroupCheckAnswer(group)
{
	var res = true;
	for(var i=0; i<page.children.length; i++) {
		if (page.children[i].type == "componentRadioButton" && page.children[i].group == group) {
			res &= page.children[i].checkAnswer();
		};
	};
	return (res==1)?true:false;
};
