var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Fiche;
(function (_Fiche) {
    var Fiche = (function (_super) {
        __extends(Fiche, _super);
        function Fiche(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.currentFiche = 1;
        }
        Fiche.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        Fiche.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Fiche.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.isPolish = true;
            this.Loader = new Phaser.Loader(this.game);
            this.Background = this.game.add.image(50, -150, "bck");
            this.prevB = this.game.add.button(120, 820, "prevF", this.prevFiche, this, 0, 0, 1, 0);
            this.nextB = this.game.add.button(1150, 820, "nextF", this.nextFiche, this, 0, 0, 1, 0);
            var fSpeaker = this.game.add.button(100, 50, "fSpeaker", this.readLector, this, 0, 0, 1, 0);
            var Assistant = this.game.add.button(1350, 300, "assistant", this.assistantClick, this, 0, 0, 0, 0);
            var flip = this.game.add.button(1150, 70, "flip", this.flip, this, 0, 0, 1, 0);
            this.FicheImage = this.game.add.image(300, 100, "firstImage");
            this.FicheImage.x = (this.Background.x + this.Background.width / 2) - this.FicheImage.width / 2 - 50;
            this.Description = this.game.add.text(400, 720, this.GameData.words[0].term_PL, { font: "30pt Arial", wordWrap: true, wordWrapWidth: this.FicheImage.width * 2 }, this);
            this.Description.x = (this.Background.x + this.Background.width / 2) - this.Description.width / 2 - 50;
            this.Description.addColor("#2d842d", 0);
            this.addChild(this.Background);
            this.addChild(Assistant);
            this.Background.addChild(fSpeaker);
            this.Background.addChild(flip);
            this.Background.addChild(this.prevB);
            this.Background.addChild(this.nextB);
            this.Background.addChild(this.Description);
            this.Background.addChild(this.FicheImage);
            this.BackgroundWidth = this.Background.width;
            this.BackgroundStartingPosition = this.Background.x;
            this.prevB.visible = false;
        };
        Fiche.prototype.assistantClick = function () {
        };
        Fiche.prototype.animateFlip = function () {
            var tw = this.game.add.tween(this.Background);
            tw.to({ width: this.BackgroundWidth, x: this.BackgroundStartingPosition }, 700, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(function () {
                this.game.input.enabled = true;
            }, this);
            tw.start();
            this.readLector();
        };
        Fiche.prototype.flip = function () {
            this.game.input.enabled = false;
            var tw = this.game.add.tween(this.Background);
            tw.to({ width: 0, x: this.Background.x + this.Background.width / 2 }, 500, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(this.animateFlip, this);
            tw.start();
            if (this.isPolish) {
                this.Description.setText(this.GameData.words[this.currentFiche - 1].term_EN);
                this.isPolish = false;
            }
            else {
                this.Description.setText(this.GameData.words[this.currentFiche - 1].term_PL);
                this.isPolish = true;
            }
            this.Description.x = (this.Background.x + this.Background.width / 2) - this.Description.width / 2 - 50;
        };
        Fiche.prototype.readLector = function () {
            var fNumber = this.currentFiche;
            if (fNumber > 1)
                fNumber - 1;
            if (this.isPolish)
                this.currentAudio = new Audio("Sounds/" + MODULE + "/" + CardChooser.getCardNum().match(/\d+/) + "_" + fNumber + "_PL.mp3");
            else
                this.currentAudio = new Audio("Sounds/" + MODULE + "/" + CardChooser.getCardNum().match(/\d+/) + "_" + fNumber + "_EN.mp3");
            Global.Main.PlayMusic(this.currentAudio);
        };
        Fiche.prototype.nextFiche = function () {
            this.isPolish = true;
            this.prevB.visible = true;
            if (this.currentFiche === this.GameData.FicheQuantity - 1)
                this.nextB.visible = false;
            if (this.currentFiche < this.GameData.FicheQuantity) {
                this.currentFiche++;
            }
            this.readLector();
            this.Description.setText(this.GameData.words[this.currentFiche - 1].term_PL);
            this.Description.x = (this.Background.x + this.Background.width / 2) - this.Description.width / 2 - 50;
            this.loadFiche();
        };
        Fiche.prototype.prevFiche = function () {
            this.isPolish = true;
            this.nextB.visible = true;
            console.log(this.currentFiche);
            if (this.currentFiche == 2)
                this.prevB.visible = false;
            if (this.currentFiche > 0)
                this.currentFiche--;
            this.readLector();
            this.Description.setText(this.GameData.words[this.currentFiche - 1].term_PL);
            this.Description.x = (this.Background.x + this.Background.width / 2) - this.Description.width / 2 - 50;
            this.loadFiche();
        };
        Fiche.prototype.loadFiche = function () {
            this.Loader.image(this.currentFiche + "", "Graphics/Games/" + MODULE + "/" + CardChooser.getCardNum().match(/\d+/) + "_" + this.currentFiche + ".jpg");
            this.Loader.onLoadComplete.addOnce(this.setFiche, this);
            this.Loader.start();
        };
        Fiche.prototype.setFiche = function () {
            this.FicheImage.loadTexture(this.currentFiche, 0);
        };
        Fiche.prototype.loadGraphics = function () {
            this.game.load.image("bck", "Graphics/GUI/" + CardChooser.getModule() + "/" + "modul1.png");
            this.game.load.spritesheet("prevF", "Graphics/GUI/OS/prev1.png", 100, 100, 2);
            this.game.load.spritesheet("flip", "Graphics/GUI/OS/flipButton1.png", 115, 115, 2);
            this.game.load.spritesheet("fSpeaker", "Graphics/GUI/OS/speaker1.png", 115, 115, 2);
            this.game.load.image("firstImage", "Graphics/Games/" + MODULE + "/" + CardChooser.getCardNum().match(/\d+/) + "_1.jpg");
            this.game.load.spritesheet("nextF", "Graphics/GUI/OS/next1.png", 100, 100, 2);
            this.game.load.spritesheet("assistant", "Graphics/GUI/" + CardChooser.getModule() + "/Assistant.png", 480, 560, 1);
        };
        return Fiche;
    })(Base.BasicGroup);
    _Fiche.Fiche = Fiche;
})(Fiche || (Fiche = {}));
//# sourceMappingURL=Fiche.js.map