/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentMovingText = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.timerID = null;
};

componentMovingText.prototype = new __componentText;
componentMovingText.prototype.type = "componentMovingText";

componentMovingText.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
};

componentMovingText.prototype.onCreate = function(obj)
{
	if (page.state != psDesigning) {
		var speed	= parseInt(this.movingTime)*2;

		var time	= 40;
		var x		= this.x;
		var y		= this.y;
		var sW		= this.screenWidth();
		var sH		= this.screenHeight();
		var result  = true;

		switch(this.movingType) {
			case '0': // FROM LEFT
				{
					this.style.left = 0;
					this.x = 0;
				};
				break;
			case '1': // FROM RIGHT
				{
					if (sW) {
						this.style.left = (sW - this.w);
						this.x = (sW - this.w);
					} else result = false;
				};
				break;
			case '2': // TOP
				{
					this.style.top = 0;
					this.y = 0;
				};
				break;
			case '3': // BOTTOM
				{
					if (sH) {
						this.style.top = (sH-this.h );
						this.y = (sH-this.h );
					} else result = false;
				};
				break;
			case '4': // LEFT_TOP
				{
					this.style.left = 0;
					this.style.top = 0;
					this.x = 0;
					this.y = 0;
				};
				break;
			case '5': // LEFT_BOTTOM
				{
					if (sH) {
						this.style.left = 0;
						this.style.top = (sH-this.h);
						this.x = 0;
						this.y = (sH-this.h);
					} else result = false;
				};
				break;
			case '6': // RIGHT TOP
				{
					if (sW) {
						this.style.left = (sW-this.w);
						this.style.top = 0;
						this.x = (sW-this.w);
						this.y = 0;
					} else result = false;
				};
				break;
			case '7': // RIGHT BOTTOM
				{
					if (sW && sH) {
						this.style.left = (sW-this.w);
						this.style.top = (sH-this.h);
						this.x = (sW-this.w);
						this.y = (sH-this.h);
					} else result = false;
				};
				break;
		};
		if (result) {
			this.moveObjectToXY(this.movingType, this.id, speed, speed, x, y, this.w, this.h, sW, sH, time, this.movingLightly);
		} else {
			//pg2-todo - wysypuje sie za kazdym razem w kolejnosci 1, 5, 2 - przy pobieraniu szerokosci; znalezc inne rozwiazanie
			//showMessage("Your browser do not support screen size!");
		};
	};
};


componentMovingText.prototype.moveObjectToXY = function(type, id, prevSpeed, speed, x, y, width, height, sWidth, sHeight, time, lightly)
{
	var obj = page.all[id];
	speed = parseInt(speed);

	if (speed == 0) {
		obj.style.left = x;
		obj.style.top = y;
		return;
	};

	switch(type) {
		case '0': // FROM LEFT
			{
				var leftPx = obj.style.left;
				var leftValue = parseInt(leftPx.substr(0,leftPx.length-2));
				var newLeftValue = leftValue + speed;
				if (newLeftValue < x) {
					obj.moveTo(newLeftValue, y,true);

					if (lightly == 1)
						if (((x-newLeftValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '0', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time);
				} else
				if (newLeftValue >= x) {
					if (leftValue < x) { 
						obj.moveTo(x, y, true);
					};
				};
			};
			break;
		case '1': // FROM RIGHT
			{
				var rightPx = obj.style.left;
				var rightValue = parseInt(rightPx.substr(0,rightPx.length-2));
				var newRightValue = rightValue-speed;
				if (newRightValue > x) {
					obj.moveTo(newRightValue, y, true);

					if (lightly == 1)
						if (((newRightValue-x)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '1', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				} else
				if (newRightValue <= x) {
					if (rightValue > x) { 
						obj.moveTo(x, y, true);
					};
				};
			};
			break;
		case '2': // TOP
			{
				var topPx = obj.style.top;
				var topValue = parseInt(topPx.substr(0,topPx.length-2));
				var newTopValue = topValue+speed;
				if (newTopValue < y) {
					obj.moveTo(x, newTopValue, true);

					if (lightly == 1)
						if (((y-newTopValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '2', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				} else
				if (newTopValue >= y) {
					if (topValue < y) { 
						obj.moveTo(x, y, true);
					};
				};
			};
			break;
		case '3': // BOTTOM
			{
				var bottomPx = obj.style.top;
				var bottomValue = parseInt(bottomPx.substr(0,bottomPx.length-2));
				var newBottomValue = bottomValue-speed;
				if (newBottomValue > y) {
					obj.moveTo(x, newBottomValue, true);

					if (lightly == 1)
						if (((newBottomValue-y)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '3', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				} else
				if (newBottomValue <= y) {
					if (bottomValue > y) { 
						obj.moveTo(x, y, true);
					};
				};
			};
			break;
		case '4': // LEFT_TOP
			{
				var leftPx = obj.style.left;
				var leftValue = parseInt(leftPx.substr(0,leftPx.length-2));

				var topPx = obj.style.top;
				var topValue = parseInt(topPx.substr(0,topPx.length-2));

				if (x > y) {
					var newLeftValue = leftValue+speed;
					var igrek = (y/x) * newLeftValue;

					if (newLeftValue < x) {
						obj.moveTo(newLeftValue, Math.floor(igrek), true);

						if (lightly == 1)
							if (((x-newLeftValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newLeftValue >= x) {
						if (leftValue < x) { 
							obj.moveTo(x, y, true);
						};
					};
				} else {
					var newTopValue = igrek = topValue+speed;
					var iks = (newTopValue * (x/y));

					if (newTopValue < y) {
						obj.moveTo(Math.floor(iks), newTopValue, true);

						if (lightly == 1)
							if (((y-newTopValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newTopValue >= y) {
						if (topValue < y) { 
							obj.moveTo(x, y, true);
						};
					};
				};

				if (Math.floor(igrek) < y) {
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '4', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				};
			};
			break;
		case '5': // LEFT_BOTTOM
			{
				var leftPx = obj.style.left;
				var leftValue = parseInt(leftPx.substr(0,leftPx.length-2));

				var topPx = obj.style.top;
				var topValue = parseInt(topPx.substr(0,topPx.length-2));

				if (x > (sHeight-y) ) {
					var newLeftValue = leftValue+speed;
					var igrek = ((y-(sHeight-height)) / (x-0)) * ( newLeftValue-0) + (sHeight-height);

					if (newLeftValue < x) {
						obj.moveTo(newLeftValue, Math.floor(igrek), true);
						if (lightly == 1)
							if (((x-newLeftValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newLeftValue >= x) {
						if (leftValue < x) { 
							obj.moveTo(x, y, true);
						};
					};
				} else {
					var newTopValue = igrek = topValue-speed;
					var iks = ((newTopValue-(sHeight-height)) * (x/(y-(sHeight-height))));

					if (newTopValue > y) {
						obj.moveTo(Math.floor(iks), newTopValue, true);

						if (lightly == 1)
							if (((newTopValue-y)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newTopValue <= y) {
						if (topValue > y) { 
							obj.moveTo(x, y, true);
						};
					};
				};

				if (Math.floor(igrek) > y) {
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '5', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				};
			};
			break;
		case '6': // RIGHT TOP
			{
				var rightPx = obj.style.left;
				var rightValue = parseInt(rightPx.substr(0,rightPx.length-2));

				var topPx = obj.style.top;
				var topValue = parseInt(topPx.substr(0,topPx.length-2));

				if ((sWidth-x) > y) {
					var newRightValue = rightValue-speed;
					var igrek = (y / (x - (sWidth-width))) * (newRightValue - (sWidth-width));

					if (newRightValue > x) {
						obj.moveTo(newRightValue, Math.floor(igrek), true);

						if (lightly == 1)
							if (((newRightValue-x)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newRightValue <= x) {
						if (rightValue > x) { 
							obj.moveTo(x, y, true);
						};
					};
				} else {
					var newTopValue = igrek = topValue+speed;
					var iks = (newTopValue * ((x-(sWidth-width))/y)) + (sWidth-width);
					if (newTopValue < y) {
						obj.moveTo(Math.floor(iks), newTopValue, true);

						if (lightly == 1)
							if (((y-newTopValue)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newTopValue >= y) {
						if (topValue < x) { 
							obj.moveTo(x, y, true);
						};
					};
				};

				if (Math.floor(igrek) < y) {
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '6', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				};
			};
			break;
		case '7': // RIGHT BOTTOM
			{
				var rightPx = obj.style.left;
				var rightValue = parseInt(rightPx.substr(0,rightPx.length-2));

				var topPx = obj.style.top;
				var topValue = parseInt(topPx.substr(0,topPx.length-2));

				if ((sWidth-x) > (sHeight-y)) {
					var newRightValue = rightValue-speed;
					var igrek = ( ( y - (sHeight-height) ) / ( x - (sWidth-width) ) ) * ( newRightValue - (sWidth-width) ) + (sHeight-height);
					if (newRightValue > x) {
						obj.moveTo(newRightValue, Math.floor(igrek), true);

						if (lightly == 1)
							if (((rightValue-x)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newRightValue <= x) {
						if (rightValue > x) { 
							obj.moveTo(x, y, true);
						};
					};
				} else {
					var newTopValue = igrek = topValue-speed;
					var iks = ((newTopValue-(sHeight-height)) * (x-(sWidth-width)) / (y-(sHeight-height))) + (sWidth-width);

					if (newTopValue > y) {
						obj.moveTo(Math.floor(iks), newTopValue, true);

						if (lightly == 1)
							if (((newTopValue-y)/speed) <= (Math.log(prevSpeed)/Math.LN2)) speed = Math.ceil(speed / 2);
					} else
					if (newTopValue <= x) {
						if (topValue > x) { 
							obj.moveTo(x, y, true);
						};
					};
				};
				if (Math.floor(igrek) > y) {
					this.timerID = setTimeout( "page.all['" + this.id + "'].moveObjectToXY( '7', '"+id+"', "+prevSpeed+", "+speed+", "+x+", "+y+", "+width+", "+height+", "+sWidth+", "+sHeight+", "+time+", "+lightly+" )",time );
				};
			};
			break;
	};
};
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
componentMovingText.prototype.screenWidth = function()
{
	if (self.innerWidth) return self.innerWidth; else
	if (document.documentElement && document.documentElement.clientWidth) return document.documentElement.clientWidth; else
	if (document.body) return document.body.clientWidth; else return false;
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
componentMovingText.prototype.screenHeight = function()
{
	if (self.innerHeight) return self.innerHeight; else
	if (document.documentElement && document.documentElement.clientHeight) return document.documentElement.clientHeight; else
	if (document.body) return document.body.clientHeight; else return false;
};

componentMovingText.prototype.onFree = function() {
	if (this.timerID != null) window.clearTimeout(this.timerID);
};

componentMovingText.prototype.onStep = function()
{
	if (this.step == page.stepIndex) {
		var speed	= parseInt(this.movingTime)*2;

		var time	= 40;
		var x		= this.x;
		var y		= this.y;
		var sW		= this.screenWidth();
		var sH		= this.screenHeight();
		var result  = true;

		switch(this.movingType)
		{
			case '0': // FROM LEFT
				{
					this.style.left = 0;
					this.x			= 0;
				}
				break;
			case '1': // FROM RIGHT
				{
					if (sW) {
						this.style.left = (sW - this.w);
						this.x = (sW - this.w);
					} else result = false;
				};
				break;
			case '2': // TOP
				{
					this.style.top = 0;
					this.y = 0;
				};
				break;
			case '3': // BOTTOM
				{
					if (sH) {
						this.style.top = (sH - this.h);
						this.y = (sH - this.h);
					} else result = false;
				};
				break;
			case '4': // LEFT_TOP
				{
					this.style.left = 0;
					this.style.top	= 0;
					this.x = 0;
					this.y = 0;
				};
				break;
			case '5': // LEFT_BOTTOM
				{
					if (sH) {
						this.style.left = 0;
						this.style.top = (sH - this.h);
						this.x = 0;
						this.y = (sH - this.h);
					} else result = false;
				};
				break;
			case '6': // RIGHT TOP
				{
					if (sW) {
						this.style.left = (sW - this.w);
						this.style.top	= 0;
						this.x = (sW - this.w);
						this.y = 0;
					} else result = false;
				};
				break;
			case '7': // RIGHT BOTTOM
				{
					if (sW && sH) {
						this.style.left = (sW - this.w);
						this.style.top = (sH - this.h);
						this.x = (sW - this.w);
						this.y = (sH - this.h);
					} else result = false;
				};
				break;
		};
		if (result) {
			this.moveObjectToXY(this.movingType, this.id, speed, speed, x, y, this.w, this.h, sW, sH, time, this.movingLightly);
		} else showMessage("You browser do not support screen size!");
	};
};
