/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentVisualTimer = function(name)
{
	this.componentTimer = componentTimer;
	this.componentTimer(name);

	if (arguments[1]) {
	} else {
		this.topText = this.addChild(new componentText(null));
	};

	this.TimerID = null;
	this.time = 0;
	this.componentObj = null;
	this.imgs = null;
	this.graphImgs = null;
	this.timerSID = 0;
	this.offsetTime = 0;
	this.refresh = 0;
};

componentVisualTimer.prototype = new componentTimer;
componentVisualTimer.prototype.type = "componentVisualTimer";

componentVisualTimer.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
	this.graphImgs = this.timerGraphicImages.split("||");

	this.captureMouseEvents();
};

componentVisualTimer.prototype.overwriteKNFSettings = function() { //pg2-axa knf
	if (
			typeof(config.overwriteVisualTimerSettings) != 'undefined' && typeof(config.hideVisualTimerText) != 'undefined' &&
			typeof(config.offsetTimeHours) != 'undefined' && typeof(config.offsetTimeMinutes) != 'undefined' && typeof(config.offsetTimeSeconds) &&
			config.overwriteVisualTimerSettings
		)
	{
		this.offsetTimeHours = config.offsetTimeHours;
		this.offsetTimeMinutes = config.offsetTimeMinutes;
		this.offsetTimeSeconds = config.offsetTimeSeconds;
		if (this.offsetTimeHours == 0 && this.offsetTimeMinutes == 0 && this.offsetTimeSeconds == 0) this.offsetTimeSeconds = 1;
	};
	//...
};

componentVisualTimer.prototype.onCreate = function(obj)
{
	this.imgs = this.timerImages.split("||");

	var hours = this.startTimeHours;
	var minutes = this.startTimeMinutes;
	var seconds = this.startTimeSeconds;

	this.time = hours * 3600 + minutes * 60 + seconds;	

	if (!this.startEndTime)	{
		this.overwriteKNFSettings(); //pg2-axa knf
		var hours = this.offsetTimeHours;
		var minutes = this.offsetTimeMinutes;
		var seconds = this.offsetTimeSeconds;
	} else {
		var hours = this.endTimeHours;
		var minutes = this.endTimeMinutes;
		var seconds = this.endTimeSeconds;
	};

	this.offsetTime = ((hours * 3600 + minutes * 60 + seconds) == 0) ? 1 : (hours * 3600 + minutes * 60 + seconds);
};

componentVisualTimer.prototype.actionResetTimer = function()
{
	//this.time = 0; //pg2-do not reset until it's saved
	this.stop();
	lms.setCourseData(this.id, this.time);
	if (!this.globalTimer) this.time = 0; //pg2-if it ain't global timer, reset it
};

componentVisualTimer.prototype.onAfterLoad = function(obj)
{
	if (this.timerType == 1 || this.timerType == 2) {
		this.setBorder(this.timerFillColor, 1);
	};
};

componentVisualTimer.prototype.onPaint = function(obj)
{
	this.displayTime();
	if (this.timerType == 1 || this.timerType == 2) {
		this.setClip(this.w+2, this.h+2);
	};
};

componentVisualTimer.prototype.onLoad = function(obj)
{
	this.refresh = parseInt(this.refreshTime * 1000);
	if (this.timerType == 1 || this.timerType == 2) {
		this.setBorder(this.timerFillColor, 1);
	};

	if (!this.startEndTime) {
		this.overwriteKNFSettings(); //pg2-axa knf

		var hours = this.offsetTimeHours;
		var minutes = this.offsetTimeMinutes;
		var seconds = this.offsetTimeSeconds;
	} else {
		var hours = this.endTimeHours;
		var minutes = this.endTimeMinutes;
		var seconds = this.endTimeSeconds;
	};

	this.offsetTime = hours * 3600 + minutes * 60 + seconds;

	if (!this.startEndTime) {
		var lastTime = lms.getCourseData(this.id);
		
		if (this.globalTimer && lastTime){
			this.time = parseInt(lastTime);			
		};
	} else {
		var lastTime = lms.getCourseData(this.id);
		if (this.globalTimer && lastTime) {
			this.time = parseInt(lastTime)
		} else {
			var hours = this.startTimeHours;
			var minutes = this.startTimeMinutes;
			var seconds = this.startTimeSeconds;
			this.time = hours * 3600 + minutes * 60 + seconds;
		};
	};
	var lastTime = lms.getCourseData(this.id);

	if (this.globalTimer && this.timerResetOnExit && lms.getCourseData(this.id+'SID') != lms.getSID()) {
		lms.setCourseData(this.id+'SID', lms.getSID());
		this.timerSID = lms.getSID();
		this.actionResetTimer();

		if (this.startEndTime) {
			var hours = this.startTimeHours;
			var minutes = this.startTimeMinutes;
			var seconds = this.startTimeSeconds;
			this.time = hours * 3600 + minutes * 60 + seconds;
		};
	};	

	this.displayTime();
	this.run();
};

componentVisualTimer.prototype.displayTime = function(obj)
{	
	var timeStart = this.time;
	var timeEnd = this.offsetTime - this.time;

	var divStyle = "";
	var timerText = "";

	divStyle += "border: "+this.timerBorderWidth+"px "+this.timerBorderColor+" solid; ";
	divStyle += "width: "+this.w+"; ";
	divStyle += "height: "+this.h+"; ";
	divStyle += "overflow: hidden; ";
	divStyle += "position: absolute; ";
	divStyle += "background-color: "+this.timerBgColor+";";

	switch (this.timerType) {
		case 0:
			if (this.timeLeft) {
				var t = Math.floor(timeEnd / 3600);
				if (t < 10) t = "0"+t;
				timerText = this.text.replace(/\[hh\]/,t);

				var t = Math.floor(timeEnd / 60) % 60;
				if (t < 10) t = "0"+t;
				timerText = timerText.replace(/\[mm\]/,t);

				var t = timeEnd % 60;
				if (t < 10) t = "0"+t;
				timerText = timerText.replace(/\[ss\]/,t);

				var t = Math.floor(timeEnd / 3600);
				timerText = timerText.replace(/\[timeh\]/,t);

				var t = Math.floor(timeEnd / 60);
				timerText = timerText.replace(/\[timem\]/,t);

				var t = timeEnd;
				timerText = timerText.replace(/\[times\]/,t);
			} else {
				var t = Math.floor(timeStart / 3600);
				if (t < 10) t = "0"+t;
				timerText = this.text.replace(/\[hh\]/,t);

				var t = Math.floor(timeStart / 60) % 60;
				if (t < 10) t = "0"+t;
				timerText = timerText.replace(/\[mm\]/,t);

				var t = timeStart % 60;
				if (t < 10) t = "0"+t;
				timerText = timerText.replace(/\[ss\]/,t);

				var t = Math.floor(timeStart / 3600);
				timerText = timerText.replace(/\[timeh\]/,t);

				var t = Math.floor(timeStart / 60);
				timerText = timerText.replace(/\[timem\]/,t);

				var t = timeStart;
				timerText = timerText.replace(/\[times\]/,t);
			};
			if (this.execution) {
				if (typeof(config.hideVisualTimerText) != 'undefined' && typeof(config.overwriteVisualTimerSettings) != 'undefined' &&
					config.overwriteVisualTimerSettings && config.hideVisualTimerText)
				{ //pg2-axa knf
					document.getElementById(this.id + "_contentObj").style.color = 'transparent';
				};
				document.getElementById(this.id + "_contentObj").innerHTML = timerText;
			} else this.topText.text = timerText;

			break;
		case 1:
			var percent = this.time / this.offsetTime;
			var widthLeft = this.w - Math.ceil(this.w * percent);
			var widthRight = Math.ceil(this.w * percent);

			if (this.timeLeft) {
				this.setHTML("<div style=\"background: "+this.timerFillColor+"; width:"+widthLeft+"px;height:"+this.h+"px; position: absolute; clip:rect(0px "+widthLeft+"px "+this.h+"px 0px);\"></div>");
			} else {
				this.setHTML("<div style=\"background: "+this.timerFillColor+"; width:"+widthRight+"px;height:"+this.h+"px; position: absolute; clip:rect(0px "+widthRight+"px "+this.h+"px 0px);\"></div>");
			};

			break;
		case 2:
			var percent = this.time / this.offsetTime;
			var sizeTop = this.h - Math.ceil(this.h * percent);
			var sizeBottom = Math.ceil(this.h * percent);
			if (this.timeLeft) {
				this.setHTML("<div style=\"background: "+this.timerFillColor+"; width:"+this.w+"px;height:"+this.h+"px; position: absolute; clip:rect("+sizeBottom+"px "+this.w+"px "+this.h+"px 0px);\"></div>");
			} else {
				this.setHTML("<div style=\"background: "+this.timerFillColor+"; width:"+this.w+"px;height:"+this.h+"px; position: absolute; clip:rect("+sizeTop+"px "+this.w+"px "+this.h+"px 0px);\"></div>");
			};

			break;
		case 3:
			if (this.timeLeft) {
				var idx = ((this.offsetTime - this.time) / this.refreshTime) % this.graphImgs.length;
				this.setHTML("<img src='"+this.resourcesURL+this.graphImgs[idx]+"'>");
			} else {
				var idx = (this.time / this.refreshTime) % this.graphImgs.length;
				this.setHTML("<img src='"+this.resourcesURL+this.graphImgs[idx]+"'>");
			};

			break;
		case 4:
			var content = "";
			var timerText = "";

			if (this.timeLeft) {
				var tReplace = "";
				var t = (Math.floor(timeEnd / 3600)).toString();
				if (t < 10) t = "0"+t;

				for (var i = 0; i < 2; i++)	tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				timerText = this.text.replace(/\[hh\]/,tReplace);

				tReplace = "";
				var t = (Math.floor(timeEnd / 60) % 60).toString();
				if (t < 10) t = "0"+t;
				for (var i = 0; i < 2; i++)	tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				timerText = timerText.replace(/\[mm\]/,tReplace);

				tReplace = "";
				var t = (timeEnd % 60).toString();
				if (t < 10) t = "0"+t;
				for (var i = 0; i < 2; i++)	tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				timerText = timerText.replace(/\[ss\]/,tReplace);

				tReplace = "";
				var t = (Math.floor(timeEnd / 3600)).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 3600000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[timeh\]/,tReplace);

				tReplace = "";
				var t = (Math.floor(timeEnd / 60)).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 60000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[timem\]/,tReplace);

				tReplace = "";
				var t = (timeEnd).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 1000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[times\]/,tReplace);
			} else {			
				var tReplace = "";
				var t = (Math.floor(timeStart / 3600)).toString();
				if (t < 10) t = "0"+t;
				for (var i = 0; i < 2; i++) {
					tReplace += "<img src='" + this.resourcesURL + this.imgs[t.charAt(i)] + "'>";
				};
				timerText = this.text.replace(/\[hh\]/,tReplace);

				var tReplace = "";
				var t = (Math.floor(timeStart / 60) % 60).toString();
				if (t < 10) t = "0"+t;
				for (var i = 0; i < 2; i++) {
					tReplace += "<img src='" + this.resourcesURL + this.imgs[t.charAt(i)] + "'>";
				};
				timerText = timerText.replace(/\[mm\]/,tReplace);

				var tReplace = "";
				var t = (timeStart % 60).toString();
				if (t < 10) t = "0"+t;
				for (var i = 0; i < 2; i++) {
					tReplace += "<img src='" + this.resourcesURL + this.imgs[t.charAt(i)] + "'>";
				};
				timerText = timerText.replace(/\[ss\]/,tReplace);

				tReplace = "";
				var t = (Math.floor(timeStart / 3600)).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 3600000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[timeh\]/,tReplace);

				tReplace = "";
				var t = (Math.floor(timeStart / 60)).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+this.resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 60000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[timem\]/,tReplace);

				tReplace = "";
				var t = (timeStart).toString();
				for (var i = 0; i < t.length; i++) tReplace += "<img src='"+resourcesURL+this.imgs[t.charAt(i)]+"'>";
				for (var i = t.length; i < Math.floor(this.offsetTime / 1000).toString().length; i++) {
					tReplace += "<img src='"+this.resourcesURL+this.imgs[0]+"'>";
				};
				timerText = timerText.replace(/\[times\]/,tReplace);
			};
			this.setHTML(timerText);

			break;
	};
};

componentVisualTimer.prototype.componentVisualTimerBaseResetElement = componentVisualTimer.prototype.resetElement;
componentVisualTimer.prototype.resetElement = function()
{
	this.componentVisualTimerBaseResetElement();
	this.time = 0;
};

componentVisualTimer.prototype.showTimeLeft = function()
{
	this.time += this.refreshTime;
	this.displayTime();
	this.stop();
	
	if (parseInt(this.time + this.refreshTime) <= parseInt(this.offsetTime)) {
		this.TimerID = window.setTimeout('pc.'+this.id+'.showTimeLeft();', this.refresh);
	} else {
		this.invokeEvent("Timer");
	};
};

componentVisualTimer.prototype.hide = function()
{
	this.setVisible(this.isVisible(false));
	this.paint();
};

componentVisualTimer.prototype.show = function()
{
	this.setVisible(this.isVisible(true));
	this.paint();
	this.actionResetTimer(); //pg2-start after refresh
	this.run();
};

componentVisualTimer.prototype.stop = function()
{
	if (page.state != psDesigning) {
		if (this.TimerID != null) {
			window.clearTimeout(this.TimerID);
			this.TimerID = null;
		};
		this.paint();
	};
};

componentVisualTimer.prototype.run = function()
{
	if (PageInterface.GetValue("state") != psDesigning) {
		if (this.TimerID == null && this.time + this.refreshTime <= this.offsetTime) {
			this.TimerID = window.setTimeout('pc.'+this.id+'.showTimeLeft();', this.refresh);
		};
	};
};

componentVisualTimer.prototype.onUnLoad = function()
{
	if (page.state != psDesigning) {
		if (this.globalTimer) {
			lms.setCourseData(this.id, this.time);
		};
		this.stop();
		this.time = 0;
	};
};

componentVisualTimer.prototype.onRepaint = function()
{
	if (PageInterface.GetValue("allowCAI") && this.stopTimeAfterCheck) {
		this.stop();
	};
};
