/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentYellowCardReport = function(name)
{
	this.componentTextWithScroll = componentTextWithScroll;
	this.componentTextWithScroll(name);

	this.checksArr = new Array();
	this.mailReportText = '';
	this.commentsTableDIV = '';
	this.imagesCompleteInfo = new Array();
	this.filtrNamesArr = new Array();
};

componentYellowCardReport.prototype = new componentTextWithScroll();
componentYellowCardReport.prototype.type = "componentYellowCardReport";

componentYellowCardReport.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.checksArr['Private'] = 0; 
	this.checksArr['Author'] = 0; 
	this.checksArr['Public'] = 0;
	this.checksArr['Tutor'] = 0;

	this.imagesNameArr = [ this.buttonCloseOver, this.buttonCloseOut, this.buttonPrintOut, this.buttonPrintOver, this.buttonMailOut, this.buttonMailOver, this.sepHorizontal, this.checkboxIn, this.checkboxOut, this.myDot, this.authorDot, this.publicDot, this.tutorDot, this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();
	this.setCompleteArrayInfo(this.completeInfoStyleImages, this.completeInfoButtonsImages);
};

componentYellowCardReport.prototype.setCompleteArrayInfo = function(style, buttons)
{
	var imagesStr = style + buttons;
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++) {
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]) {
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentYellowCardReport.prototype.componentYellowCardReportBaseShow = componentYellowCardReport.prototype.show;
componentYellowCardReport.prototype.show = function()
{
	if (PageInterface.GetValue("state") != psDesigning) PageInterface.Execute("setOnTop", this);

	this.componentYellowCardReportBaseShow();
	this.showFiltredComments();
	this.setFiltersOn();
};

componentYellowCardReport.prototype.setFiltersOn = function(obj)
{
	var name = '';
	for (var k in this.checksArr) {
		name = k;
		if (k == 'Private') name = 'My';
		var checkObj = document.getElementById(this.id + "_check" + name + "Image");
		if (checkObj) {
			if (this.checksArr[k] == 1) {
				checkObj.src = this.resourcesURL + this.checkboxIn
			} else {
				checkObj.src = this.resourcesURL + this.checkboxOut;
			};
		};
	};
};

componentYellowCardReport.prototype.setHTMLObiects = function(obj)
{
	var imgBckg = document.getElementById(this.id + "_imgBckg");
	var trackBckgImg = document.getElementById(this.id + "_trackBckgImg");
	var arrowTopImg = document.getElementById(this.id + "_arrowTopImg");
	var arrowBottomImg = document.getElementById(this.id + "_arrowBottomImg");
	var trackImg = document.getElementById(this.id + "_trackImg");

	var backgroundChooseImage = document.getElementById(this.id + "_backgroundChooseImage");
	var closeButtonImage = document.getElementById(this.id + "_closeButtonImage");

	var showCommentsFont = document.getElementById(this.id + "_showCommentsFont");
	var mailButtonImage = document.getElementById(this.id + "_mailButtonImage");
	var printButtonImage = document.getElementById(this.id + "_printButtonImage");

	var checkMyImage = document.getElementById(this.id + "_checkMyImage");
	var checkAuthorImage = document.getElementById(this.id + "_checkAuthorImage");
	var checkPublicImage = document.getElementById(this.id + "_checkPublicImage");
	var checkTutorImage = document.getElementById(this.id + "_checkTutorImage");

	var checkMyDotImage = document.getElementById(this.id + "_checkMyDotImage");
	var checkAuthorDotImage = document.getElementById(this.id + "_checkAuthorDotImage");
	var checkPublicDotImage = document.getElementById(this.id + "_checkPublicDotImage");
	var checkTutorDotImage = document.getElementById(this.id + "_checkTutorDotImage");

	var checkSepImg1 = document.getElementById(this.id + "_checkSepImg1");
	var checkSepImg2 = document.getElementById(this.id + "_checkSepImg2");
	var checkSepImg3 = document.getElementById(this.id + "_checkSepImg3");

	var titleDotImage = document.getElementById(this.id + "_titleDotImage");
	var headerTextFont = document.getElementById(this.id + "_headerTextFont");
	var showCommentsFont = document.getElementById(this.id + "_showCommentsFont");
	var myCommentsFont = document.getElementById(this.id + "_myCommentsFont");
	var authorCommentsFont = document.getElementById(this.id + "_authorCommentsFont");
	var publicCommentsFont = document.getElementById(this.id + "_publicCommentsFont");
	var tutorCommentsFont = document.getElementById(this.id + "_tutorCommentsFont");

	var font = this.getProjectFont(this.allowGF == 1, this.fontFamily, this.fontSize, this.fontColor );

	headerTextFont.style.fontFamily = font.family;
	headerTextFont.style.fontSize = getFontSize(font.size, 'px');
	headerTextFont.style.color = font.color;

	if (showCommentsFont) {
		var font = this.getProjectFont(this.filtersGlobalFormating == 1, this.filtersFontFamily, this.filtersFontSize, this.filtersFontColor );
		showCommentsFont.style.fontFamily = font.family;
		showCommentsFont.style.fontSize = getFontSize(font.size, 'px');
		showCommentsFont.style.color = font.color;
	};
	if (myCommentsFont) {
		myCommentsFont.style.fontFamily = font.family;
		myCommentsFont.style.fontSize = getFontSize(font.size, 'px');
		myCommentsFont.style.color = font.color;
		myCommentsFont.style.whiteSpace = 'nowrap';
	};
	if (authorCommentsFont) {
		authorCommentsFont.style.fontFamily = font.family;
		authorCommentsFont.style.fontSize = getFontSize(font.size, 'px');
		authorCommentsFont.style.color = font.color;
		authorCommentsFont.style.whiteSpace = 'nowrap';
	};
	if (publicCommentsFont) {
		publicCommentsFont.style.fontFamily = font.family;
		publicCommentsFont.style.fontSize = getFontSize(font.size, 'px');
		publicCommentsFont.style.color = font.color;
		publicCommentsFont.style.whiteSpace = 'nowrap';
	};
	if (tutorCommentsFont) {
		tutorCommentsFont.style.fontFamily = font.family;
		tutorCommentsFont.style.fontSize = getFontSize(font.size, 'px');
		tutorCommentsFont.style.color = font.color;
		tutorCommentsFont.style.whiteSpace = 'nowrap';
	};

	imgBckg.src = this.resourcesURL + this.imgBckg;

	trackBckgImg.src = this.resourcesURL + this.sliderBckg;
	arrowTopImg.src = this.resourcesURL + this.arrowTopOut;
	arrowBottomImg.src = this.resourcesURL + this.arrowBottomOut;
	trackImg.src = this.resourcesURL + this.sliderOut;

	closeButtonImage.src = this.resourcesURL + this.buttonCloseOut;

	mailButtonImage.src = this.resourcesURL + this.buttonMailOut;
	printButtonImage.src = this.resourcesURL + this.buttonPrintOut;

	if (checkMyImage) checkMyImage.src = this.resourcesURL + this.checkboxOut;
	if (checkMyImage) checkAuthorImage.src = this.resourcesURL + this.checkboxOut;
	if (checkMyImage) checkPublicImage.src = this.resourcesURL + this.checkboxOut;
	if (checkMyImage) checkTutorImage.src = this.resourcesURL + this.checkboxOut;
	if (checkMyImage) checkMyDotImage.src = this.resourcesURL + this.myDot;
	if (checkMyImage) checkAuthorDotImage.src = this.resourcesURL + this.authorDot;
	if (checkMyImage) checkPublicDotImage.src = this.resourcesURL + this.publicDot;
	if (checkMyImage) checkTutorDotImage.src = this.resourcesURL + this.tutorDot;
	if (checkMyImage) checkSepImg1.src = this.resourcesURL + this.sepVertical;
	if (checkMyImage) checkSepImg2.src = this.resourcesURL + this.sepVertical;
	if (checkMyImage) checkSepImg3.src = this.resourcesURL + this.sepVertical;
};

componentYellowCardReport.prototype.placeHTMLObiects = function(obj)
{
	var trackBckgDiv = document.getElementById(this.id + "_trackBckgDiv");
	var arrowTopDiv = document.getElementById(this.id + "_arrowTopDiv");
	var arrowBottomDiv = document.getElementById(this.id + "_arrowBottomDiv");
	var trackDiv = document.getElementById(this.id + "_trackDiv");

	var arrowH = this.getImageHeight('arrowTopOut');
	var arrowW = this.getImageWidth('arrowTopOut');
	arrowTopDiv.style.width = arrowW;
	arrowTopDiv.style.height = arrowH;
	arrowTopDiv.style.top = this.headerHeight + this.contentPadding;
	arrowTopDiv.style.left = this.w - arrowW - this.contentPadding;
	arrowTopDiv.style.clip = 'rect(0px ' + arrowW + 'px ' + arrowH + 'px 0px)';

	var arrowH = this.getImageHeight('arrowBottomOut');
	var arrowW = this.getImageWidth('arrowBottomOut');
	arrowBottomDiv.style.width = arrowW;
	arrowBottomDiv.style.height = arrowH;
	arrowBottomDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH - arrowH;
	arrowBottomDiv.style.left = this.w - arrowW - this.contentPadding;
	arrowBottomDiv.style.clip = 'rect(0px ' + arrowW + 'px ' + arrowH + 'px 0px)';

	var arrowH = this.getImageHeight('arrowBottomOut');
	var arrowW = this.getImageWidth('arrowBottomOut');
	arrowBottomDiv.style.width = arrowW;
	arrowBottomDiv.style.height = arrowH;
	arrowBottomDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH - arrowH;
	arrowBottomDiv.style.left = this.w - arrowW - this.contentPadding;
	arrowBottomDiv.style.clip = 'rect(0px ' + arrowW + 'px ' + arrowH + 'px 0px)';

	var trackBckgH = this.getImageHeight('sliderBckg');
	var trackBckgW = this.getImageWidth('sliderBckg');
	trackBckgDiv.style.width = arrowW;
	trackBckgDiv.style.height = this.h - this.headerHeight - this.footerHeight - this.checkboxesFieldH - this.contentPadding;
	trackBckgDiv.style.top = this.headerHeight + this.contentPadding;
	trackBckgDiv.style.left = this.w - trackBckgW - this.contentPadding;
	trackBckgDiv.style.clip = 'rect(0px ' + trackBckgDiv.style.width + ' ' + trackBckgDiv.style.height + ' 0px)';

	var sliderH = this.getImageHeight('sliderOut');
	var sliderW = this.getImageWidth('sliderOut');
	trackDiv.style.width = sliderW;
	trackDiv.style.height = sliderH;
	trackDiv.style.top = this.headerHeight + arrowH + this.contentPadding;
	trackDiv.style.left = this.w - trackBckgW - this.contentPadding;
	trackDiv.style.clip = 'rect(0px ' + trackDiv.style.width + ' ' + trackDiv.style.height + ' 0px)';

	this.sliderLowOffset = this.getImageHeight('arrowTopOut') + this.contentPadding + this.headerHeight;
	this.trackHeight = this.h - 2*this.borderWidth - this.contentPadding - this.headerHeight - this.footerHeight - this.checkboxesFieldH - this.getImageHeight('arrowTopOut') - this.getImageHeight('arrowBottomOut');
	this.sliderHighOffset = this.trackHeight - this.getImageHeight('sliderOut');

	var backgroundChooseDiv = document.getElementById(this.id + "_backgroundChooseDiv");

	var middleTop = document.getElementById(this.id + "_middleTop");
	var middleBottom = document.getElementById(this.id + "_middleBottom");

	var closeButtonDiv = document.getElementById(this.id + "_closeButtonDiv");
	var headerTextDiv = document.getElementById(this.id + "_headerTextDiv");

	var showCommentsDiv = document.getElementById(this.id + "_showCommentsDiv");
	var mailButtonDiv = document.getElementById(this.id + "_mailButtonDiv");
	var printButtonDiv = document.getElementById(this.id + "_printButtonDiv");

	var checkMyDiv = document.getElementById(this.id + "_checkMyDiv");
	var checkAuthorDiv = document.getElementById(this.id + "_checkAuthorDiv");
	var checkPublicDiv = document.getElementById(this.id + "_checkPublicDiv");
	var checkTutorDiv = document.getElementById(this.id + "_checkTutorDiv");

	var checkMyDotDiv = document.getElementById(this.id + "_checkMyDotDiv");
	var checkAuthorDotDiv = document.getElementById(this.id + "_checkAuthorDotDiv");
	var checkPublicDotDiv = document.getElementById(this.id + "_checkPublicDotDiv");
	var checkTutorDotDiv = document.getElementById(this.id + "_checkTutorDotDiv");

	var myCommentsDiv = document.getElementById(this.id + "_myCommentsDiv");
	var authorCommentsDiv = document.getElementById(this.id + "_authorCommentsDiv");
	var publicCommentsDiv = document.getElementById(this.id + "_publicCommentsDiv");
	var tutorCommentsDiv = document.getElementById(this.id + "_tutorCommentsDiv");
	var commentsDiv = document.getElementById(this.id + "_tableDiv");

	var checkSep1 = document.getElementById(this.id + "_checkSep1");
	var checkSep2 = document.getElementById(this.id + "_checkSep2");
	var checkSep3 = document.getElementById(this.id + "_checkSep3");

	var buttonH = this.getImageHeight('buttonCloseOut');
	var buttonW = this.getImageWidth('buttonCloseOut');
	closeButtonDiv.style.width = buttonW;
	closeButtonDiv.style.height = buttonH;
	closeButtonDiv.style.top = this.contentPadding;
	closeButtonDiv.style.left = this.w - buttonW - this.contentPadding;
	closeButtonDiv.style.clip = 'rect(0px ' + buttonW + 'px ' + buttonH + 'px 0px)';

	var imageW = this.headerHeight;
	headerTextDiv.style.left = 30;
	headerTextDiv.style.width = this.w - 5 - parseInt(closeButtonDiv.style.width);
	headerTextDiv.style.height = imageW;
	headerTextDiv.style.top = 0;
	headerTextDiv.style.clip = 'rect(0px ' + eval(parseInt(headerTextDiv.style.width)) + 'px ' + imageW + 'px 0px)';

	if (showCommentsDiv) {
		showCommentsDiv.style.width = this.w - 40;
		showCommentsDiv.style.height = this.checkboxesFieldH;
		showCommentsDiv.style.top = this.h - this.checkboxesFieldH - this.footerHeight;
		showCommentsDiv.style.left = this.contentPadding + 10;
		showCommentsDiv.style.clip = 'rect(0px ' + eval(this.w - 40) + 'px ' + this.w + 'px 0px)';
	};

	var buttonPrintH = this.getImageHeight('buttonPrintOut');
	var buttonPrintW = this.getImageWidth('buttonPrintOut');
	printButtonDiv.style.width = buttonPrintW;
	printButtonDiv.style.height = buttonPrintH;
	printButtonDiv.style.top = this.h - buttonPrintH - this.contentPadding;
	printButtonDiv.style.left = this.w - buttonPrintW - this.contentPadding;
	printButtonDiv.style.clip = 'rect(0px ' + buttonPrintW + 'px ' + buttonPrintH + 'px 0px)';

	var buttonMailH = this.getImageHeight('buttonMailOut');
	var buttonMailW = this.getImageWidth('buttonMailOut');
	mailButtonDiv.style.width = buttonMailW;
	mailButtonDiv.style.height = buttonMailH;
	mailButtonDiv.style.top = this.h - buttonMailH - this.contentPadding;
	mailButtonDiv.style.left = this.w-buttonMailW-buttonPrintW-this.contentPadding;
	mailButtonDiv.style.clip = 'rect(0px ' + buttonMailW + 'px ' + buttonMailH + 'px 0px)';

	var checkH = this.getImageHeight('checkboxOut');
	var checkW = this.getImageWidth('checkboxOut');
	if (checkMyDiv) {
		checkMyDiv.style.width = checkW;
		checkMyDiv.style.height = checkH;
		checkMyDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - checkH/2;
		checkMyDiv.style.left = parseInt(this.w/5)+10;
		checkMyDiv.style.clip = 'rect(0px ' + buttonW + 'px ' + buttonH + 'px 0px)';
	};
	if (checkAuthorDiv) {
		checkAuthorDiv.style.width = checkW;
		checkAuthorDiv.style.height = checkH;
		checkAuthorDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - checkH/2;
		checkAuthorDiv.style.left = parseInt(this.w/5*2)+10;
		checkAuthorDiv.style.clip = 'rect(0px ' + buttonW + 'px ' + buttonH + 'px 0px)';
	};
	if (checkPublicDiv) {
		checkPublicDiv.style.width = checkW;
		checkPublicDiv.style.height = checkH;
		checkPublicDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - checkH/2;
		checkPublicDiv.style.left = parseInt(this.w/5*3)+10;
		checkPublicDiv.style.clip = 'rect(0px ' + buttonW + 'px ' + buttonH + 'px 0px)';
	};
	if (checkTutorDiv) {
		checkTutorDiv.style.width = checkW;
		checkTutorDiv.style.height = checkH;
		checkTutorDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - checkH/2;
		checkTutorDiv.style.left = parseInt(this.w/5*4)+10;
		checkTutorDiv.style.clip = 'rect(0px ' + buttonW + 'px ' + buttonH + 'px 0px)';
	};

	if (checkMyDotDiv) {
		var pointH = this.getImageHeight('myDot');
		var pointW = this.getImageWidth('myDot');
		checkMyDotDiv.style.width = pointW;
		checkMyDotDiv.style.height = pointH;
		checkMyDotDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - pointH/2;
		checkMyDotDiv.style.left = parseInt(this.w/5)+15+checkW;
		checkMyDotDiv.style.clip = 'rect(0px ' + pointW + 'px ' + pointH + 'px 0px)';
	};
	if (checkMyDotDiv) {
		var pointH = this.getImageHeight('authorDot');
		var pointW = this.getImageWidth('authorDot');
		checkAuthorDotDiv.style.width = pointW;
		checkAuthorDotDiv.style.height = pointH;
		checkAuthorDotDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - pointH/2;
		checkAuthorDotDiv.style.left = parseInt(this.w/5*2)+15+checkW;
		checkAuthorDotDiv.style.clip = 'rect(0px ' + pointW + 'px ' + pointH + 'px 0px)';
	};
	if (checkMyDotDiv) {
		var pointH = this.getImageHeight('publicDot');
		var pointW = this.getImageWidth('publicDot');
		checkPublicDotDiv.style.width = pointW;
		checkPublicDotDiv.style.height = pointH;
		checkPublicDotDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - pointH/2;
		checkPublicDotDiv.style.left = parseInt(this.w/5*3)+15+checkW;
		checkPublicDotDiv.style.clip = 'rect(0px ' + pointW + 'px ' + pointH + 'px 0px)';
	};
	if (checkMyDotDiv) {
		var pointH = this.getImageHeight('tutorDot');
		var pointW = this.getImageWidth('tutorDot');
		checkTutorDotDiv.style.width = pointW;
		checkTutorDotDiv.style.height = pointH;
		checkTutorDotDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH/2 - pointH/2;
		checkTutorDotDiv.style.left = parseInt(this.w/5*4)+15+checkW;
		checkTutorDotDiv.style.clip = 'rect(0px ' + pointW + 'px ' + pointH + 'px 0px)';
	};
	this.showFilters();

	if (this.dir == "rtl") {
		this.RTLElement(closeButtonDiv);
		this.RTLElement(headerTextDiv);
		this.RTLElement(printButtonDiv);
		this.RTLElement(mailButtonDiv);
		this.RTLElement(showCommentsDiv);
		this.RTLElement(trackBckgDiv);
		this.RTLElement(arrowTopDiv);
		this.RTLElement(arrowBottomDiv);
		this.RTLElement(trackDiv);
	};
};

componentYellowCardReport.prototype.changeImage = function(obj, imageName)
{
	obj.src = this.resourcesURL + imageName;
};

componentYellowCardReport.prototype.changeCheckImage = function(obj, checkName)
{
	if (this.checksArr[checkName] == 1) {
		obj.src = this.resourcesURL + this.checkboxOut;
		this.checksArr[checkName] = 0;
	} else {
		obj.src = this.resourcesURL + this.checkboxIn
		this.checksArr[checkName] = 1;
	};
	this.showFiltredComments();
};

componentYellowCardReport.prototype.getMaxFilterCaptWidth = function()
{
	var sizeDiv = document.getElementById(this.id + "sizeDiv");
	var myCommentsFont = document.getElementById(this.id + "_myCommentsFont");
	var authorCommentsFont = document.getElementById(this.id + "_authorCommentsFont");
	var publicCommentsFont = document.getElementById(this.id + "_publicCommentsFont");
	var tutorCommentsFont = document.getElementById(this.id + "_tutorCommentsFont");
	this.filtrNamesArr.push(myCommentsFont);
	this.filtrNamesArr.push(authorCommentsFont);
	this.filtrNamesArr.push(publicCommentsFont);
	this.filtrNamesArr.push(tutorCommentsFont);
	var max = 0;

	for (var i=0; i < this.filtrNamesArr.length; i++) {
		sizeDiv.innerHTML = this.filtrNamesArr[i].innerHTML;
		if (sizeDiv.offsetWidth) max = sizeDiv.offsetWidth;
	};
	return max;
};

componentYellowCardReport.prototype.showFilters = function()
{
	var number = 0;
	var index = 1;
	var sepNo = 1;

	var checkW = this.getImageWidth('checkboxOut');
	var pointW = this.getImageWidth('tutorDot');

	try {
		if (eval(this.checkMy)) number++;
		if (eval(this.checkAuthor)) number++;
		if (eval(this.checkPublic)) number++;
		if (eval(this.checkTutor)) number++;
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.showFilters() eval checkMy/checkAuthor/checkPublic/checkTutor execution error\nMessage:\n' + e.message); //pg2
	};

	var checkMyDiv = document.getElementById(this.id + "_checkMyDiv");
	var checkAuthorDiv = document.getElementById(this.id + "_checkAuthorDiv");
	var checkPublicDiv = document.getElementById(this.id + "_checkPublicDiv");
	var checkTutorDiv = document.getElementById(this.id + "_checkTutorDiv");

	var checkMyDotDiv = document.getElementById(this.id + "_checkMyDotDiv");
	var checkAuthorDotDiv = document.getElementById(this.id + "_checkAuthorDotDiv");
	var checkPublicDotDiv = document.getElementById(this.id + "_checkPublicDotDiv");
	var checkTutorDotDiv = document.getElementById(this.id + "_checkTutorDotDiv");

	var myCommentsDiv = document.getElementById(this.id + "_myCommentsDiv");
	var authorCommentsDiv = document.getElementById(this.id + "_authorCommentsDiv");
	var publicCommentsDiv = document.getElementById(this.id + "_publicCommentsDiv");
	var tutorCommentsDiv = document.getElementById(this.id + "_tutorCommentsDiv");

	var sizeDiv = document.getElementById(this.id + "sizeDiv");

	var leftShift = parseInt(this.w/4);
	var spaceLeft = this.w - leftShift;

	var maxFiltrCaptionWidth = this.getMaxFilterCaptWidth();
	var filtrWidth = maxFiltrCaptionWidth+checkW+pointW+20;
	if (filtrWidth > this.w/5) {
		var useRealWidth = true;
	} else {
		var useRealWidth = false;
	};

	var lastFilterLeft = 0;

	try {
		if (eval(this.checkMy)) {
			myCommentsDiv.style.height = this.checkboxesFieldH;
			myCommentsDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH;

			if (!useRealWidth) {
				checkMyDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+10;
				checkMyDotDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+15+checkW;
				myCommentsDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+checkW+pointW+20;
				myCommentsDiv.style.width = parseInt(this.w/5);
				myCommentsDiv.style.clip = 'rect(0px ' + parseInt(this.w/5) + 'px ' + this.checkboxesFieldH + 'px 0px)';
			} else {
				sizeDiv.innerHTML = this.filtrNamesArr[0].innerHTML;
				checkMyDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+10;
				checkMyDotDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+15+checkW;
				myCommentsDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+checkW+pointW+20;
				myCommentsDiv.style.width = sizeDiv.offsetWidth;
				myCommentsDiv.style.clip = 'rect(0px ' + sizeDiv.offsetWidth + 'px ' + this.checkboxesFieldH + 'px 0px)';
				lastFilterLeft += parseInt(myCommentsDiv.style.left.replace('px', '')) + sizeDiv.offsetWidth;
			};
			//myCommentsDiv.style.clip = 'rect(0px '+eval(parseInt(this.w/5))+'px '+this.checkboxesFieldH+'px 0px)';

			index++;
		} else {
			checkMyDiv.style.visibility = 'hidden';
			checkMyDotDiv.style.visibility = 'hidden';
			myCommentsDiv.style.visibility = 'hidden';
		};
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.executeScript() eval checkMy execution error\nMessage:\n' + e.message); //pg2
	};

	try {
		if (eval(this.checkAuthor))	{
			authorCommentsDiv.style.height = this.checkboxesFieldH;
			authorCommentsDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH;

			if (!useRealWidth) {
				authorCommentsDiv.style.width = parseInt(this.w/5);
				checkAuthorDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+10;
				checkAuthorDotDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+15+checkW;
				authorCommentsDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+checkW+pointW+20;
				authorCommentsDiv.style.clip = 'rect(0px ' + parseInt(this.w/5) + 'px ' + this.checkboxesFieldH + 'px 0px)';
			} else {
				sizeDiv.innerHTML = this.filtrNamesArr[1].innerHTML;
				checkAuthorDiv.style.left = lastFilterLeft + 10
				checkAuthorDotDiv.style.left = lastFilterLeft + checkW + 10;
				authorCommentsDiv.style.width = sizeDiv.offsetWidth;
				authorCommentsDiv.style.left = lastFilterLeft + checkW + pointW + 10;
				authorCommentsDiv.style.clip = 'rect(0px ' + sizeDiv.offsetWidth + 'px ' + this.checkboxesFieldH + 'px 0px)';
				lastFilterLeft = parseInt(authorCommentsDiv.style.left.replace('px', '')) + authorCommentsDiv.offsetWidth;
			};

			var sepObj = document.getElementById(this.id + '_checkSep' + sepNo);
			if (sepObj) {
				sepObj.style.left = leftShift + parseInt(spaceLeft/number*(index-1));
				sepNo++;
			};

			index++;
		} else {
			checkAuthorDiv.style.visibility = 'hidden';
			checkAuthorDotDiv.style.visibility = 'hidden';
			authorCommentsDiv.style.visibility = 'hidden';
		};
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.executeScript() eval checkAuthor execution error\nMessage:\n' + e.message); //pg2
	};

	try {
		if (eval(this.checkPublic))	{
			publicCommentsDiv.style.height = this.checkboxesFieldH;
			publicCommentsDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH;

			if (!useRealWidth) {
				publicCommentsDiv.style.width = parseInt(this.w/5);
				checkPublicDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+10;
				checkPublicDotDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+15+checkW;
				publicCommentsDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+checkW+pointW+20;
				publicCommentsDiv.style.clip = 'rect(0px ' + parseInt(this.w/5) + 'px ' + this.checkboxesFieldH + 'px 0px)';
			} else {
				sizeDiv.innerHTML = this.filtrNamesArr[2].innerHTML;
				checkPublicDiv.style.left = lastFilterLeft + 10
				checkPublicDotDiv.style.left = lastFilterLeft + checkW + 10;
				publicCommentsDiv.style.width = sizeDiv.offsetWidth;
				publicCommentsDiv.style.left = lastFilterLeft + checkW + pointW + 10;
				publicCommentsDiv.style.clip = 'rect(0px ' + sizeDiv.offsetWidth + 'px ' + this.checkboxesFieldH + 'px 0px)';
				lastFilterLeft = parseInt(publicCommentsDiv.style.left.replace('px', '')) + publicCommentsDiv.offsetWidth;
			};

			var sepObj = document.getElementById(this.id + '_checkSep' + sepNo);
			if (sepObj) {
				sepObj.style.left = leftShift + parseInt(spaceLeft/number*(index-1));
				sepNo++;
			};

			index++;
		} else {
			checkPublicDiv.style.visibility = 'hidden';
			checkPublicDotDiv.style.visibility = 'hidden';
			publicCommentsDiv.style.visibility = 'hidden';
		};
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.executeScript() eval checkPublic execution error\nMessage:\n' + e.message); //pg2
	};

	try {
		if (eval(this.checkTutor))	{
			tutorCommentsDiv.style.height = this.checkboxesFieldH;
			tutorCommentsDiv.style.top = this.h - this.footerHeight - this.checkboxesFieldH;

			if (!useRealWidth) {
				tutorCommentsDiv.style.width = parseInt(this.w/5);
				checkTutorDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1))+10;
				checkTutorDotDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1)) + 15 + checkW;
				tutorCommentsDiv.style.left = leftShift + parseInt(spaceLeft/number*(index-1)) + checkW + pointW + 20;
				tutorCommentsDiv.style.clip = 'rect(0px ' + parseInt(this.w/5) + 'px ' + this.checkboxesFieldH + 'px 0px)';
			} else {
				sizeDiv.innerHTML = this.filtrNamesArr[3].innerHTML;
				checkTutorDiv.style.left = lastFilterLeft + 10
				checkTutorDotDiv.style.left = lastFilterLeft + checkW + 10;
				tutorCommentsDiv.style.width = sizeDiv.offsetWidth;
				tutorCommentsDiv.style.left = lastFilterLeft + checkW + pointW + 10;
				tutorCommentsDiv.style.clip = 'rect(0px ' + sizeDiv.offsetWidth + 'px ' + this.checkboxesFieldH + 'px 0px)';
				lastFilterLeft = parseInt(tutorCommentsDiv.style.left.replace('px', '')) + tutorCommentsDiv.offsetWidth;
			};

			var sepObj = document.getElementById(this.id + '_checkSep' + sepNo);
			if (sepObj) {
				sepObj.style.left = leftShift + parseInt(spaceLeft/number*(index-1));
				sepNo++;
			};

			index++;
		} else {
			checkTutorDiv.style.visibility = 'hidden';
			checkTutorDotDiv.style.visibility = 'hidden';
			tutorCommentsDiv.style.visibility = 'hidden';
		};
	} catch(e) {
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.executeScript() eval checkTutor execution error\nMessage:\n' + e.message); //pg2
	};

	if (this.dir == "rtl") {
		this.RTLElement(checkMyDiv);
		this.RTLElement(checkAuthorDiv);
		this.RTLElement(checkPublicDiv);
		this.RTLElement(checkTutorDiv);
		this.RTLElement(checkMyDotDiv);
		this.RTLElement(checkAuthorDotDiv);
		this.RTLElement(checkPublicDotDiv);
		this.RTLElement(checkTutorDotDiv);
		this.RTLElement(myCommentsDiv);
		this.RTLElement(authorCommentsDiv);
		this.RTLElement(publicCommentsDiv);
		this.RTLElement(tutorCommentsDiv);
	};
	return number;
};

componentYellowCardReport.prototype.deleteAllRows = function()
{
	var table 	= document.getElementById(this.id + "Table");
	var length = table.rows.length;

	for (var i=0; i < length; i++) table.deleteRow(0);
};

componentYellowCardReport.prototype.showFiltredComments = function()
{
	var table = document.getElementById(this.id + "Table");
	var content = '';
	this.mailReportText = '';

	if (PageInterface.GetValue("state") != psDesigning) {
		var yellowCardsArray = PlayerInterface.GetValue("getYellowCardsArray");

		var imgH = 3;//this.getImageHeight('sepHorizontal');
		this.deleteAllRows();

		for (var i=0; i < yellowCardsArray.length; i++) {
			var yCard = yellowCardsArray[i];
			if (yCard && ((yCard.cardType == 'author' && this.checksArr['Author'] == 1) 
				 || (yCard.cardType == 'public' && this.checksArr['Public'] == 1)
				 || (yCard.cardType == 'private' && this.checksArr['Private'] == 1)
				 || (yCard.cardType == 'tutor' && this.checksArr['Tutor'] == 1)))
			{
				if (i > 0) content = '<img  src="' + this.resourcesURL + this.sepHorizontal + '" width="100%" height="' + imgH + '">';
				content += this.makeCommentDIV(yCard);

				var row 	= table.insertRow(table.rows.length);
				var cell 	= row.insertCell(0);
				cell.innerHTML 	= content;
				this.makeMailText(yCard);
			};
		};
		this.getTextHeight();
	};
};

componentYellowCardReport.prototype.makeMailText = function(card)
{
	this.mailReportText += card.author + '%0D%0A ';
	this.mailReportText += unescape(card.title) + '%0D%0A';
	this.mailReportText += card.date + '%0D%0A';
	this.mailReportText += unescape(card.note) + '%0D%0A';
	this.mailReportText += '======================================================================%0D%0A';
};

componentYellowCardReport.prototype.getProjectFont = function(fontGlobalFormating, family, size, color)
{
	var font = {};
	font.family = family;
	font.size = size;
	font.color = color;

	if (fontGlobalFormating && project.globalFormating) {
		font.family = project.font.family;
		font.size = project.font.size;
		font.color = project.font.color;
	};
	return font;
};

componentYellowCardReport.prototype.makeCommentDIV = function(card)
{
	var imgName = '';
	var font = this.getProjectFont(this.cardsGlobalFormating == 1, this.cardsFontFamily, this.cardsFontSize, this.cardsFontColor);

	switch (card.cardType) {
		case 'author': 
			var imgW = this.getImageWidth('authorDot');
			var imgName = this.authorDot;
			break;
		case 'public':
			var imgW = this.getImageWidth('publicDot');
			var imgName = this.publicDot;
			break;
		case 'private':
			var imgW = this.getImageWidth('myDot'); 
			var imgName = this.myDot;
			break;
		case 'tutor':
			var imgW = this.getImageWidth('tutorDot');
			var imgName = this.tutorDot;
			break;
	};

	var imgArr = this.getClockAndPersonImg(card);
	var str = '';

	str += '<table width="100%" border="0" dir="' + this.dir + '">';
	str += '<tr><td width="5px">';
	str += '</td><td width="1%" valign="top">';
	str += '<img  src="' + this.resourcesURL + imgName + '" >';
	str += '</td><td colspan="2">';
	str += '<font face="' + font.family + '" size="' + font.size + '" color="' + font.color + '">';
	str += unescape(card.title);
	str += '</font>';
	str += '</td></tr>';
	str += '<tr><td width="5px">';
	str += '</td><td>';
	str += '</td><td>';
	str += '<table width="100%" border="0">';
	str += '<tr>'
	if (card.showUserName.toString() == 'true') {
		str += '<td width="130px" >'
		str += '<img  src="' + this.resourcesURL + imgArr[1] + '" >'
		str += '<font face="' + font.family + '" size="' + font.size + '" color="' + font.color + '">';
		str += unescape(card.author);
		str += '</font>';
		str += '</td>';
		str += '<td>';
	} else {
		str += '<td colspan="3">';
	};
	str += '<img  src="' + this.resourcesURL + imgArr[0] + '" >';
	str += '<font face="' + font.family + '" size="' + font.size + '" color="' + font.color + '">';
	str += unescape(card.date);
	str += '</font>';
	str += '</td>';
	str += '</tr>';
	str += '</table>';
	str += '</td><td>';
	str += '</td></tr>';
	str += '</td><td>';
	str += '</td><td colspan="3">';
	if (card.pageName.length > 70) {
		var pageName = card.pageName.substring(0, 70) + '...';
	} else {
		var pageName = card.pageName;
	};
	str += '<font face="' + font.family + '" size="' + font.size + '" color="' + font.color + '" onClick="if (!opener) PlayerInterface.Execute(\'gotoPage\', ' + card.pageGI + ');">';
	str += this.pageTitle + ' <u style="cursor:pointer;" title="' + card.pageName + '">' + pageName + '</u>';
	str += '</font>';
	str += '</td></tr>';
	str += '</tr>';
	str += '<tr>';
	str += '</td><td>';
	str += '</td></tr>';
	str += '</td><td>';
	str += '</td><td colspan="3">';
	str += '<font face="' + font.family + '" size="' + font.size + '" color="' + font.color + '">';
	str += unescape(card.note);
	str += '</font>';
	str += '</td></tr>';
	str += '</table>';
	return str;
};

componentYellowCardReport.prototype.getClockAndPersonImg = function(card)
{
	var clock = card.clockGraphic;
	var person = card.personGraphic;

	return [clock, person];
};

componentYellowCardReport.prototype.sendCommentsByMail = function(obj)
{
	window.location="mailto:" + this.eMailAdress + "?subject=" + escape("E-mail from " + page.getUELO().courseName) + "&body=" + this.replaceCharsInMail(this.mailReportText),5,5,100,100,"resizable=yes","mailWindow";
};

componentYellowCardReport.prototype.replaceCharsInMail = function(text)
{
	text = text.replace(/ą/ig, 'a');
	text = text.replace(/ć/ig, 'c');
	text = text.replace(/ę/ig, 'e');
	text = text.replace(/ł/ig, 'l');
	text = text.replace(/ń/ig, 'n');
	text = text.replace(/ó/ig, 'o');
	text = text.replace(/ś/ig, 's');
	text = text.replace(/ź/ig, 'z');
	text = text.replace(/ż/ig, 'z');
	text = text.replace(/&/ig, 'and');
	return text;
};

componentYellowCardReport.prototype.makePrintWindow = function()
{
	var table = document.getElementById(this.id + "Table");
	var win = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width=600, height=300");

	var inner = '<html><head><title>' + project.pageName + '</title>';
	inner += '</head><body onload="self.print();">';
	inner += '<table width="100%" border="0" dir="' + this.dir + '">';
	inner += table.innerHTML;
	inner += '</table>';
	inner += '</body></html>';
	inner += '</body></html>';

	win.document.write(inner);
	win.document.close();
	win.focus();
};

componentYellowCardReport.prototype.getTextHeight = function()
{
	var commentsDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");

	var Table = document.getElementById(this.id + "Table");
	var trackBckgDiv = document.getElementById(this.id + "_trackBckgDiv");
	var arrowTopDiv = document.getElementById(this.id + "_arrowTopDiv");
	var arrowBottomDiv = document.getElementById(this.id + "_arrowBottomDiv");
	var trackDiv = document.getElementById(this.id + "_trackDiv");

	this.textHeight = Table.scrollHeight;
	commentsDiv.scrollTop = 0;
	trackDiv.style.top = this.sliderLowOffset;

	var textFieldW = this.w - 2*this.borderWidth - 2*this.contentPadding - this.getImageWidth('sliderOut') - 2*this.textSpacing;
	var textFieldH = this.h - this.headerHeight - this.contentPadding - this.footerHeight - this.checkboxesFieldH;

	this.buttonsActive = (textFieldH < this.textHeight) ? true : false;

	if (this.buttonsActive) {
		commentsDiv.style.width = this.w - this.contentPadding - this.getImageWidth('sliderOut');
		commentsDiv.style.height = textFieldH;
		commentsDiv.style.top = this.headerHeight+this.contentPadding;
		commentsDiv.style.left = this.contentPadding;
		commentsDiv.style.clip = 'rect(0px ' + commentsDiv.style.width + ' ' + commentsDiv.style.height + ' 0px)';
		trackBckgDiv.style.display = 'block';
		arrowTopDiv.style.display = 'block';
		arrowBottomDiv.style.display = 'block';
		trackDiv.style.display = 'block';
	} else {
		commentsDiv.style.width = this.w - this.contentPadding;
		commentsDiv.style.height = textFieldH;
		commentsDiv.style.top = this.headerHeight;
		commentsDiv.style.left = this.contentPadding;
		commentsDiv.style.clip = 'rect(0px ' + commentsDiv.style.width + ' ' + commentsDiv.style.height + ' 0px)';

		trackBckgDiv.style.display = 'none';
		arrowTopDiv.style.display = 'none';
		arrowBottomDiv.style.display = 'none';
		trackDiv.style.display = 'none';
	};
	//########
};

componentYellowCardReport.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentYellowCardReport.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};
