﻿module Quiz2 {
    export class Quiz2 extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        numberOfChecked: any;

        numberOfCorrect: any;

        Questions: any[];

        Color: any;
        LocalPoints: any[];
        CreateAnimals = false;
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            if (this.Elements.Color) {
                this.Color = this.Elements.Color;
            } else this.Color = "red";
            this.numberOfChecked = 0;
            EU.createStaticElements(this);
            //this.createStaticElements();
            this.createQuestions();
            this.LocalPoints = [];
            this.initPointingSystem();
           

        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createStaticElements() {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        }

        soundButtonDown(button) {
            Global.Main.PlayMusic(new Audio(button.name));
        }

        createQuestions() {
            this.Questions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {

                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = this.Elements.Questions[i].Position.x;
                var posY = this.Elements.Questions[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = <string>(this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans),
                        posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans) +
                        (j + 1) * this.Elements.Questions[i].Spacing + el.height + j * ans.height);
                    ans.inputEnabled = true;
                    ans.align = <string>(this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue,
                        "points": this.Elements.Questions[i].Answers[j].points

                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        }

        private getJustedPositionX(just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        }

        private getJustedPositionY(just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        }

        //input

        private onInputOver(el: Phaser.Text, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Text, pointer) {
            el.alpha = 1.0;
        }

        private onInputDown(el: Phaser.Text, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";

            }
            else {
                el.setShadow(el.height / 25, el.height / 25, this.Color);
                this.numberOfChecked++;
                el.name = "checked";
            }

            this.checkIfEverythingIsCorrect()
        }


        private checkIfEverythingIsCorrect() {
        if (this.numberOfChecked == 1)
        {
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].Element.name == "checked") {
                        for (var m = 0; m < this.LocalPoints.length; m++) {
                            this.LocalPoints[m] = this.LocalPoints[m] + this.Questions[i].Answers[j].points[m];
                            EU.Log(this.LocalPoints);

                        }
                        EU.savePoints(this.LocalPoints);
                        EU.saveCreationState(true, (this.Elements.CurrentPage+1));
                    }
                  
                }
            }
            EU.setGameCompletion(this.parent, 1);
            EU.Log("Correct!!!");
                if (TYPE === "gm") {
                    // if bed == 0 last page
                    super.nextTask();
                }
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;

        }

        private calculateMaxPoints() {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue) points++;
                }
            }
            return points;
        }

        private calculatePlayerPoints() {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked") {
                        var tmp = this.Questions[i].Answers[j].points;
                        for (var m = 0; m < this.LocalPoints.length; m++)
                            this.LocalPoints[m] = this.LocalPoints[m] + tmp[m];
                        points++;
                    }
                }
            }
            return points;
        }
        private initPointingSystem() {
           
            if (this.Elements.InitPoints) {
                EU.saveCreationState(true, this.Elements.CurrentPage);
                this.LocalPoints = this.Elements.points;
                EU.initPointingSystem(this.Elements.points);
                this.createGraphicRepresentation();
            }
        }
        private createGraphicRepresentation()
        {
            if (EU.loadCreationState(this.Elements.CurrentPage)) {
                if (this.LocalPoints[1] <= 0) {
                    this.LocalPoints[1] -= 1;
                    EU.savePoints(this.LocalPoints);
                    EU.saveCreationState(true,(this.Elements.CurrentPage + 1));
                    EU.Log("wykonane w :" + this.Elements.CurrentPage);
                    EU.setGameCompletion(this.parent, 1);
                    super.superNextTask(this.Elements.CurrentPage);
                }
                else {
                    for (var m1 = 0; m1 < this.LocalPoints[0]; m1++) {
                        var el;
                        el = this.game.add.image(0, 0, this.PREFIX + this.Elements.Reperesentation[0].key);
                        el.scale.setTo(0.5, 0.5);
                        var posY = this.Elements.Reperesentation[0].pos.y + 50 * (m1 % 3);
                        var posX = this.Elements.Reperesentation[0].pos.x + 25 + 50 * (m1 % 25);

                        el.position.set(posX, posY);
                        this.addChild(el);
                    }
                    for (var m2 = 0; m2 < this.LocalPoints[1]; m2++) {
                        var el;
                        el = this.game.add.image(0, 0, this.PREFIX + this.Elements.Reperesentation[1].key);
                        el.scale.setTo(0.5, 0.5);

                        var posY = this.Elements.Reperesentation[0].pos.y + 200 + 50 * (m2 % 3);
                        var posX = this.Elements.Reperesentation[1].pos.x + 25 + 50 * (m2 % 25);

                        el.position.set(posX, posY);
                        this.addChild(el);
                    }
                }
            }
        }

        update() {
            if ((EU.points != undefined && this.LocalPoints != undefined) && (EU.points[0] != this.LocalPoints[0] || EU.points[1] != this.LocalPoints[1])) {
                this.LocalPoints = EU.loadPoints(this.LocalPoints);
                this.createGraphicRepresentation();
              //  EU.Log("this.LocalPoints = " + this.LocalPoints + " EU.points:  " + EU.points);
            }
        }
    }
}