﻿module Memo {

    export class Memo extends Base.BasicGroup {


        Elements: any;
        PREFIX: any;

        unhide: number = 0;

        

        firstCard: MemoCard;
        secondCard: MemoCard;

        rows: number;
        columns: number;
        left: number;
        top: number;
        cardWidth: number;
        cardHeight: number;
        totalPair: number;
        innerSpace: number;

        cards: Array<string> = [];

        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++) {
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
                if (this.Elements.Graphics[i].key != 'memo') this.cards.push(this.Elements.Graphics[i].key);
            }
        }

        shuffle(o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
            return o;
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            
            this.rows = this.Elements.Options[0].Rows;
            this.columns = this.Elements.Options[0].Columns;
            this.top = this.Elements.Options[0].Top;
            this.left = this.Elements.Options[0].Left;
            this.cardWidth = this.Elements.Options[0].CardWidth;
            this.cardHeight = this.Elements.Options[0].CardHeight;
            this.innerSpace = this.Elements.Options[0].InnerSpace;

            this.totalPair = (this.Elements.Graphics.length - 1) / 2;

            this.shuffle(this.cards);
            var variant = 1;
            for (var i = 0; i < this.columns; i++) 
                for (var j = 0; j < this.rows; j++) {
                    var m = new MemoCard(this.game, this.left + i * this.cardWidth + this.innerSpace, this.top + j * this.cardHeight + this.innerSpace, this.cards[0]);
                    m.inputEnabled = true;
                    m.events.onInputDown.add(this.clickCard, this);
                    this.cards.shift();
                    this.addChild(m);
            }

        }

        clickCard(obj: MemoCard) {
            this.unhide++
            if (this.unhide == 1) {
                this.firstCard = obj;
                this.firstCard.inputEnabled = false;
                this.firstCard.showKey();
            }

            if (this.unhide == 2) {
                this.secondCard = obj;
                this.secondCard.inputEnabled = false;
                this.secondCard.showKey();
                this.game.time.events.add(Phaser.Timer.SECOND * 1, this.checkPair, this);
                
            }
        }

        checkPair() {
            if (this.firstCard.group == this.secondCard.group) {
                this.firstCard.done = true;
                this.secondCard.done = true;
                this.unhide = 0;
                this.totalPair--;
                console.log(this.totalPair);
                if (this.totalPair == 0) {
                    EU.Log('Well done.');
                    EU.setGameCompletion(this.parent, 1);
                    super.nextTask();
                }
                EU.Log('Pair');
            }
            else {
                this.firstCard.back();
                this.secondCard.back();
                this.unhide = 0;
            }


        }

    }

    class MemoCard extends Phaser.Sprite {

        group: string;
        imgKey: string;
        game: Phaser.Game;
        done: boolean = false;

        constructor(game, x, y, key) {
            super(game, x, y, 'memo');
            this.group = key.substring(0, key.length - 1);
            this.imgKey = key;
            this.game = game;
        }

        showKey() {
            this.loadTexture(this.imgKey, 0, true);
        }

        back() {
            this.loadTexture('memo', 0, true);
            this.inputEnabled = true;
        }

    }

} 