/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
componentHTMLButton = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	if (arguments[1]) {
	} else {
		this.label = this.addChild(new componentText(null));
	};
};

componentHTMLButton.prototype = new componentElement();
componentHTMLButton.prototype.type = "componentHTMLButton";

componentHTMLButton.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	if (this.execution) {
		this.onPaint();
	} else {
		this.label.p_checkMarkers = this.p_checkMarkers;
		this.label.p_checkPNG = this.p_checkPNG;
		this.label.pngFix = this.pngFix;
	};
};

componentHTMLButton.prototype.onPaint = function()
{
	if (!this.execution) {
		var width = this.w - (this.borderWidth*2);
		var height = this.h - (this.borderWidth*2); 
		var t = '<button name="' + this.id + '" id="' + this.id + '" ';
		t += 'style="width: ' + width + '; height: ' + height + '; ';
		t += 'background-color: ' + this.bgColor + '; cursor: ' + this.cursor + '; ';
		t += 'border-width: ' + this.label.borderWidth + '; border-color:' + this.label.borderColor + ';"';
		t += ' onclick="WBTObject.all[\''+this.id+'\'].fnOnClick()"';
		t += '>';
		t += this.label.text;
		t += '</button>';
		this.setHTML(t);
	};
};

componentHTMLButton.prototype.fnOnClick = function(e)
{
	if (this.confirmAnswer && page.pageType == "Exercise") {
		page.checkAnswer(this);
	} else {
		if (this.onClick && this.onClick(this)) return true;
		if (this.parent && this.parent.eventClick) this.parent.eventClick(e);
	};
	return false;
};

componentHTMLButton.prototype.eventClick = function(e)
{
	return false;
};
