﻿module ImageMath {
    export class ImageMath extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        Color: any;
        ColorText: any;

        Selectables: any[];

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            EU.createStaticElements(this);
            this.createSelectableElements();
            if(this.Elements.Options.Color)
                this.Color = this.Elements.Options.Color;
            if (this.Elements.Options.ColorText)
                this.ColorText = this.Elements.Options.ColorText;
            EU.createFillElements(this);
           
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createStaticElements() {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        }

        soundButtonDown(button) {
            Global.Main.PlayMusic(new Audio(button.name));
        }

        createSelectableElements() {
            this.Selectables = [];
            for (var i = 0; i < this.Elements.SelectableElements.length; i++) {
                var Element = [];
                var tmpline = 0;
                for (var j = 0; j < this.Elements.SelectableElements[i].NumberOfElements; j++) {
                    var el;
                    switch (this.Elements.SelectableElements[i].el.type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.SelectableElements[i].el.key);
                            el.events.onInputDown.add(this.onInputDown, this);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.SelectableElements[i].el.text, this.Elements.Options.Style);
                            el.events.onInputDown.add(this.onInputText, this);
                            break;
                    }
                    var posX = this.Elements.SelectableElements[i].Position.x;
                    var posY = this.Elements.SelectableElements[i].Position.y;
                    if (this.Elements.Options.Just) {
                        switch (this.Elements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2 -
                                ((this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements) / 2;
                               
                                el.anchor.x = 0;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120 -
                                (this.Elements.Options.Spacing + el.width) * this.Elements.SelectableElements[i].NumberOfElements;
                                el.anchor.x = 0;
                                break;
                        }
                        switch (this.Elements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    if (this.Elements.SelectableElements[i].NumberOfElementsPeerLine) {
                       
                        if (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine == 0)
                        {
                        tmpline=tmpline+1;
                        }  
                        posX = posX + (el.width) * (j % this.Elements.SelectableElements[i].NumberOfElementsPeerLine);
                        posY = posY + (el.height) * (tmpline);
                        el.position.set(posX , posY);
                    }

                    else {
                        el.position.set(posX + (this.Elements.Options.Spacing + el.width) * j, posY);
                    }
                    el.inputEnabled = true;
                    el.name = "unchecked";
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    this.addChild(el);
                    Element.push(el);
                }
                this.Selectables.push(Element);
            }
        }

        private onInputOver(el: Phaser.Sprite, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Sprite, pointer) {
            el.alpha = 1.0;
        }

        private onInputDown(el: Phaser.Sprite, pointer) {
            if (el.name == "unchecked") {
                el.tint = this.Color;
                el.name = "checked";
            }
            else {
                el.name = "unchecked";
                el.tint = 0xFFFFFF;
            }

            this.checkIfEverythingIsCorrect();
        }

        private onInputText(el: Phaser.Text, pointer) {
            if (el.name == "unchecked") {
                el.setShadow(el.height / 25, el.height / 25, this.ColorText);
                el.name = "checked";
            }
            else {
                el.setShadow(0, 0, "black");
                el.name = "unchecked";
            }
            this.checkIfEverythingIsCorrect();
        }

        private checkIfEverythingIsCorrect() {
            EU.Log(this.calculatePlayerPoints() + "/" + this.calculateMaxPoints());
            if (this.calculateMaxPoints() == this.calculatePlayerPoints() && EU.checkIfFillsAreCorrect(this)) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Everyting Correct!!!");
                if (TYPE === "gm") super.nextTask();
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }

        private calculatePlayerPoints() {
            var points = 0;
            for (var i = 0; i < this.Selectables.length; i++) {
                var checked = 0;
                for (var j = 0; j < this.Selectables[i].length; j++) {
                    
                    if (this.Selectables[i][j].name == "checked") {
                        checked++;
                    }
                }
                if (checked == this.Elements.SelectableElements[i].CorrectNumOfElements) {
                    points++;
                }
            }
            return points;
        }

        private calculateMaxPoints() {
            return this.Elements.SelectableElements.length;
        }

    }
}

/*

{
    "attrs": ["TestGroupName", {
        "GameType": GameTypes.ImageMath,
        "description": "1. Zaznacz tyle kółek pod obrazkiem, ile sylab słyszysz w każdym wyrazie.",
        "Lector": "MW_kp_I_6_1.mp3",
        "MaxPoints": 1, "isStandalone": false, "isFirst": false, "GameData": {
            "GameType": "OneToOne",
            "DrawingsAreAnswers": true,
            "TaskPrefix": "Zad1",
            "Graphics":
            [
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_cytryna.png", "key": "01" },
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_kot.png", "key": "02" },
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_poduszka.png", "key": "03" },
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_tv.png", "key": "04" },
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_zegar.png", "key": "05" },
                { "src": "Graphics/WorkCards/MW_I_6/zad1/MW_kp_I_6_sylaba_unchecked.png", "key": "select" },

            ],
            "StaticElements":
            {
                "el": [

                    { "type": "image", "key": "01", "pos": { "x": -600, "y": 100 } },
                    { "type": "image", "key": "02", "pos": { "x": -300, "y": 100 } },
                    { "type": "image", "key": "03", "pos": { "x": 0, "y": 100 } },
                    { "type": "image", "key": "04", "pos": { "x": 300, "y": 100 } },
                    { "type": "image", "key": "05", "pos": { "x": 600, "y": 100 } },

                ],
                "Options": {
                    "Just": { "x": "center", "y": "top" },

                },
            },

            "SelectableElements":
            [
                {
                    "NumberOfElements": 4,
                    "CorrectNumOfElements": 3,
                    "Position": { "x": -600, "y": 350 },
                    "el": { "type": "image", "key": "select" },

                },

                {
                    "NumberOfElements": 4,
                    "CorrectNumOfElements": 1,
                    "Position": { "x": -300, "y": 350 },
                    "el": { "type": "image", "key": "select" },

                },

                {
                    "NumberOfElements": 4,
                    "CorrectNumOfElements": 3,
                    "Position": { "x": 0, "y": 350 },
                    "el": { "type": "image", "key": "select", "text": "k" },

                },

                {
                    "NumberOfElements": 4,
                    "CorrectNumOfElements": 4,
                    "Position": { "x": 300, "y": 350 },
                    "el": { "type": "image", "key": "select" },

                },

                {
                    "NumberOfElements": 4,
                    "CorrectNumOfElements": 2,
                    "Position": { "x": 600, "y": 350 },
                    "el": { "type": "image", "key": "select" },

                },

            ],
            "Options": {
                "Just": { "x": "center", "y": "top" },
                "Style": { font: "40px Arial", fill: 'black' },
                "Spacing": 10,
                "Color": 0x99FF99,
                "ColorText": "red",

            },

        }

    }]
},


*/