/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentRPLPanel = function(name)
{
	this.componentInfoPanel = componentInfoPanel;
	this.componentInfoPanel(name);

	this.imagesSymulationArr = new Array();
	this.imagesEndSymulation = new Array();

	this.runStepsInPanel = true;
	this.RPLComponent = null;

	this.rowNumber = 0;
	this.topRowShowName = 1;
	this.progresImageNumber = 0;

	this.sliderBaseTop = 0;
	this.sliderLowOffset = 0;
	this.sliderHighOffset = 0;
	this.dragobjectParent = null;
	this.dragobject = null;
	this.position = 0;
	this.oldPosition = 0;
	this.ty = 0;
	this.p_checkPNG = true;
	this.pngFix = true;

	this.iTimerID = null;

	this.imagesNameArr = new Array();
};

componentRPLPanel.prototype = new componentInfoPanel();
componentRPLPanel.prototype.type = "componentRPLPanel";

componentRPLPanel.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [this.sliderPress, this.sliderFree, this.leftTop, this.centerTop, this.rightTop, this.topMiddle, this.centerMiddle, this.bottomMiddle, this.leftBottom,
							this.bottom, this.rightBottom, this.leftTop, this.centerTop, this.rightTop, this.topMiddle, this.centerMiddle, this.bottomMiddle, this.leftBottom,
							this.bottom, this.rightBottom, this.naviTopOut, this.naviTopOver, this.naviMiddle, this.naviBottomOut, this.naviBottomOver, this.clientIcon, this.studentIcon,
							this.leftSteps, this.centerSteps, this.rightSteps, this.buttonCloseOver, this.buttonCloseOut, this.buttonPrintOut, this.buttonPrintOver, this.shadowLeft,
							this.shadowRight
						];
	this.getPreloadImagesArr();	
	this.setCompleteArrayInfo(this.completeInfoStyleImages, this.completeInfoButtonsImages);
};

componentRPLPanel.prototype.onCreate = function(obj)
{
	this.imagesSymulationArr = this.imagesSymulation.split("||");
	this.imagesEndSymulation = this.imagesEndSymulation.split("||");

	this.setHTMLObiekts();
};

componentRPLPanel.prototype.getStepsDivWidth = function(obj)
{
	return this.getImageWidth('buttonPrintOut');
};

componentRPLPanel.prototype.getStepsDivLeft = function(obj)
{
	return this.w - this.buttonCloseX - 10;
};

componentRPLPanel.prototype.componentRPLPanelBaseSetHTMLObiekts = componentRPLPanel.prototype.setHTMLObiekts;
componentRPLPanel.prototype.setHTMLObiekts = function(obj)
{
	this.componentRPLPanelBaseSetHTMLObiekts();

	var imageProgressImg = document.getElementById(this.id + "_imageProgressImg");
	var contentTable = document.getElementById(this.id + "__contentTable");
	var contentDiv = document.getElementById(this.id + "_contentDiv");
	var RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	var RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	var imageProgressDiv = document.getElementById(this.id + "_imageProgressDiv");
	var naviBarDiv = document.getElementById(this.id + "_naviBarDiv");
	var titleDiv = document.getElementById(this.id + "_titleDiv");
	var titleImg = document.getElementById(this.id + "_titleImg");
	var sliderDIV = document.getElementById(this.id + "_sliderDIV");
	var sliderImg = document.getElementById(this.id + "_sliderImg");
	var naviBarDiv = document.getElementById(this.id + "_naviBarDiv");
	var naviBarTableMiddle = document.getElementById(this.id + "_naviBarTableMiddle");
	var stepsBckgDiv = document.getElementById(this.id + "_stepsBckgDiv");
	var middleTableDiv = document.getElementById(this.id + "_middleTableDiv");

	middleTableDiv.style.top = 0;

	//imageProgressImg.width = this.getImageWidth(this.imagesSymulationArr[this.progresImageNumber]);
	//imageProgressImg.height = this.getImageHeight(this.imagesSymulationArr[this.progresImageNumber]);
	//imageProgressImg.src = this.resourcesURL + this.imagesSymulationArr[0];
	imageProgressImg.width = this.imgProgressWidth;
	imageProgressImg.height = this.imgProgressHeight;
	imageProgressImg.src = this.resourcesURL + this.imagesSymulationArr[this.progresImageNumber];
	sliderImg.src = this.resourcesURL + this.sliderFree;

	//contentTable.height = this.contentTableHeight;
	var contentDivH = this.h - this.getImageHeight('centerTop') - this.getImageHeight('bottom')+2;
	contentDiv.style.height = contentDivH;
	contentDiv.style.width = this.w;
	contentDiv.style.clip = 'rect(0px '+this.w+'px '+contentDivH+'px 0px)';

	this.contentTableHeight = contentDiv.offsetHeight - this.imgProgressHeight; //this.getImageHeight(this.imagesSymulationArr[0]);
	RPLTextsDiv.style.height = this.contentTableHeight;
	RPLTextsDiv.style.width = this.w-this.getImageWidth('naviMiddle')-5;
	RPLTextsDiv.style.clip = 'rect(0px '+this.w+'px '+this.contentTableHeight+'px 0px)';

	imageProgressDiv.style.height = this.imgProgressHeight;//this.getImageHeight(this.imagesSymulationArr[0]);
	imageProgressDiv.style.width = this.w;
	//imageProgressDiv.style.clip = 'rect(0px '+this.w+'px '+this.getImageHeight(this.imagesSymulationArr[0])+'px 0px)';
	imageProgressDiv.style.clip = 'rect(0px '+this.w+'px '+this.imgProgressHeight+'px 0px)';
	naviBarDiv.style.height = this.contentTableHeight;

	titleImg.src = this.resourcesURL + this.iconTitle;
	if (titleDiv) {
		var dotH = 15;//this.getImageHeight('this.iconTitle');
		var dotW = 15;//this.getImageWidth('this.iconTitle');
		var centerTopH = this.getImageHeight('centerTop');
		titleDiv.style.top = (centerTopH/2) - (dotH/2);
		titleDiv.style.height = dotH;
		titleDiv.style.width = dotW;
		titleDiv.style.clip = 'rect(0px '+dotW+'px '+dotH+'px 0px)';
	};

	var naviTop = naviBarDiv.style.top.replace('px', '');
	var sliderH = this.getImageHeight('sliderFree');
	var sliderW = this.getImageWidth('sliderFree');
	this.sliderBaseTop = parseInt(naviTop) + (naviBarDiv.offsetHeight/2) - (sliderH/2);

	if (sliderDIV) {
		sliderDIV.style.top = this.sliderBaseTop;
		sliderDIV.style.left = this.w - (sliderW/2) - (this.getImageWidth('naviMiddle')/2);
		sliderDIV.style.height = sliderH;
		sliderDIV.style.width = sliderW;
		sliderDIV.style.clip = 'rect(0px '+sliderW+'px '+sliderH+'px 0px)';
	};

	this.sliderLowOffset = parseInt(naviTop) + this.getImageHeight('naviTopOut');
	this.sliderHighOffset = naviBarTableMiddle.offsetHeight - this.getImageHeight('sliderFree');

	if (this.headerBold) {
		var headerTemp = headerFont.innerHTML;
		headerFont.innerHTML = '<b>' + headerTemp + '</b>';
	};
};

componentRPLPanel.prototype.onAfterLoad = function(question, answer)
{
	if (this.connectWithRPL) {
		var objStat = null;
		for (var i =0; i < page.children.length; i++) {
			var obj = page.children[i];
			if (obj.type == 'componentRPL' && this.RPLComponent != '' && obj.id.indexOf(this.RPLComponent) > -1) {
				obj.panelRPLOBJ = this;
				this.RPLComponent = obj;
				break;
			};
		};	
	};
};

componentRPLPanel.prototype.showQuestionAndAnswerAtPanel = function(question, answer)
{
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	if (RPLTextsTable.rows.length > 2){
		var row 	= RPLTextsTable.insertRow(RPLTextsTable.rows.length);
		row.id = 'row_'+this.rowNumber++;
		var cell_1 = row.insertCell(0);
		cell_1.vAlign = 'top';
		cell_1.align = 'center';
		cell_1.innerHTML = this.getImageHTML('___.infoPanel.rowSep.gif', eval(this.w-this.getImageWidth('naviMiddle')-5), 3);
		cell_1.colSpan = 3;	
	};

	var font = this.getProjectFont(this.contentGlobalFormating == 1, this.contentFontFamily, this.contentFontSize, this.contentFontColor );

	var row = RPLTextsTable.insertRow(RPLTextsTable.rows.length);
	row.id = 'row_'+this.rowNumber++;
	var cell_1 	= row.insertCell(0);
	cell_1.innerHTML = '<p class="RPLPanelMarginTImg">';
	cell_1.innerHTML += this.getImageHTML(this.clientIcon, this.getImageWidth('clientIcon'), this.getImageHeight('clientIcon'));
	cell_1.vAlign = 'top';
	cell_1.align = 'center';
	cell_1.style.width = 60;
	var cell_2 	= row.insertCell(1);
	cell_2.style.fontFamily = font.family;
	cell_2.style.fontSize = getFontSize(font.size, 'px');
	cell_2.style.color = font.color;		
	cell_2.innerHTML = '<p class="RPLPanelMarginT">';
	if (this.clientBold) cell_2.innerHTML += '<b>' + question + '</b>'; else cell_2.innerHTML += question;
	cell_2.innerHTML += '<p class="RPLPanelMarginB">';

	var row = RPLTextsTable.insertRow(RPLTextsTable.rows.length);
	row.id = 'row_'+this.rowNumber++;
	var cell_1 = row.insertCell(0);
	cell_1.vAlign = 'top';
	cell_1.align = 'center';
	cell_1.innerHTML = this.getImageHTML('___.infoPanel.rowSep.gif', eval(this.w-this.getImageWidth('naviMiddle')-5), 3);
	cell_1.colSpan = 2;

	var row = RPLTextsTable.insertRow(RPLTextsTable.rows.length);
	row.id = 'row_'+this.rowNumber++;
	var cell_1 	= row.insertCell(0);
	cell_1.innerHTML = '<p class="RPLPanelMarginTImg">';
	cell_1.innerHTML += this.getImageHTML(this.studentIcon, this.getImageWidth('studentIcon'), this.getImageHeight('studentIcon'));
	cell_1.vAlign = 'top';
	cell_1.align = 'center';
	cell_1.style.width = 60;	
	var cell_2 	= row.insertCell(1);
	cell_2.style.fontFamily = font.family;
	cell_2.style.fontSize = getFontSize(font.size, 'px');
	cell_2.style.color = font.color;		
	cell_2.innerHTML = '<p class="RPLPanelMarginT">';
	if (this.studentBold) cell_2.innerHTML += '<b>' + answer + '</b>'; else cell_2.innerHTML += answer;
	cell_2.innerHTML += '<p class="RPLPanelMarginB">';

	this.setProgressbarImage();
};

componentRPLPanel.prototype.setProgressbarImage = function()
{
	var	imageProgressImg = document.getElementById(this.id + "_imageProgressImg");
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");

	var imageNumber = parseInt(RPLTextsTable.rows.length/4)+1;
	this.progresImageNumber = imageNumber;
	imageProgressImg.src = this.resourcesURL + this.imagesSymulationArr[imageNumber];
};

componentRPLPanel.prototype.setEndProgressbar = function()
{
	var	imageProgressImg = document.getElementById(this.id + "_imageProgressImg");
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");

	var imageNumber = parseInt(RPLTextsTable.rows.length/4);
	imageProgressImg.src = this.resourcesURL + this.imagesEndSymulation[imageNumber];
};

componentRPLPanel.prototype.getImageHTML = function(imgName, width, height)
{
	if (width == 0) {
		width = getImageWidth(imgName);
	};
	if (height == 0) {
		height = getImageHeight(imgName)
	};

	var s = '';
	var src = this.resourcesURL+imgName;
	var smallLettersName = imgName.toLowerCase();
	src = ".." + src.substr(src.lastIndexOf("/resources/"), src.length);

	if (smallLettersName.indexOf('.png') > -1 ) {
		s = '<span  src="' + this.resourcesURL+imgName + '"';
		s += ' style="width:' + width + '; height:' + height + '; display:inline-block;';
		s += 'filter:progid:DXImageTransform.Microsoft.AlphaImageLoader';
		s += '(src=\'' + src + '\', sizingMethod=\'image\');" ></span>';
	} else {
		s = '<img src="'+this.resourcesURL+imgName+'" height="'+height+'px" width="'+width+'px" >';
	};
	return s;
};

componentRPLPanel.prototype.getProjectFont = function(fontGlobalFormating, family, size, color)
{
	var font = {};
	font.family = family;
	font.size = size;
	font.color = color;

	if (fontGlobalFormating && project.globalFormating) {
		font.family = project.font.family;
		font.size = project.font.size;
		font.color = project.font.color;
	};
	return font;
};

componentRPLPanel.prototype.displayPrevStep = function()
{
	var	RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	var str = '';
	var moveValue = 0;

	for (var i=0; i < RPLTextsTable.rows.length; i++) {
		var No = RPLTextsTable.rows[i].id.replace('row_', '');
		if (parseInt(No) < eval(this.topRowShowName*2-4)) {
			moveValue += RPLTextsTable.rows[i].offsetHeight;
		} else {
			if (this.topRowShowName > 1)this.topRowShowName--;
			break;
		};
	};
	RPLTextsDiv.scrollTop = moveValue;
};

componentRPLPanel.prototype.displayNextStep = function()
{
	var	RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	var moveValue = 0;
	for (var i=0; i < RPLTextsTable.rows.length; i++) {
		var No = RPLTextsTable.rows[i].id.replace('row_', '');

		if (parseInt(No) < eval(this.topRowShowName*2)) {
			moveValue += RPLTextsTable.rows[i].offsetHeight;
		} else {
			var scrollTop = RPLTextsDiv.scrollTop;
			RPLTextsDiv.scrollTop = moveValue;
			if ((scrollTop != RPLTextsDiv.scrollTop) && (this.topRowShowName < eval(RPLTextsTable.rows.length*2))) this.topRowShowName++;
			break;
		};
	};
};

componentRPLPanel.prototype.countShowRow = function()
{
	var	RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	var	RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	var moveValue = 0;
	var lastHeight = 0;
	var row = null;

	for (var i=0; i < RPLTextsTable.rows.length; i++){
		var No = RPLTextsTable.rows[i].id.replace('row_', '');
		row = RPLTextsTable.rows[i];
		moveValue += RPLTextsTable.rows[i].offsetHeight;
		lastHeight = RPLTextsTable.rows[i].offsetHeight;

		if (moveValue > RPLTextsDiv.scrollTop && moveValue < RPLTextsDiv.offsetHeight) {
			if (eval(RPLTextsDiv.scrollHeight - RPLTextsDiv.offsetHeight) == RPLTextsDiv.scrollTop) {
				//RPLTextsDiv.scrollTop = 10000;
			} else {
				RPLTextsDiv.scrollTop = moveValue-lastHeight;
			};
			this.topRowShowName = parseInt(No/2)+1;
			break;
		};
	};
};

componentRPLPanel.prototype.onSliderClick = function(obj, objParent)
{
	window.event.returnValue = false;
	window.event.cancelBubble = true;	

	this.dragobjectParent = objParent;
	this.dragobject = obj;
};

componentRPLPanel.prototype.onSliderFree = function()
{
	var sliderDIV = document.getElementById(this.id + "_sliderDIV");
	if (this.dragobject) {
		this.eventMouseUp(event);
		this.dragobject = false;
		sliderDIV.style.top = this.sliderBaseTop;
		this.countShowRow();
	};
};	

componentRPLPanel.prototype.moveSlider = function () 
{	
	var RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	if (this.dragobject) {
		if (window.event.clientX >= 0 && window.event.clientY >= 0) {
			var trackH = this.dragobjectParent.offsetHeight;
			var mouseClickPos = window.event.clientY - this.y - this.sliderLowOffset;

			if (mouseClickPos > trackH/2 && mouseClickPos < eval(this.sliderHighOffset + trackH/2)) {
				var divTop = eval(this.sliderLowOffset + mouseClickPos - trackH/2);
				this.dragobjectParent.style.top = divTop;
				if (eval(this.sliderLowOffset+mouseClickPos) > this.sliderBaseTop) {
					if (is.ie) {
						RPLTextsDiv.doScroll('scrollbarDown');	
					} else {
						RPLTextsDiv.scrollTop = RPLTextsDiv.scrollTop+10;
					};
				} else {
					if (is.ie) {
						RPLTextsDiv.doScroll('scrollbarUp');
					} else {
						RPLTextsDiv.scrollTop = RPLTextsDiv.scrollTop-10;
					};
				};				
			};
		};
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	};
};

componentRPLPanel.prototype.getLeftPos = function(parObj)
{
	if (is.ie) {
		if (parObj.currentStyle.left == "auto") {
			return 0;
		} else {
			return parseInt(parObj.currentStyle.left);
		};
	} else {
		var result = parObj.style.left.replace("px", "");
		return result;
	};
};

componentRPLPanel.prototype.getTopPos = function(parObj)
{
	if (is.ie) {
		if (parObj.currentStyle.top == "auto") {
			return 0;
		} else {
			return parseInt(parObj.currentStyle.top);
		};
	} else {
		var result = parObj.style.top.replace("px", "");
		return result;
	};
};

componentRPLPanel.prototype.deleteAllRows = function()
{
	var imageProgressImg = document.getElementById(this.id + "_imageProgressImg");	
	this.progresImageNumber = 0;
	imageProgressImg.src = this.resourcesURL + this.imagesSymulationArr[this.progresImageNumber];

	var table = document.getElementById(this.id + "_RPLTextsTable");
	if (table) {
		var length = table.rows.length;
		for (var i=0; i < length; i++) {
			table.deleteRow(0);
		};
	};
};

componentRPLPanel.prototype.onUnLoad = function()
{
	this.deleteAllRows();
};

componentRPLPanel.prototype.printPreview = function()
{
	var RPLTextsDiv = document.getElementById(this.id + "_RPLTextsDiv");
	var RPLTextsTable = document.getElementById(this.id + "_RPLTextsTable");
	var inner = '<style type="text/css">.RPLPanelMarginTImg {margin-top: 5px;}.RPLPanelMarginT {margin-top: 10px;}.RPLPanelMarginB {margin-bottom: 10px;}</style>';
	var win = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width=600, height=300");
	win.document.write(inner+RPLTextsDiv.innerHTML);
};
