var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Compass;
(function (_Compass) {
    var Compass = (function (_super) {
        __extends(Compass, _super);
        function Compass(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.houses = [];
            this.target = 0;
        }
        Compass.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Compass.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
            this.game.load.spritesheet('player', 'Graphics/Games/ZIP_G_III_10/ZIP_g_III_10_gracz.png', 21, 29, 4);
        };
        Compass.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
            this.cursors = this.game.input.keyboard.createCursorKeys();
        };
        Compass.prototype.create = function () {
            this.housesGroup = this.game.add.group();
            this.addChild(this.game.add.sprite(100, 0, 'mapa'));
            this.addChild(this.game.add.sprite(1350, 200, 'kompas'));
            this.houses[0] = this.game.add.sprite(860, 320, 'dom1');
            this.houses[1] = this.game.add.sprite(600, 440, 'dom2');
            this.houses[2] = this.game.add.sprite(800, 650, 'dom3');
            this.houses[3] = this.game.add.sprite(280, 440, 'dom4');
            this.houses[4] = this.game.add.sprite(280, 320, 'dom5');
            this.houses[5] = this.game.add.sprite(740, 70, 'dom6');
            this.houses[6] = this.game.add.sprite(900, 160, 'dom7');
            this.houses[7] = this.game.add.sprite(1190, 220, 'dom8');
            for (var i = 0; i < 8; i++)
                this.houses[i].anchor.setTo(0.5, 0.5);
            for (var i = 0; i < 8; i++)
                this.addChild(this.houses[i]);
            this.game.physics.startSystem(Phaser.Physics.ARCADE);
            this.player = this.game.add.sprite(670, 290, 'player');
            this.player.anchor.setTo(0.5, 0.5);
            this.player.animations.add('walk', [0, 1, 2, 3], 0, false);
            this.addChild(this.player);
            this.game.physics.enable(this.player, Phaser.Physics.ARCADE);
            for (var i = 0; i < 8; i++) {
                this.game.physics.enable(this.houses[i], Phaser.Physics.ARCADE);
                this.houses[i].body.immovable = true;
            }
            this.line = new Phaser.Line(this.player.x, this.player.y, this.houses[0].x, this.houses[0].y);
            this.dir = this.game.add.sprite(1562, 406, 'E');
            this.dir.anchor.setTo(0.5, 0.5);
            this.addChild(this.dir);
            this.ready = true;
        };
        Compass.prototype.update = function () {
            if (this.ready) {
                if (this.target == 8) {
                    EU.setGameCompletion(this.parent, 1);
                    EU.Log("Gra ukończona z sukcesem.");
                    _super.prototype.nextTask.call(this);
                    this.ready = false;
                }
                for (var i = 0; i < 8; i++)
                    if (this.game.physics.arcade.collide(this.player, this.houses[i])) {
                        if (this.target == i) {
                            this.houses[this.target].kill();
                            this.target++;
                            if (this.target != 8)
                                this.line.end = new Phaser.Point(this.houses[this.target].x, this.houses[this.target].y);
                        }
                    }
                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;
                if (this.line.angle >= -0.8 && this.line.angle < 0.8)
                    this.dir.loadTexture('E', 0, true);
                if (this.line.angle >= 0.8 && this.line.angle < 1.2)
                    this.dir.loadTexture('SE', 0, true);
                if (this.line.angle >= 1.2 && this.line.angle < 2)
                    this.dir.loadTexture('S', 0, true);
                if (this.line.angle >= 2 && this.line.angle < 2.4)
                    this.dir.loadTexture('SW', 0, true);
                if (this.line.angle >= 2.4 && this.line.angle < 3.2 || this.line.angle >= -3.2 && this.line.angle < -2.4)
                    this.dir.loadTexture('W', 0, true);
                if (this.line.angle >= -2.4 && this.line.angle < -2)
                    this.dir.loadTexture('NW', 0, true);
                if (this.line.angle >= -2 && this.line.angle < -1.2)
                    this.dir.loadTexture('N', 0, true);
                if (this.line.angle >= -1.2 && this.line.angle < -0.8)
                    this.dir.loadTexture('NE', 0, true);
                if (this.line.length > 50)
                    this.dir.tint = 0xffffff;
                if (this.line.length > 100)
                    this.dir.tint = 0xffbbbb;
                if (this.line.length > 200)
                    this.dir.tint = 0xff8888;
                if (this.line.length > 300)
                    this.dir.tint = 0xff4444;
                if (this.line.length > 400)
                    this.dir.tint = 0xff0000;
                if (this.cursors.left.isDown && this.player.x > 180) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.x = -100;
                    if (this.player.body.moves != false)
                        this.player.animations.frame = 3;
                }
                else if (this.cursors.right.isDown && this.player.x < 1250) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.x = 100;
                    if (this.player.body.moves != false)
                        this.player.animations.frame = 2;
                }
                else if (this.cursors.up.isDown && this.player.y > 50) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.y = -100;
                    if (this.player.body.moves != false)
                        this.player.animations.frame = 1;
                }
                else if (this.cursors.down.isDown && this.player.y < 620) {
                    this.line.start = new Phaser.Point(this.player.x, this.player.y);
                    this.player.body.velocity.y = 100;
                    if (this.player.body.moves != false)
                        this.player.animations.frame = 0;
                }
                else
                    this.player.animations.stop();
            }
        };
        return Compass;
    })(Base.BasicGroup);
    _Compass.Compass = Compass;
})(Compass || (Compass = {}));
//# sourceMappingURL=Compass.js.map