/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("grammar.js");

GrammarItem = function()
{
	this.key = null;
	this.description = null;
	this.visible = true;
};

GrammarItem.prototype.free = function()
{
	this.key = null;
	this.description = null;
	this.visible = true;
};

Grammar = function()
{
	this.items = new Array();
	this.filter = "";
};

Grammar.prototype.add = function(key, desc, links)
{
	var result = false;
	if (typeof(key) != "undefined" && key != ""
			&& typeof(desc) != "undefined") {
		var index = this.items.length;
		this.items[index] = new GrammarItem();
		this.items[index].key = key;
		this.items[index].description = desc;
		if (links != "") {
			this.items[index].links = links.split(",");
		} else {
			this.items[index].links = new Array();
		};
		result = true;
	};
	return result;
};

Grammar.prototype.setActiveKey = function(value)
{
	if (value && value != "") {
		var gram_tree_comp = page.getElementsType("componentGrammarTree");
		for (var i=0; i<gram_tree_comp.length; i++) {
			var comp = gram_tree_comp[i];
			comp.setKey(value);
		};
	};
};

Grammar.prototype.free = function()
{
	for (var i=0; i<this.items.length; i++) {
		var item = this.items[i];
		item.free();
		item = null;
	};
};

grammar = new Grammar();
