/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentSLWtree = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);
	
	this.treeCreated = false;
	this.pagesArr = new Array();
	this.oldPageMarked = null;
	
	this.menu = "";
};

componentSLWtree.prototype = new __componentText();
componentSLWtree.prototype.type = "__componentText";

componentSLWtree.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.obj.dir=this.dir;
};

componentSLWtree.prototype.onShow = function()
{
	var treePagesArr = this.treeStruct.split('#!#');
	this.menu = "";
	var fontSize = getFontSize(this.fontSize, 'px');
	var root = new SLWTreePageItem(
					this.id,
					0, //page index
					-1, //parent 
					'root',//title
					'none',//icon
					this.resourcesURL,
					this.plusSrc,//plus
					this.minusSrc,//minus
					this.fontFamily,
					fontSize,
					this.fontColor
				);
	
	this.pagesArr['0'] = root;
	
	for (var i=0; i < treePagesArr.length; i++)
	{
		var actionArr = treePagesArr[i].split('$#$')
		var pageElemArr = actionArr[2].split('||')		
 		var item = new SLWTreePageItem(
						this.id,
						eval(i+1), //page index
						pageElemArr[0], //parent 
						pageElemArr[pageElemArr.length-1],//title
						pageElemArr[pageElemArr.length-2].replace('icon=', ''),//icon
						actionArr[1],//action
						this.resourcesURL,
						this.plusSrc,//plus
						this.minusSrc,//minus
						this.blankIcon,//minus
						this.fontFamily,
						fontSize,
						this.fontColor
					);	
		this.addChildToParent(pageElemArr[0], item);
		this.pagesArr[eval(i+1)] = item;
	};	
	
	for (var i in this.pagesArr)
	{
		if (this.pagesArr[i] && this.pagesArr[i].rootParent){
			this.menu += this.pagesArr[i].toString();
		};
	};	
	
	this.obj.innerHTML = this.menu;
	this.obj.style.cssText += '; overflow: auto;';
}

componentSLWtree.prototype.addChildToParent = function( parentIndex, child )
{
	var item = this.pagesArr[parentIndex];
	
	if (item){
		item.children.push(child);
		item.open =  true;
		child.haveParent = true;
		child.parentObj = item;
		child.rootParent = (item.title == 'root');
	}else{
		child.haveParent = false;
	};
}

componentSLWtree.prototype.focus = function( ID, elemId )
{	
	if (this.oldPageMarked){
		this.oldPageMarked.style.background = 'transparent';
	};
	
	var span = document.getElementById( ID );
	if (span) {
		span.style.background = this.focusBckgColor;
		span.style.color = '#000000';
		this.oldPageMarked = span;
	};
	
	try{
		eval('pc.'+this.pagesArr[elemId].action+';');
	}catch(e){}
}

componentSLWtree.prototype.mouseOver = function( ID )
{	
	var span = document.getElementById(ID);
	if (span) {
		span.style.textDecoration = 'underline';
		if (!this.oldPageMarked){
			span.style.color = this.focusFontColor;
		}else if (ID != this.oldPageMarked.id){
			span.style.color = this.focusFontColor;
		}
	};
}

componentSLWtree.prototype.mouseOut = function( ID )
{	
	var span = document.getElementById(ID);
	if (span) {
		span.style.textDecoration = 'none';
		span.style.color = this.fontColor
	};
}

function SLWTreePageItem(compName, index, parentIndex, title, icon, action, resourcesURL, plusIcon,  minusIcon, blankIcon, fontFamily, fontSize, fontColor )
{
	this.id = compName+'-item-'+index;
	this.compName = compName;
	this.shortId = index;
	this.index = index;
	this.parentIndex = parentIndex;
	this.title = title;
	this.haveParent = false;
	this.parentObj = null;
	this.open = false;
	this.rootParent = false;
	this.action = action;
	
	this.resourcesURL = resourcesURL;
	this.icon = icon;
	this.plusIcon = plusIcon;
	this.minusIcon = minusIcon;
	this.blankIcon = blankIcon;
	
	this.fontFamily = fontFamily;
	this.fontSize = fontSize;
	this.fontColor = fontColor;
	
	this.children = new Array();
};

SLWTreePageItem.prototype.expand = function ()
{
	var obj = document.getElementById(this.id+'-cont');
	var objSrc = document.getElementById(this.id+'-indent');
	
	if (obj){
		obj.style.display = "block";
		this.open = false;
	};
	if (objSrc){
		objSrc.src = this.resourcesURL + this.minusIcon;
	};
};

SLWTreePageItem.prototype.collapse = function ()
{
	var obj = document.getElementById(this.id+'-cont');
	var objSrc = document.getElementById(this.id+'-indent');
	
	if (obj){
		obj.style.display = "none";
		this.open = true;
	};
	if (objSrc){
		objSrc.src = this.resourcesURL + this.plusIcon;
	};	
};

SLWTreePageItem.prototype.expandCollapse = function ()
{
	if (this.open){
		this.expand();		
	}else{
		this.collapse();
	};
};

SLWTreePageItem.prototype.toString = function ()
{
	var myParent = this.parentObj;
	myParent = myParent.parentObj;
	
	var expandStr = '';
	var extraAction = '';
	var indent = '';
	var str = '';
	str = '<p id="' + this.id + '-focus" style="white-space: nowrap;">';
		
	while (myParent) {
		myParent = myParent.parentObj;
		indent = "<img src=\"" + this.resourcesURL + this.blankIcon + "\">" + indent;
	};
	
	if (this.children.length > 0){
		expandStr += "<img id=\"" + this.id + "-indent\" onclick=\"page.all['"+this.compName+"'].pagesArr["+this.index+"].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
		extraAction = "page.all['"+this.compName+"'].pagesArr["+this.index+"].expandCollapse();";
	}else{
		expandStr += "<img src=\"" + this.resourcesURL + this.blankIcon + "\">"
		extraAction = '';
	};
	
	str += indent;
	str += expandStr;
	str += "<img src=\"" + this.resourcesURL + this.icon + "\">&nbsp;";	
	str += "<span id=\"" + this.id + "-anchor\" style=\"font-family: "+this.fontFamily+"; font-size:"+this.fontSize+"; color: "+this.fontColor+";\" ";
	
	str += "onClick=\"page.all['"+this.compName+"'].focus( this.id , '"+this.shortId+"');"+extraAction+"\"";
	str += "onMouseover=\"page.all['"+this.compName+"'].mouseOver( this.id );\"";
	str += "onMouseout=\"page.all['"+this.compName+"'].mouseOut( this.id );\"";
	str += ">" + this.title + "</span>";
	
	if (this.children.length > 0){
		str += "<div id=\"" + this.id + "-cont\" style=\"position: relative; display: " + ((this.open) ? 'none' : 'block') + ";\">";
		for (var i = 0; i < this.children.length; i++) {
			str += this.children[i].toString();
		};
		str += "</div>";
	}
	str += "</p>";
	
	return str;
};


















