//
//  MenuLayer.m
//  ZlapKlienta
//
//  Created by Grako on 07/01/14.
//  Copyright 2014 AppSynthe. All rights reserved.
//

#import "MenuLayer.h"

#import "Globals.h"
#import "HelpLayer.h"
#import "LevelLayer.h"


@interface MenuLayer ()
{
    
}

@end

CCLabelTTF *label_menu[3];
CCSprite *sprite_menu_button[3];
int buttons_amount = 3;
int button_size[2] = {280, 80};
int menu_mode = 0;

@implementation MenuLayer

// Helper class method that creates a Scene with the LevelLayer as the only child.
+ (CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	MenuLayer *layer = [MenuLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
- (id) init
{
	// always call "super" init
	// Apple recommends to re-assign "self" with the "super's" return value
	if( (self = [super init]) ) {

        self.touchEnabled = YES;
        [self initMenu];
        score = 0;
	}
	return self;
}

- (void) initMenu
{
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    
    CCSprite * bg = [CCSprite spriteWithFile:@"bg_menu.png"];
    bg.position = ccp(winSize.width/2, winSize.height/2);
    [self addChild:bg];
    
    [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:@"menu_items.plist"];
    
    fd_luckiest.fontSize = 33;
    
    for (int i = 0; i < buttons_amount; i++) {
        sprite_menu_button[i] = [CCSprite spriteWithSpriteFrameName:@"menu_items/button_menu.png"];
        sprite_menu_button[i].position = ccp(winSize.width / 2, winSize.height / 2 - i * (button_size[1] + 15) + 10);
        sprite_menu_button[i].tag = i;
        [self addChild: sprite_menu_button[i]];
//        NSLog(@"button %i (%f, %f, %i, %i)", i, sprite_menu_button[i].position.x - button_size[0]/2, sprite_menu_button[i].position.y - button_size[1] / 2, button_size[0], button_size[1]);
        
        NSString *label_string;
        switch (i) {
            case 0: label_string = @"START"; break;
            case 1: label_string = @"POMOC"; break;
            case 2: label_string = @"TABELA WYNIKÓW"; break;
        }
        
        label_menu[i] = [CCLabelTTF labelWithString:NSLocalizedString(label_string, "") fontDefinition:fd_luckiest];
//        label_menu[i].dimensions = CGSizeMake(button_size[0] - 100, button_size[1]);
//        [fd_luckiest setLineBreakMode:UILineBreakModeWordWrap];
        [label_menu[i] setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
        [label_menu[i] enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
        label_menu[i].horizontalAlignment = kCCTextAlignmentCenter;
        label_menu[i].verticalAlignment = kCCVerticalTextAlignmentCenter;
        label_menu[i].position = ccp(sprite_menu_button[i].position.x, sprite_menu_button[i].position.y);

        [self addChild:label_menu[i]];
    }
}

- (void) menuAction:(int)action
{
    switch (action) {
        case 0:
            level_number = 0;
            [[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[LevelLayer scene]]];
            break;
        case 1:
            [[CCDirector sharedDirector] replaceScene:[CCTransitionCrossFade transitionWithDuration:0.5 scene:[HelpLayer scene:0]]];
            break;
        case 2:
            [[CCDirector sharedDirector] replaceScene:[CCTransitionCrossFade transitionWithDuration:0.5 scene:[HelpLayer scene:1]]];
            break;
    }
}

- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
    [self removeAllChildren];
	[super dealloc];
}

#pragma mark Touches

- (void) ccTouchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSLog(@"tacz bigan");
    UITouch* touch = [touches anyObject];
    CGPoint t = [touch locationInView: [touch view]];
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    t.y = winSize.height - t.y;
    
    for (CCSprite *this_sprite in self.children)
    {
        if (CGRectContainsPoint(this_sprite.boundingBox, t) && this_sprite.tag > -1)
        {
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/menu_click" ofType:@"mp3"]];
            CCCallBlockN * actionRunMenuAction = [CCCallBlockN actionWithBlock:^(CCNode *node) {[self menuAction:this_sprite.tag];}];
            [label_menu[this_sprite.tag] runAction:[CCSequence actions:[CCScaleTo actionWithDuration:.2 scale:.8f], [CCScaleTo actionWithDuration:.2 scale:1.0f], nil]];
            [self runAction:[CCSequence actions: [CCDelayTime actionWithDuration:.2], actionRunMenuAction, nil]];
        }
    }
}


@end
