//
//  HelpLayer.m
//  ZlapKlienta
//
//  Created by Grako on 08/01/14.
//  Copyright 2014 AppSynthe. All rights reserved.
//

#import "HelpLayer.h"

#import "Globals.h"
#import "MenuLayer.h"
#import "libs/ASIHTTPRequest/ASIFormDataRequest.h"

CCLabelTTF *label_screen_text, *label_your_score, *label_score_names, *label_score_values;
CCSprite *sprite_button_close, *sprite_button_next, *sprite_button_prev;
int layer_mode, score_showing = 0, scoreIndex = 0, scoresPerPage = 10;
NSMutableArray *scores;

@implementation HelpLayer

+(CCScene *) scene:(int)mode
{
    layer_mode = mode; //0 - help, 1 - scores
    
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
    // 'layer' is an autorelease object.
	HelpLayer *layer = [HelpLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

//
-(id) init
{
	if( (self=[super init])) {
        
        NSLog(@"mode: %i", layer_mode);
        
        self.touchEnabled = TRUE;
        
        CGSize winSize = [[CCDirector sharedDirector] winSize];
        
        CCSprite * bg = [CCSprite spriteWithFile:@"bg_level.png"];
        bg.position = ccp(winSize.width/2, winSize.height/2);
        [self addChild:bg];
        
        [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:@"menu_items.plist"];
        
        CCSprite *sprite_table = [CCSprite spriteWithSpriteFrameName:@"menu_items/billboard.png"];
        sprite_table.position = ccp(winSize.width/2, winSize.height * .45);
        sprite_table.tag = 0;
        [self addChild:sprite_table];
        
        CCSprite *sprite_button_close = [CCSprite spriteWithSpriteFrameName:@"menu_items/button_close.png"];
        sprite_button_close.position = ccp(winSize.width * .94, winSize.height * .94);
        sprite_button_close.tag = 1;
        [self addChild:sprite_button_close];

        sprite_button_next = [CCSprite spriteWithSpriteFrameName:@"menu_items/arrow_right.png"];
        sprite_button_next.position = ccp(winSize.width * .85, winSize.height * .26);
        sprite_button_next.tag = 2;
        sprite_button_next.visible = FALSE;
        [self addChild:sprite_button_next];

        sprite_button_prev = [CCSprite spriteWithSpriteFrameName:@"menu_items/arrow_right.png"];
        sprite_button_prev.position = ccp(winSize.width * .20, winSize.height * .26);
        sprite_button_prev.tag = 3;
        sprite_button_prev.flipX = TRUE;
        sprite_button_prev.visible = FALSE;
        [self addChild:sprite_button_prev];

        NSString *label_screen_title_text;
        switch (layer_mode) {
            case 0: //help
                label_screen_title_text = NSLocalizedString(@"HELP", "");
                break;
            case 1: //scores
                label_screen_title_text = NSLocalizedString(@"HIGHSCORES", "");
                break;
        }
        
        [fd_luckiest setLineBreakMode:UILineBreakModeWordWrap];
        [fd_luckiest setAlignment:kCCTextAlignmentCenter];
        [fd_luckiest setVertAlignment:kCCVerticalTextAlignmentCenter];

        //label title
        [fd_luckiest setFontSize:33];
        [fd_luckiest setDimensions:CGSizeMake(winSize.width * .1, winSize.height * .2)];
        CCLabelTTF *label_screen_title = [CCLabelTTF labelWithString:label_screen_title_text fontDefinition:fd_luckiest];
        [label_screen_title setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
        [label_screen_title enableStrokeWithColor:ccc3(0,0,0) size:1 updateImage:YES];
        label_screen_title.position = ccp(winSize.width * .525, winSize.height * .73);
        [self addChild:label_screen_title z:10000];
        
        
        //label text
        [fd_luckiest setFontSize:22];
        [fd_luckiest setDimensions:CGSizeMake(winSize.width * .7, winSize.height * .4)];
        label_screen_text = [CCLabelTTF labelWithString:NSLocalizedString(@"", "") fontDefinition:fd_luckiest];
        [label_screen_text setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
        [label_screen_text enableStrokeWithColor:ccc3(0,0,0) size:1 updateImage:YES];
        label_screen_text.position = ccp(winSize.width * .525, winSize.height * .475);
        label_screen_text.tag = 0;
        [self addChild:label_screen_text z:10000];
        
        switch (layer_mode) {
            case 0:
                [self showHelpScreen:0];
                break;
            case 1:
                [fd_luckiest setFontSize:22];
                label_your_score = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"YOUR SCORE", ""), score] fontDefinition:fd_luckiest];
                [label_your_score setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
                [label_your_score enableStrokeWithColor:ccc3(0,0,0) size:1 updateImage:YES];
                label_your_score.position = ccp(winSize.width * .525, winSize.height * .3);
                if (score) [self addChild:label_your_score z:10000];
                [label_screen_text setString:NSLocalizedString(@"LOADING...", "")];
                

                [fd_luckiest setVertAlignment:kCCVerticalTextAlignmentTop];
                
                [fd_luckiest setAlignment:kCCTextAlignmentLeft];
                [fd_luckiest setDimensions:CGSizeMake(winSize.width * .2, winSize.height * .4)];
                label_score_names = [CCLabelTTF labelWithString:NSLocalizedString(@"", "") fontDefinition:fd_luckiest];
                [label_score_names setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
                [label_score_names enableStrokeWithColor:ccc3(0,0,0) size:1 updateImage:YES];
                label_score_names.position = ccp(winSize.width * .435, winSize.height * .515);
                [self addChild:label_score_names z:10000];

                [fd_luckiest setDimensions:CGSizeMake(winSize.width * .2, winSize.height * .4)];
                label_score_values = [CCLabelTTF labelWithString:NSLocalizedString(@"", "") fontDefinition:fd_luckiest];
                [label_score_values setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
                [label_score_values enableStrokeWithColor:ccc3(0,0,0) size:1 updateImage:YES];
                label_score_values.position = ccp(winSize.width * .635, winSize.height * .515);
                [self addChild:label_score_values z:10000];
                
                [self scoresDownload];
                break;
        }

	}
	
	return self;
}

- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
    [self removeAllChildren];
	[super dealloc];
}

- (void) scoresDownload
{
    __block ASIFormDataRequest *request;
    request = [ASIFormDataRequest requestWithURL:[NSURL URLWithString:@"http://ace-platforma.pl/ranking2.ashx"]];
    [request setValidatesSecureCertificate:NO];
    [request setTimeOutSeconds:10];
    [request setDelegate:self];
    
    //    [request setPostValue:@"1" forKey:@"update_date"];
    
    
    [request setRequestMethod:@"GET"];
    
    [request setCompletionBlock:^
     {
             if ([request responseStatusCode] != 200)
             {
                 NSLog(@"Could not send the message to the server");
             }
             else
             {
                 NSString *data = [request responseString];
//                 NSLog(@"data: %@", data);
                 NSArray *lines = [data componentsSeparatedByString:@";"];
                 NSMutableArray *scores_unsorted = [[NSMutableArray alloc] init];
                 scores = [[NSMutableArray alloc] init];
                 for (int i=0; i< [lines count]; i+=2) if ([[lines objectAtIndex:i] length]) {
                     NSDictionary *score_entry = [NSDictionary dictionaryWithObjectsAndKeys:
                                           [lines objectAtIndex:i], @"name",
                                           [NSNumber numberWithInt:[[lines objectAtIndex:i+1] integerValue]], @"score", nil];
                     [scores_unsorted addObject:score_entry];
                 }
                 
                 NSSortDescriptor *firstDescriptor =
                 [[NSSortDescriptor alloc] initWithKey:@"score"
                                             ascending:NO
                                              selector:@selector(compare:)];
                 NSArray *descriptors = [NSArray arrayWithObjects:firstDescriptor, nil];
                 NSArray *scores_sorted = [scores_unsorted sortedArrayUsingDescriptors:descriptors];
                 scores = [(NSArray*)scores_sorted mutableCopy];
//                 NSLog(@"scores_unsorted: %@", scores_unsorted);
//                 NSLog(@"scores_sorted: %@", scores_sorted);
                 
                 BOOL insertScore = FALSE;
                 for (int i=0; i<[scores count]; i++) {
                     if ([[[scores objectAtIndex:i] objectForKey:@"score"] integerValue] <= score) {
                         if (i < 100) {
                             insertScore = TRUE;
                             [self scoreInsert:i];
                         } else
                             NSLog(@" - NOT inserting score, cause it's out of top 100");
                         break; //anyway
                     }
                 }
                 
                 if (!insertScore) {
                     label_screen_text.opacity = 0;
                     [self showHelpScreen:2];
                 }

                 
//                 NSLog(@"scores after insert: %@", scores);

             }
     }];
    
    [request setFailedBlock:^
     {
             NSError *error = [request error];
             NSLog(@"Didn't download scores (%@)", error);
             [label_screen_text setString:NSLocalizedString(@"Błąd połączenia.", "")];
     }];
    
    [request startAsynchronous];
}

- (void) scoreInsert:(int)i
{
    scoreIndex = i;
    UIAlertView * alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"Gratulacje!", "") message:[NSString stringWithFormat:@"Zajmujesz %i pozycję w tabeli wynków. Podaj swoje imię:", scoreIndex] delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
    alert.alertViewStyle = UIAlertViewStylePlainTextInput;
    [alert show];
    [alert release];
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    NSString *player_name = [[alertView textFieldAtIndex:0] text];
    if ([player_name length]) {
        if ([player_name length] > 16) player_name = [player_name substringToIndex:16];
        NSDictionary *score_entry = [NSDictionary dictionaryWithObjectsAndKeys:
                                     player_name, @"name",
                                     [NSNumber numberWithInt:score], @"score", nil];
        [scores insertObject:score_entry atIndex:scoreIndex];
        score_showing = scoreIndex - 7;
        if (score_showing < 0) score_showing = 0;
        NSLog(@" - inserting score: %i, at index: %i", score, scoreIndex);
        [self scoreUpload:score_entry];
    }
    
    label_screen_text.opacity = 0;
    [self showHelpScreen:2];
}

- (void) scoreUpload:(NSDictionary*)score_entry
{
// http://ace-platforma.pl/save2.ashx?nick=ado2&lpkt=12563
    
    __block ASIFormDataRequest *request;
    request = [ASIFormDataRequest requestWithURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://ace-platforma.pl/save2.ashx?nick=%@&lpkt=%i",
                                                                       [score_entry objectForKey:@"name"], [[score_entry objectForKey:@"score"] integerValue]
                                                                       ]]];
    [request setValidatesSecureCertificate:NO];
    [request setTimeOutSeconds:10];
    [request setDelegate:self];
    [request setRequestMethod:@"POST"];
    
    [request setCompletionBlock:^
     {
         if ([request responseStatusCode] != 200)
         {
             NSLog(@"Could not send the message to the server");
         }
         else
         {
             NSString *data = [request responseString];
             NSLog(@"scoreUpload response: %@", data);
         }
     }];
    
    [request setFailedBlock:^
     {
         NSError *error = [request error];
         NSLog(@"Didn't download groups.txt (%@)", error);
     }];
    
    [request startAsynchronous];
}

- (void) menuAction:(int)action
{
    switch (action) {
        case 1:
            [[CCDirector sharedDirector] replaceScene:[CCTransitionCrossFade transitionWithDuration:0.5 scene:[MenuLayer scene]]];
            break;
        case 2:
            if (layer_mode) {
                score_showing += scoresPerPage;
                if (score_showing > [scores count] - scoresPerPage) score_showing = [scores count] - scoresPerPage;
                [self showHelpScreen:2];
            } else
                [self showHelpScreen:1];
            break;
        case 3:
            if (layer_mode) {
                score_showing -= scoresPerPage;
                if (score_showing < 0) score_showing = 0;
                [self showHelpScreen:2];
                
            } else
                [self showHelpScreen:0];
            break;
    }
}

- (void) showHelpScreen:(int)screen
{
    NSLog(@"showHelpScreen: %i", screen);
    
    int i = 0, iMax = 0;
    NSString *tekst = @"";
    NSString *text_names = @"";
    NSString *text_scores = @"";
    switch (screen) {
        case 0:
            tekst = @"Złap Klienta stawiając na jego drodze butiki,\n sklepy i galerie handlowe.\n\n Zatrzymaj klienta na dłużej stawiając przy drodze\n bannery reklamowe.\n\n Wszystkie budowle znajdują się na dolnym pasku ekranu.\nAby ustawić jedną z nich, przeciągnij ją palcem\n w wybrane miejsce. Opis każdej budowli znajdziesz\n w lewym okienku.\n\n";
            sprite_button_next.visible = TRUE;
            sprite_button_prev.visible = FALSE;
            break;

        case 1:
            tekst = @"Każdy poziom podzielony jest na 10 etapów, zwanych falami.\n\n Każdy klient, który opuści mapę, udaje się do konkurencji, \nzwiększając jej przychód.\n\nAby wygrać daną falę, osiągnij w niej większy przychód\n niż konkurencja. Różnicę pomiędzy Twoim zyskiem, \na zyskiem konkurencji pokazuje 'bilans fali'. \n\nPowodzenia!";
            sprite_button_next.visible = FALSE;
            sprite_button_prev.visible = TRUE;
            break;
        case 2:
            i = score_showing;
            iMax = score_showing + scoresPerPage;
            while (i < iMax && i < [scores count]) {
                text_names = [text_names stringByAppendingString:[NSString stringWithFormat:@"%i. %@\n", i + 1, [[scores objectAtIndex:i] objectForKey:@"name"]]];
                text_scores = [text_scores stringByAppendingString:[NSString stringWithFormat:@"%@\n", [[scores objectAtIndex:i] objectForKey:@"score"]]];
                i++;
            }
            [label_score_names setString:text_names];
            [label_score_values setString:text_scores];

            if (i == scoresPerPage) sprite_button_prev.visible = FALSE;
            else                    sprite_button_prev.visible = TRUE;
            
            if (i < [scores count]) sprite_button_next.visible = TRUE;
            else                    sprite_button_next.visible = FALSE;

            break;
        default:
            break;
    }

    [fd_luckiest setFontSize:22];
    [label_screen_text setString:tekst];
}

#pragma mark Touches

- (void) ccTouchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSLog(@"tacz bigan");
    UITouch* touch = [touches anyObject];
    CGPoint t = [touch locationInView: [touch view]];
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    t.y = winSize.height - t.y;
    
    for (CCSprite *this_sprite in self.children)
    {
        if (CGRectContainsPoint(this_sprite.boundingBox, t) && this_sprite.tag > 0 && this_sprite.visible)
        {
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/menu_click" ofType:@"mp3"]];
//            NSLog(@"this sprite tag = %i", this_sprite.tag);
            CCCallBlockN * actionRunMenuAction = [CCCallBlockN actionWithBlock:^(CCNode *node) {[self menuAction:this_sprite.tag];}];
            [this_sprite runAction:[CCSequence actions:[CCScaleTo actionWithDuration:.2 scale:.8f], [CCScaleTo actionWithDuration:.2 scale:1.0f], nil]];
            [self runAction:[CCSequence actions: [CCDelayTime actionWithDuration:.2], actionRunMenuAction, nil]];
        }
    }
}

@end
