//
//  IntroLayer.m
//  ZlapKlienta
//
//  Created by Grako on 10/12/13.
//  Copyright AppSynthe 2013. All rights reserved.
//


// Import the interfaces
#import "IntroLayer.h"

#import "HelpLayer.h"
#import "LevelLayer.h"
#import "MenuLayer.h"
#import "Globals.h"


#pragma mark - IntroLayer

// LevelLayer implementation
@implementation IntroLayer

// Helper class method that creates a Scene with the LevelLayer as the only child.
+(CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	IntroLayer *layer = [IntroLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// 
-(id) init
{
	if( (self=[super init])) {

//        NSArray *familyNames = [UIFont familyNames];
//        for (NSString *aFamilyName in familyNames) {
//            NSArray *fontNames = [UIFont fontNamesForFamilyName:aFamilyName];
//            for (NSString *aFontName in fontNames) {
//                NSLog(@"%@", aFontName);
//            }
//        }
        
        fd_luckiest = [[CCFontDefinition alloc] init];
        [fd_luckiest setFontName:@"LuckiestGuy-Regular"];
        [fd_luckiest setFontSize:22];
        //    [fd_luckiest setAlignment:kCCTextAlignmentLeft];
        //    [fd_luckiest setVertAlignment:kCCVerticalTextAlignmentTop];
        
        fd_mclaren = [[CCFontDefinition alloc] init];
        [fd_mclaren setFontName:@"McLaren-Regular"];
        [fd_mclaren setFontSize:22];

        [[SimpleAudioEngine sharedEngine] playBackgroundMusic:[[NSBundle mainBundle] pathForResource:@"SFX/music" ofType:@"mp3"] loop:YES];
    }
	
	return self;
}

-(void) onEnter
{
	[super onEnter];
	[[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[MenuLayer scene] ]];
//	[[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[LevelLayer scene] ]];
//	[[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[HelpLayer scene:1] ]];
}

- (void) dealloc {
    [super dealloc];
}

@end
