//
//  LevelLayer.m
//  ZlapKlienta
//
//  Created by Grako on 10/12/13.
//  Copyright AppSynthe 2013. All rights reserved.
//


// Import the interfaces
#import "LevelLayer.h"

#import "Globals.h"
#import "HelpLayer.h"
#import "MenuLayer.h"

@interface LevelLayer ()
{
    BOOL isPanelItemMoving;
    CCSprite *spriteLevelMap[8][19];
    CCSprite *spritePanelItem[10]; // (0-7) buildings, 8) border, 9) item_moving
    CCSprite *spriteCircle;
    CCLabelTTF *labelBalance, *labelMoney ,*labelScore, *labelMenu;
    CCLabelTTF *labelWave, *labelCost, *labelRange, *labelPower,  *labelFireRate, *labelDescription;
    CCAnimation *anim_hero_walk[10];
    int levelMap[8][19];
    int level_time_tick;
    int spawn_index;
    int wave_balance;
    NSMutableArray *buildingArray;
    NSMutableArray *hero;
    NSArray *hero_name;
}

@property (nonatomic, strong) CCSprite *buildings;
@property (nonatomic, strong) CCAction *moveAction, *walkAction;
//@property (nonatomic, strong) CCLabelTTFWithStroke *labelMoney;

@end



#pragma mark - LevelLayer

// LevelLayer implementation
@implementation LevelLayer

// Helper class method that creates a Scene with the LevelLayer as the only child.
+ (CCScene *) scene
{
	// 'scene' is an autorelease object.
	CCScene *scene = [CCScene node];
	
	// 'layer' is an autorelease object.
	LevelLayer *layer = [LevelLayer node];
	
	// add layer as a child to scene
	[scene addChild: layer];
	
	// return the scene
	return scene;
}

// on "init" you need to initialize your instance
- (id) init
{
	// always call "super" init
	// Apple recommends to re-assign "self" with the "super's" return value
	if( (self = [super init]) ) {

        self.touchEnabled = YES;
        hero = [[NSMutableArray alloc] init];
        hero_name = [[NSArray alloc] initWithObjects:@"0) solo", @"1) rodzinka", @"2) staruszka", @"3) samochod", @"4) deskarz", @"5) garniak", @"6) wycieczka", @"7) turysta", nil];
        level_time_tick = 0;
        wave_number = -1;

        // ----- cut all this -----
//        level_number = 2;
//        wave_number = 8;
        //        money = 500;
        // ------------------------

        money = level_money[level_number];
        spawn_index = 0;
        
        if (!level_number) {
            score = 0;
        }
        [self initLevel];
        [self levelLabelAndAction:1];
        [self schedule:@selector(heroZorder) interval:.1];
	}
	return self;
}

- (void) initLevel
{
    CGSize winSize = [[CCDirector sharedDirector] winSize];

    CCSprite * bg = [CCSprite spriteWithFile:@"bg_level.png"];
    bg.position = ccp(winSize.width/2, winSize.height/2);
    [self addChild:bg];

    [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:@"level_items.plist"];
    
    CCSprite * level_panel = [CCSprite spriteWithFile:@"level_panel.png"];
    level_panel.position = ccp(winSize.width/2, [level_panel boundingBox].size.height/2);
    [self addChild:level_panel];
 
    //draw panel items + active border + item moving
    [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:@"panel_items.plist"];
    for (int i = 0; i < buildings_amount + 1; i++) {
        spritePanelItem[i] = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"panel_items/%i.png", i]];
        spritePanelItem[i].position = ccp(panel_items_pos[0] + i * panel_items_pos[2], panel_items_pos[1]);
        [self addChild:spritePanelItem[i]];
    }
    
    [self panelItemsUpdate];
    [self panelItemSelect:0];
    
    
    [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:@"buildings.plist"];

    //draw road
        for (int y = 0; y < map_y_size; y++) {
            for (int x = 0; x < map_x_size; x++) {
                if (levels_maps[level_number][y][x] == 1) {
                    spriteLevelMap[y][x] = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"buildings/building%i.png", levels_maps[level_number][y][x]]];
                    spriteLevelMap[y][x].position = ccp(levelX + x * tile_size + building_margin[levels_maps[level_number][y][x] - 1][0],
                                                          levelY + y * tile_size + building_margin[levels_maps[level_number][y][x] - 1][1]);
                    spriteLevelMap[y][x].flipX = arc4random() % 2;
                    spriteLevelMap[y][x].flipY = arc4random() % 2;
                    spriteLevelMap[y][x].rotation = arc4random() % 4 * 90;

                    [self addChild:spriteLevelMap[y][x] z:1];//(map_y_size - y) * 1000 + x];
                    levelMap[y][x] = levels_maps[level_number][y][x];
                }
            }
        }
    //draw buildings
    for (int y = map_y_size - 1; y >= 0; y--) {
        for (int x = 0; x < map_x_size; x++) {
            if (levels_maps[level_number][y][x] > 1) {
                spriteLevelMap[y][x] = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"buildings/building%i.png", levels_maps[level_number][y][x]]];
                spriteLevelMap[y][x].position = ccp(levelX + x * tile_size + building_margin[levels_maps[level_number][y][x] - 1][0],
                                                    levelY + y * tile_size + building_margin[levels_maps[level_number][y][x] - 1][1]);
                [self addChild:spriteLevelMap[y][x] z:(map_y_size - y) * 1000 + x];
                levelMap[y][x] = levels_maps[level_number][y][x];
                [self buildingAction:[NSArray arrayWithObjects:[NSNumber numberWithInt:x], [NSNumber numberWithInt:y], nil]];
            }
        }
    }

    NSMutableArray * walkAnimFrames;
    for (int i = 0; i < heroes_amount; i++) {
        [[CCSpriteFrameCache sharedSpriteFrameCache] addSpriteFramesWithFile:[NSString stringWithFormat:@"hero%i.plist", i]];
//        CCSpriteBatchNode *spriteSheet_hero = [CCSpriteBatchNode batchNodeWithFile:[NSString stringWithFormat:@"hero%i.png", i]];
        walkAnimFrames = [[NSMutableArray alloc] init];
        for (int j=1; j<=hero_data[i][2]; j++)
            [walkAnimFrames addObject:[[CCSpriteFrameCache sharedSpriteFrameCache] spriteFrameByName:[NSString stringWithFormat:@"hero%i/%d.png", i, j]]];
        
        anim_hero_walk[i] = [CCAnimation animationWithSpriteFrames:walkAnimFrames delay: (hero_data[i][4] * .01)];
        [anim_hero_walk[i] retain];
        [walkAnimFrames release];
    }
    
    //labels
    [fd_luckiest setFontSize:22];
    labelMoney = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"$ %i", money] fontDefinition:fd_luckiest];
    labelMoney.anchorPoint = CGPointZero;
    [labelMoney setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelMoney enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelMoney.position = ccp(winSize.width * .045, winSize.height - winSize.height * .05);
    [self addChild:labelMoney z:10000];

    labelScore = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"SCORE", ""), score] fontDefinition:fd_luckiest];
    [labelScore setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelScore enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelScore.anchorPoint = CGPointZero;
    labelScore.position = ccp(winSize.width * .045, winSize.height - winSize.height * .09);
    [self addChild:labelScore z:10000];

    labelBalance = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"WAVE BALANCE", ""), wave_balance] fontDefinition:fd_luckiest];
    [labelBalance setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelBalance enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelBalance.anchorPoint = CGPointZero;
    labelBalance.position = ccp(winSize.width * .045, winSize.height - winSize.height * .13);
    [self addChild:labelBalance z:10000];
    
    [fd_luckiest setFontSize:66];
    labelWave = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%@\n%i / %i", NSLocalizedString(@"WAVE", ""), wave_number + 1, level_waves] fontDefinition:fd_luckiest];
    [labelWave setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelWave enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelWave.horizontalAlignment = kCCTextAlignmentCenter;
    labelWave.verticalAlignment = kCCTextAlignmentCenter;
    labelWave.position = ccp(winSize.width * .5, winSize.height * 1.1); //- winSize.height * .06);
    labelWave.scale = .33;
    [self addChild:labelWave z:10000];
    
    [fd_luckiest setFontSize:13];
    
    labelCost = [CCLabelTTF labelWithString:NSLocalizedString(@"COST", "") fontDefinition:fd_luckiest];
    [labelCost setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelCost enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelCost.horizontalAlignment = kCCTextAlignmentCenter;
    labelCost.verticalAlignment = kCCTextAlignmentCenter;
    labelCost.position = ccp(winSize.width * .045, winSize.height * .114);
    [self addChild:labelCost z:10000];
    labelCost = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"$ %i", building_cost[0]] fontDefinition:fd_luckiest];
    labelCost.position = ccp(winSize.width * .0966, winSize.height * .114);
    [self addChild:labelCost z:10000];
    
    labelRange = [CCLabelTTF labelWithString:NSLocalizedString(@"RANGE", "") fontDefinition:fd_luckiest];
    [labelRange setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelRange enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelRange.horizontalAlignment = kCCTextAlignmentCenter;
    labelRange.verticalAlignment = kCCTextAlignmentCenter;
    labelRange.position = ccp(winSize.width * .045, winSize.height * .0807);
    [self addChild:labelRange z:10000];
    labelRange = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%i", building_range[0]] fontDefinition:fd_luckiest];
    labelRange.position = ccp(winSize.width * .0966, winSize.height * .0807);
    [self addChild:labelRange z:10000];
    
    labelPower = [CCLabelTTF labelWithString:NSLocalizedString(@"POWER", "") fontDefinition:fd_luckiest];
    [labelPower setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelPower enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelPower.horizontalAlignment = kCCTextAlignmentCenter;
    labelPower.verticalAlignment = kCCTextAlignmentCenter;
    labelPower.position = ccp(winSize.width * .1621, winSize.height * .114);
    [self addChild:labelPower z:10000];
    labelPower = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%i", building_power[0]] fontDefinition:fd_luckiest];
    labelPower.position = ccp(winSize.width * .213, winSize.height * .114);
    [self addChild:labelPower z:10000];
    
    labelFireRate = [CCLabelTTF labelWithString:NSLocalizedString(@"FIRE RATE", "") fontDefinition:fd_luckiest];
    [labelFireRate setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelFireRate enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelFireRate.horizontalAlignment = kCCTextAlignmentCenter;
    labelFireRate.verticalAlignment = kCCTextAlignmentCenter;
    labelFireRate.position = ccp(winSize.width * .1600, winSize.height * .0807);
    [self addChild:labelFireRate z:10000];
    labelFireRate = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%i", building_fire_rate[0]] fontDefinition:fd_luckiest];
    labelFireRate.position = ccp(winSize.width * .213, winSize.height * .0807);
    [self addChild:labelFireRate z:10000];
    
    [fd_mclaren setFontSize:11];
    [fd_mclaren setLineBreakMode:UILineBreakModeWordWrap];
    [fd_mclaren setAlignment:kCCTextAlignmentLeft];
    [fd_mclaren setVertAlignment:kCCVerticalTextAlignmentTop];
    [fd_mclaren setDimensions:CGSizeMake(215,42)];
    labelDescription = [CCLabelTTF labelWithString:NSLocalizedString(@"Butik – zaspokaja w średnim tempie małą klientelę ", "") fontDefinition:fd_mclaren];
//    labelDescription.dimensions = CGSizeMake(215,30);
    labelDescription.anchorPoint = CGPointZero;
    [labelDescription setFontFillColor:ccc3(255, 255, 255) updateImage:NO];
//    [labelDescription enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelDescription.position = ccp(winSize.width * .025, winSize.height * .005);
    [self addChild:labelDescription z:10000];
    
    [fd_luckiest setFontSize:28];
    labelMenu = [CCLabelTTF labelWithString:NSLocalizedString(@"MENU", "") fontDefinition:fd_luckiest];
    labelMenu.anchorPoint = CGPointZero;
    [labelMenu setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelMenu enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelMenu.position = ccp(winSize.width * .895, winSize.height * .047);
    [self addChild:labelMenu z:10000];
}

// on "dealloc" you need to release all your retained objects
- (void) dealloc
{
	// in case you have something to dealloc, do it in this method
	// in this particular example nothing needs to be released.
	// cocos2d will automatically release all the children (Label)
	
	// don't forget to call "super dealloc"
    [self removeAllChildren];
	[super dealloc];
}

#pragma mark Gameplay Voids

- (void) buildingAction:(NSArray *)map_xy
{
    bool isBanner = FALSE;
    int chosen = FALSE;
    CGFloat delay_multipler = 1;
    CGFloat money_multiplier = 1;
    int map_x = [[map_xy objectAtIndex:0] integerValue];
    int map_y = [[map_xy objectAtIndex:1] integerValue];
    CGFloat delay = building_fire_rate[(levelMap[map_y][map_x] - 2)] * .5;
//    NSLog(@"- buildingAction (x: %i | y:%i) [hero count:%i] delay: %f | fire_rate = %i -", map_x, map_y, [hero count], delay, building_fire_rate[levelMap[map_y][map_x] - 2]);
    if ((levelMap[map_y][map_x] - 2) == 6) isBanner = TRUE;
    if (map_x && [hero count] && ((levelMap[map_y][map_x] - 2) < 3 || isBanner)) { //if there are heroes to check && building is a shop or billboard
        //choose one unit in its radius
        int hero_index = 0, hero_delay;
        while (!chosen && hero_index < [hero count]) {
            int hero_x = [[[hero objectAtIndex:hero_index] objectForKey:@"next_map_x"] integerValue];
            int hero_y = [[[hero objectAtIndex:hero_index] objectForKey:@"next_map_y"] integerValue];
            hero_delay = [[[hero objectAtIndex:hero_index] objectForKey:@"delay"] integerValue];

            if ((abs(hero_x - map_x) < 2 && abs(hero_y - map_y) < 2) && ((isBanner && !hero_delay) || !isBanner)) //hero in range && (hero can be delayed || not a banner)
//                if
                    chosen = TRUE;
                else
                    hero_index++;
            
        }

//        NSLog(@" after a while chosen = %@, hero_index = %i", chosen ? @"YES" : @"NO", hero_index);
        
        if (chosen) {
            //search for storehouses and backoffices
            for (int building_kind = 4; building_kind < 8; building_kind ++) { //check |4) storehouse |5) marketing |6) NIL |7) backoffice
                int fbr = building_range[building_kind]; //farthest building range
                int x_l_margin = map_x - fbr; if (x_l_margin < 0) x_l_margin = 0;
                int x_r_margin = map_x + fbr; if (x_r_margin > map_x_size - 1) x_r_margin = map_x_size - 1;
                int y_l_margin = map_y - fbr; if (y_l_margin < 0) y_l_margin = 0;
                int y_r_margin = map_y + fbr; if (y_r_margin > map_y_size - 1) y_r_margin = map_y_size - 1;
//                NSLog(@"  - checking for fbr: %i [%i-%i, %i-%i]", fbr, x_l_margin, x_r_margin, y_l_margin, y_r_margin);
                
                //search for booster in building area
                if (building_kind != 6) //all in array except billboard
                for (int x = x_l_margin; x <= x_r_margin; x++) {
                    for (int y = y_l_margin; y <= y_r_margin; y++) {
                        int dX = abs(x - map_x);
                        int dY = abs(y - map_y);
                        if ((levelMap[y][x] == (building_kind + 2)) && ( (!dX && dY <= fbr) || (!dY && dX <= fbr) || (dX + dY <= fbr + 1) )) // correct_building && (range in straight line || x+y = range+1)
                        {
                            switch (building_kind) {
                                case 4: money_multiplier += .20; /*NSLog(@"    - found storehouse [%i, %i], money_multiplier: %f", x, y, money_multiplier);*/ break;
                                case 5: if (chosen) delay_multipler -= .25; if (delay_multipler <= 0) delay_multipler = 0.1; /*NSLog(@"    - found marketing  [%i, %i], delay_multiplier: %f", x, y, delay_multipler);*/ break;
                                case 7: delay_multipler -= .15; if (delay_multipler <= 0) delay_multipler = 0.1; /*NSLog(@"    - found backoffice [%i, %i], delay_multiplier: %f", x, y, delay_multipler);*/ break;
                                default: break;
                            }
                        }
                        
                    }
                }
            }
            
            int tag = [[[hero objectAtIndex:hero_index] objectForKey:@"tag"] integerValue];
            int kind = [[[hero objectAtIndex:hero_index] objectForKey:@"kind"] integerValue];
            CCNode *this_hero = [self getChildByTag:tag];
            CCNode *this_energy_full = [self getChildByTag:2000 + tag];
            CCNode *this_energy_empty = [self getChildByTag:1000 + tag];
            
            //if it's a banner
            if (isBanner) {
//                NSLog(@"bef hero_delay = %i", hero_delay);
                if (!hero_delay) {
                    switch (kind) {
                        case 0: case 3:             [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_man_1" ofType:@"mp3"]]; break;
                        case 5: case 7:             [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_man_2" ofType:@"mp3"]];break;
                        case 2:                     [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_grandma" ofType:@"mp3"]];break;
                        case 4:                     [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_kid" ofType:@"mp3"]];break;
                        case 1:                     [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_female_2" ofType:@"mp3"]];break;
                        case 6:                     [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/wow_female_1" ofType:@"mp3"]];break;
                    }
//                    NSLog(@"  - is zero so will equal 3");
                    hero_delay = 3;
                    [[hero objectAtIndex:hero_index] setObject:[NSNumber numberWithInt:hero_delay] forKey:@"delay"];
//                    //show ! icon
                    CCSprite *spriteNotice = [CCSprite spriteWithSpriteFrameName:@"level_items/notice.png"];
                    spriteNotice.position = ccp(this_hero.position.x, this_hero.position.y + 40);
                    spriteNotice.scale = .75f;
                    CCCallBlockN * actionNoticeDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[spriteNotice removeFromParent];}];
                    CCAction *noticeFadeOut = [CCFadeTo actionWithDuration:0.5 opacity:0];
                    [self addChild:spriteNotice z:10999];
                    [spriteNotice runAction:[CCSequence actions:[CCDelayTime actionWithDuration:0.5], noticeFadeOut, actionNoticeDone, nil]];
                    [this_hero stopActionByTag:0];
                    [this_energy_empty stopActionByTag:0];
                    [this_energy_full stopActionByTag:0];
                    [self heroNextMove:tag isChange:YES];
                }
                
            } else {
            
                //earn money
                int earnings = building_power[levelMap[map_y][map_x] - 2] * money_multiplier;
//                NSLog(@"  - eargnins: %i", earnings);
                int hero_money = [[[hero objectAtIndex:hero_index] objectForKey:@"money"] integerValue];
                if (hero_money < earnings) {earnings = hero_money; hero_money = 0;} else {hero_money -= earnings;}
                [[hero objectAtIndex:hero_index] setObject:[NSNumber numberWithInt:hero_money] forKey:@"money"];
                if (earnings) {
                    money += earnings;
                    score += earnings * score_multiplier;
                    wave_balance += earnings;
                    [self panelItemsUpdate];
                    [labelMoney setString:[NSString stringWithFormat:@"$ %i", money]];
                    [labelScore setString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"SCORE", ""), score]];
                    [self updateWaveBalace];
                }
                this_energy_full.scaleX = (float)hero_money / (float)hero_data[kind][6];
                this_energy_full.anchorPoint = CGPointMake(0.5f + ((1 - this_energy_full.scaleX) * .5f) * (this_energy_empty.scaleX *.95) / this_energy_full.scaleX, 0);
                //earning animation
                if (earnings) {
                    [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/money" ofType:@"mp3"]];
                    [fd_luckiest setFontSize:18];
                    CCLabelTTF *labelEarnings = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"$ %i", earnings] fontDefinition:fd_luckiest];
                    labelEarnings.horizontalAlignment = kCCTextAlignmentCenter;
                    labelEarnings.verticalAlignment = kCCTextAlignmentCenter;
                    [labelEarnings setFontFillColor:ccc3(0, 255, 0) updateImage:NO];
                    [labelEarnings enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
                    labelEarnings.position = ccp(this_hero.position.x, this_hero.position.y);
                    CCMoveTo *actionMove = [CCMoveTo actionWithDuration:1.5 position:ccp(levelX + map_x * tile_size, levelY + map_y * tile_size)];
                    CCCallBlockN * actionMoveDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[labelEarnings removeFromParent];}];
                    CCSequence *earnSequence = [CCSequence actions:actionMove, actionMoveDone, nil];
                    CCAction *earnFadeOut = [CCFadeTo actionWithDuration:0.5 opacity:0];
                    [self addChild:labelEarnings z:11000];
                    [labelEarnings runAction:[CCSequence actions:[CCDelayTime actionWithDuration:1.0], earnFadeOut, nil]];
                    [labelEarnings runAction:[CCEaseIn actionWithAction:earnSequence rate:1.5]];
                }
                if (!hero_money) { //remove broke hero
                    CCFiniteTimeAction *heroFadeOut = [CCFadeTo actionWithDuration:1.0 opacity:0];
                    CCCallBlockN * actionHeroDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {
                        for (int i=0; i<[hero count]; i++) if ([[[hero objectAtIndex:i] objectForKey:@"tag"] integerValue] == this_hero.tag) {
                            [self heroRemove:i];
                        }
                    }];
                    [this_hero runAction:[CCSequence actions:heroFadeOut, actionHeroDone, nil]];

//                    CCFiniteTimeAction *walletFadeOut = [CCFadeTo actionWithDuration:1.0 opacity:0];
                    CCCallBlockN * actionEnergyDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[this_energy_full removeFromParent]; [this_energy_empty removeFromParent];}];
                    [this_energy_empty runAction:[CCSequence actions:[CCFadeTo actionWithDuration:1.0 opacity:0], nil]];
                    [this_energy_full runAction:[CCSequence actions:[CCFadeTo actionWithDuration:1.0 opacity:0], actionEnergyDone, nil]];
                }
            } // else than banner
        } // if chosen
    } // if [hero count] && buliding has direct actions on heroes
    
    if (!chosen) delay = 0.1;
    if (delay) {
        NSArray *argArray = [NSArray arrayWithObjects:[NSNumber numberWithInt:map_x], [NSNumber numberWithInt:map_y], nil];
//        [self performSelector:@selector(buildingAction:) withObject:argArray afterDelay:delay * delay_multipler];
        
        CCCallBlockN * actionBuildingAction = [CCCallBlockN actionWithBlock:^(CCNode *node) {[self buildingAction:argArray];}];
        [self runAction:[CCSequence actions:[CCDelayTime actionWithDuration:delay * delay_multipler], actionBuildingAction, nil]];
        
    }
//    NSLog(@"= buildingAction (money_multiplier: %f [money=%i | delay_multipler: %f [delay=%f]) =", money_multiplier, money, delay_multipler, delay * delay_multipler);

}

- (void) panelItemsUpdate
{
    for (int i = 0; i < buildings_amount; i++) {
        if (money < building_cost[i]) {
            panel_item_available[i] = false;
            spritePanelItem[i].visible = false;
        } else {
            panel_item_available[i] = true;
            spritePanelItem[i].visible = true;
        }
//        NSLog(@"panel_item %i visible: %@", i, panel_item_available[i] ? @"YES" : @"NO");
    }
    [labelMoney setString:[NSString stringWithFormat:@"$ %i", money]];
}

- (void) panelItemSelect:(int)item_selected
{
    panel_item_active = item_selected;
    NSLog(@"panel_item_active: %i", panel_item_active);
    
    spritePanelItem[8].position = ccp(panel_items_pos[0] + item_selected * panel_items_pos[2], panel_items_pos[1]);
    NSString *building_value;
    [fd_luckiest setAlignment:kCCTextAlignmentCenter];
    [fd_luckiest setVertAlignment:kCCVerticalTextAlignmentCenter];
    [labelCost setString:[NSString stringWithFormat:@"$ %i", building_cost[item_selected]]];
    if (building_range[item_selected]) building_value = [NSString stringWithFormat:@"%i", building_range[item_selected]]; else building_value = @"-";
    [labelRange setString:building_value];
    if (building_power[item_selected]) building_value = [NSString stringWithFormat:@"%i", building_power[item_selected]]; else building_value = @"-";
    [labelPower setString:building_value];
    if (building_fire_rate[item_selected]) building_value = [NSString stringWithFormat:@"%i", building_fire_rate[item_selected]]; else building_value = @"-";
    [labelFireRate setString:building_value];
    
    switch (panel_item_active) {
        case 0: [labelDescription setString:NSLocalizedString(@"Butik – zaspokaja w średnim tempie małą klientelę ", "")]; break;
        case 1: [labelDescription setString:NSLocalizedString(@"Sklep – obsługuje szybko średnią klientelę", "")]; break;
        case 2: [labelDescription setString:NSLocalizedString(@"Galeria handlowa – wolno zaspokaja dużą klientelę ", "")]; break;
        case 3: [labelDescription setString:NSLocalizedString(@"Dział Analiz – zwiększa dokładność prognozy następnej fali", "")]; break;
        case 4: [labelDescription setString:NSLocalizedString(@"Magazyn – zwiększa szybkość inwestycji w swoim zasięgu o 20%", "")]; break;
        case 5: [labelDescription setString:NSLocalizedString(@"Agencja reklamowa – zwiększa sku- teczność bilbordów w zasięgu o 25%", "")]; break;
        case 6: [labelDescription setString:NSLocalizedString(@"Bilbord – spowalnia jednostki \nw zasięgu działania o 25%", "")]; break;
        case 7: [labelDescription setString:NSLocalizedString(@"Backoffice – zwiększa siłę inwestycji w swoim zasięgu o 15%", "")]; break;
            
        default: break;
    }
}

- (void) heroNextMove:(int)tag isChange:(BOOL)change
{
    CCNode *this_hero = [self getChildByTag:tag];
    CCNode *this_energy_empty = [self getChildByTag:tag + 1000];
    CCNode *this_energy_full = [self getChildByTag:tag + 2000];
    int i = 0;
    for (i = 0; i<[hero count]; i++) {
//        NSLog(@"for i=%i (tag: %i =?= %i)", i, [[[hero objectAtIndex:i] objectForKey:@"tag"] integerValue], tag);
        if ([[[hero objectAtIndex:i] objectForKey:@"tag"] integerValue] == tag) break;
    }
//    NSLog(@"- heroNextMove(tag %i): %i -", tag, i);
    int kind = [[[hero objectAtIndex:i] objectForKey:@"kind"] integerValue];
    int map_x;
    int map_y;
    int rotation;
    int dir_x = 0, dir_y = 0;

    if (change) {
        map_x = [[[hero objectAtIndex:i] objectForKey:@"map_x"] integerValue];
        map_y = [[[hero objectAtIndex:i] objectForKey:@"map_y"] integerValue];
        rotation = [[[hero objectAtIndex:i] objectForKey:@"rotation"] integerValue];
    } else {
        map_x = [[[hero objectAtIndex:i] objectForKey:@"next_map_x"] integerValue];
        map_y = [[[hero objectAtIndex:i] objectForKey:@"next_map_y"] integerValue];
        rotation = [[[hero objectAtIndex:i] objectForKey:@"next_rotation"] integerValue];

        [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:map_x] forKey:@"map_x"];
        [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:map_y] forKey:@"map_y"];
        [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:rotation] forKey:@"rotation"];

    }
    
//    NSLog(@"HERO %i (change: %i) next move from: %i, %i", i, change, map_x, map_y);

    if (map_x == 18) {[self heroRemove:i]; return;}
    if (rotation == 360) {rotation = 0; this_hero.rotation = rotation;} else if (rotation == -90) {rotation = 270; this_hero.rotation = rotation;}
    
    [self reorderChild:this_hero z:(map_y_size - map_y) * 1000 +  (999 - tag)];
    [self heroZorder];
//    [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:this_hero.zOrder] forKey:@"z_order"];

//    NSLog(@"this_hero (index: %i, tag: %i) z: %i", i, tag, this_hero.zOrder);
    
    switch (rotation) {
        case 0: //down
            if      (levelMap[map_y-1][map_x-1] == 1) {dir_x = -tile_size/2;    dir_y = -tile_size/2;   rotation = 90;  map_y--;}
            else if (levelMap[map_y-1][map_x+1] == 1) {dir_x = tile_size/2;     dir_y = -tile_size/2;   rotation = -90; map_y--;}
            else {dir_y = -tile_size; map_y--;}
            break;
        case 90: //left
            if      (levelMap[map_y+1][map_x-1] == 1) {dir_x = -tile_size/2;     dir_y = tile_size/2;   rotation = 180; map_x--;}
            else if (levelMap[map_y-1][map_x-1] == 1) {dir_x = -tile_size/2;     dir_y = -tile_size/2;  rotation = 0;   map_x--;}
            else {dir_x = -tile_size; map_x--;}
            break;
        case 180: //up
            if      (levelMap[map_y+1][map_x-1] == 1) {dir_x = -tile_size/2;    dir_y = tile_size/2;    rotation = 90;  map_y++;}
            else if (levelMap[map_y+1][map_x+1] == 1) {dir_x = tile_size/2;     dir_y = tile_size/2;    rotation = 270; map_y++;}
            else
            {dir_y = tile_size; map_y++;}
            break;
        case 270: //right
            if      (levelMap[map_y+1][map_x+1] == 1) {dir_x = tile_size/2;     dir_y = tile_size/2;    rotation = 180; map_x++;}
            else if (levelMap[map_y-1][map_x+1] == 1) {dir_x = tile_size/2;     dir_y = -tile_size/2;   rotation = 360; map_x++;}
            else {dir_x = tile_size; map_x++;}
            break;
    }
    
    
//    NSLog(@" this hero (map_x: %i | map_y: %i) rot: %i", map_x, map_y, rotation);
    CGFloat walk_time = hero_data[kind][5] * .5;
    int hero_delay = [[[hero objectAtIndex:i] objectForKey:@"delay"] integerValue];
    if (hero_delay) {
        hero_delay--;
        if (hero_delay < 0) hero_delay = 0;
        [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:hero_delay] forKey:@"delay"];
        walk_time *= 1.25f;
        if (change) {
            NSLog(@"change from x: %i-%i, y:%i-%i", [[[hero objectAtIndex:i] objectForKey:@"map_x"] integerValue], [[[hero objectAtIndex:i] objectForKey:@"next_map_x"] integerValue], [[[hero objectAtIndex:i] objectForKey:@"map_y"] integerValue], [[[hero objectAtIndex:i] objectForKey:@"next_map_y"] integerValue]);
            
            CGFloat hero_distance =   fabsf(this_hero.position.x - levelX - hero_data[i][0] - map_x * tile_size)
                                    + fabsf(this_hero.position.y - levelY - hero_data[i][1] - map_y * tile_size);

            CGFloat full_distance =   abs([[[hero objectAtIndex:i] objectForKey:@"next_map_x"] integerValue] - [[[hero objectAtIndex:i] objectForKey:@"map_x"] integerValue]) * tile_size
                                    + abs([[[hero objectAtIndex:i] objectForKey:@"next_map_y"] integerValue] - [[[hero objectAtIndex:i] objectForKey:@"map_y"] integerValue]) * tile_size;
            
//            CGFloat full_distance =     fabsf((levelX + [[[hero objectAtIndex:i] objectForKey:@"next_map_x"] integerValue] * tile_size + hero_data[i][0]) - moveTo_x)
//                                      + fabsf((levelY + [[[hero objectAtIndex:i] objectForKey:@"next_map_y"] integerValue] * tile_size + hero_data[i][1]) - moveTo_y);
            NSLog(@"walk time (%f) * hero_distance (%f) / full_distance (%f) = %f", walk_time, hero_distance, full_distance, walk_time * hero_distance / full_distance);
            walk_time *= hero_distance / full_distance;
        }
    }
//    NSLog(@"heroNextMove delay = %i (walk_time: %f)", hero_delay, walk_time);
    [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:map_x] forKey:@"next_map_x"];
    [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:map_y] forKey:@"next_map_y"];
    [[hero objectAtIndex:i] setObject:[NSNumber numberWithInt:rotation] forKey:@"next_rotation"];
    int moveTo_x = levelX + map_x * tile_size + hero_data[i][0] ;
    int moveTo_y = levelY + map_y * tile_size + hero_data[i][1] ;
    CCRotateTo *actionRotate =  [CCRotateTo actionWithDuration:walk_time   angle:rotation];
    CCMoveTo *actionMove =      [CCMoveTo   actionWithDuration:walk_time   position:ccp(moveTo_x, moveTo_y)];
    CCMoveTo *actionMoveEnergyE =[CCMoveTo   actionWithDuration:walk_time   position:ccp(moveTo_x, moveTo_y + building_margin[9][1])];
    CCMoveTo *actionMoveEnergyF =[CCMoveTo   actionWithDuration:walk_time   position:ccp(moveTo_x, moveTo_y + building_margin[9][1])];
    
    CCCallBlockN * actionMoveDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[self heroNextMove:tag isChange:NO];}];
    
    CCSequence *walkSequence = [CCSequence actions:actionMove, actionMoveDone, nil];
    walkSequence.tag = 0;
    actionMoveEnergyE.tag = 0;
    actionMoveEnergyF.tag = 0;
    [this_hero runAction:actionRotate];
    [this_hero runAction:walkSequence];
    [this_energy_empty runAction:actionMoveEnergyE];
    [this_energy_full runAction:actionMoveEnergyF];
    
//    NSLog(@"HERO %i (change: %i) next move   to: %i, %i", i, change, map_x, map_y);
    
}

- (void) heroRemove:(int)i
{
    int tag = [[[hero objectAtIndex:i] objectForKey:@"tag"] integerValue];
    int money = [[[hero objectAtIndex:i] objectForKey:@"money"] integerValue];
    wave_balance -= money;
    [self updateWaveBalace];
    
    CCNode *this_hero = [self getChildByTag:tag];
    CCNode *this_energy_empty = [self getChildByTag:tag + 1000];
    CCNode *this_energy_full = [self getChildByTag:tag + 2000];
    
    if (money) {
        [fd_luckiest setFontSize:18];
        CCLabelTTF *labelEarnings = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"- $ %i", money] fontDefinition:fd_luckiest];
        labelEarnings.horizontalAlignment = kCCTextAlignmentCenter;
        labelEarnings.verticalAlignment = kCCTextAlignmentCenter;
        [labelEarnings setFontFillColor:ccc3(255, 0, 0) updateImage:NO];
        [labelEarnings enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
        labelEarnings.position = ccp(this_hero.position.x - 60, this_hero.position.y);
//        CGSize winSize = [[CCDirector sharedDirector] winSize];
        CCMoveTo *actionMove = [CCMoveTo actionWithDuration:1.5 position:ccp(this_hero.position.x - 120, this_hero.position.y + 60)];// * (winSize.height - this_hero.position.y) / winSize.height)];
        CCCallBlockN * actionMoveDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[labelEarnings removeFromParent];}];
        CCSequence *earnSequence = [CCSequence actions:actionMove, actionMoveDone, nil];
        CCAction *earnFadeOut = [CCFadeTo actionWithDuration:0.5 opacity:0];
        [self addChild:labelEarnings z:11000];
        [labelEarnings runAction:[CCSequence actions:[CCDelayTime actionWithDuration:1.0], earnFadeOut, nil]];
        [labelEarnings runAction:[CCEaseIn actionWithAction:earnSequence rate:1.5]];
    }
    
    [self removeChild:this_hero];
    [self removeChild:this_energy_empty];
    [self removeChild:this_energy_full];
    [hero removeObjectAtIndex:i];
    NSLog(@"REMOVED (tag %i): %i (count = %i, spawn_index[1] = %i", tag, i, [hero count], levels_wave_spawn[level_number][wave_number][spawn_index][1]);
    
    if (![hero count] && !levels_wave_spawn[level_number][wave_number][spawn_index][1]) {
        if (wave_balance >= 0) {
            CCCallBlockN * callNextWave = [CCCallBlockN actionWithBlock:^(CCNode *node) {
                if (wave_number < 9)    [self nextWave];
                else                    [self levelLabelAndAction:2];
            }];
            [self runAction:[CCSequence actions: [CCDelayTime actionWithDuration:2], callNextWave, nil]];
        } else {
            [self levelLabelAndAction:0]; //show game over
        }
    }
}

- (void) heroSpawn
{
    int i = levels_wave_spawn[level_number][wave_number][spawn_index][0];
    CCAnimate *walkAnimate = [CCAnimate actionWithAnimation:anim_hero_walk[i]];
    CCSequence *walkSequence;
    if (hero_data[i][3]) walkSequence = [CCSequence actions: walkAnimate, [walkAnimate reverse], nil]; //is reverse animation?
    else                 walkSequence = [CCSequence actions: walkAnimate, nil];
    CCAction *walkAction = [CCRepeatForever actionWithAction:walkSequence];
    
    int map_y = 0, map_x = -1;
    while (!levelMap[map_y][map_x + 1]) {map_y++;}
//    NSLog(@" bef spawn [hero count] = %i | will spawn at map_y = %i", [hero count], map_y);
    CCSprite *sprite_hero;
    sprite_hero = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"hero%i/1.png", i]];
    sprite_hero.position = ccp(levelX + (map_x + 1) * tile_size - tile_size/2 + hero_data[i][0], levelY + map_y * tile_size + hero_data[i][1]);
    sprite_hero.rotation = 270;
    sprite_hero.tag = level_time_tick;
//    NSLog(@"sprite_hero.pos = %f, %f", sprite_hero.position.x, sprite_hero.position.y);
    [sprite_hero runAction:walkAction];
    [self addChild:sprite_hero z:10000];

    CCSprite *sprite_energy_empty;
    sprite_energy_empty = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"level_items/energy_empty.png"]];//, (int)(hero_data[i][6] * .1)]];
    sprite_energy_empty.position = ccp(levelX + (map_x + 1) * tile_size - tile_size/2 + building_margin[9][0], levelY + map_y * tile_size + building_margin[9][1]);
    sprite_energy_empty.anchorPoint = CGPointMake(.5, 0);
    sprite_energy_empty.tag = 1000 + level_time_tick;
//    sprite_energy_empty.scale = .75;
    [self addChild:sprite_energy_empty z:10001];

    CCSprite *sprite_energy_full;
    sprite_energy_full = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"level_items/energy_full.png"]];//, (int)(hero_data[i][6] * .1)]];
    sprite_energy_full.position = ccp(levelX + (map_x + 1) * tile_size - tile_size/2 + building_margin[9][0], levelY + map_y * tile_size + building_margin[9][1]);
    sprite_energy_full.anchorPoint = CGPointMake(.5, 0);
//    sprite_energy_full.scale = .75;
    sprite_energy_full.tag = 2000 + level_time_tick;
    //    sprite_wallet.scale = .75;
    [self addChild:sprite_energy_full z:10002];
    
    
    [hero addObject:[NSMutableDictionary dictionary]];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:0] forKey:@"delay"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:i] forKey:@"kind"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:map_x] forKey:@"map_x"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:map_y] forKey:@"map_y"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:hero_data[i][6]] forKey:@"money"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:map_x] forKey:@"next_map_x"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:map_y] forKey:@"next_map_y"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:sprite_hero.rotation] forKey:@"next_rotation"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithFloat:sprite_hero.rotation] forKey:@"rotation"];
    [[hero objectAtIndex:[hero count]-1] setObject:[NSNumber numberWithInt:sprite_hero.tag] forKey:@"tag"];
    
    spawn_index++;
    
//    NSLog(@"SPAWNED (tag %i) kind: %i", sprite_hero.tag, i);
//    NSLog(@"{adding hero at index %i}", [hero count]-1);
    [self heroNextMove:sprite_hero.tag isChange:NO];
}

- (void) heroZorder
{
    if ([hero count] > 1)
    for (int a = 0; a < [hero count] - 1; a++)
        for (int b = a + 1; b < [hero count]; b++) {
            CCNode *hero_a = [self getChildByTag:[[[hero objectAtIndex:a] objectForKey:@"tag"] integerValue]];
            CCNode *hero_b = [self getChildByTag:[[[hero objectAtIndex:b] objectForKey:@"tag"] integerValue]];
            BOOL xClose = (abs([[[hero objectAtIndex:a] objectForKey:@"map_x"] integerValue] - [[[hero objectAtIndex:b] objectForKey:@"map_x"] integerValue]) <= 1) ? 1 : 0;
            BOOL yClose = (abs([[[hero objectAtIndex:a] objectForKey:@"map_y"] integerValue] - [[[hero objectAtIndex:b] objectForKey:@"map_y"] integerValue]) <= 1) ? 1 : 0;
            if (hero_a.rotation == hero_b.rotation && xClose && yClose) {
                switch (abs((int)hero_a.rotation)) {
                    case 0:
                        if (hero_a.position.y > hero_b.position.y && hero_a.zOrder >= hero_b.zOrder) {
                            [self reorderChild:hero_b z:hero_a.zOrder + 1];
                            //                            NSLog(@" - reordering hero %i (z: %i) behind hero %i (z: %i)", b, hero_b.zOrder, a, hero_a.zOrder);
                        }
                        break;
                        
                    case 90:
                        if (hero_a.position.x > hero_b.position.x && hero_a.zOrder >= hero_b.zOrder) {
                            [self reorderChild:hero_b z:hero_a.zOrder + 1];
                            //                            NSLog(@" - reordering hero %i (z: %i) behind hero %i (z: %i)", b, hero_b.zOrder, a, hero_a.zOrder);
                        }
                        break;
                        
                    case 180:
                        if (hero_a.position.y > hero_b.position.y && hero_a.zOrder <= hero_b.zOrder) {
                            [self reorderChild:hero_b z:hero_a.zOrder - 1];
                            //                            NSLog(@" - reordering hero %i (z: %i) behind hero %i (z: %i)", b, hero_b.zOrder, a, hero_a.zOrder);
                        }
                        break;
                        
                    case 270:
                        if (hero_a.position.x < hero_b.position.x && hero_a.zOrder >= hero_b.zOrder) {
//                            NSLog(@"%f - %f  && %i - %i", hero_a.position.x, hero_b.position.x, hero_a.zOrder, hero_b.zOrder);
                            [self reorderChild:hero_a z:hero_b.zOrder - 1];
//                            NSLog(@" - reordering hero %i (z: %i) behind hero %i (z: %i)", b, hero_b.zOrder, a, hero_a.zOrder);
                        }
                        break;
                }
            }
        }

}

- (void) levelLabelAndAction:(int)action
{
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    CGFloat labelDelay = 2;
    NSString *text;
    switch (action) {
        case 0:
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/level_failed" ofType:@"mp3"]];
            text = NSLocalizedString(@"GAME OVER", "");
            break;
        case 1: text = [NSString stringWithFormat:@"%@ %i", NSLocalizedString(@"LEVEL", ""), level_number + 1]; break;
        case 2:
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/level_complete" ofType:@"mp3"]];
            
            text = NSLocalizedString(@"LEVEL COMPLETE", "");
                score += money * score_multiplier;
//                [labelMoney setString:[NSString stringWithFormat:@"$ %i", money]];
            if (money) {
                [fd_luckiest setFontSize:33];
                int moneyBonus = money * score_multiplier;
                score += moneyBonus;
                CCLabelTTF *labelBonus = [CCLabelTTF labelWithString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"MONEY BONUS", ""), moneyBonus] fontDefinition:fd_luckiest];

                [labelBonus setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
                [labelBonus enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
                labelBonus.horizontalAlignment = kCCTextAlignmentCenter;
                labelBonus.verticalAlignment = kCCTextAlignmentCenter;
                labelBonus.opacity = 0;
                labelBonus.position = ccp(winSize.width * .5, winSize.height * .40);
                [self addChild:labelBonus z:10000];
                labelDelay += 1.5;
                
                CCCallBlockN * labelBonusDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[labelBonus removeFromParent];}];
                [labelBonus runAction:[CCSequence actions:[CCDelayTime actionWithDuration:1], [CCFadeIn actionWithDuration:.25], [CCDelayTime actionWithDuration:2], [CCFadeOut actionWithDuration:.25], labelBonusDone, nil]];
            }

            break;
    }
    
    [fd_luckiest setFontSize:77];
    CCLabelTTF *labelLevel = [CCLabelTTF labelWithString:text fontDefinition:fd_luckiest];
    [labelLevel setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelLevel enableStrokeWithColor:ccc3(0,0,0) size:0 updateImage:YES];
    labelLevel.horizontalAlignment = kCCTextAlignmentCenter;
    labelLevel.verticalAlignment = kCCTextAlignmentCenter;
    labelLevel.opacity = 0;
    labelLevel.position = ccp(winSize.width * .5, winSize.height * .5);
    CCCallBlockN * labelLevelDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {
        [labelLevel removeFromParent];
        switch (action) {
            case 0: [[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[HelpLayer scene:1]]]; break;
            case 1: [self nextWave]; break;
            case 2: [self nextLevel]; break;
        }
    }];
    
    [self addChild:labelLevel z:10000];
    [labelLevel runAction:[CCSequence actions: [CCFadeIn actionWithDuration:.25], [CCDelayTime actionWithDuration:labelDelay], [CCFadeOut actionWithDuration:.25], labelLevelDone, nil]];
}

- (void) nextLevel
{
    level_number++;
    if (level_number < 10)
        [[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[LevelLayer scene]]];
    else
        [[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[HelpLayer scene:1]]];

}

- (void) nextWave
{
    wave_balance = 0;
    [self updateWaveBalace];
    level_time_tick = 0;
    spawn_index = 0;
    wave_number++;
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    int interval = 0;
    
    //count analysis dept & show wave analysis
    int analysis_count = 0;
    for (int x=0; x<map_x_size; x++) for (int y=0; y<map_y_size; y++) if (levelMap[y][x] == 5) analysis_count++;
    if (analysis_count) {
        [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/analitycs" ofType:@"mp3"]];

        CCSprite *sprite_analysis_panel = [CCSprite spriteWithSpriteFrameName:@"level_items/analitycs.png"];
        sprite_analysis_panel.position = ccp(winSize.width / 2, winSize.height / 2);
        sprite_analysis_panel.opacity = 0;
        
        [self addChild:sprite_analysis_panel z:11000];
        [sprite_analysis_panel runAction:[CCSequence actions: [CCFadeIn actionWithDuration:.25], [CCDelayTime actionWithDuration:4.75], [CCFadeOut actionWithDuration:.25], nil]];
        
        int hero_number = 0;
        if (analysis_count > 3)
            analysis_count = 3;
        CGFloat analysis_accuracy = analysis_count * .33;
        while (levels_wave_spawn[level_number][wave_number][hero_number][1]) {
            CCSprite *hero_analyzed = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"hero%i/1.png", levels_wave_spawn[level_number][wave_number][hero_number][0]]];
            hero_analyzed.position = ccp(winSize.width / 2 + (arc4random() % 225 - 112.5f) * analysis_accuracy, -20 + winSize.height / 2 + (arc4random() % 125 - 62.5f) * analysis_accuracy);
            hero_analyzed.opacity = 0;
            hero_analyzed.scale = .75f;
            CCCallBlockN * actionHeroAnalyzedDone = [CCCallBlockN actionWithBlock:^(CCNode *node) {[hero_analyzed removeFromParent];}];
            [hero_analyzed runAction:[CCSequence actions: [CCFadeIn actionWithDuration:2], [CCDelayTime actionWithDuration:3], [CCFadeOut actionWithDuration:.25], actionHeroAnalyzedDone, nil]];
            [self addChild:hero_analyzed z:11001];
            hero_number++;
        }
        interval = 5.25;
    }
    
    //show wave number & start wave
    [labelWave setString:[NSString stringWithFormat:@"%@\n%i / %i", NSLocalizedString(@"WAVE", ""), wave_number + 1, level_waves]];
    CCScaleTo *labelScaleTo1 = [CCScaleTo actionWithDuration:.5 scale:1];
    CCScaleTo *labelScaleTo2 = [CCScaleTo actionWithDuration:.5 scale:.33];
    CCMoveTo *labelMoveTo1 = [CCMoveTo actionWithDuration:.5 position:ccp(winSize.width / 2 , winSize.height * .5)];
    CCMoveTo *labelMoveTo2 = [CCMoveTo actionWithDuration:.5 position:ccp(winSize.width / 2 , winSize.height - winSize.height * .06)];
    CCCallBlockN * actionRunTickSecondTimer = [CCCallBlockN actionWithBlock:^(CCNode *node) {[self schedule: @selector(tickSecond:) interval:1];}];

    [labelWave runAction:[CCSequence actions: [CCDelayTime actionWithDuration:interval], [CCEaseOut actionWithAction:labelScaleTo1 rate:1.5], [CCDelayTime actionWithDuration:0.5], [CCEaseIn actionWithAction:labelScaleTo2 rate:1.5], nil]];
    [labelWave runAction:[CCSequence actions: [CCDelayTime actionWithDuration:interval], [CCEaseOut actionWithAction:labelMoveTo1 rate:1.5], [CCDelayTime actionWithDuration:0.5], [CCEaseIn actionWithAction:labelMoveTo2 rate:1.5], actionRunTickSecondTimer, nil]];
}

- (void) tickSecond: (ccTime) dt
{
    int i = levels_wave_spawn[level_number][wave_number][spawn_index][1];
//    NSLog(@"level_time_tick %i >? (level_number %i | wave_number %i | spawn_index %i) %i ", level_time_tick, level_number, wave_number, spawn_index, i);
    if (!i) [self unschedule:@selector(tickSecond:)];
    else if (level_time_tick >= i) {
        [self heroSpawn];
    }
    
    level_time_tick++;
}

- (void) updateWaveBalace
{
    if (wave_balance < 0)       [labelBalance setFontFillColor:ccc3(255, 0, 0) updateImage:NO];
    else if (wave_balance > 0)  [labelBalance setFontFillColor:ccc3(0, 255, 0) updateImage:NO];
    else                        [labelBalance setFontFillColor:ccc3(255, 255, 0) updateImage:NO];
    [labelBalance setString:[NSString stringWithFormat:@"%@: %i", NSLocalizedString(@"WAVE BALANCE", ""), wave_balance]];

}

#pragma mark Touches

- (void) ccTouchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    UITouch* touch = [touches anyObject];
    CGPoint t = [touch locationInView: [touch view]];
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    t.y = winSize.height - t.y;
    NSLog(@"x: %f | y: %f", t.x, t.y);
    
    if (t.x > winSize.width * .879 && t.y <  winSize.height * .117) {
        // are you sure you want to quit?
        [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/menu_click" ofType:@"mp3"]];
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"Wyjście do menu", "")
                                                        message:@"Czy na pewno chcesz zakończyć grę?"
                                                       delegate:self
                                              cancelButtonTitle:@"Nie"
                                              otherButtonTitles:@"Tak", nil];
        [alert show];
        [alert release];
        
        [[CCDirector sharedDirector] pause];
//        [self pauseSchedulerAndActions];
//        for (CCNode *child in [self children]) {
//            [child pauseSchedulerAndActions];
//            
//        }
    } else

    //panel items
    for (int i = 0; i < buildings_amount; i++) {
        if (t.x > panel_items_pos[0] + panel_items_pos[2] * i - panel_items_pos[3] && t.x < panel_items_pos[0] + panel_items_pos[2] * i + panel_items_pos[3] &&
            t.y > panel_items_pos[1] - panel_items_pos[3] && t.y < panel_items_pos[1] + panel_items_pos[3]) {
            NSLog(@"taczed value: %i", i);
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/building_choose" ofType:@"mp3"]];
            [self panelItemSelect:i];
            if (building_cost[i] <= money) isPanelItemMoving = true;
        }
    }
}

- (void) ccTouchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event {
    if (isPanelItemMoving) {
        NSLog(@"ccTouchesCancelled: will cancel item moving");
        isPanelItemMoving = FALSE;
//        spritePanelItem[9].visible = FALSE;
        [spritePanelItem[9] removeFromParent];
        spritePanelItem[9] = nil;
        [spriteCircle removeFromParent];
        spriteCircle = nil;
    }
}

- (void) ccTouchesEnded:(NSSet *)touches withEvent:(UIEvent *)event
{
    UITouch* touch = [touches anyObject];
    CGPoint t = [touch locationInView: [touch view]];
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    t.y = winSize.height - t.y;
    
    if (isPanelItemMoving) {
        int tX = roundf((t.x - levelX) / tile_size);
        int tY = roundf((t.y - levelY) / tile_size);
        NSLog(@"tX: %i | tY: %i", tX, tY);
        if (tX > 0 && tX < map_x_size - 1 && tY > -1 && tY < map_y_size && !levelMap[tY][tX]) {
            levelMap[tY][tX] = panel_item_active + 2;
            NSLog(@"tX: %i | tY: %i | setting value: %i", tX, tY, levelMap[tY][tX]);
            [[SimpleAudioEngine sharedEngine] playEffect:[[NSBundle mainBundle] pathForResource:@"SFX/building_place" ofType:@"mp3"]];

            spriteLevelMap[tY][tX] = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"buildings/building%i.png", panel_item_active + 2]];
            spriteLevelMap[tY][tX].position = ccp(levelX + tX * tile_size + building_margin[panel_item_active + 1][0],
                                                    levelY + tY * tile_size + building_margin[panel_item_active + 1][1]);
            [self addChild:spriteLevelMap[tY][tX] z:(map_y_size - tY) * 1000 + tX];
            money -= building_cost[panel_item_active];
            [fd_luckiest setFontSize:22];
            [labelMoney setString:[NSString stringWithFormat:@"$ %i", money]];
            [self panelItemsUpdate];
            [self buildingAction:[NSArray arrayWithObjects:[NSNumber numberWithInt:tX], [NSNumber numberWithInt:tY], nil]];
        }
        [self ccTouchesCancelled:touches withEvent:event];
    }
}


- (void) ccTouchesMoved:(NSSet *)touches withEvent:(UIEvent *)event
{
    UITouch* touch = [touches anyObject];
    CGPoint t = [touch locationInView: [touch view]];
    CGSize winSize = [[CCDirector sharedDirector] winSize];
    t.y = winSize.height - t.y;

    if (isPanelItemMoving) {
        if (!spritePanelItem[9]) {
            spritePanelItem[9] = [CCSprite spriteWithSpriteFrameName:[NSString stringWithFormat:@"buildings/building%i.png", panel_item_active + 2]];
            [self addChild:spritePanelItem[9] z: (map_y_size + 1) * 1000];
            spriteCircle = [CCSprite spriteWithSpriteFrameName:@"level_items/circle.png"];
            spriteCircle.opacity = 0;
            CGFloat circle_scale[] = {.30, .44, .72, 1.0, 1.25};
            if (building_range[panel_item_active]) spriteCircle.scale = circle_scale[building_range[panel_item_active]]; else spriteCircle.scale = 0.01;
            [self addChild:spriteCircle z: (map_y_size + 1) * 1000 - 1];
        }
        
        int tX = roundf((t.x - levelX) / tile_size);
        int tY = roundf((t.y - levelY) / tile_size);
//        NSLog(@"tX: %i | tY: %i | reading value: %i", tX, tY, levelMap[tY][tX]);
        CGPoint pos = ccp(levelX + tX * tile_size , levelY + tY * tile_size);
        if (tX > 0 && tX < map_x_size - 1 && tY > -1 && tY < map_y_size) {
            spritePanelItem[9].position = ccp(pos.x + building_margin[panel_item_active + 1][0], pos.y + building_margin[panel_item_active + 1][1]);
            if (levelMap[tY][tX]) {
                spritePanelItem[9].opacity = 100;
                spriteCircle.opacity = 0;
            } else {
                spritePanelItem[9].opacity = 255;
                spriteCircle.opacity = 127;
            }
        } else {
            spritePanelItem[9].position = ccp(t.x, t.y);
            spritePanelItem[9].opacity = 100;
            spriteCircle.opacity = 0;
        }
        spriteCircle.position = ccp(pos.x + 4, pos.y);

        
    }
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (buttonIndex) {
        NSLog(@"buttonIndex: %i, to menu!", buttonIndex);
        [[CCDirector sharedDirector] resume];
        [[CCDirector sharedDirector] replaceScene:[CCTransitionFade transitionWithDuration:1.0 scene:[MenuLayer scene]]];
    } else {
        [[CCDirector sharedDirector] resume];
//        [self resumeSchedulerAndActions];
//        for (CCNode *child in [self children]) {
//            [child resumeSchedulerAndActions];
//        }
    }
}

@end

