//-----------------------------------------------------------------------------------------------------------------------------------------------
//------                            Nagwek
//-----------------------------------------------------------------------------------------------------------------------------------------------
// container_id - id kontenera z elementami np. '#logo_2', timeout - czas zmiany elementu
//--------------------------
function fade_elements(container_id, timeout, speed) {
   var cont = $(container_id);
   if(cont.css('position')!='absolute')
     cont.css({'position':'relative'})
     
   var el_tab = cont.children().get();
   if(el_tab.length < 2)
     return;
   
   var c = el_tab.length;
   for(var i=0; i<c; i++)
      $(el_tab[i]).css({'position':'absolute', 'left':0, 'top':0, 'display':((i==0)? 'block' : 'none')});

  var fade_next = function() {
    
    $(el_tab[0]).fadeOut(speed);
    $(el_tab[1]).fadeIn(speed);
    
    var first = el_tab.shift();
    el_tab.push(first);
  }

  setInterval(fade_next, timeout);

}

//-----------------------------------------------------------------------------------------------------------------------------------------------
//------                            Menu
//-----------------------------------------------------------------------------------------------------------------------------------------------
//container_id - id kontenera z elementami np. '#logo_2', bg_img - przeroczysty obrazek dla ta, bg_color i bg_opacity - dla IE8 :/
//--------------------------
function hover_menu(container_id, bg_img, bg_color, bg_opacity, speed) {
  var cont = $(container_id);

  var tab = cont.children('a').each(function () {
      var link = $(this);
      var overlay = link.find('div');

      if($.browser.msie)
      {
        $('<div style="position:absolute; left:0px; top:0px; width:100%; height:100%; background-color:' + bg_color +'; display:none"></div>').insertBefore(overlay).css({opacity:bg_opacity});
      }
      else
      {
        overlay.wrap('<div style="position:absolute; left:0px; top:0px; width:100%; height:100%; background-image:url(\''+ bg_img +'\'); display:none">');
        overlay.css({'display': 'block'});
      }

      var p = overlay.parent();
      p.addClass('transparent_c');
      link.hover(
                  function() {link.children('div').stop(true,true).fadeIn(speed)},
                  function() {link.children('div').stop(true,true).fadeOut(speed)}
                
                );
   });
}

//-----------------------------------------------------------------------------------------------------------------------------------------------
//------                            Stopka 
//-----------------------------------------------------------------------------------------------------------------------------------------------
// zwraca czarno biay obrazek lub rdo oryginalnego - gdy nie ma obsugi canvas...
//--------------------------
function get_bw(image_src) {

  var canvas = document.createElement('canvas');
  if((canvas != null) && (canvas.getContext))
  {
     var ctx = canvas.getContext('2d');
     var tmp_img = 	new Image();
     tmp_img.src = image_src;
     canvas.width = tmp_img.width;
     canvas.height = tmp_img.height;
     ctx.drawImage(tmp_img, 0, 0); 

     var canvas_data = ctx.getImageData(0, 0, canvas.width, canvas.height);
     var a, b;
     for(a=0; a < canvas_data.height; a++)
     {
       for(b=0; b < canvas_data.width; b++)
       {
          var pix_ind = (a * 4) * canvas_data.width + b*4;
          var bw = (canvas_data.data[pix_ind] + canvas_data.data[pix_ind + 1] + canvas_data.data[pix_ind + 2]) / 3; 
          canvas_data.data[pix_ind] = canvas_data.data[pix_ind + 1] = canvas_data.data[pix_ind + 2] = bw;
       }
     
     }
    ctx.putImageData(canvas_data, 0, 0, 0, 0, canvas_data.width, canvas_data.height);
    return canvas.toDataURL();
  }
  else
    return image_src;
}

//    container_id- id kontenera z elementami np. '#logo_2', space_x- odstp midzy elementami, frame_interval- czsto ruchu[ms]
//    frame_step - przesunicie obrazka na klatke
//--------------------------
function foot_anim (container_id, space_px, frame_interval, frame_step) {

  var cont = $(container_id);
  cont.css({
              'display':'inline-block',
              'overflow':'hidden',
              'white-space':'nowrap',
              'visibility':'visible',
              'position':'relative',
              opacity:0
            });
 
  $(window).load( function () {

  cont.animate({opacity:1}, 1500);

 
  var pos_x = 0;
  cont.children().each(function () {
                                       var el = $(this);
                                       el.wrap('<div style="position:absolute; left:'+ pos_x +'px; width:' + el.width() + 'px; z-index:2" class="move_this">');
                                       pos_x += space_px + el.width();
                                    });


  cont.find('img').each(function () {
    var el = $(this);
    el.css({"position":"absolute"});
    el.wrap('<div class="img_wrapper" style="display: block;">');
    el.clone().addClass('img_bw').css({"position":"absolute","z-index":"7","opacity":"0"}).insertBefore(el).queue(function(){
      var el = $(this);
      el.parent().css({"width":this.width,"height":this.height});
      el.dequeue();
    });
     this.src = get_bw(this.src);
 });

    $(container_id + ' img').mouseover(function(){$(this).parent().find('img:first').stop().animate({opacity:1}, 300);})
    $('.img_bw').mouseout(function(){$(this).stop().animate({opacity:0}, 300);});
  
  // nie ma po co przewija...
  var elements_width  = cont.children('.move_this:last').position().left + cont.children('.move_this:last').width();
  if(elements_width < cont.width())
  {  
     cont.children('.move_this').each(function () {$(this).css({'margin-left':(cont.width()/2 - elements_width/2)})});
     return;
  }


  var pause = false;
  var move_tab = cont.children('.move_this').get();
  var move_count = move_tab.length;
  var slide_images = function ()
              {
                 if(!pause)
                 {
                   
                   // move_this all element right
                   for(var i =0; i<move_count; i++)
                    { 
                       var left = parseInt(move_tab[i].style.left, 10) + frame_step;
                       move_tab[i].style.left = left + 'px';
                    }

                     if(frame_step < 0)
                       if(parseInt(move_tab[0].style.left, 10) <= -parseInt(move_tab[0].style.width, 10))
                       {
                          move_tab[0].style.left = (parseInt(move_tab[move_count-1].style.left, 10) + parseInt(move_tab[move_count-1].style.width, 10) + space_px) + 'px';
                          var first = move_tab.shift();
                          move_tab.push(first);
                       }
                    if(frame_step > 0)
                       if(parseInt(move_tab[0].style.left, 10) >= 0)
                       {
                          move_tab[move_count-1].style.left = -(parseInt(move_tab[move_count-1].style.width, 10) + space_px) + 'px';
                          var last = move_tab.pop();
                          move_tab.unshift(last);
                       }
                 }
              };

  setInterval(slide_images, frame_interval);

  cont.mouseover(function () {pause = true});
  cont.mouseout(function () {pause = false});
  
  });
}