$(document).ready(function() {
    $( "#search-place" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "http://" + window.location.hostname + "/controller.php",
                dataType: "json",
                data: {
                    maxRows: 12,
                    searchText: request.term
                },
                success: function( data ) {
                    response( $.map( data, function( item ) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        position: { my: "left top", at: "left bottom", collision: "none", offset: "6 -2" }

    }).data( "autocomplete" )._renderItem = function( ul, item ) {
        var regex = new RegExp( '(' + $( "#search-place" ).val() + ')', 'gi' );
        item.label = item.label.replace( regex, "<b>$1</b>" )

        return $( "<li>" )
            .data( "item.autocomplete", item )
            .append( "<a>" + item.label + "</a>" )
            .appendTo( ul );
    }; 
});
