(function ( $ ) {
    var main_slider = null;
    var mini_slider = null;
    var left_slider = null;

    var right_slider = null;
    var left_minislider = null;
    var right_minislider = null;
    var max_elements = null;
    var max_children = null;
    var original_main_board_width = null;
    var original_mini_board_width = null;

    var settings;
    var free_scroll = true;
    var first_visible_element = 0;
    var slider_overflow = 0;

    function bufforBoards(){
        original_main_board_width = main_slider.width() + 36;
        original_mini_board_width = mini_slider.width();
        main_slider.width(main_slider.width()*10);
        mini_slider.width(mini_slider.width()*10);
        for (var i = 1; i <= 2; i++) {
            main_slider.append(main_slider.children().clone());
            mini_slider.append(mini_slider.children().clone());
        }

    }
    function adjustWidthToChildren(el){
        var width = 0;
        el.children().each( function( ){
            width += $(this).width();
        })
        el.width(width);
    }
    function bufforToright(){

    }
    function bufforToLeft(){

    }
    function slide(amount ) {
        var to = (first_visible_element + amount);

        if (!canScroll()){
            debug("Cant scroll2:", 1);
            finishScrolAnimation();
            return false;
        }
        if (to > max_elements){
            slider_overflow = -amount;
            to = to % (max_elements + 1);

        }

        if (to < 0) {
            slider_overflow = amount;
            to = (to + max_elements + 1) % (max_elements+ 1) ;
        }
        debug("Slide to:"+to+ "MAX: "+max_elements, 1);
        debug("visible first:"+first_visible_element+ "MAX: "+max_elements, 8);
        hash_change = true;
        location.hash = to;
    }

    function reslide(amount) {

        location.hash = "";
        slide(amount);
    }


    $(window).bind( 'hashchange', function(e) {
        var go_to = parseInt(location.hash.replace( /^#/, '' )) % (max_elements + 1);
        debug("Hash element: "+go_to, 1);
        if (!canScroll()){
            debug("Cant scroll:", 1);
            finishScrolAnimation();
            return true;
        }
        block_scroll();
        e.preventDefault();
        var dir = "-";
        var mul = -1;
        if (go_to < 0) {

            slider_overflow = go_to;
            go_to = (go_to + max_elements + 1) % (max_elements + 1) ;

        }

        if (go_to > max_elements) {
            go_to = go_to % (max_elements + 1);
        }
        if (go_to - first_visible_element < 0){
            dir = "+"
            mul = 1;
        }

        debug("hash visible first:"+first_visible_element+ "goto: "+go_to, 1);
        var diff = Math.abs(go_to - first_visible_element );
        if (slider_overflow != 0){

            diff = slider_overflow;

        }
        var overflow = slider_overflow;
        var mini_overflow = slider_overflow;
        slider_overflow = 0;
        debug("Step size: "+ settings.main_slider_step,1);
        main_slider.finish().animate({
            left: dir+"="+settings.main_slider_step*diff,

        }, settings.main_slider_interval*(Math.log(Math.abs(diff)) + 1), settings.easing, function() {
            first_visible_element = go_to;

            debug("set first element :" + first_visible_element, 1);
            if (overflow != 0) {
                var main_mleft = parseInt(main_slider.css("left").replace("px", ""));
                debug("Overflow:" + "margin-left" + (main_mleft +   original_mini_board_width) +"HOW MUCH: "+slider_overflow, 9);
                main_slider.css("left", (main_mleft + mul*original_main_board_width) + "px");
            }
            release_scroll();
        });
        mini_slider.finish().animate({
            "margin-left" : dir+"="+settings.mini_slider_step*diff,
        }, settings.main_slider_interval*(Math.log(Math.abs(diff)) + 1), settings.easing, function() {
            if (mini_overflow != 0) {
                var mleft = parseInt(mini_slider.css("margin-left").replace("px", ""));
                debug("Overflow:" + "margin-left" + (mleft +  original_mini_board_width), 1);
                mini_slider.css("margin-left", (mleft + mul*original_mini_board_width) + "px");
            }
        });
    })
    function debug(t, level){ if(settings.enable_debug_level > level){ console.log(t) } }
    $.fn.slider = function(options) {
        var defaults = {
            main_slider_step : this.parent().width()/5,
            main_slider_interval : 1000,
            easing : "swing",
            allowAnimationBreak : false,

        };
        main_slider = this;
        adjustWidthToChildren(main_slider);
        main_slider.css("left", original_main_board_width);

        max_elements = Math.floor(main_slider.width()/main_slider.parent().width()*5 ) ;
         settings = $.extend( {}, defaults, options );

        this.slider.setMinislider(settings.mini_slider);
        this.slider.setLeftSlider(settings.left_slider);
        this.slider.setRightSlider(settings.right_slider);
        this.slider.setRightMiniSlider(settings.right_minislider);
        this.slider.setLeftMiniSlider(settings.left_minislider);

        max_children = main_slider.children().length ;
        bufforBoards();
        mini_slider.css("margin-left",  mini_slider.parent().width()*0.3695 - original_mini_board_width);
        main_slider.css("left",  -original_main_board_width);

        var go_to = parseInt(location.hash.replace( /^#/, '' ));
        if(  go_to > 0){
            reslide(go_to);
        }


        return this;
    };

    function block_scroll(){
        free_scroll = false;

    }
    function release_scroll(){
        free_scroll = true;
    }
    function canScroll(){
        return free_scroll;
    }
    function finishScrolAnimation(){
        if (settings.allowAnimationBreak) main_slider.finish();

    }
    $.fn.slider.setMinislider = function(element) {

        mini_slider = element;
        adjustWidthToChildren(mini_slider);
        return this;
    };

    $.fn.slider.setLeftSlider = function(element) {

        left_slider = element;
        element.click(function(e){
            slide(-1);

        });
        element.css("z-index", 100);
        return this;
    };

    $.fn.slider.setRightSlider = function(element) {

        right_slider = element;
        element.click(function(e){
            slide(1);
        });
        element.css("z-index", 100);
        return this;
    };
    $.fn.slider.setLeftMiniSlider = function(element) {

        left_minislider = element;
        element.click(function(e){
                slide(-5);
        });
        element.css("z-index", 100);
        return this;
    };
    $.fn.slider.setRightMiniSlider = function(element) {

        right_minislider = element;
        element.click(function(e){
            slide(5);
        });
        element.css("z-index", 100);
        return this;
    };

}( jQuery ));

$(document).ready(function(){
    $("#gra1a").slider({
        mini_slider : $("#min_gra1a"),
        left_slider : $("#prev"),
        right_slider : $("#next"),
        left_minislider : $("#prev1"),
        right_minislider : $("#next1"),
        mini_slider_step : 46,
        main_slider_step : 181,
        main_slider_interval: 300,
        easing: "easeOutBack", //http://api.jqueryui.com/easings/   easeOutBack, swing
        allowAnimationBreak : false,
        enable_debug_level: 5,
    });
})