function createCookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function eraseCookie(name) {
	createCookie(name,"",-1);
}
            
function saveState(id) {
    if(jQuery("#" + id + "> :first .tdCheckbox").attr("checked")) {
        createCookie('d' + id, 1, 1);
    } else {
        eraseCookie('d' + id);
    }
}   

function saveBookmarkState(id) {
    var getData = $.parseQuery();
    if(getData.subgo) {
        bookmarkName = getData.subgo;
    } else {
        bookmarkName = 'wszystkie';
    }   
    if(jQuery("#" + id + "> :first .tdCheckbox").attr("checked")) {
        createCookie(bookmarkName + '['+ id +']', 1, 1);
    } else {
        eraseCookie(bookmarkName + '['+ id +']');
    }
}         

function toogleCheckbox(id) {
    if(jQuery("#" + id + "> :first .tdCheckbox").attr("checked")) {
        jQuery("#" + id + "> :first .tdCheckbox").attr("checked", false);
    } else {
        jQuery("#" + id + "> :first .tdCheckbox").attr("checked", true);
    }
}
function toogleHighliting(id) {
    if(jQuery("#" + id + "> :first .tdCheckbox").attr("checked")) {
        jQuery("#" + id + ">").css("border-left", "1px dashed #c00");
        jQuery("#" + id + ">").css("border-right", "1px dashed #c00");
    } else {
        jQuery("#" + id + ">").css("border", "1px solid #FFFFFF");
    }
}
            
jQuery(document).ready(function(){
    jQuery(".trClickable > :not(.noClickable)").css("cursor", "pointer").click(function(){
        toogleCheckbox(jQuery(this).parent().attr("id"));
        toogleHighliting(jQuery(this).parent().attr("id"));
        saveState(jQuery(this).parent().attr("id"));
        saveBookmarkState(jQuery(this).parent().attr("id"));
    });
    jQuery('#uncheckAll').click(function(){
        jQuery(".trClickable").each(function(){
            if(jQuery("#" + jQuery(this).attr("id") + "> :first .tdCheckbox").attr("checked")) {
                toogleCheckbox(jQuery(this).attr("id"));
                toogleHighliting(jQuery(this).attr("id"));
                saveState(jQuery(this).attr("id"));
                saveBookmarkState(jQuery(this).attr("id"));
            }
         });
    });
    jQuery(".tdCheckbox").click(function(){
        toogleHighliting(jQuery(this).parent().parent().attr("id"));
        saveState(jQuery(this).parent().parent().attr("id"));
        saveBookmarkState(jQuery(this).parent().parent().attr("id"));
    });
    jQuery("#checkboxToogleSelection").click(function(){
        jQuery(".trClickable").each(function(){
            toogleCheckbox(jQuery(this).attr("id"));
            toogleHighliting(jQuery(this).attr("id"));
            saveState(jQuery(this).attr("id"));
            saveBookmarkState(jQuery(this).attr("id"));
         });
         return false;
    });
    jQuery(".trClickable").each(function(){
        if(readCookie('d' + jQuery(this).attr("id")) == 1 && 
           !jQuery("#" + jQuery(this).attr("id") + "> :first .tdCheckbox").attr("checked")) {
            toogleCheckbox(jQuery(this).attr("id"));
            toogleHighliting(jQuery(this).attr("id"));
        }
    });
});