/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import org.scilab.forge.jlatexmath.Box;

public class FcscoreBox
extends Box {
    private int N;
    private boolean strike;
    private float space;
    private float thickness;

    public FcscoreBox(int n, float f, float f2, float f3, boolean bl) {
        this.N = n;
        this.width = (float)n * (f2 + f3) + 2.0f * f3;
        this.height = f;
        this.depth = 0.0f;
        this.strike = bl;
        this.space = f3;
        this.thickness = f2;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Stroke stroke = graphics2D.getStroke();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = 1.0;
        if (d == d2) {
            d3 = d;
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform2.scale(1.0 / d, 1.0 / d2);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.setStroke(new BasicStroke((float)(d3 * (double)this.thickness), 0, 0));
        float f3 = this.thickness / 2.0f;
        Line2D.Float float_ = new Line2D.Float();
        float f4 = f + this.space;
        f4 = (float)((double)f4 * d3 + (double)(this.space / 2.0f) * d3);
        int n = (int)Math.round((double)(this.space + this.thickness) * d3);
        for (int i = 0; i < this.N; ++i) {
            float_.setLine((double)f4 + (double)f3 * d3, (double)(f2 - this.height) * d3, (double)f4 + (double)f3 * d3, (double)f2 * d3);
            graphics2D.draw(float_);
            f4 += (float)n;
        }
        if (this.strike) {
            float_.setLine((double)(f + this.space) * d3, (double)(f2 - this.height / 2.0f) * d3, (double)f4 - d3 * (double)this.space / 2.0, (double)(f2 - this.height / 2.0f) * d3);
            graphics2D.draw(float_);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setStroke(stroke);
    }

    public int getLastFontId() {
        return -1;
    }
}

