/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.jlatexmath.Box;

public class FramedBox
extends Box {
    protected Box box;
    protected float thickness;
    protected float space;
    private Color line;
    private Color bg;

    public FramedBox(Box box, float f, float f2) {
        this.box = box;
        this.width = box.width + 2.0f * f + 2.0f * f2;
        this.height = box.height + f + f2;
        this.depth = box.depth + f + f2;
        this.shift = box.shift;
        this.thickness = f;
        this.space = f2;
    }

    public FramedBox(Box box, float f, float f2, Color color, Color color2) {
        this(box, f, f2);
        this.line = color;
        this.bg = color2;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        Color color;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(this.thickness, 0, 0));
        float f3 = this.thickness / 2.0f;
        if (this.bg != null) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.bg);
            graphics2D.fill(new Rectangle2D.Float(f + f3, f2 - this.height + f3, this.width - this.thickness, this.height + this.depth - this.thickness));
            graphics2D.setColor(color);
        }
        if (this.line != null) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.line);
            graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - this.height + f3, this.width - this.thickness, this.height + this.depth - this.thickness));
            graphics2D.setColor(color);
        } else {
            graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - this.height + f3, this.width - this.thickness, this.height + this.depth - this.thickness));
        }
        graphics2D.setStroke(stroke);
        this.box.draw(graphics2D, f + this.space + this.thickness, f2);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

