/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.OverUnderBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class OverUnderDelimiter
extends Atom {
    private final Atom base;
    private Atom script;
    private final SymbolAtom symbol;
    private final SpaceAtom kern;
    private final boolean over;

    public OverUnderDelimiter(Atom atom, Atom atom2, SymbolAtom symbolAtom, int n, float f, boolean bl) throws InvalidUnitException {
        this.type = 7;
        this.base = atom;
        this.script = atom2;
        this.symbol = symbolAtom;
        this.kern = new SpaceAtom(n, 0.0f, f, 0.0f);
        this.over = bl;
    }

    public void addScript(Atom atom) {
        this.script = atom;
    }

    public boolean isOver() {
        return this.over;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        float f;
        Box box = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(teXEnvironment);
        Box box2 = DelimiterFactory.create(this.symbol.getName(), teXEnvironment, box.getWidth());
        Box box3 = null;
        if (this.script != null) {
            box3 = this.script.createBox(this.over ? teXEnvironment.supStyle() : teXEnvironment.subStyle());
        }
        if ((f = OverUnderDelimiter.getMaxWidth(box, box2, box3)) - box.getWidth() > 1.0E-7f) {
            box = new HorizontalBox(box, f, 2);
        }
        box2 = new VerticalBox(box2, f, 2);
        if (box3 != null && f - box3.getWidth() > 1.0E-7f) {
            box3 = new HorizontalBox(box3, f, 2);
        }
        return new OverUnderBox(box, box2, box3, this.kern.createBox(teXEnvironment).getHeight(), this.over);
    }

    private static float getMaxWidth(Box box, Box box2, Box box3) {
        float f = Math.max(box.getWidth(), box2.getHeight() + box2.getDepth());
        if (box3 != null) {
            f = Math.max(f, box3.getWidth());
        }
        return f;
    }
}

