/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.net.URL;
import java.net.URLClassLoader;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.DefaultTeXFont;

public class URLAlphabetRegistration
implements AlphabetRegistration {
    private URL url;
    private String language;
    private AlphabetRegistration pack = null;
    private Character.UnicodeBlock[] blocks;

    private URLAlphabetRegistration(URL uRL, String string, Character.UnicodeBlock[] unicodeBlockArray) {
        this.url = uRL;
        this.language = string;
        this.blocks = unicodeBlockArray;
    }

    public static void register(URL uRL, String string, Character.UnicodeBlock[] unicodeBlockArray) {
        DefaultTeXFont.registerAlphabet(new URLAlphabetRegistration(uRL, string, unicodeBlockArray));
    }

    public Character.UnicodeBlock[] getUnicodeBlock() {
        return this.blocks;
    }

    public Object getPackage() throws AlphabetRegistrationException {
        URL[] uRLArray = new URL[]{this.url};
        this.language = this.language.toLowerCase();
        String string = "org.scilab.forge.jlatexmath." + this.language + "." + Character.toString(Character.toUpperCase(this.language.charAt(0))) + this.language.substring(1, this.language.length()) + "Registration";
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            this.pack = (AlphabetRegistration)Class.forName(string, true, uRLClassLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AlphabetRegistrationException("Class at " + this.url + " cannot be got.");
        }
        catch (Exception exception) {
            throw new AlphabetRegistrationException("Problem in loading the class at " + this.url + " :\n" + exception.getMessage());
        }
        return this.pack;
    }

    public String getTeXFontFileName() {
        return this.pack.getTeXFontFileName();
    }
}

