/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

class VerticalBox
extends Box {
    private float leftMostPos = Float.MAX_VALUE;
    private float rightMostPos = Float.MIN_VALUE;

    public VerticalBox() {
    }

    public VerticalBox(Box box, float f, int n) {
        this();
        this.add(box);
        if (n == 2) {
            StrutBox strutBox = new StrutBox(0.0f, f / 2.0f, 0.0f, 0.0f);
            super.add(0, strutBox);
            this.height += f / 2.0f;
            this.depth += f / 2.0f;
            super.add(strutBox);
        } else if (n == 3) {
            this.depth += f;
            super.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
        } else if (n == 4) {
            this.height += f;
            super.add(0, new StrutBox(0.0f, f, 0.0f, 0.0f));
        }
    }

    public final void add(Box box) {
        super.add(box);
        if (this.children.size() == 1) {
            this.height = box.height;
            this.depth = box.depth;
        } else {
            this.depth += box.height + box.depth;
        }
        this.recalculateWidth(box);
    }

    public final void add(Box box, float f) {
        if (this.children.size() >= 1) {
            this.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
        }
        this.add(box);
    }

    private void recalculateWidth(Box box) {
        this.leftMostPos = Math.min(this.leftMostPos, box.shift);
        this.rightMostPos = Math.max(this.rightMostPos, box.shift + (box.width > 0.0f ? box.width : 0.0f));
        this.width = this.rightMostPos - this.leftMostPos;
    }

    public void add(int n, Box box) {
        super.add(n, box);
        if (n == 0) {
            this.depth += box.depth + this.height;
            this.height = box.height;
        } else {
            this.depth += box.height + box.depth;
        }
        this.recalculateWidth(box);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = f2 - this.height;
        for (Box box : this.children) {
            box.draw(graphics2D, f + box.getShift() - this.leftMostPos, f3 += box.getHeight());
            f3 += box.getDepth();
        }
    }

    public int getSize() {
        return this.children.size();
    }

    public int getLastFontId() {
        int n = -1;
        ListIterator listIterator = this.children.listIterator(this.children.size());
        while (n == -1 && listIterator.hasPrevious()) {
            n = ((Box)listIterator.previous()).getLastFontId();
        }
        return n;
    }
}

