<?php
class ArticlesController extends Moto_Model_Account_Controller
{
    private $_articleStorage;

    public function init()
    {
        $this->_articleStorage = new Moto_Model_Table_Articles();
    }

    public function indexAction()
    {
        $articles = $this->_articleStorage->getPublished()->toArray();
        $this->view->assign('articles', $articles);
    }

    public function contentAction()
    {
        $id = (int) $this->_request->getParam('id');
        if (empty($id)) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $article = $this->_articleStorage->getById($id);
        if (empty($article)) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $this->view->assign('article', $article);
    }
}