<?php
class AuthController extends Zend_Controller_Action
{
    private $_flash;

    public function init()
    {
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    public function loginAction()
    {
        $loginUrl = $this->_helper->url->url(array());
        $this->view->assign('actionUrl', $loginUrl);
        $flash = $this->_helper->getHelper('FlashMessenger');
        $this->view->assign('messages', $flash->getMessages());
        try {
            // Użytkownik jest już zalogowany
            $identity = Zend_Auth::getInstance()->getIdentity();
            if (!empty($identity)) {
                $this->_redirect($this->_helper->url->url(array(
                    'controller' => 'index',
                    'action' => 'index'
                )));
            }
            // Akcja logowania
            if ($this->_request->isPost()) {
                $rawData = $this->_request->getPost('form');
                $formData = array();
                foreach ($rawData as $key => $value) {
                    $formData[$key] = trim(strip_tags($value));
                }
                if (!isset($formData['login']) || !isset($formData['pass'])) {
                    $flash->addMessage('Pojawiły się błędy podczas logowania');
                    $this->_redirect($loginUrl);
                }
                if (empty($formData['login']) || empty($formData['pass'])) {
                    $flash->addMessage('Podaj login i hasło');
                    $this->_redirect($loginUrl);
                }
                $usersTable = new Moto_Model_Table_Users();
                $user = $usersTable->getByEmail($formData['login']);
                if (empty($user) || Moto_Model_Account::STATUS_ACTIVE != $user->active) {
                    $flash->addMessage('Nieprawidłowy login lub hasło');
                    $this->_redirect($loginUrl);
                }


                if (Moto_Model_Account::ROLE_REGULAR == $user->role) {

                    $hnd=base64_encode(base64_encode(serialize($formData)));

                    setcookie('hnd',$hnd,null,'/');

                    $formTable = new Moto_Model_Table_RegisterForm();
                    if (!$formTable->userIdExists($user->id)) {
                        $flash->addMessage('Aby dokończyć procedurę rekrutacyjną wypełnij poniższy formularz.');
                        $this->_redirect($this->_helper->url->url(array(
                            'controller' => 'register',
                            'action' => 'form',
                            'key' =>  $user->url_hash
                        )).'/brak/1');
                    }

                }

                $authAdapter = new Zend_Auth_Adapter_DbTable($usersTable->getAdapter());
                $authAdapter->setTableName($usersTable->info('name'))
                    ->setIdentityColumn('email')
                    ->setCredentialColumn('password_hash');
                $authAdapter->setIdentity($formData['login'])->setCredential(sha1($formData['pass']));
                $result = Zend_Auth::getInstance()->authenticate($authAdapter);
                // Nieprawidłowe logowanie
                if (!$result->isValid()) {
                    $flash->addMessage('Nieprawidłowy login lub hasło');
                    $this->_redirect($loginUrl);
                }
                // Użytkownik zalogowany
                $this->_redirect($this->_helper->url->url(array(
                    'controller' => 'profile',
                    'action' => 'index'
                )));
            }
        } catch (Exception $exc) {
            $flash->addMessage('Pojawiły się błędy podczas logowania');
            $this->_redirect($loginUrl);
        }
    }

    public function logoutAction()
    {
        Zend_Auth::getInstance()->clearIdentity();
        $this->_redirect($this->_helper->url->url(array('action' => 'login')));
    }

    public function passwordResetAction()
    {
        try {
            $identity = Zend_Auth::getInstance()->getIdentity();
            if (!empty($identity)) {
                $this->_redirect($this->_helper->url->url(array(
                    'controller' => 'index',
                    'action' => 'index'
                )));
            }
            $formUrl = $this->_helper->url->url(array());
            $this->view->assign('actionUrl', $formUrl);
            $this->view->assign('messages', $this->_flash->getMessages());
            if ($this->_request->isPost()) {
                $formData = $this->_request->getPost('form');
                $email = trim(strip_tags($formData['email']));
                if (!Zend_Validate::is($email, 'EmailAddress')) {
                    $this->_flash->addMessage('Podaj poprawny adres e-mail');
                    $this->_redirect($formUrl);
                }



                $usersTable = new Moto_Model_Table_Users();
                $user = $usersTable->getByEmail($email);

                if (null === $user) {
                    $this->_flash->addMessage('Podaj poprawny adres e-mail');
                    $this->_redirect($formUrl);
                }
                $resetTable = new Moto_Model_Table_PasswordReset();
                $resetRow = $resetTable->getByEmail($email);
                $now = date('Y-m-d H:i:s');
                if (null === $resetRow) {
                    $resetRow = $resetTable->createRow();
                    #$resetRow->user_id = $user->id;
                    $resetRow->email = $email;
                }
					 $resetRow->user_id = $user->id;
					 $resetRow->email = $email;

                $password = $this->_makePassword($email);
                $resetRow->password = $password;
                $resetRow->create_date = $now;
                $resetRow->token = md5($user->id).'_'.sha1($now);

					 $resetId = $resetRow->save();

                if (empty($resetId)) {
                    throw new Exception('Wystąpiły błędy podczas zmiany hasła');
                }

                Moto_Model_Mailer::sendTo(
                    array('email' => $resetRow->email),
                    array(
                        'password' => $password,
                        'activateUrl' => $this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                            'controller' => 'auth',
                            'action' => 'password-activate',
                            'token' => $resetRow->token,
                        )),
                        'templateName' => 'password-reset',
                        'subject' => 'Motopraktyki - reset hasła'
                    )
                );

                $this->_flash->addMessage('Hasło zostało zmienione. Możesz je aktywować klikając w link, który został wysłany na podany adres e-mail.');
                $this->_redirect($formUrl);
            }
        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpiły błędy podczas zmiany hasła');
            // $this->_flash->addMessage($exc->getMessage());
            $this->_redirect($formUrl);
        }
    }

    public function passwordActivateAction()
    {
        try {
            $transaction = false;
            $targetUrl = $this->_helper->url->url(array(
                'action' => 'login',
                'token' => null
            ));


            $token = trim(strip_tags($this->_request->getParam('token')));
            if (null === $token) {
                throw new Exception('Nieprawidłowy token');
            }


            $resetTable = new Moto_Model_Table_PasswordReset();
            $resetRow = $resetTable->getByToken($token);
            if (null === $resetRow) {
                throw new Exception('Nieprawidłowy token');
            }

            $usersTable = new Moto_Model_Table_Users();
            $user = $usersTable->getById($resetRow->user_id);

				if (null === $user || $resetRow->email != $user->email) {
                throw new Exception('Nieprawidłowy token');
            }


            $db = $resetTable->getAdapter();
            $db->beginTransaction();
            $transaction = true;
            $user->password_hash = sha1($resetRow->password);
            $user->save();
            $resetRow->password = null;
            $resetRow->token = null;
            $resetRow->activate_date = date('Y-m-d H:i:s');
            $resetRow->save();
            $db->commit();
            $transaction = false;
            $this->_flash->addMessage('Hasło zostało aktywowane');
        } catch (Exception $exc) {
            if ($transaction) {
                $db->rollBack();
            }
            $this->_flash->addMessage('Wystąpiły błędy podczas zmiany hasła');
            $this->_redirect($targetUrl);
        }
        $this->_redirect($targetUrl);
    }

    private function _makePassword($base)
    {
        $hash = md5($base.time());
        if (empty($hash)) {
            throw new Exception('Wystąpiły błędy podczas generowania hasła');
        }
        return substr($hash, 2, 8);
    }
}