<?php
class CertificateController extends Moto_Model_Account_Controller
{
    private $_facade;

    public function init()
    {
        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
        $this->_facade = new Moto_Model_Facade();
    }

    public function indexAction()
    {
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (!$logbook->hasCertificateAccess()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $data = $this->_facade->getCompletionData($this->_account->getId());
        $firstDateParts = explode('-', $logbook->getFirstDate());
        $lastDateParts = explode('-', $logbook->getLastDate());

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');

        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/certificate/');
        $view->assign('data', $data);
        $view->assign('firstDateParts', $firstDateParts);
        $view->assign('lastDateParts', $lastDateParts);
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $html = $view->render('index.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }

    public function completionAction()
    {
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (!$logbook->hasCertificateAccess()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $page = (int) $this->_request->getParam('page', 1);
        switch ($page) {
            case 1:
                $template = 'completion-1.phtml';
                break;
            case 2:
                $template = 'completion-2.phtml';
                break;
            default:
                $template = 'completion-1.phtml';
                break;
        }
        $data = $this->_facade->getCompletionData($this->_account->getId());
        $firstDateParts = explode('-', $logbook->getFirstDate());
        $lastDateParts = explode('-', $logbook->getLastDate());

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');

        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/certificate/');
        $view->assign('data', $data);
        $view->assign('firstDateParts', $firstDateParts);
        $view->assign('lastDateParts', $lastDateParts);
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $html = $view->render($template);
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }

    /**
     * Ekran pobrania umowy uczestnictwa
     */
    public function agreementAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');

        $logbook = new Moto_Model_Logbook($this->_account->getId());
        // echo '<pre>';var_dump($logbook->getUserInfo());exit;

        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/certificate/');
        $view->assign('data', $logbook->getUserInfo());
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $html = $view->render('agreement.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }
}