<?php

class IndexController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $account = Moto_Model_Account_Factory::getByAuth();
        if (!empty($account)) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->_redirect($this->_helper->url->url(array(
            'controller' => 'articles',//'register',
            'action' => 'content',//'simple'
				'id' => 1
        )));

    }

    public function eventsAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/json');
        $config = new Zend_Config_Ini(APPLICATION_PATH.'/configs/events.ini', APPLICATION_ENV);
        $events = $config->event->toArray();
        $eventsData = array();
        foreach ($events as $event) {
            $formattedDate = strtotime(date('Y').'-'.$event['date']).'000';
            $event['date'] = $formattedDate;
            $eventsData[] = $event;
        }
        echo json_encode($eventsData);
    }
}

