<?php
class LogbookController extends Moto_Model_Account_Controller
{
    private $_flash;

    private $_facade;

    public function init()
    {
        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_facade = new Moto_Model_Facade();
    }

    // Główny ekran dziennika
    public function mainAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $this->view->assign('jobMap', $motoConfig->job->map->toArray());
        $this->view->assign('practicePlaces', $motoConfig->practicePlace->toArray());
        $this->view->assign('logBaseData', $logbook->getBaseData());
        $this->view->assign('baseData', $this->_account->getBaseData());
        $this->view->assign('tutorInfo', $logbook->getTutorInfo());
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('actionUrl', $this->_helper->url->url(array('action'=>'main-save-confirm')));
        $this->view->assign('reportUrl', $this->_helper->url->url(array('action'=>'report')));
        $this->view->assign('summaryUrl', $this->_helper->url->url(array('action'=>'user-summary')));
        $this->view->assign('pdfUrl', $this->_helper->url->url(array('action'=>'pdf')));
    }

    // Ekran potwierdzenia zapisu podstawowych danych do dziennika
    public function mainSaveConfirmAction()
    {
        $mainUrl = $this->_helper->url->url(array('action'=>'main'));
        if (!$this->_request->isPost()) {
            $this->_redirect($mainUrl);
        }
        $postData = $this->_request->getPost('form');
        $filtered = array();
        foreach ($postData as $key => $val) {
            $filtered[$key] = trim(strip_tags($val));
        }
        $status = true;
        if (empty($filtered['profession']) || empty($filtered['practice_place_id'])) {
            $status = false;
            $this->_flash->addMessage('Uzupełnij formularz przed zapisem');
        }
        if (!$status) {
            $this->_redirect($mainUrl);
        }
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $this->view->assign('jobMap', $motoConfig->job->map->toArray());
        $this->view->assign('practicePlaces', $motoConfig->practicePlace->toArray());
        $this->view->assign('data', $filtered);
        $this->view->assign('backUrl', $mainUrl);
        $this->view->assign('actionUrl', $this->_helper->url->url(array('action'=>'main-save')));
    }

    // Zapis podstawowych danych do dziennika
    public function mainSaveAction()
    {
        $mainUrl = $this->_helper->url->url(array('action'=>'main'));
        if (!$this->_request->isPost()) {
            $this->_redirect($mainUrl);
        }
        try {
            $postData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($postData as $key => $val) {
                $filtered[$key] = trim(strip_tags($val));
            }
            $logbook = new Moto_Model_Logbook($this->_account->getId());
            $logbook->setProfession($filtered['profession'])->setPracticePlaceId($filtered['practice_place_id'])->saveBase();
        } catch (Exception $exc) {
            $this->_flash->addMessage('Pojawiły się błędy podczas zapisu danych. Spróbuj ponownie lub skontaktuj się z administratorem.');
        }
        $this->_redirect($mainUrl);
    }

    // Ekran sprawozdania z praktyk
    public function reportAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        // Jeśli nie ma podstawowych danych w dzienniku, to przekierowanie na główną stronę dziennika
        if (!$logbook->hasBaseData()) {
            $this->_redirect($this->_helper->url->url(array('action'=>'main')));
        }
        $this->view->assign('reports', $logbook->getReports());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('logUrl', $this->_helper->url->url(array(
            'action' => 'main'
        )));
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            try {
                $postData = $this->_request->getPost('form');
                $filtered = array();
                foreach ($postData as $key => $val) {
                    $filtered[$key] = trim(strip_tags($val));
                }
                $status = true;
                $messages = array();
                if (!Zend_Validate::is($filtered['date'], 'Date')) {
                    $status = false;
                    $messages['date'] = 'Podaj datę praktyki';
                }
                if (empty($filtered['content'])) {
                    $status = false;
                    $messages['content'] = 'Uzupełnij sprawozdanie';
                }
                if (!$status) {
                    $this->view->assign('data', $filtered);
                    $this->view->assign('msg', $messages);
                    return;
                }
                $reportsTable = new Moto_Model_Table_LogbookReport();
                $now = date('Y-m-d H:i:s');
                $data = array(
                    'logbook_id' => $logbook->getId(),
                    'user_id' => $logbook->getUserId(),
                    'practice_date' => $filtered['date'],
                    'content' => $filtered['content'],
                    'add_date' => $now,
                    'update_date' => $now
                );
                $ctrl = $reportsTable->insert($data);
                // Wysyłka maila do opiekuna
                if (0 < $ctrl) {
                    try {
                        $accountData = $this->_account->getBaseData();
                        $tutorInfo = $logbook->getTutorInfo();
                        $usersTable = new Moto_Model_Table_Users();
                        $tutor = $usersTable->getById($tutorInfo['id']);
                        $this->_facade->sendTutorReportNotification($tutor->email, array(
                            'first_name' => $accountData['first_name'],
                            'last_name' => $accountData['last_name'],
                            'practice_date' => $filtered['date'],
                            'url' => 'http://'.$this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                                'controller' => 'auth',
                                'action' => 'login'
                            ))
                        ));
                    } catch (Exception $e) {
                        // Nie reagujemy, bo to mało istotny wyjątek
                    }
                }
            } catch (Exception $exc) {
                // $this->_flash->addMessage($exc->getMessage());
                $this->_flash->addMessage('Pojawiły się błędy podczas zapisu sprawozdania');
            }
            $this->_redirect($this->_helper->url->url(array()));
        }
    }

    public function tutorAction()
    {
        $profileUrl = $this->_helper->url->url(array(
            'controller' => 'profile',
            'action' => 'index',
            'uid' => null
        ));
        // Dostęp tylko dla opiekuna praktyk
        if (Moto_Model_Account::ROLE_TUTOR != $this->_account->getRole()) {
            $this->_redirect($profileUrl);
        }
        try {
            $uid = (int) $this->_request->getParam('uid');
            $logbook = new Moto_Model_Logbook($uid);
            $this->view->assign('userInfo', $logbook->getUserInfo());
            $this->view->assign('reports', $logbook->getReports());
            $this->view->assign('logData', $logbook->getBaseData());
            $this->view->assign('tutorSummaryUrl', $this->_helper->url->url(array(
                'action' => 'tutor-summary',
                'uid' => $uid
            )));
            $this->view->assign('profileUrl', $profileUrl);
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
        } catch (Exception $exc) {
            $this->_flash->addMessage('Pojawiły się błędy podczas odczytu danych');
            $this->_redirect($profileUrl);
        }
    }

    public function tutorNoteAction()
    {
        $profileUrl = $this->_helper->url->url(array(
            'controller' => 'profile',
            'action' => 'index',
            'uid' => null,
            'rid' => null
        ));
        $uid = (int) $this->_request->getParam('uid');
        $rid = (int) $this->_request->getParam('rid');
        $logUrl = $this->_helper->url->url(array(
            'action' => 'tutor',
            'uid' => $uid,
            'rid' => null
        ));
        // Dostęp tylko dla opiekuna praktyk
        if (Moto_Model_Account::ROLE_TUTOR != $this->_account->getRole()) {
            $this->_redirect($profileUrl);
        }
        try {
            $reportsTable = new Moto_Model_Table_LogbookReport();
            $reportRow = $reportsTable->getById($rid);
            if (null === $reportRow) {
                throw new Exception('Nieprawidłowy identyfikator sprawozdania');
            }
            $this->view->assign('logUrl', $logUrl);
            $this->view->assign('reportInfo', $reportRow->toArray());
            $this->view->assign('actionUrl', $this->_helper->url->url(array(
                'action' => 'tutor-note',
                'uid' => $uid,
                'rid' => $rid
            )));
            // Przetworzenie formularza
            if ($this->_request->isPost()) {
                $postData = $this->_request->getPost('form');
                $filtered = array();
                foreach ($postData as $key => $value) {
                    $filtered[$key] = trim(strip_tags($value));
                }
                if (empty($filtered['tutor_note'])) {
                    $this->view->assign('msg', 'Uzupełnij ocenę/uwagi');
                    return;
                }
                $reportRow->tutor_note = $filtered['tutor_note'];
                $reportRow->save();
                $this->_redirect($logUrl);
            }
        } catch (Exception $exc) {
            $this->_flash->addMessage('Pojawiły się błędy podczas odczytu danych');
            $this->_redirect($logUrl);
        }
    }

    public function userSummaryAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logUrl = $this->_helper->url->url(array('action'=>'main'));
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (!$logbook->hasBaseData()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('logData', $logbook->getBaseData());
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('backUrl', $logUrl);
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $summaryNote = trim(strip_tags($this->_request->getPost('summaryNote')));
            if (empty($summaryNote)) {
                $this->_flash->addMessage('Uzupełnij treść uwag');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $logbook->setUserSummary($summaryNote)->saveBase();
            $this->_redirect($this->_helper->url->url(array()));
        }
    }

    public function tutorSummaryAction()
    {
        // Dostęp tylko dla opiekuna
        if (Moto_Model_Account::ROLE_TUTOR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $uid = (int) $this->_request->getParam('uid');
        $backUrl = $this->_helper->url->url(array('action'=>'tutor', 'uid'=>$uid));
        $logbook = new Moto_Model_Logbook($uid);
        if (!$logbook->hasBaseData()) {
            $this->_redirect($backUrl);
        }
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('userInfo', $logbook->getUserInfo());
        $this->view->assign('logData', $logbook->getBaseData());
        $this->view->assign('backUrl', $backUrl);
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        if ($this->_request->isPost()) {
            $summaryNote = trim(strip_tags($this->_request->getPost('summaryNote')));
            if (empty($summaryNote)) {
                $this->_flash->addMessage('Uzupełnij treść uwag');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $logbook->setTutorSummary($summaryNote)->saveBase();
            $this->_redirect($this->_helper->url->url(array()));
        }
    }

    public function pdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (!$logbook->hasBaseData()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logData = $logbook->getBaseData();
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/logbook/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('logData', $logData);
        $view->assign('userData', $logbook->getUserInfo());
        $view->assign('config', $motoConfig->toArray());
        $view->assign('firstDate', $logbook->getFirstDate());
        $view->assign('lastDate', $logbook->getLastDate());
        $view->assign('reports', $logbook->getReports());
        $html = $view->render('pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }
}