<?php
class ProfileController extends Moto_Model_Account_Controller
{
    private $_flash;

    private $_facade;

    public function init()
    {

        $r=$this->_request->getParam('r', null);
        if(!empty($r)){
            $this->logAction($r);
        }

        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_facade = new Moto_Model_Facade();

    }

    public function indexAction()
    {
        switch ($this->_account->getRole()) {
            case Moto_Model_Account::ROLE_REGULAR:
                $url = $this->_helper->url->url(array(
                    'action' => 'regular'
                ));
                break;
            case Moto_Model_Account::ROLE_TUTOR:
                $url = $this->_helper->url->url(array(
                    'action' => 'tutor'
                ));
                break;
            case Moto_Model_Account::ROLE_EXPERT:
                $url = $this->_helper->url->url(array(
                    'action' => 'expert'
                ));
                break;
            case Moto_Model_Account::ROLE_ADMIN:
                $url = $this->_helper->url->url(array(
                    'module' => 'panel',
                    'controller' => 'index',
                    'action' => 'index'
                ));
                break;
            default:
            throw new Zend_Action_Controller_Exception(404);
        }
        $this->_redirect($url);
    }

    public function logAction($r){

        $formData=unserialize(base64_decode(base64_decode($_COOKIE['hnd'])));

        $usersTable = new Moto_Model_Table_Users();
        $user = $usersTable->getByEmail($formData['login']);
        $authAdapter = new Zend_Auth_Adapter_DbTable($usersTable->getAdapter());
        $authAdapter->setTableName($usersTable->info('name'))
            ->setIdentityColumn('email')
            ->setCredentialColumn('password_hash');
        $authAdapter->setIdentity($formData['login'])->setCredential(sha1($formData['pass']));
        $result = Zend_Auth::getInstance()->authenticate($authAdapter);
        // Nieprawidłowe logowanie
        if (!$result->isValid()) {
            $_flash->addMessage('Nieprawidłowy login lub hasło');
            $this->_redirect($loginUrl);
        }
        // Użytkownik zalogowany
        setcookie('hnd',null,-3600,'/');
        $this->_redirect($r);

    }

    public function formAction()
    {
        $key = trim(strip_tags($this->_request->getParam('key')));

        $users = new Moto_Model_Table_Users();
        $user = $users->getByKey($key);
        // Nieprawidłowy hash
        if (null === $user) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $formTable = new Moto_Model_Table_RegisterForm();

        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        try {
            $schedule = new Moto_Model_Table_WorkshopSchedule();
            $events = $schedule->getEventsByType('1');
            $this->view->assign('events', $events);
            $events2 = $schedule->getEventsByType('2');
            $this->view->assign('events2', $events2);
            $this->view->assign('actionUrl', $this->_helper->url->url(array(
                'action' => 'form',
                'key' => $key
            )));
            $this->view->assign('email', $user['email']);
            // Przetworzenie formularza
            if ($this->_request->isPost()) {
                $formData = $this->_request->getPost('form');
                $msgConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/messages.ini', APPLICATION_ENV);
                $form = new Moto_Model_Register_FormData($formData);
                $filtered = $form->setMessagesMap($msgConfig->toArray())->getFiltered();
                if (!$form->isValid()) {
                    $this->view->assign('msg', $form->getMessages());
                    $this->view->assign('data', $filtered);
                    return;
                }

                $filtered['points'] = $form->calcPoints();
                $filtered['user_id'] = $user['id'];

                $addCtrl = $formTable->updateForm($filtered,$user['id']);
                if (0 >= $addCtrl) {
                    $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych.');
                    $this->_redirect($this->_helper->url->url(array(
                        'action' => 'form',
                        'key' => $key
                    )));
                }
                try {
                    $user->full_register_date = date('Y-m-d H:i:s');
                    $user->save();
                } catch (Exception $exc) {}// Mało istotna operacja

                $this->_redirect($this->_helper->url->url(array(
                        'action' => 'regular'
                )));

            }

            //pobranie danych
            $dane = $formTable->getByUserId($user['id']);
            $this->view->assign('data', $dane);


        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych.');
            $this->_redirect($this->_helper->url->url(array(
                'action' => 'form',
                'key' => $key
            )));
        }
    }

    /**
     * Profil uczestnika praktyk
     */
    public function regularAction()
    {
        
        //reset hasla
        if ($this->_request->isPost()) {
            $data=$this->getRequest()->getPost();
            $filtered = array();        

            foreach ($data['form'] as $key => $value) {
                $filtered[$key] = trim(strip_tags($value));
            }


            $err=0;
            if (empty($filtered['password']) || '' == $filtered['password']) {
                $this->_flash->addMessage('Podaj hasło do zresetowania.');
                $err=1;
            } else {
                if ($filtered['password'] != $filtered['passwordRepeat']) {
                    $this->_flash->addMessage('Podane hasła nie są jednakowe.');
                    $err=1;
                }
            }


            if($err==0){
                $db = new Moto_Model_Table_Users();   
                
                $where = $db->getAdapter()->quoteInto(array(
                    'id = ?' => $this->_account->getId()
                ));
                
                $data=array(
                    'password_hash' => sha1($filtered['password'])
                );
                
                $ok=$db->getAdapter()->update('users',$data, $where);

                if($ok==0){
                    $this->_flash->addMessage('Hasło nie zostało zmienione.');          
                }else{
                    $this->_flash->addMessage('Hasło zostało zmienione.');                     
                }             
                          
            }

            $this->view->assign('flashMsgs', $this->_flash->getMessages());           
        }
        
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Sprawdzenie, czy uczestnik praktyk wypełniał formularz rejestracyjny
        /*
        if (Moto_Model_Account::ROLE_REGULAR == $this->_account->getRole()) {

            $formTable = new Moto_Model_Table_RegisterForm();
            if (!$formTable->userIdExists($this->_account->getId())) {
                $this->_flash->addMessage('Aby dokończyć procedurę rekrutacyjną wypełnij poniższy formularz.');
                $this->_redirect($this->_helper->url->url(array(
                    'controller' => 'register',
                    'action' => 'form',
                    'key' =>  $this->_account->getHash()
                )));
            }

        }
         *
         */
        // Jeśli uczestnik nie wypełniał ankiety przed rozpoczęciem praktyk, to przekierowanie na ankietę
        if (!Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE)) {
            /* dzieki temu jest profil
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'practice-before'
            )));
             *
             */
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_BEFORE)) {
            $prepareBeforePollUrl = $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-before-pdf'
            ));
            $this->view->assign('prepareBeforePdf', true);
        } else {
            $prepareBeforePollUrl = $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-before'
            ));
        }
        // Uczestnik wypełniał już ankietę na zakończenie praktyk
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_AFTER)) {
            $this->view->assign('practiceAfterPdf', $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'practice-after-pdf'
            )));
        } else {
            // Sprawdzenie, czy uczestnik zakończył już praktyki
            $practiceStatus = $logbook->getPracticeStatus();
            if (Moto_Model_Logbook::TIME_STATUS_AFTER == $practiceStatus) {
                $this->view->assign('practiceAfter', $this->_helper->url->url(array(
                    'controller' => 'poll',
                    'action' => 'practice-after'
                )));
            }
        }
        // Uczestnik wypełniał już ankietę na zakończenie warsztatów
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_AFTER)) {
            $this->view->assign('prepareAfterPdf', $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-after-pdf'
            )));
        } else {
            // Sprawdzenie, czy uczestnik zakończył już warsztatów
            $prepareStatus = $logbook->getPrepareStatus();
            if (Moto_Model_Logbook::TIME_STATUS_AFTER == $prepareStatus) {
                $this->view->assign('prepareAfter', $this->_helper->url->url(array(
                    'controller' => 'poll',
                    'action' => 'prepare-after'
                )));
            }
        }
        $this->view->assign('prepareBeforePollUrl', $prepareBeforePollUrl);
        $this->view->assign('baseData', $this->_account->getBaseData());
        $this->view->assign('logbookUrl', $this->_helper->url->url(array(
            'controller' => 'logbook',
            'action' => 'main'
        )));
        $this->view->assign('hasCertificateAccess', $logbook->hasCertificateAccess());
        $this->view->assign('uploadDate', $this->_account->getPresentationUploadDate());
        $this->view->assign('presentationUrl', $this->_helper->url->url(array('action'=>'presentation')));
        $this->view->assign('daneUrl', '/profile/form/key/'.$this->_account->getHash());
        $this->view->assign('practiceBeforePdf', $this->_helper->url->url(array(
            'controller' => 'poll',
            'action' => 'practice-before-pdf'
        )));
        $this->view->assign('reminder', $this->_account->getReminder());
    }

    /**
     * Ekran "pobierz" uczestnika praktyk
     */
    public function regularDownloadAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Jeśli uczestnik nie wypełniał ankiety przed rozpoczęciem praktyk, to przekierowanie na ankietę
        if (!Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE)) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'practice-before'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        $this->view->assign('hasCertificateAccess', $logbook->hasCertificateAccess());

		  $this->view->assign('pdfUrl','/register/pdf/key/'.$this->_account->getHash().'/r/1');
    }

    /**
     * Ekran pobrania/linków ewaluacji uczestnika
     */
    public function regularPollsAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Jeśli uczestnik nie wypełniał ankiety przed rozpoczęciem praktyk, to przekierowanie na ankietę
        if (!Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE)) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'practice-before'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_BEFORE)) {
            $prepareBeforePollUrl = $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-before-pdf'
            ));
            $this->view->assign('prepareBeforePdf', true);
        } else {
            $prepareBeforePollUrl = $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-before'
            ));
        }
        // Uczestnik wypełniał już ankietę na zakończenie praktyk
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_AFTER)) {
            $this->view->assign('practiceAfterPdf', $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'practice-after-pdf'
            )));
        } else {
            // Sprawdzenie, czy uczestnik zakończył już praktyki
            $practiceStatus = $logbook->getPracticeStatus();
            if (Moto_Model_Logbook::TIME_STATUS_AFTER == $practiceStatus) {
                $this->view->assign('practiceAfter', $this->_helper->url->url(array(
                    'controller' => 'poll',
                    'action' => 'practice-after'
                )));
            }
        }
        // Uczestnik wypełniał już ankietę na zakończenie warsztatów
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_AFTER)) {
            $this->view->assign('prepareAfterPdf', $this->_helper->url->url(array(
                'controller' => 'poll',
                'action' => 'prepare-after-pdf'
            )));
        } else {
            // Sprawdzenie, czy uczestnik zakończył już warsztatów
            $prepareStatus = $logbook->getPrepareStatus();
            if (Moto_Model_Logbook::TIME_STATUS_AFTER == $prepareStatus) {
                $this->view->assign('prepareAfter', $this->_helper->url->url(array(
                    'controller' => 'poll',
                    'action' => 'prepare-after'
                )));
            }
        }
        $this->view->assign('prepareBeforePollUrl', $prepareBeforePollUrl);
        $this->view->assign('practiceBeforePdf', $this->_helper->url->url(array(
            'controller' => 'poll',
            'action' => 'practice-before-pdf'
        )));
    }

    public function presentationAction()
    {
        $profileUrl = $this->_helper->url->url(array(
            'controller' => 'profile',
            'action' => 'index'
        ));
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($profileUrl);
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        $this->view->assign('profileUrl', $profileUrl);
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('hasPresentation', $logbook->hasPresentation());
        if ($this->_request->isPost()) {
            $info = $this->_facade->savePresentation($logbook);
            $this->_flash->addMessage($info['message']);
            $this->_redirect($this->_helper->url->url(array()));
        }
    }

    /**
     * Profil opiekuna
     */
    public function tutorAction()
    {
        // Dostęp tylko dla opiekuna praktyk
        if (Moto_Model_Account::ROLE_TUTOR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('baseData', $this->_account->getBaseData());
        $this->view->assign('users', $this->_account->getAssignedUsers());
    }

    /**
     * Uczestnicy przydzieleni do opiekuna
     */
    public function tutorUsersAction()
    {
        // Dostęp tylko dla opiekuna praktyk
        if (Moto_Model_Account::ROLE_TUTOR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('baseData', $this->_account->getBaseData());
        $this->view->assign('users', $this->_account->getAssignedUsers());
    }

    /**
     * Profil eksperta
     */
    public function expertAction()
    {
        // Dostęp tylko dla eksperta
        if (Moto_Model_Account::ROLE_EXPERT != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('report', $this->_account->getReport());
    }
}