<?php

class RegisterController extends Zend_Controller_Action
{
    private $_facade;

    private $_flash;

    public function init()
    {

        // $this->_helper->layout()->setLayout('front');
        $account = Moto_Model_Account_Factory::getByAuth();
        if (!empty($account)) {

		  		$r=$this->_request->getParam('key', null);
        		if(empty($r)){

            	$this->_redirect($this->_helper->url->url(array(
	                'controller' => 'profile',
	                'action' => 'index'
	            )));

				}

        }
        $this->_facade = new Moto_Model_Facade();
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        // $this->render('technical-break');
        // return;
    }

    /**
     * Formularz wstępnej rejestracji
     */
    public function simpleAction()
    {
        if ('production' == APPLICATION_ENV) {
            if (!$this->_request->isSecure()) {
                $secureUrl = 'https://'.$this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                    'action' => 'simple'
                ));
                $this->_redirect($secureUrl);
            }
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array(
            'controller' => 'register',
            'action' => 'simple-do'
        )));
        $this->view->assign('messages', $this->_flash->getMessages());
        $this->view->assign('remindUrl', $this->_helper->url->url(array(
            'action' => 'remind-form'
        )));
    }

    public function simpleDoAction()
    {
        if (!$this->_request->isPost()) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $data = $this->_request->getPost('form');
        $validation = $this->_facade->simpleRegisterValidate($data);
        if (!$validation['status']) {
            foreach ($validation['messages'] as $key => $value) {
                $this->_flash->addMessage($value);
            }
            $this->_redirect($this->_helper->url->url(array('action' => 'simple')));
        }
        $formLink = $this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
            'action' => 'form'
        ));
        $register_info = $this->_facade->simpleRegisterDo($validation['filtered'], $formLink);
        if (!$register_info) {
            $this->_flash->addMessage('Wystąpiły błędy podczas rejestracji danych. Spróbuj ponownie lub skontaktuj się z administratorem serwisu.');
            $this->_redirect($this->_helper->url->url(array('action' => 'simple')));
        }
        $this->_redirect($this->_helper->url->url(array(
            'controller' => 'register',
            'action'=>'summary-simple'
        )));
    }

    public function remindFormAction()
    {
        if ('production' == APPLICATION_ENV) {
            if (!$this->_request->isSecure()) {
                $secureUrl = 'https://'.$this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                    'action' => 'remind-form'
                ));
                $this->_redirect($secureUrl);
            }
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('messages', $this->_flash->getMessages());
        if ($this->_request->isPost()) {
            $validation = $this->_facade->remindFormValidate($this->_request->getPost('form'));
            if (!$validation['status']) {
                foreach ($validation['messages'] as $key => $value) {
                    $this->_flash->addMessage($value);
                }
                $this->_redirect($this->_helper->url->url(array('action' => 'remind-form')));
            }
            $formLink = $this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                'action' => 'form'
            ));
            $this->_facade->sendRemindMail($validation['filtered'], $formLink);
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'register',
                'action'=>'summary-remind'
            )));
        }
    }

    public function summaryRemindAction()
    {
    }

    public function summarySimpleAction()
    {
    }

    public function formAction()
    {
        $key = trim(strip_tags($this->_request->getParam('key')));

        //logowanie z linku, aktywacja
        $first_key = trim(strip_tags($this->_request->getParam('first')));
        if($first_key=='true'){
            Zend_Auth::getInstance()->clearIdentity();
            $this->_redirect('/auth/login?first=true');
            return;
        }

        if ('production' == APPLICATION_ENV) {
            if (!$this->_request->isSecure()) {
                $secureUrl = 'https://'.$this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                    'action' => 'form',
                    'key' => $key
                ));
                $this->_redirect($secureUrl);
            }
        }
        $users = new Moto_Model_Table_Users();
        $user = $users->getByKey($key);
        // Nieprawidłowy hash
        if (null === $user) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $formTable = new Moto_Model_Table_RegisterForm();
        // User już się rejestrował
        if ($formTable->userIdExists($user['id'])) {
            $this->_redirect($this->_helper->url->url(array(
                'action' => 'summary',
                'key' => $key
            )));
        }

        //dopiski dla layout.phtml
        $this->view->assign('brak',$this->_getParam('brak'));
        $this->view->assign('brak_url',$this->getRequest()->getRequestUri());

        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        try {
            $schedule = new Moto_Model_Table_WorkshopSchedule();
            $events = $schedule->getEventsByType('1');
            $this->view->assign('events', $events);
            $events2 = $schedule->getEventsByType('2');
            $this->view->assign('events2', $events2);
            $this->view->assign('actionUrl', $this->_helper->url->url(array(
                'action' => 'form',
                'key' => $key
            )));
            $this->view->assign('email', $user['email']);
            // Przetworzenie formularza
            if ($this->_request->isPost()) {
                $formData = $this->_request->getPost('form');
                $msgConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/messages.ini', APPLICATION_ENV);
                $form = new Moto_Model_Register_FormData($formData);
                $filtered = $form->setMessagesMap($msgConfig->toArray())->getFiltered();
                if (!$form->isValid()) {
                    $this->view->assign('msg', $form->getMessages());
                    $this->view->assign('data', $filtered);
                    return;
                }
                $filtered['points'] = $form->calcPoints();
                $filtered['user_id'] = $user['id'];
                $addCtrl = $formTable->addForm($filtered);
                if (0 >= $addCtrl) {
                    $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych.');
                    $this->_redirect($this->_helper->url->url(array(
                        'action' => 'form',
                        'key' => $key
                    )));
                }
                try {
                    $user->full_register_date = date('Y-m-d H:i:s');
                    $user->save();
                } catch (Exception $exc) {}// Mało istotna operacja
                $this->_redirect($this->_helper->url->url(array(
                    'action' => 'summary',
                    'key' => $key
                )));
            }
        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych.');
            $this->_redirect($this->_helper->url->url(array(
                'action' => 'form',
                'key' => $key
            )));
        }
    }

    public function summaryAction()
    {
        //dopiski dla layout.phtml
        $this->view->assign('brak',$this->_getParam('brak'));
        $this->view->assign('brak_url',$this->getRequest()->getRequestUri());
        $this->view->assign('hnd',1);

        $key = trim(strip_tags($this->_request->getParam('key')));
        $this->view->assign('pdfUrl', $this->_helper->url->url(array(
            'action' => 'pdf',
            'key' => $key
        )));
    }

    public function eventInfoAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $id = (int) $this->_request->getParam('id');
        $schedule = new Moto_Model_Table_WorkshopSchedule();
        $event = $schedule->getById($id);
        if (null === $event) {
            echo json_encode(array());
        }
        echo json_encode($event->toArray());
    }

    public function pdfAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');

        $key = trim(strip_tags($this->_request->getParam('key')));
        $users = new Moto_Model_Table_Users();
        $user = $users->getByKey($key);
        if (null === $user) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $formsTable = new Moto_Model_Table_RegisterForm();
        $form = $formsTable->getByUserId($user->id);
        if (null === $form) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $formData = $form->toArray();

        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $schedule = new Moto_Model_Table_WorkshopSchedule();
        $preferredEvent = $schedule->getById($formData['preferred_date'])->toArray();
        $additionalEvent = $schedule->getById($formData['additional_date'])->toArray();
        
        if($formData['preferredWorkshop_date']>0){
            $tm=$schedule->getById($formData['preferredWorkshop_date'])->toArray();
            $preferredEvent['prepare_start_date']=$tm['prepare_start_date'];
            $preferredEvent['prepare_stop_date']=$tm['prepare_stop_date'];
        }
        if($formData['additionalWorkshop_date']>0){
            $tm=$schedule->getById($formData['additionalWorkshop_date'])->toArray();
            $additionalEvent['prepare_start_date']=$tm['prepare_start_date'];
            $additionalEvent['prepare_stop_date']=$tm['prepare_stop_date'];
        }
        

        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/register/');
        $view->assign('data', $formData);
        $view->assign('placeTypeMap', array('village' => 'wieś', 'city' => 'miasto'));
        $view->assign('educationMap', $motoConfig->education->map->toArray());
        $view->assign('jobMap', $motoConfig->job->map->toArray());
        $view->assign('preferredEvent', $preferredEvent);
        $view->assign('additionalEvent', $additionalEvent);
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $html = $view->render('pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        // $dompdf->stream("formularz_zgloszeniowy.pdf");
        echo $dompdf->output();
    }

    /**
     * Ekran rejestracji opiekuna praktyk
     */
    public function tutorAction()
    {
        $account = Moto_Model_Account_Factory::getByAuth();
        if (null !== $account) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('messages', $this->_flash->getMessages());
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $data = $this->_request->getPost('form');
            $validation = $this->_facade->simpleRegisterValidate($data);
            if (!$validation['status']) {
                foreach ($validation['messages'] as $key => $value) {
                    $this->_flash->addMessage($value);
                }
                $this->_redirect($this->_helper->url->url(array()));
            }
            $formLink = $this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                'action' => 'tutor-form'
            ));
            $info = $this->_facade->tutorRegister($validation['filtered'], $formLink);
            if (!$info) {
                $this->_flash->addMessage('Wystąpiły błędy podczas rejestracji danych. Spróbuj ponownie lub skontaktuj się z administratorem serwisu.');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_redirect($this->_helper->url->url(array('action' => 'summary-tutor')));
        }
    }

    /**
     * Formularz danych osobowych opiekuna praktyk
     */
    public function tutorFormAction()
    {
        $key = trim(strip_tags($this->_request->getParam('key')));
        $users = new Moto_Model_Table_Users();
        $user = $users->getByKey($key);
        // Nieprawidłowy hash
        if (null === $user) {
            throw new Zend_Controller_Action_Exception(404);
        }
        if (Moto_Model_Account::ROLE_TUTOR != $user->role) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $dataTable = new Moto_Model_Table_ContactData();
        if ($dataTable->userExists($user->id)) {
            $this->view->assign('registered', true);
            return;
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $formData = $this->_request->getPost('form');
            $tutorForm = new Moto_Model_Register_TutorForm($formData);
            $msgConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/messages.ini', APPLICATION_ENV);
            $filtered = $tutorForm->setMessagesMap($msgConfig->toArray())->getFiltered();
            if (!$tutorForm->isValid()) {
                $this->view->assign('msg', $tutorForm->getMessages());
                $this->view->assign('data', $filtered);
                return;
            }
            $filtered['user_id'] = $user->id;
            $ctrl = $dataTable->registerUser($filtered);
            if (0 < $ctrl) {
                $user->full_register_date = date('Y-m-d H:i:s');
                $user->save();
                $admins = $users->getByRole(Moto_Model_Account::ROLE_ADMIN);
                if (!empty($admins)) {
                    $this->_facade->sendTutorRegisterNotification($admins[0]['email']);
                }
            }
            $this->_redirect($this->_helper->url->url(array('action'=>'summary-tutor-details', 'key' => null)));
        }
    }

    public function summaryTutorAction()
    {}

    public function summaryTutorDetailsAction()
    {}

    // Ekran rejestracji eksperta
    public function expertAction()
    {
        $account = Moto_Model_Account_Factory::getByAuth();
        if (null !== $account) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('messages', $this->_flash->getMessages());
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $data = $this->_request->getPost('form');
            $validation = $this->_facade->simpleRegisterValidate($data);
            if (!$validation['status']) {
                foreach ($validation['messages'] as $key => $value) {
                    $this->_flash->addMessage($value);
                }
                $this->_redirect($this->_helper->url->url(array()));
            }
            $formLink = $this->_request->getServer('HTTP_HOST').$this->_helper->url->url(array(
                'action' => 'expert-form'
            ));
            $info = $this->_facade->expertRegister($validation['filtered'], $formLink);
            if (!$info) {
                $this->_flash->addMessage('Wystąpiły błędy podczas rejestracji danych. Spróbuj ponownie lub skontaktuj się z administratorem serwisu.');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_redirect($this->_helper->url->url(array('action' => 'summary-expert')));
        }
    }

    public function expertFormAction()
    {
        $key = trim(strip_tags($this->_request->getParam('key')));
        $users = new Moto_Model_Table_Users();
        $user = $users->getByKey($key);
        // Nieprawidłowy hash
        if (null === $user) {
            throw new Zend_Controller_Action_Exception(404);
        }
        if (Moto_Model_Account::ROLE_EXPERT != $user->role) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $dataTable = new Moto_Model_Table_ContactData();
        if ($dataTable->userExists($user->id)) {
            $this->view->assign('registered', true);
            return;
        }
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $formData = $this->_request->getPost('form');
            $expertForm = new Moto_Model_Register_ExpertForm($formData);
            $msgConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/messages.ini', APPLICATION_ENV);
            $filtered = $expertForm->setMessagesMap($msgConfig->toArray())->getFiltered();
            if (!$expertForm->isValid()) {
                $this->view->assign('msg', $expertForm->getMessages());
                $this->view->assign('data', $filtered);
                return;
            }
            $filtered['user_id'] = $user->id;
            $ctrl = $dataTable->registerUser($filtered);
            if (0 < $ctrl) {
                $user->full_register_date = date('Y-m-d H:i:s');
                $user->save();
                $admins = $users->getByRole(Moto_Model_Account::ROLE_ADMIN);
                if (!empty($admins)) {
                    $this->_facade->sendExpertRegisterNotification($admins[0]['email']);
                }
            }
            $this->_redirect($this->_helper->url->url(array('action'=>'summary-expert-details', 'key' => null)));
        }
    }

    public function summaryExpertAction()
    {}

    public function summaryExpertDetailsAction()
    {}
}