<?php
abstract class Moto_Model_Account
{
    const ROLE_REGULAR = 'regular';
    const ROLE_ADMIN = 'admin';
    const ROLE_TUTOR = 'tutor';
    const ROLE_EXPERT = 'expert';

    const STATUS_ACTIVE = 1;
    const STATUS_REJECTED = 2;
    const STATUS_PENDING = 0;

    protected $_store;

    public function setStore($store)
    {
        $this->_store = $store;
        return $this;
    }

    public function getRole()
    {
        if (empty($this->_store)) {
            return null;
        }
        return $this->_store->role;
    }

    public function getId()
    {
        if (empty($this->_store)) {
            return 0;
        }
        return $this->_store->id;
    }
    
    public function getHash()
    {
        if (empty($this->_store->url_hash)) {
            return 0;
        }
        return $this->_store->url_hash;
    }

    public function getReminder()
    {
        return array();
    }
}